/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickfix.EditorQuickFixProcessor;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.quickassist.EQuickAssistExtractMethodProcessor;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtil;

public class EEditorQuickFixProcessor
extends EditorQuickFixProcessor {
    private IEPluginConfig pluginConfig;

    public EEditorQuickFixProcessor(IEPluginConfig pluginConfig, ITextEditor textEditor) {
        super(textEditor);
        this.pluginConfig = pluginConfig;
    }

    public List<ICompletionProposal> getProposalsByKind(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, boolean startMonitorJob) {
        return EQuickFixUtil.getInstance().getProposalsByKind(this.pluginConfig, quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, proposals, startMonitorJob, (IProgressMonitor)new NullProgressMonitor());
    }

    public IRfScopeElement getRfScope(ITextEditor textEditor, IDocument document, int offset) {
        try {
            int line = document.getLineOfOffset(offset) + 1;
            return RfUtils.getRfScope(this.pluginConfig.getRfManager(), textEditor, document, offset, line);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public Set<String> getQuickFixMarkerIds() {
        return EProblemCategories.QUICKFIXABLE_PROBLEMS;
    }

    public Set<String> getProblemMarkerIds() {
        return EProblemCategories.ALL_PROBLEMS;
    }

    public ICompletionProposal[] getQuickAssistProposals(ITextViewer viewer) {
        ArrayList<DVTAbstractQuickAssistProposal> quickAssistProposals = new ArrayList<DVTAbstractQuickAssistProposal>();
        DVTAbstractQuickAssistProposal[] extractToMethodProposals = new EQuickAssistExtractMethodProcessor(this.pluginConfig, viewer, this.fTextEditor).getProposals(false);
        if (extractToMethodProposals != null && extractToMethodProposals.length != 0) {
            quickAssistProposals.addAll(Arrays.asList(extractToMethodProposals));
        }
        return quickAssistProposals.toArray(new ICompletionProposal[quickAssistProposals.size()]);
    }

    public Comparator<? super ICompletionProposal> getProposalsSorter() {
        return null;
    }
}

