/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.quickfix.util.EQuickFixUtilCommon;

public class EQuickFixUtil
extends EQuickFixUtilCommon {
    private static EQuickFixUtil INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EQuickFixUtil getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new EQuickFixUtil();
            }
        }
        return INSTANCE;
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposalsOnJob(final IEPluginConfig pluginConfig, final int quickFixKind, final boolean isHierarchical, final IMarker marker, final ITextViewer viewer, final IRfScopeElement scope, final int offset, final Position position, final String elementName, final List<ICompletionProposal> existingProposals, boolean b) {
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        final AtomicBoolean done = new AtomicBoolean(false);
        Job computingQuickFixProposalJob = new Job("Compute Quick Fix Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                List<ICompletionProposal> proposalsByKindInternal = EQuickFixUtil.this.getProposalsByKindInternal(pluginConfig, quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, false);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.addAll(proposalsByKindInternal);
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingQuickFixProposalJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        return result;
    }

    @Override
    protected List<ICompletionProposal> computeQuickFixProposals(IEPluginConfig pluginConfig, int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean b, IProgressMonitor monitor) {
        EQuickFixUtil.scheduleTimeoutWatchDog((IProgressMonitor)monitor, (int)200);
        List<ICompletionProposal> proposalsByKindInternal = this.getProposalsByKindInternal(pluginConfig, quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, monitor, true);
        return proposalsByKindInternal;
    }
}

