/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.quickfix.util;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.util.MinWordDistanceComparator;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.model.reflection.Determinant;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfConstraintLayer;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarType;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.semantic.RfUndefVariable;
import ro.amiq.edt.base.r2lparser.R2LManager;
import ro.amiq.edt.base.r2lparser.R2LNoProposalElement;
import ro.amiq.edt.base.r2lparser.R2LOverrideWizardElement;
import ro.amiq.edt.base.r2lparser.R2LProposalManager;
import ro.amiq.edt.base.r2lparser.R2LResultContainer;
import ro.amiq.edt.base.ui.editor.contentassist.EContentAssistUtils;
import ro.amiq.edt.base.ui.editor.quickfix.AbstractVariableQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.CreateImportedFileQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DeclareArgumentQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DeclareEnumQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DeclareEventQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DeclareFieldQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DeclareVariableQuickFix;
import ro.amiq.edt.base.ui.editor.quickfix.DidYouMeanQuickFix;
import ro.amiq.etools.eparser.ReparseElement;

public abstract class EQuickFixUtilCommon
extends DVTQuickFixUtil {
    private static final String NEWLINE = System.lineSeparator();
    private static final String DEFAULT_TYPE = "int";
    public static final String QUICK_FIX_PROPOSAL_CATEGORY = "QuickFixCategory_";

    public List<ICompletionProposal> getProposalsByKind(IEPluginConfig pluginConfig, int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, boolean startMonitorJob, IProgressMonitor monitor) {
        if (startMonitorJob) {
            return this.computeQuickFixProposalsOnJob(pluginConfig, quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true);
        }
        return this.computeQuickFixProposals(pluginConfig, quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, true, monitor);
    }

    protected List<ICompletionProposal> getProposalsByKindInternal(IEPluginConfig pluginConfig, int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        boolean addDidYouMeanProposal = true;
        try {
            switch (quickFixKind) {
                case 1: {
                    EQuickFixUtilCommon.addDeclareProposals(pluginConfig, viewer, marker, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
                    break;
                }
                case 28: {
                    EQuickFixUtilCommon.addDeclareEventProposal(pluginConfig, viewer, marker, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
                    break;
                }
                case 39: {
                    RfModule includingFile = scope instanceof RfModule ? (RfModule)scope : (RfModule)((RfDefElement)scope).getDefFile();
                    List<ICompletionProposal> createFileProposals = EQuickFixUtilCommon.collectCreateImportedFileProposals(pluginConfig, elementName, includingFile, marker, viewer, offset, position, progressMonitor, isTooltipTriggered);
                    if (createFileProposals == null || createFileProposals.isEmpty()) break;
                    proposals.addAll(createFileProposals);
                    break;
                }
            }
            int wordLength = elementName.length();
            if (addDidYouMeanProposal && wordLength > 2) {
                ArrayList quickFixClass = new ArrayList();
                quickFixClass.add(DidYouMeanQuickFix.class);
                if (!EQuickFixUtilCommon.containsProposal(quickFixClass, existingProposals)) {
                    EQuickFixUtilCommon.addDidYouMeanProposal(pluginConfig, marker, viewer, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return proposals;
    }

    private static void addDeclareEventProposal(IEPluginConfig pluginConfig, ITextViewer viewer, IMarker marker, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        if (!(scope instanceof RfDefElement)) {
            return;
        }
        RfDefElement scopeDef = (RfDefElement)scope;
        DeclareEventQuickFix proposal = null;
        boolean isHierarchicalIdentifier = EQuickFixUtilCommon.isHierarchicalIdentifier(marker);
        Object[] enclosingStructResult = EQuickFixUtilCommon.getEnclosingLayer(scopeDef, progressMonitor, RfStructLayer.class);
        if (enclosingStructResult == null) {
            return;
        }
        RfDefElement enclosingStruct = (RfDefElement)enclosingStructResult[0];
        boolean isMonitorCancelled = (Boolean)enclosingStructResult[1];
        if (isMonitorCancelled && isTooltipTriggered) {
            proposals.clear();
            proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
            return;
        }
        if (enclosingStruct == null) {
            return;
        }
        RfDefElement structDef = isHierarchicalIdentifier ? EQuickFixUtilCommon.getHierarchicalIdentifierStructLayer(elementName, enclosingStruct, offset) : enclosingStruct;
        if (structDef == null) {
            return;
        }
        proposal = new DeclareEventQuickFix(pluginConfig, marker, viewer, structDef);
        proposal.setParameters(offset, position, scopeDef, elementName);
        proposals.add((ICompletionProposal)proposal);
    }

    private static void addDidYouMeanProposal(IEPluginConfig pluginConfig, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws BadLocationException {
        String distanceTo;
        if (!(scope instanceof IRfScope)) {
            return;
        }
        RfModule file = null;
        RfDefElement containingScope = null;
        if (scope instanceof RfDefElement) {
            containingScope = (RfDefElement)scope;
            file = (RfModule)containingScope.getDefFile();
        } else if (scope instanceof RfNamedElement) {
            file = ((RfNamedElement)scope).getModule();
        }
        if (file == null) {
            return;
        }
        IDocument document = file.getDocument();
        IRfSingleLangProject rfProject = file.getRfProject();
        if (document == null || rfProject == null) {
            return;
        }
        if (position == null) {
            return;
        }
        int startOffset = position.getOffset();
        if (marker.getAttribute("charStart", -1) == -1) {
            IRegion lineInfo = document.getLineInformationOfOffset(startOffset);
            String lineString = document.get(lineInfo.getOffset(), lineInfo.getLength());
            int elementNameIndex = lineString.indexOf(elementName);
            if (elementNameIndex < 0) {
                return;
            }
            startOffset += elementNameIndex;
        }
        int length = elementName.length();
        if (startOffset < 0 || length == 0) {
            return;
        }
        int line = document.getLineOfOffset(startOffset);
        IRfNamedElement[] candidates = EQuickFixUtilCommon.getSortedCandidates(pluginConfig, (RfProject)rfProject, (IRfScope)scope, file, document, startOffset + length, line, distanceTo = document.get(startOffset, length));
        if (candidates == null) {
            return;
        }
        int maxCandidates = Math.min(candidates.length, 3);
        int i = 0;
        while (i < maxCandidates) {
            if (progressMonitor.isCanceled() && isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                return;
            }
            IRfNamedElement candidate = candidates[i];
            String name = candidate.getName().trim();
            if (name != null && !name.isEmpty()) {
                if (containingScope == null) {
                    containingScope = (RfDefElement)EQuickFixUtilCommon.createDummyRfDefScope(file, (RfProject)rfProject);
                }
                DidYouMeanQuickFix proposal = new DidYouMeanQuickFix(marker, viewer, name, EQuickFixUtilCommon.getImage(candidate), file);
                proposal.setParameters(offset, (Position)new DVTPosition(startOffset, length), containingScope, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    private static Image getImage(IRfNamedElement candidate) {
        Image image = EContentAssistUtils.computeImageFromElement(candidate);
        if (image == null) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        }
        return image;
    }

    private static IRfNamedElement[] getSortedCandidates(IEPluginConfig pluginConfig, RfProject rfProject, IRfScope containingScope, RfModule file, IDocument document, int proposalEndOffset, int line, String distanceTo) {
        R2LProposalManager manager = new R2LProposalManager(pluginConfig, rfProject, containingScope, file.getPackageName(), file.getParserPath(), document, proposalEndOffset, line, true);
        R2LResultContainer r2lResultContainer = ((R2LManager)manager).getProposals();
        if (r2lResultContainer == null) {
            return null;
        }
        IRfNamedElement[] candidates = r2lResultContainer.candidates;
        if (candidates == null || candidates.length == 0 || candidates[0] instanceof R2LNoProposalElement) {
            return null;
        }
        ArrayList<RfNamedElement> listOfCandidates = new ArrayList<RfNamedElement>();
        HashSet<String> candidateNames = new HashSet<String>();
        IRfNamedElement[] iRfNamedElementArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String candidateName;
            RfNamedElement candidate = iRfNamedElementArray[n2];
            if (!(candidate instanceof R2LOverrideWizardElement || (candidateName = candidate.getName()).equals(distanceTo) || candidateNames.contains(candidateName))) {
                listOfCandidates.add(candidate);
                candidateNames.add(candidateName);
            }
            ++n2;
        }
        candidates = listOfCandidates.toArray(new IRfNamedElement[listOfCandidates.size()]);
        Arrays.sort(candidates, new MinWordDistanceComparator(distanceTo));
        return candidates;
    }

    private static boolean containsProposal(List<Class<?>> proposalsToCheck, List<ICompletionProposal> existingProposals) {
        for (ICompletionProposal existingProposal : existingProposals) {
            if (!proposalsToCheck.contains(existingProposal.getClass())) continue;
            return true;
        }
        return false;
    }

    private static void addDeclareProposals(IEPluginConfig pluginConfig, ITextViewer viewer, IMarker marker, IRfScopeElement scope, int offset, Position position, String elementName, List<ICompletionProposal> proposals, IProgressMonitor progressMonitor, boolean isTooltipTriggered) {
        RfScalarTypeLayer typeLayer;
        if (!(scope instanceof RfDefElement)) {
            return;
        }
        RfDefElement scopeDef = (RfDefElement)scope;
        AbstractVariableQuickFix proposal = null;
        Object[] enclosingMethodResult = EQuickFixUtilCommon.getEnclosingLayer(scopeDef, progressMonitor, RfMethodLayer.class);
        if (enclosingMethodResult == null) {
            return;
        }
        RfDefElement enclosingMethod = (RfDefElement)enclosingMethodResult[0];
        boolean isMonitorCancelled = (Boolean)enclosingMethodResult[1];
        if (isMonitorCancelled && isTooltipTriggered) {
            proposals.clear();
            proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
            return;
        }
        boolean isHierarchicalIdentifier = EQuickFixUtilCommon.isHierarchicalIdentifier(marker);
        if (!(scope instanceof RfMethodLayer) && enclosingMethod != null && !isHierarchicalIdentifier) {
            RfActionBlockLayer.ActionKind actionBlockKind;
            List<RfModule.IdentifierPosition> identifiersPositionForIdName = EQuickFixUtilCommon.getIdentifierPositionsInLayer(enclosingMethod, elementName);
            boolean isSingleIdentifier = identifiersPositionForIdName != null && identifiersPositionForIdName.size() == 1;
            RfModule.IdentifierPosition singleIdentifierPosition = isSingleIdentifier && identifiersPositionForIdName != null ? identifiersPositionForIdName.get(0) : null;
            RfDefElement declareVariableScope = scopeDef;
            if (scopeDef instanceof RfActionBlockLayer && ((actionBlockKind = ((RfActionBlockLayer)scopeDef).getActionKind()) == RfActionBlockLayer.ActionKind.DO_ACTION || actionBlockKind == RfActionBlockLayer.ActionKind.GEN_ACTION)) {
                declareVariableScope = (RfDefElement)((Object)scopeDef.getEnclosingScope());
            }
            proposal = new DeclareVariableQuickFix(pluginConfig, marker, viewer, enclosingMethod, isSingleIdentifier, singleIdentifierPosition);
            proposal.setParameters(offset, position, declareVariableScope, elementName);
            proposals.add((ICompletionProposal)proposal);
            if (enclosingMethod instanceof RfMethodLayer && ((RfMethodLayer)enclosingMethod).getMethod() != null && !((RfMethodLayer)enclosingMethod).getMethod().isPredefined()) {
                proposal = new DeclareArgumentQuickFix(marker, viewer, enclosingMethod);
                proposal.setParameters(offset, position, scopeDef, elementName);
                proposals.add((ICompletionProposal)proposal);
            }
        }
        if (isHierarchicalIdentifier && scope instanceof RfMethodLayer) {
            EQuickFixUtilCommon.addDeclareEventProposal(pluginConfig, viewer, marker, scope, offset, position, elementName, proposals, progressMonitor, isTooltipTriggered);
        }
        if ((typeLayer = EQuickFixUtilCommon.getPotentialScalarTypeToExtend(elementName, scopeDef, offset)) != null) {
            proposal = new DeclareEnumQuickFix(marker, viewer, typeLayer);
            proposal.setParameters(offset, position, scopeDef, elementName);
            proposals.add((ICompletionProposal)proposal);
        } else {
            Object[] enclosingStructResult = EQuickFixUtilCommon.getEnclosingLayer(scopeDef, progressMonitor, RfStructLayer.class);
            if (enclosingStructResult == null) {
                return;
            }
            RfDefElement enclosingStruct = (RfDefElement)enclosingStructResult[0];
            isMonitorCancelled = (Boolean)enclosingMethodResult[1];
            if (isMonitorCancelled && isTooltipTriggered) {
                proposals.clear();
                proposals.add(QUICK_FIX_TOOLTIP_CANCELLED);
                return;
            }
            if (enclosingStruct == null) {
                return;
            }
            RfDefElement structDef = isHierarchicalIdentifier ? EQuickFixUtilCommon.getHierarchicalIdentifierStructLayer(elementName, enclosingStruct, offset) : enclosingStruct;
            if (structDef == null) {
                return;
            }
            boolean isStaticAccess = marker.getAttribute("QUICKFIX_STATIC_ID", false);
            proposal = new DeclareFieldQuickFix(pluginConfig, marker, viewer, structDef, isStaticAccess);
            proposal.setParameters(offset, position, scopeDef, elementName);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private static RfScalarTypeLayer getPotentialScalarTypeToExtend(String elementName, RfDefElement enclosingLayer, int offset) {
        if (enclosingLayer == null || offset < 0) {
            return null;
        }
        IRfFileDef moduleFileDef = enclosingLayer.getDefFile();
        if (!(moduleFileDef instanceof RfModule)) {
            return null;
        }
        RfModule module = (RfModule)moduleFileDef;
        RfModule.IdentifierPosition identifierPosition = module.getIdentifier(elementName, offset);
        if (identifierPosition == null) {
            return null;
        }
        RfNamedElement namedElement = identifierPosition.getNamedElement();
        if (!(namedElement instanceof RfUndefVariable)) {
            return null;
        }
        RfUndefVariable undefVariable = (RfUndefVariable)namedElement;
        IRfNamedElement associatedType = undefVariable.getAssociatedType();
        if (!(associatedType instanceof IRfAssociatedTypeElement)) {
            return null;
        }
        IRfNamedElement expectedType = ((IRfAssociatedTypeElement)associatedType).getAssociatedType();
        if (!(expectedType instanceof RfScalarType)) {
            return null;
        }
        int maxLayerModuleIndex = -1;
        RfScalarTypeLayer layerToExtend = null;
        RfScalarType scalarType = (RfScalarType)expectedType;
        List<RfDefElement> scalarTypeLayers = scalarType.getLayers();
        for (RfDefElement typeLayer : scalarTypeLayers) {
            int layerModuleIndex;
            if (!(typeLayer instanceof RfScalarTypeLayer) || (layerModuleIndex = typeLayer.getModuleIndex()) <= maxLayerModuleIndex || layerModuleIndex > module.getModuleIndex()) continue;
            layerModuleIndex = maxLayerModuleIndex;
            layerToExtend = (RfScalarTypeLayer)typeLayer;
        }
        return layerToExtend;
    }

    private static boolean isHierarchicalIdentifier(IMarker marker) {
        return marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
    }

    private static List<ICompletionProposal> collectCreateImportedFileProposals(IEPluginConfig pluginConfig, String fileName, RfModule includingFile, IMarker marker, ITextViewer viewer, int offset, Position position, IProgressMonitor progressMonitor, boolean isTooltipTriggered) throws Exception {
        if (fileName == null || fileName.isEmpty() || ".e".equals(fileName) || includingFile == null) {
            return null;
        }
        IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)fileName);
        ImageDescriptor imageDescriptor = editorDescriptor == null ? null : editorDescriptor.getImageDescriptor();
        Image image = imageDescriptor == null ? null : DVTImages.imageCache.getImage(imageDescriptor);
        IResource includingFileResource = includingFile.getFileAdapter();
        if (includingFileResource == null) {
            return null;
        }
        IProject project = includingFileResource.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IEProject eProject = pluginConfig.getModelManager().getEModel().getEProject(project);
        if (eProject == null) {
            return null;
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(true);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return null;
        }
        IPath includingFileLocation = includingFileResource.getLocation();
        if (includingFileLocation == null) {
            return null;
        }
        Path includingFileParentPath = includingFileLocation.removeLastSegments(1).toFile().toPath();
        if (includingFileParentPath == null) {
            return null;
        }
        LinkedHashSet<Path> specmanPaths = new LinkedHashSet<Path>();
        specmanPaths.add(includingFileParentPath);
        String rawSpecmanPath = compilationUnitProperties.getDvtSpecmanPath();
        if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
            String[] specmanPath;
            String[] stringArray = specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
            int n = specmanPath.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                if (progressMonitor.isCanceled() && isTooltipTriggered) {
                    return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
                }
                if (!path.isEmpty()) {
                    specmanPaths.add(Paths.get(path, new String[0]));
                }
                ++n2;
            }
        }
        if (specmanPaths.isEmpty()) {
            return null;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Path includePath = Paths.get(fileName, new String[0]).normalize();
        if (includePath.getFileName() == null) {
            return null;
        }
        IRfDefElement dummyEnclosingScope = EQuickFixUtilCommon.createDummyRfDefScope(includingFile, rfProject);
        HashSet<Path> proposalFilePaths = new HashSet<Path>();
        for (Path specmanPath : specmanPaths) {
            if (progressMonitor.isCanceled() && isTooltipTriggered) {
                return Collections.singletonList(QUICK_FIX_TOOLTIP_CANCELLED);
            }
            Path filePathInIncDir = specmanPath.resolve(includePath);
            Path normalizedFilePathInIncDir = filePathInIncDir.normalize();
            Path parentOfFileInIncDir = filePathInIncDir.getParent();
            if (proposalFilePaths.contains(normalizedFilePathInIncDir) || parentOfFileInIncDir == null || !Files.isWritable(parentOfFileInIncDir) || !Files.isExecutable(parentOfFileInIncDir)) continue;
            proposalFilePaths.add(normalizedFilePathInIncDir);
            CreateImportedFileQuickFix proposal = new CreateImportedFileQuickFix(pluginConfig, marker, viewer, filePathInIncDir.toFile(), image);
            proposal.setParameters(offset, position, dummyEnclosingScope, includePath.toString());
            proposals.add((ICompletionProposal)proposal);
        }
        String includingFileDirectory = includingFileParentPath.toString();
        proposals.sort((o1, o2) -> {
            if (!(o1 instanceof CreateImportedFileQuickFix) && !(o2 instanceof CreateImportedFileQuickFix)) {
                return -1;
            }
            String parentDir1 = ((CreateImportedFileQuickFix)((Object)o1)).getFileParentDir();
            String parentDir2 = ((CreateImportedFileQuickFix)((Object)o2)).getFileParentDir();
            if (parentDir1.equals(includingFileDirectory)) {
                return -1;
            }
            if (parentDir2.equals(includingFileDirectory)) {
                return 1;
            }
            return parentDir1.compareTo(parentDir2);
        });
        return proposals;
    }

    private static IRfDefElement createDummyRfDefScope(final RfModule includingFile, final RfProject rfProject) {
        RfDefElement dummyEnclosingScope = new RfDefElement(null, null, 0, new LineInfo(0, 0, -1), new LineInfo(0, 0, -1), null, null){

            @Override
            public IRfFileDef getDefFile() {
                return includingFile;
            }

            @Override
            public RfProject getRfProject() {
                return rfProject;
            }

            public String getInfo() {
                return null;
            }
        };
        return dummyEnclosingScope;
    }

    public static Object[] getEnclosingLayer(RfDefElement scopeDef, IProgressMonitor progressMonitor, Class<?> ... classes) {
        boolean isMonitorCancelled;
        block6: {
            HashSet classesSet = new HashSet(Arrays.asList(classes));
            isMonitorCancelled = false;
            do {
                IRfScope enclosing;
                if (classesSet.contains(scopeDef.getClass())) {
                    return new Object[]{scopeDef, false};
                }
                if (progressMonitor.isCanceled()) break block6;
                if (scopeDef instanceof IRfScope) {
                    enclosing = ((IRfScope)((Object)scopeDef)).getEnclosingScope();
                    if (!(enclosing instanceof RfDefElement)) {
                        Object[] objectArray = new Object[2];
                        objectArray[1] = isMonitorCancelled;
                        return objectArray;
                    }
                } else {
                    Object[] objectArray = new Object[2];
                    objectArray[1] = isMonitorCancelled;
                    return objectArray;
                }
                scopeDef = (RfDefElement)((Object)enclosing);
            } while (!(scopeDef instanceof RfStructLayer) || classesSet.contains(scopeDef.getClass()));
            Object[] objectArray = new Object[2];
            objectArray[1] = isMonitorCancelled;
            return objectArray;
        }
        isMonitorCancelled = true;
        if (isMonitorCancelled) {
            Object[] objectArray = new Object[2];
            objectArray[1] = isMonitorCancelled;
            return objectArray;
        }
        return new Object[]{scopeDef, false};
    }

    public static RfDefElement getEncompassingScopeOfIdentifiers(String idName, RfDefElement methodLayer, RfDefElement startScope) {
        List<RfModule.IdentifierPosition> identifiersForIdName = EQuickFixUtilCommon.getIdentifierPositionsInLayer(methodLayer, idName);
        int[] offsetPair = EQuickFixUtilCommon.getEncompassingScopeOffsetPairForIdentifier(identifiersForIdName);
        if (offsetPair == null) {
            return null;
        }
        int scopeMinOffset = offsetPair[0];
        int scopeMaxOffset = offsetPair[1];
        return EQuickFixUtilCommon.getEncompassingScopeInternal(startScope, scopeMinOffset, scopeMaxOffset);
    }

    public static List<RfModule.IdentifierPosition> getIdentifierPositionsInLayer(RfDefElement methodLayer, String idName) {
        if (methodLayer == null) {
            return Collections.emptyList();
        }
        IRfFileDef layerFileDef = methodLayer.getDefFile();
        if (!(layerFileDef instanceof RfModule)) {
            return Collections.emptyList();
        }
        List<RfModule.IdentifierPosition> identifiers = ((RfModule)layerFileDef).getIdentifiers(idName);
        if (identifiers == null) {
            return Collections.emptyList();
        }
        ArrayList<RfModule.IdentifierPosition> methodLayerIdentifiers = new ArrayList<RfModule.IdentifierPosition>();
        int methodLayerStartOffset = methodLayer.getStartOffset();
        int methodLayerEndOffset = methodLayer.getEndOffset();
        Region methodRegion = new Region(methodLayerStartOffset, methodLayerEndOffset - methodLayerStartOffset);
        for (RfModule.IdentifierPosition identifier : identifiers) {
            int idOffset = identifier.getOffset();
            RfNamedElement namedElement = identifier.getNamedElement();
            if (!(namedElement instanceof RfUndefVariable) || !((RfUndefVariable)namedElement).isInCurrentScope() || !DVTDocumentUtils.regionContains((IRegion)methodRegion, (int)idOffset)) continue;
            methodLayerIdentifiers.add(identifier);
        }
        return methodLayerIdentifiers;
    }

    private static int[] getEncompassingScopeOffsetPairForIdentifier(List<RfModule.IdentifierPosition> identifiers) {
        int[] offsets = new int[2];
        int identifierOccurrenceMinOffset = Integer.MAX_VALUE;
        int identifierOccurenceMaxOffset = Integer.MIN_VALUE;
        for (RfModule.IdentifierPosition identifier : identifiers) {
            int idOffset = identifier.getOffset();
            if (idOffset < identifierOccurrenceMinOffset) {
                identifierOccurrenceMinOffset = idOffset;
            }
            if (idOffset <= identifierOccurenceMaxOffset) continue;
            identifierOccurenceMaxOffset = idOffset;
        }
        offsets[0] = identifierOccurrenceMinOffset;
        offsets[1] = identifierOccurenceMaxOffset;
        return offsets;
    }

    public static RfDefElement getEncompassingScopeInternal(RfDefElement startScope, int scopeMinOffset, int scopeMaxOffset) {
        RfDefElement encompassingScope = startScope;
        while (!(encompassingScope instanceof RfMethodLayer) && encompassingScope != null) {
            if (encompassingScope.containsOffset(scopeMinOffset) && encompassingScope.containsOffset(scopeMaxOffset) && !(encompassingScope instanceof RfConstraintLayer) && encompassingScope.getLayerKind() != 172 && encompassingScope.getLayerKind() != 173) break;
            if (encompassingScope instanceof RfActionBlockLayer) {
                encompassingScope = (RfDefElement)((Object)((RfActionBlockLayer)encompassingScope).getEnclosingScope());
                continue;
            }
            if (encompassingScope instanceof RfMethodLayer) {
                encompassingScope = ((RfMethodLayer)encompassingScope).getEnclosingScope(RfStructLayer.class);
                continue;
            }
            if (encompassingScope instanceof RfCoverLayer) {
                encompassingScope = (RfDefElement)((Object)((RfCoverLayer)encompassingScope).getEnclosingScope());
                continue;
            }
            if (!(encompassingScope instanceof RfConstraintLayer)) continue;
            encompassingScope = (RfDefElement)((Object)((RfConstraintLayer)encompassingScope).getEnclosingScope());
        }
        if (encompassingScope == null) {
            return startScope;
        }
        return encompassingScope;
    }

    public static String guessType(String elementName, RfDefElement enclosingMethod, int offset) {
        if (enclosingMethod == null || offset < 0) {
            return DEFAULT_TYPE;
        }
        IRfFileDef moduleFileDef = enclosingMethod.getDefFile();
        if (!(moduleFileDef instanceof RfModule)) {
            return DEFAULT_TYPE;
        }
        RfModule module = (RfModule)moduleFileDef;
        RfModule.IdentifierPosition identifierPosition = module.getIdentifier(elementName, offset);
        if (identifierPosition == null) {
            return DEFAULT_TYPE;
        }
        RfNamedElement identifierElement = identifierPosition.getNamedElement();
        if (!(identifierElement instanceof RfUndefVariable)) {
            return DEFAULT_TYPE;
        }
        IRfNamedElement identifierAssocType = ((RfUndefVariable)identifierElement).getAssociatedType();
        if (identifierAssocType == null) {
            return DEFAULT_TYPE;
        }
        if (identifierAssocType instanceof IRfAssociatedType) {
            if ((identifierAssocType = ((IRfAssociatedType)identifierAssocType).getAssociatedType()) == null) {
                return DEFAULT_TYPE;
            }
            return ((RfNamedElement)identifierAssocType).getName();
        }
        return identifierAssocType.getName();
    }

    public static RfDefElement getHierarchicalIdentifierStructLayer(String elementName, RfDefElement enclosingLayer, int offset) {
        if (enclosingLayer == null || offset < 0) {
            return null;
        }
        IRfFileDef moduleFileDef = enclosingLayer.getDefFile();
        if (!(moduleFileDef instanceof RfModule)) {
            return null;
        }
        RfModule module = (RfModule)moduleFileDef;
        RfModule.IdentifierPosition identifierPosition = module.getIdentifier(elementName, offset);
        if (identifierPosition == null) {
            return null;
        }
        RfNamedElement namedElement = identifierPosition.getNamedElement();
        if (!(namedElement instanceof RfUndefVariable)) {
            return identifierPosition.getDefElement();
        }
        RfUndefVariable undefVariable = (RfUndefVariable)namedElement;
        if (undefVariable.isInCurrentScope()) {
            return enclosingLayer;
        }
        Determinant identifierDeterminant = undefVariable.getParentScopeDeterminant();
        List<RfDefElement> identifierStructLayers = undefVariable.getParentScopeLayers();
        if (identifierStructLayers == null || identifierStructLayers.isEmpty()) {
            return null;
        }
        if (identifierDeterminant == null) {
            return identifierStructLayers.get(0);
        }
        boolean skipFirstLayer = false;
        for (RfDefElement layer : identifierStructLayers) {
            ReparseElement[] reparseStack = ((RfStructLayer)layer).getReparseStack();
            if (!(layer instanceof RfStructLayer) || reparseStack != null || ((RfStructLayer)layer).isImplicit()) {
                skipFirstLayer = true;
                continue;
            }
            Determinant layerDeterminant = ((RfStructLayer)layer).getDeterminant();
            if (layerDeterminant == null || !layerDeterminant.contains(identifierDeterminant, true)) continue;
            return layer;
        }
        if (identifierStructLayers.size() == 1 && skipFirstLayer) {
            return null;
        }
        return identifierStructLayers.get(0);
    }

    public static int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces) {
        return EQuickFixUtilCommon.getBackwardOffsetFor(document, text, minOffsetLimit, offset, grabWhiteSpaces, false);
    }

    private static int getBackwardOffsetFor(IDocument document, String text, int minOffsetLimit, int offset, boolean grabWhiteSpaces, boolean grabEndOfLine) {
        try {
            grabWhiteSpaces |= grabEndOfLine;
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return scanner.getOffset();
                }
                content = ((IDocumentExtension3)document).getContentType("__e_partitioning", scanner.getOffset(), false);
                if (!content.equals("__dftl_partition_content_type")) continue;
                index = (char)ch == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    ch = scanner.read();
                    if (!(Character.isJavaIdentifierStart(text.charAt(0)) && Character.isJavaIdentifierStart((char)ch) || ch != -1 && Character.isWhitespace((char)ch) && Character.isJavaIdentifierPart((char)ch))) {
                        while (grabWhiteSpaces && Character.isWhitespace((char)ch) && (grabEndOfLine || (char)ch != '\r' && (char)ch != '\n')) {
                            ch = scanner.read();
                        }
                        scanner.unread();
                        return scanner.getOffset();
                    }
                    index = 0;
                }
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
            return minOffsetLimit;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public static void addChangesInOrderToComposite(CompositeChange compositeChange, DVTTextFileChange functionDefTextFileChange, DVTTextFileChange functionDeclTextFileChange) {
        int functionDeclFileChangeOffset;
        int functionDefFileChangeOffset = functionDefTextFileChange.getEdit().getOffset();
        if (functionDefFileChangeOffset < (functionDeclFileChangeOffset = functionDeclTextFileChange.getEdit().getOffset())) {
            compositeChange.add((Change)functionDefTextFileChange);
            compositeChange.add((Change)functionDeclTextFileChange);
        } else {
            compositeChange.add((Change)functionDeclTextFileChange);
            compositeChange.add((Change)functionDefTextFileChange);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean textContainsStatement(IDocument document, String text, int minOffsetLimit, int offset) {
        try {
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            int index = 0;
            char pch = ' ';
            do {
                int ch;
                if ((ch = scanner.read()) == -1) {
                    scanner.unread();
                    return false;
                }
                content = ((IDocumentExtension3)document).getContentType("__e_partitioning", scanner.getOffset(), false);
                if (!content.equals("__dftl_partition_content_type")) continue;
                index = (char)ch == text.charAt(text.length() - index - 1) && (index != 0 || index == 0 && Character.isJavaIdentifierPart(ch) && !Character.isJavaIdentifierPart(pch) || index == 0 && !Character.isJavaIdentifierPart(ch)) ? ++index : 0;
                if (index == text.length()) {
                    return true;
                }
                pch = (char)ch;
            } while (scanner.getOffset() > minOffsetLimit);
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static String indentSelection(DVTEditor editor, String text, String indent, String indentStep) {
        int relativeIndentLength = TextUtils.replaceTabsWithSpacesVisual((String)indent, (int)editor.getTabWidth()).length();
        String functionSignatureFormatted = DVTStringUtil.mapSplitLines((String)text, (String)NEWLINE, (line, index) -> {
            String funcLine = TextUtils.replaceTabsWithSpacesVisual((String)line, (int)editor.getTabWidth());
            funcLine = TextUtils.trimNumberOfWhitespacesFromBeginningOfString((String)funcLine, (int)relativeIndentLength);
            return String.valueOf(indentStep) + indentStep + funcLine;
        });
        return functionSignatureFormatted;
    }

    protected abstract List<ICompletionProposal> computeQuickFixProposalsOnJob(IEPluginConfig var1, int var2, boolean var3, IMarker var4, ITextViewer var5, IRfScopeElement var6, int var7, Position var8, String var9, List<ICompletionProposal> var10, boolean var11);

    protected abstract List<ICompletionProposal> computeQuickFixProposals(IEPluginConfig var1, int var2, boolean var3, IMarker var4, ITextViewer var5, IRfScopeElement var6, int var7, Position var8, String var9, List<ICompletionProposal> var10, boolean var11, IProgressMonitor var12);
}

