/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.rules.CommentTaskRule;

public class ECommentTaskRule
extends CommentTaskRule {
    public ECommentTaskRule(IToken taskTagToken, IToken pragmaToken, boolean enable) {
        super(taskTagToken, pragmaToken, enable);
    }

    public IToken evaluate(DVTBaseScanner scanner, boolean enable) {
        int c = scanner.read();
        int offset = scanner.getOffset() - 1;
        if (Character.isJavaIdentifierPart((char)c) || c == 64) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && Character.isJavaIdentifierPart((char)c));
            scanner.unread();
            String text = this.fBuffer.toString();
            if (text.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
                this.addPosition(scanner.getDocument(), DVTFoldingPosition.Type.MACRO_EXPANSION, DVTFoldingPosition.SubType.START, offset, this.fBuffer.length());
                return this.fPragmaToken;
            }
            if (text.equals("@DVT_EXPAND_MACRO_INLINE_ORIGINAL")) {
                this.addPosition(scanner.getDocument(), DVTFoldingPosition.Type.MACRO_EXPANSION, DVTFoldingPosition.SubType.ORIGINAL, offset, this.fBuffer.length());
                return this.fPragmaToken;
            }
            if (text.equals("@DVT_EXPAND_MACRO_INLINE_END")) {
                this.addPosition(scanner.getDocument(), DVTFoldingPosition.Type.MACRO_EXPANSION, DVTFoldingPosition.SubType.END, offset, this.fBuffer.length());
                return this.fPragmaToken;
            }
            if (this.fCaseSensitive && this.fWords.contains(text)) {
                return this.fDefaultToken;
            }
            if (!this.fCaseSensitive && this.fWords.contains(text.toLowerCase())) {
                return this.fDefaultToken;
            }
            scanner.unreadLength(this.fBuffer.length());
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate((DVTBaseScanner)scanner, this.fEnable);
    }
}

