/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class EConsecutiveCharsRule
implements IRule {
    private char[] fConsecutiveChars;
    private IToken fDefaultToken;

    public EConsecutiveCharsRule(char[] consecutiveChars, IToken defaultToken) {
        Assert.isNotNull((Object)defaultToken);
        Assert.isTrue((!defaultToken.isUndefined() ? 1 : 0) != 0);
        this.fConsecutiveChars = consecutiveChars;
        this.fDefaultToken = defaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.detectSequence(scanner, this.fConsecutiveChars)) {
            return this.fDefaultToken;
        }
        return Token.UNDEFINED;
    }

    private boolean detectSequence(ICharacterScanner scanner, char[] sequence) {
        int c = scanner.read();
        if (c == -1) {
            scanner.unread();
            return false;
        }
        int i = 0;
        while (i < sequence.length) {
            if (c != sequence[i]) {
                int j = 0;
                while (j <= i) {
                    scanner.unread();
                    ++j;
                }
                return false;
            }
            if (i != sequence.length - 1) {
                c = scanner.read();
            }
            ++i;
        }
        return true;
    }
}

