/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;

public class EHDLPathRule
implements IPredicateRule {
    private IToken fToken;

    public EHDLPathRule(IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    private boolean endSequenceDetected(ICharacterScanner scanner) {
        char c;
        int length = 0;
        while ((c = (char)scanner.read()) != '\uffff') {
            ++length;
            if (!(c == '\'' || c == '$' || c == '(' || c == ')' || c >= '.' && c <= ':' || c >= '@' && c <= '[') && (c < ']' || c > '~')) break;
            if (c != '\'') continue;
            return true;
        }
        ((DVTBaseScanner)scanner).unreadLength(length);
        return false;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            if (this.endSequenceDetected(scanner)) {
                return this.fToken;
            }
        } else {
            int c = scanner.read();
            if (c == 39) {
                DVTBaseScanner dvtBaseScanner = (DVTBaseScanner)scanner;
                try {
                    int offset = dvtBaseScanner.getOffset();
                    char pch = dvtBaseScanner.getDocument().getChar(offset - 2);
                    if (Character.isJavaIdentifierPart(pch)) {
                        scanner.unread();
                        return Token.UNDEFINED;
                    }
                }
                catch (BadLocationException badLocationException) {}
                if (this.endSequenceDetected(scanner)) {
                    return this.fToken;
                }
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

