/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.encrypted;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.edt.base.core.IEPluginConfig;

public abstract class AbstractEncryptedLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public abstract IEPluginConfig getPluginConfig();

    public void decorate(Object element, IDecoration decoration) {
        try {
            IResource objectResource = this.getResource(element);
            if (objectResource == null) {
                return;
            }
            if (!objectResource.isAccessible()) {
                return;
            }
            IProject project = objectResource.getProject();
            if (project == null) {
                return;
            }
            if (!project.hasNature(this.getPluginConfig().getNature())) {
                return;
            }
            if (objectResource instanceof IFile && PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_ENCRYPTED_FILE) != null) {
                decoration.addOverlay(DVTImages.DESC_OVR_ENCRYPTED, 2);
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public void refresh(Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, elements)));
    }
}

