/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.macroexpansion;

import java.util.regex.Pattern;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.utils.EDTFileUtils;

public class MacroExpander {
    public static final int ONE_LEVEL = 1;
    public static final int ALL_LEVELS = Integer.MAX_VALUE;
    private static final Pattern p1 = Pattern.compile(";\\s*;+");
    private static final Pattern p2 = Pattern.compile("\\{\\s*");
    private static final Pattern p3 = Pattern.compile("(\\};?)\\s*");
    private static final Pattern p4 = Pattern.compile("\\s*;\\s*");

    public String expand(int initialIndent, String input, RfProject project, String contentType, int maxLevel, String expanded) throws Exception {
        return MacroExpander.formatMacroText(initialIndent, expanded);
    }

    public static String formatMacroText(int initialIndent, String unformatted) {
        if (unformatted == null) {
            return null;
        }
        String newLineAdded = unformatted.trim();
        newLineAdded = DVTStringUtil.replaceAll((Pattern)p1, (CharSequence)newLineAdded, (String)";");
        newLineAdded = DVTStringUtil.replaceAll((Pattern)p2, (CharSequence)newLineAdded, (String)"\\{\n");
        newLineAdded = DVTStringUtil.replaceAll((Pattern)p3, (CharSequence)newLineAdded, (String)"\n$1\n");
        newLineAdded = DVTStringUtil.replaceAll((Pattern)p4, (CharSequence)newLineAdded, (String)";\n");
        return EDTFileUtils.getInstance().formatText(initialIndent, newLineAdded);
    }
}

