/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.macroexpansion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.EWordFinder;

public class MacroExpansionScanner {
    String fPragmaString;
    int fPragmaStartOffset;
    Position fStartPosition;
    Position fOriginalPosition;
    Position fEndPosition;
    boolean fNested;
    private Position[] fPositions;
    private IDocument fDocument;

    public Expansion getExpansion(IDocument document, int cursorOffset) {
        this.clear();
        this.fDocument = document;
        try {
            this.scanPragma(document, cursorOffset);
            if (this.fPragmaString == null || !this.fPragmaString.equals("@DVT_EXPAND_MACRO_INLINE_START")) {
                return Expansion.makeIllegalExpansion();
            }
            this.fPositions = document.getPositions("__dvt_macro_position");
            if (!this.basicCheck()) {
                return Expansion.makeBrokenExpansion();
            }
            boolean broken = true;
            int i = 0;
            while (i < this.fPositions.length) {
                if (this.fPositions[i].getOffset() == this.fPragmaStartOffset) {
                    this.fStartPosition = this.fPositions[i];
                    if (this.fPositions.length <= i + 1 || ((DVTFoldingPosition)this.fPositions[i + 1]).getType() != DVTFoldingPosition.Type.MACRO_EXPANSION || ((DVTFoldingPosition)this.fPositions[i + 1]).getSubType() != DVTFoldingPosition.SubType.ORIGINAL) break;
                    this.fOriginalPosition = this.fPositions[i + 1];
                    i += 2;
                    broken = false;
                    break;
                }
                ++i;
            }
            if (broken) {
                return Expansion.makeBrokenExpansion();
            }
            int nested = 0;
            broken = true;
            while (i < this.fPositions.length) {
                if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.START) {
                    ++nested;
                    this.fNested = true;
                } else if (((DVTFoldingPosition)this.fPositions[i]).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION && ((DVTFoldingPosition)this.fPositions[i]).getSubType() == DVTFoldingPosition.SubType.END) {
                    if (nested == 0) {
                        broken = false;
                        this.fEndPosition = this.fPositions[i];
                        break;
                    }
                    --nested;
                }
                ++i;
            }
            if (broken) {
                return Expansion.makeBrokenExpansion();
            }
            int expansionStartLine = this.fDocument.getLineOfOffset(this.fStartPosition.offset);
            int expansionOrigLine = this.fDocument.getLineOfOffset(this.fOriginalPosition.offset);
            int expansionEndLine = this.fDocument.getLineOfOffset(this.fEndPosition.offset);
            return new Expansion(this.fNested, Math.max(0, this.getStartOffset(this.fStartPosition.offset)), this.fDocument.getLineOffset(expansionEndLine) + this.fDocument.getLineLength(expansionEndLine), this.fDocument.getLineOffset(expansionStartLine + 1), this.fDocument.getLineOffset(expansionOrigLine - 1) + this.fDocument.getLineLength(expansionOrigLine - 1) - this.fDocument.getLineDelimiter(expansionOrigLine - 1).length());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private int getStartOffset(int offset) {
        try {
            ITypedRegion region = RfUtils.getTypedRegion(this.fDocument, offset);
            offset = region.getOffset() - 1;
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, this.fDocument, offset, false);
            char c = '\u0000';
            while (Character.isWhitespace(c = (char)scanner.read()) && c != '\r' && c != '\n') {
            }
            int oldOffset = scanner.getOffset() + 1;
            if (c == '\n') {
                c = (char)scanner.read();
                if (c != '\r') {
                    scanner.unread();
                }
                offset = scanner.getOffset();
            } else if (c == '\r') {
                offset = scanner.getOffset();
            }
            region = RfUtils.getTypedRegion(this.fDocument, offset);
            if (region == null || !region.getType().equals("__dftl_partition_content_type")) {
                return oldOffset;
            }
            return offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return offset;
        }
    }

    private void clear() {
        this.fDocument = null;
        this.fStartPosition = null;
        this.fOriginalPosition = null;
        this.fEndPosition = null;
        this.fNested = false;
        this.fPositions = null;
    }

    private void scanPragma(IDocument document, int offset) throws BadLocationException {
        this.fPragmaStartOffset = -1;
        this.fPragmaString = null;
        IRegion region = EWordFinder.getDefault().getWordAtOffset(document, offset, "@");
        if (region.getOffset() > 0) {
            this.fPragmaStartOffset = region.getOffset();
            this.fPragmaString = document.get(region.getOffset(), region.getLength());
        }
    }

    private boolean basicCheck() {
        if (this.fPositions.length % 3 != 0) {
            return false;
        }
        int startPositions = 0;
        int originalPositions = 0;
        int endPositions = 0;
        Position[] positionArray = this.fPositions;
        int n = this.fPositions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p = positionArray[n2];
            if (p instanceof DVTFoldingPosition && ((DVTFoldingPosition)p).getType() == DVTFoldingPosition.Type.MACRO_EXPANSION) {
                DVTFoldingPosition.SubType subType = ((DVTFoldingPosition)p).getSubType();
                if (subType == DVTFoldingPosition.SubType.START) {
                    ++startPositions;
                } else if (subType == DVTFoldingPosition.SubType.ORIGINAL) {
                    ++originalPositions;
                } else if (subType == DVTFoldingPosition.SubType.END) {
                    ++endPositions;
                }
            }
            ++n2;
        }
        return startPositions == originalPositions && originalPositions == endPositions;
    }

    public static class Expansion {
        boolean fIllegal;
        boolean fBroken;
        boolean fNested;
        int fStartOffset;
        int fEndOffset;
        int fOriginalStartOffset;
        int fOriginalEndOffset;

        public Expansion(boolean fNested, int fStartOffset, int fEndOffset, int fOriginalStartOffset, int fOriginalEndOffset) {
            this.fNested = fNested;
            this.fStartOffset = fStartOffset;
            this.fEndOffset = fEndOffset;
            this.fOriginalStartOffset = fOriginalStartOffset;
            this.fOriginalEndOffset = fOriginalEndOffset;
        }

        public Expansion() {
        }

        static Expansion makeBrokenExpansion() {
            Expansion e = new Expansion();
            e.setBroken(true);
            return e;
        }

        static Expansion makeIllegalExpansion() {
            Expansion e = new Expansion();
            e.setIllegal(true);
            return e;
        }

        public boolean isNested() {
            return this.fNested;
        }

        public void setNested(boolean nested) {
            this.fNested = nested;
        }

        public int getOriginalStartOffset() {
            return this.fOriginalStartOffset;
        }

        public void setOriginalStartOffset(int originalStartOffset) {
            this.fOriginalStartOffset = originalStartOffset;
        }

        public int getOriginalEndOffset() {
            return this.fOriginalEndOffset;
        }

        public void setOriginalEndOffset(int originalEndOffset) {
            this.fOriginalEndOffset = originalEndOffset;
        }

        public int getStartOffset() {
            return this.fStartOffset;
        }

        public void setStartOffset(int startOffset) {
            this.fStartOffset = startOffset;
        }

        public int getEndOffset() {
            return this.fEndOffset;
        }

        public void setEndOffset(int endOffset) {
            this.fEndOffset = endOffset;
        }

        public boolean isBroken() {
            return this.fBroken;
        }

        public void setBroken(boolean broken) {
            this.fBroken = broken;
        }

        public boolean isIllegal() {
            return this.fIllegal;
        }

        public void setIllegal(boolean illegal) {
            this.fIllegal = illegal;
        }

        public String toString() {
            return "Expansion [fIllegal=" + this.fIllegal + ", fBroken=" + this.fBroken + ", fNested=" + this.fNested + ", fStartOffset=" + this.fStartOffset + ", fEndOffset=" + this.fEndOffset + ", fOriginalStartOffset=" + this.fOriginalStartOffset + ", fOriginalEndOffset=" + this.fOriginalEndOffset + "]";
        }
    }
}

