/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.macromarkers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.IDVTCustomTextProvider;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.macromarkers.MarkerTextProvider;

public abstract class AbstractMacroMarkersManager {
    private IDVTCustomTextProvider fTextProvider;

    public abstract String getMacroMarkerID();

    public void reparsed(RfProject rfProject) {
        if (rfProject == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(rfProject.getProject(), rfProject.getPluginConfig().feature())) {
            return;
        }
        HashMap macroLayersMap = new HashMap();
        List<RfMacro> macros = rfProject.getAllMacros(false, false);
        for (RfMacro rfMacro : macros) {
            if (rfMacro.isAsComputed()) continue;
            RfDefElement declaration = rfMacro.getDeclaration(false);
            List<RfDefElement> layers = rfMacro.getLayers();
            for (RfDefElement layer : layers) {
                if (layer == declaration || ((RfMacroLayer)layer).getUserDefinedReplace() == null) continue;
                ParserPath parserPath = layer.getLayerModule().getParserPath();
                List<RfMacroLayer> macroLayers = null;
                if (!macroLayersMap.containsKey(parserPath)) {
                    macroLayers = new ArrayList();
                    macroLayersMap.put(parserPath, macroLayers);
                } else {
                    macroLayers = (List)macroLayersMap.get(parserPath);
                }
                macroLayers.add((RfMacroLayer)layer);
            }
        }
        for (Map.Entry entry : macroLayersMap.entrySet()) {
            ParserPath parserPath = (ParserPath)entry.getKey();
            IFile file = (IFile)rfProject.getModule(parserPath).getAdapter(IResource.class);
            if (file == null) continue;
            this.updateMarkers(file, (List)entry.getValue());
        }
    }

    private void updateMarkers(final IFile file, final List<RfMacroLayer> macroLayers) {
        try {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    file.deleteMarkers(AbstractMacroMarkersManager.this.getMacroMarkerID(), false, 0);
                    if (macroLayers == null) {
                        return;
                    }
                    for (RfMacroLayer macroInfo : macroLayers) {
                        int lineNumber = macroInfo.getStartLine();
                        if (lineNumber <= 0) {
                            lineNumber = 1;
                        }
                        if (macroInfo.getUserDefinedReplace() == null) continue;
                        IMarker marker = file.createMarker(AbstractMacroMarkersManager.this.getMacroMarkerID());
                        marker.setAttribute("lineNumber", lineNumber);
                        marker.setAttribute("priority", 2);
                        marker.setAttribute("severity", 0);
                        marker.setAttribute("message", (Object)macroInfo.getUserDefinedReplace());
                    }
                }
            };
            file.getWorkspace().run(r, null, 1, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static String joinMacroParams(String[] params) {
        StringBuilder joinedParams = new StringBuilder();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (joinedParams.length() == 0) {
                joinedParams.append(param);
            } else {
                joinedParams.append("\uffff").append(param);
            }
            ++n2;
        }
        return joinedParams.toString();
    }

    public static String[] splitMacroParams(String joinedParams) {
        return joinedParams.split("\uffff");
    }

    public IDVTCustomTextProvider getTextProvider() {
        if (this.fTextProvider == null) {
            this.fTextProvider = new MarkerTextProvider();
        }
        return this.fTextProvider;
    }
}

