/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.namechecker;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.EProblemKinds;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.namechecker.Collision;
import ro.amiq.dvt.ui.namechecker.Convention;
import ro.amiq.dvt.ui.namechecker.ConventionStoreUtil;
import ro.amiq.dvt.ui.namechecker.Identifier;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.ui.namechecker.ASTIdentifierMap;
import ro.amiq.edt.base.ui.namechecker.NameCheckerWalker;
import ro.amiq.edt.base.ui.preferences.PrefConst;
import ro.amiq.etools.eparser.EAST;

public abstract class AbstractNameCheckerWarningsManager {
    private static final String MACRO = "MACRO";
    private static final String POSITIVE = "positive";
    private static final String ANY = "ANY";
    private List<Collision> fConventionNames = new ArrayList<Collision>();
    private List<Collision> fReservedNames = new ArrayList<Collision>();
    private List<Convention> fConventions;
    private String[] fKeywords;
    private IEPluginConfig fPluginConfig;
    boolean fIsSLN;
    private static final Pattern patternID = Pattern.compile("\\b[a-zA-Z_][a-zA-Z0-9_]*\\b");
    private static final Pattern patternRG = Pattern.compile("<(([a-zA-Z]+[0-9]*')?[a-zA-Z]+)>");

    protected AbstractNameCheckerWarningsManager(IEPluginConfig pluginConfig) {
        this.fPluginConfig = pluginConfig;
        this.fIsSLN = DVTUtilsCommon.INSTANCE.isInSlnLikeMode((IPluginConfig)this.fPluginConfig);
    }

    private void checkConventions(ASTIdentifierMap map, IProject project) {
        if (this.fKeywords == null) {
            this.fKeywords = PrefConst.getNamecheckKeywords(this.fPluginConfig.getPlugin(), this.fIsSLN);
        }
        if (this.fConventions == null) {
            this.fConventions = new ArrayList<Convention>();
            try {
                ConventionStoreUtil.load(this.fConventions, (IProject)project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (map == null) {
            return;
        }
        for (Map.Entry<String, Map<String, Collection<Identifier>>> typeToMap : map.entrySet()) {
            boolean startWithMacro = false;
            if (typeToMap.getKey().startsWith(MACRO)) {
                startWithMacro = true;
            }
            for (Map.Entry<String, Collection<Identifier>> idToIdentifier : typeToMap.getValue().entrySet()) {
                Collection<Identifier> tmpIDs = idToIdentifier.getValue();
                String stringID = idToIdentifier.getKey();
                if (startWithMacro) {
                    stringID = this.patternReplaceAll(patternRG, stringID, "");
                }
                Matcher mID = patternID.matcher(stringID);
                while (mID.find()) {
                    Collision newID;
                    int nofConventions = this.fKeywords == null ? 0 : this.fKeywords.length;
                    String id = mID.group();
                    int j = 0;
                    while (this.fKeywords != null && j < nofConventions) {
                        if (this.fKeywords[j].equals(id)) {
                            for (Identifier tmpID : tmpIDs) {
                                newID = new Collision(0, id, tmpID, null);
                                this.fReservedNames.add(newID);
                            }
                            break;
                        }
                        ++j;
                    }
                    nofConventions = this.fConventions.size();
                    j = 0;
                    while (j < nofConventions) {
                        Matcher m;
                        Convention rule = this.fConventions.get(j);
                        if (this.checkLanguage(rule) && !rule.isOverriden() && rule.getEnabled() && (rule.getKind().equals(typeToMap.getKey()) || rule.getKind().equals(ANY)) && (!(m = rule.getPattern().matcher(idToIdentifier.getKey())).matches() && rule.getMatch().equalsIgnoreCase(POSITIVE) || m.matches() && !rule.getMatch().equalsIgnoreCase(POSITIVE))) {
                            for (Identifier tmpID : tmpIDs) {
                                newID = new Collision(1, tmpID.getId(), tmpID, rule);
                                this.fConventionNames.add(newID);
                            }
                        }
                        ++j;
                    }
                }
            }
        }
    }

    public abstract boolean checkLanguage(Convention var1);

    private String patternReplaceAll(Pattern pattern, String input, String replacement) {
        StringBuffer replaceSB = new StringBuffer();
        Matcher tmpM = pattern.matcher(input);
        while (tmpM.find()) {
            tmpM.appendReplacement(replaceSB, replacement);
        }
        tmpM.appendTail(replaceSB);
        return replaceSB.toString();
    }

    private String extractMessage(Collision c) {
        int kind = c.getKind();
        String result = DVTStringUtil.appendString((Object[])new Object[]{"The '", c.getName(), "' ", c.getElement().toLowerCase().replace('_', ' '), c.getElement().startsWith(MACRO) ? " part" : " name"});
        if (kind == 0 && !this.fIsSLN) {
            return DVTStringUtil.appendString((Object[])new Object[]{"IEEE1647 KEYWORD: ", result, " is reserved by the standard as keyword."});
        }
        if (kind == 2 && !this.fIsSLN) {
            return DVTStringUtil.appendString((Object[])new Object[]{"IEEE1647 KEYPHRASE: ", result, " is part of a reserved keyphrase."});
        }
        if (kind == 0 && this.fIsSLN) {
            return DVTStringUtil.appendString((Object[])new Object[]{"SLN KEYWORD: ", result, " is reserved by the standard as keyword."});
        }
        if (kind == 2 && this.fIsSLN) {
            return DVTStringUtil.appendString((Object[])new Object[]{"SLN KEYPHRASE: ", result, " is part of a reserved keyphrase."});
        }
        return DVTStringUtil.appendString((Object[])new Object[]{c.getNamingConvention().toUpperCase(), ": ", result, " does not satisfy the naming convention."});
    }

    public void build(int buildKind, EModuleInfo info, IProject project) {
        DVTProblem problem;
        DVTProblemKind problemKind;
        if (info == null || project == null) {
            return;
        }
        if (info.getLanguageKind() != this.fPluginConfig.getLanguageKind()) {
            return;
        }
        if (BuildConfigManager.isNamingConventionChecksDisabled((IProject)project)) {
            return;
        }
        AST ast = info.getModuleAST();
        if (ast == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(project, this.fPluginConfig.feature())) {
            return;
        }
        NameCheckerWalker walker = new NameCheckerWalker();
        walker.getASTFactory().setASTNodeClass(EAST.class);
        try {
            walker.program(ast);
            if (walker.isDVTEncrypted) {
                return;
            }
            this.checkConventions(walker.getAllIDs(), project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        ParserPath parserPath = info.getParserPath();
        DVTProblemCategory category = EProblemCategories.E_NAME_CHECKING;
        if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.fPluginConfig)) {
            category = EProblemCategories.SLN_NAME_CHECKING;
        }
        DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(project, category, parserPath.path);
        for (Collision c : this.fConventionNames) {
            problemKind = EProblemKinds.E_NAMING_CONVENTION;
            if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.fPluginConfig)) {
                problemKind = EProblemKinds.SLN_NAMING_CONVENTION;
            }
            problem = new DVTProblem(project, problemKind, parserPath.path, buildKind == 1, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        for (Collision c : this.fReservedNames) {
            problemKind = EProblemKinds.E_RESERVED_ID;
            if (DVTUtilsCommon.INSTANCE.isInSLNMode((IPluginConfig)this.fPluginConfig)) {
                problemKind = EProblemKinds.SLN_RESERVED_ID;
            }
            problem = new DVTProblem(project, problemKind, parserPath.path, false, c.getLineNumber(), new String[]{this.extractMessage(c)});
            problem.setAttribute("charStart", (Object)c.getStartOffset());
            problem.setAttribute("charEnd", (Object)c.getEndOffset());
            DVTProblemManager.getInstance().reportProblem(problem);
        }
        if (buildKind == 0) {
            DVTProblemsUiUpdaterRegistry.get((String)category.getId()).update(info.getResource(), buildKind == 1);
        }
        this.fConventionNames.clear();
        this.fReservedNames.clear();
    }

    public void clean() {
        this.fConventions = null;
        this.fKeywords = null;
    }
}

