/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.edt.base.core.IEPluginConfig;

public abstract class AbstractSyntaxPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected OverlayPreferenceStore fOverlayStore;
    private ColorSelector fgEditor;
    private List fList;
    private Button fSemanticHighlightCheckBox;
    private Button fTemplateHighlightCheckBox;
    private Button fXTemplateHighlightCheckBox;
    private Button fBoldCheckBox;
    private Button fItalicCheckBox;
    private Boolean fInitialSemanticHighlight;
    private Boolean fInitialTemplateHighlight;
    private Boolean fInitialXTemplateHighlight;
    private int previousSelectionIndex = 0;
    protected DVTPreviewSourceViewer fPreviewViewer;
    private final String[][] fListModel = new String[][]{{"Arguments", "highlight.semantic_argument"}, {"Comment Hyperlinks", "highlight.comment_hyperlink"}, {"Comment Pragmas", "highlight.comment_pragma"}, {"Comments", "highlight.comment"}, {"Constants", "highlight.semantic_constant"}, {"Default", "highlight.default"}, {"Define Groups", "highlight.group"}, {"Events", "highlight.event"}, {"Expansion Literals", "highlight.exp_literal"}, {"Expansion Replacements", "highlight.exp_replace"}, {"Fields", "highlight.semantic_field"}, {"HDL Paths", "highlight.hdl_path"}, {"Javadoc Tags", "highlight.javadoc_tags"}, {"Keyphrases", "highlight.keyphrase"}, {"Keywords", "highlight.keyword"}, {"Labels", "highlight.label"}, {"Methods", "highlight.method"}, {"Numbers", "highlight.number"}, {"Ports - Input, Inout", "highlight.port"}, {"Ports - Output", "highlight.semantic_out_port"}, {"Preprocessing", "highlight.preproc"}, {"Replacement Terms", "highlight.replace"}, {"Section Start/End", "highlight.openclose"}, {"String Literals", "highlight.string"}, {"Task Tags", "highlight.comment_task"}, {"Types", "highlight.semantic_types"}, {"Template Identifiers", "highlight.template_id"}, {"Time Units", "highlight.unit"}, {"Variables", "highlight.semantic_variable"}};
    private IEPluginConfig fPluginConfig;

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.openclose.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.openclose.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.openclose.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyphrase.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.preproc.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.group.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.group.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.group.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constant.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.unit.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.unit.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.unit.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.hdl_path.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.hdl_path.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.hdl_path.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.event.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.event.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.event.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.replace.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.replace.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.replace.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.exp_literal.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_literal.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_literal.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.exp_replace.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_replace.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.exp_replace.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_out_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public AbstractSyntaxPage(IEPluginConfig pluginConfig) {
        this.fPluginConfig = pluginConfig;
        this.setPreferenceStore(pluginConfig.getPlugin().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
        this.setDescription(null);
    }

    public void init(IWorkbench workbench) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    protected Control createContents(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        colorComposite.setFont(parent.getFont());
        Link link = (Link)this.createLink(colorComposite);
        link.setLayoutData((Object)new GridData(768));
        this.fSemanticHighlightCheckBox = new Button(colorComposite, 32);
        this.fSemanticHighlightCheckBox.setText("&Enable Semantic Coloring");
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fSemanticHighlightCheckBox.setLayoutData((Object)gd);
        this.fSemanticHighlightCheckBox.setFont(parent.getFont());
        this.fTemplateHighlightCheckBox = new Button(colorComposite, 32);
        this.fTemplateHighlightCheckBox.setText("&Highlight __ID__ as Template Identifier");
        this.fTemplateHighlightCheckBox.setLayoutData((Object)gd);
        this.fTemplateHighlightCheckBox.setFont(parent.getFont());
        this.fXTemplateHighlightCheckBox = new Button(colorComposite, 32);
        this.fXTemplateHighlightCheckBox.setText("&Highlight x_ID_x as Template Identifier");
        this.fXTemplateHighlightCheckBox.setLayoutData((Object)gd);
        this.fXTemplateHighlightCheckBox.setFont(parent.getFont());
        Label label = new Label(colorComposite, 16384);
        label.setText("Fore&ground:");
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fList.setLayoutData((Object)gd);
        this.fList.setFont(parent.getFont());
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        stylesComposite.setFont(parent.getFont());
        label = new Label(stylesComposite, 16384);
        label.setText("C&olor");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        label.setFont(parent.getFont());
        this.fgEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fgEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        foregroundColorButton.setFont(parent.getFont());
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText("&Bold");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fBoldCheckBox.setFont(parent.getFont());
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText("I&talic");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox.setFont(parent.getFont());
        label = new Label(colorComposite, 16384);
        label.setText("&Preview:");
        label.setLayoutData((Object)new GridData(768));
        label.setFont(parent.getFont());
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(20);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        previewer.setLayoutData((Object)gd);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractSyntaxPage.this.handleListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = AbstractSyntaxPage.this.fListModel[AbstractSyntaxPage.this.fList.getSelectionIndex()][1];
                PreferenceConverter.setValue((IPreferenceStore)AbstractSyntaxPage.this.fOverlayStore, (String)(String.valueOf(key) + ".color"), (RGB)AbstractSyntaxPage.this.fgEditor.getColorValue());
            }
        });
        this.fSemanticHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSyntaxPage.this.fInitialSemanticHighlight == null) {
                    AbstractSyntaxPage.this.fInitialSemanticHighlight = AbstractSyntaxPage.this.fOverlayStore.getBoolean("highlight.semantic.value");
                }
                AbstractSyntaxPage.this.fOverlayStore.setValue("highlight.semantic.value", AbstractSyntaxPage.this.fSemanticHighlightCheckBox.getSelection());
            }
        });
        this.fTemplateHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSyntaxPage.this.fInitialTemplateHighlight == null) {
                    AbstractSyntaxPage.this.fInitialTemplateHighlight = AbstractSyntaxPage.this.fOverlayStore.getBoolean("highlight.template_id.value");
                }
                AbstractSyntaxPage.this.fOverlayStore.setValue("highlight.template_id.value", AbstractSyntaxPage.this.fTemplateHighlightCheckBox.getSelection());
            }
        });
        this.fXTemplateHighlightCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSyntaxPage.this.fInitialXTemplateHighlight == null) {
                    AbstractSyntaxPage.this.fInitialXTemplateHighlight = AbstractSyntaxPage.this.fOverlayStore.getBoolean("highlight.x_template_id.value");
                }
                AbstractSyntaxPage.this.fOverlayStore.setValue("highlight.x_template_id.value", AbstractSyntaxPage.this.fXTemplateHighlightCheckBox.getSelection());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = AbstractSyntaxPage.this.fListModel[AbstractSyntaxPage.this.fList.getSelectionIndex()][1];
                AbstractSyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".bold", AbstractSyntaxPage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String key = AbstractSyntaxPage.this.fListModel[AbstractSyntaxPage.this.fList.getSelectionIndex()][1];
                AbstractSyntaxPage.this.fOverlayStore.setValue(String.valueOf(key) + ".italic", AbstractSyntaxPage.this.fItalicCheckBox.getSelection());
            }
        });
        this.initialize();
        return colorComposite;
    }

    private void initialize() {
        this.initializeFields();
        if (this.fList.getItems().length == 0) {
            int i = 0;
            while (i < this.fListModel.length) {
                this.fList.add(this.fListModel[i][0]);
                ++i;
            }
        }
        this.fList.setSelection(0);
        this.fList.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractSyntaxPage.this.fList.select(0);
                AbstractSyntaxPage.this.handleListSelection();
            }
        });
    }

    private void initializeFields() {
        IPreferenceStore prefs = this.getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)prefs, (String)"highlight.default.color");
        this.fgEditor.setColorValue(rgb);
        this.fSemanticHighlightCheckBox.setSelection(prefs.getBoolean("highlight.semantic.value"));
        this.fTemplateHighlightCheckBox.setSelection(prefs.getBoolean("highlight.template_id.value"));
        this.fXTemplateHighlightCheckBox.setSelection(prefs.getBoolean("highlight.x_template_id.value"));
        this.fBoldCheckBox.setSelection(prefs.getBoolean("highlight.default.bold"));
        this.fItalicCheckBox.setSelection(prefs.getBoolean("highlight.default.italic"));
    }

    protected void handleListSelection() {
        int selectionIndex = this.fList.getSelectionIndex();
        if (selectionIndex == -1) {
            selectionIndex = this.previousSelectionIndex;
            this.fList.setSelection(selectionIndex);
        } else {
            this.previousSelectionIndex = selectionIndex;
        }
        String key = this.fListModel[selectionIndex][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)(String.valueOf(key) + ".color"));
        this.fgEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".bold"));
        this.fItalicCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + ".italic"));
    }

    private Control createLink(Composite contents) {
        final Link link = new Link(contents, 0);
        link.setFont(contents.getFont());
        link.setText("Font type can be configured on the <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Colors and Fonts</a> preference page.");
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, null);
            }
        });
        String linktooltip = "Go To 'Colors and Fonts' Preference Page";
        link.setToolTipText(linktooltip);
        return link;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return this.fPluginConfig.getPlugin().getPreferenceStore();
    }

    protected void performApply() {
        this.fPluginConfig.getEStyle().updateTokens();
        super.performApply();
    }

    public boolean performCancel() {
        this.fPluginConfig.getEStyle().updateTokens();
        return super.performCancel();
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        this.fPluginConfig.getEStyle().updateTokens();
        IWorkbenchPage page = DVTUiUtils.getActivePage();
        if (page == null) {
            return true;
        }
        final IEditorPart activeEditor = page.getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return true;
        }
        DVTUiUtils.getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((DVTEditor)activeEditor).getTextViewer().invalidateTextPresentation();
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            }
        });
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initialize();
        super.performDefaults();
        this.handleListSelection();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    protected abstract Control createPreviewer(Composite var1);
}

