/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.preferences;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.ESourceViewerConfiguration;

public class ESourcePreviewerUpdater {
    private ESourcePreviewerUpdater() {
    }

    public static void registerPreviewer(final IEPluginConfig projectConfig, final SourceViewer viewer, final ESourceViewerConfiguration configuration, final IPreferenceStore preferenceStore) {
        Assert.isNotNull((Object)viewer);
        Assert.isNotNull((Object)((Object)configuration));
        Assert.isNotNull((Object)preferenceStore);
        final IPropertyChangeListener fontChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.jface.textfont")) {
                    Font font = JFaceResources.getTextFont();
                    viewer.getTextWidget().setFont(font);
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                configuration.adaptToPreferenceChange(event);
                ESourceViewerConfiguration.updatePresentationReconciler(projectConfig, ((DVTPreviewSourceViewer)viewer).getReconciler());
                viewer.invalidateTextPresentation();
            }
        };
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
        viewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                preferenceStore.removePropertyChangeListener(propertyChangeListener);
                JFaceResources.getFontRegistry().removeListener(fontChangeListener);
            }
        });
    }
}

