/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import ro.amiq.dvt.ui.preferences.language.TreeSymbol;

public class PrefConst {
    public static final String PREFERENCE_DELIMITER = ";";
    public static final String C_COMMENT = "//";
    public static final String VHDL_COMMENT = "--";
    public static final String SEMANTIC_HIGHLIGHT = "highlight.semantic";
    public static final boolean SEMANTIC_HIGHLIGHT_VALUE = true;
    public static final String TEMPLATE_IDENTIFIER = "highlight.template_id";
    public static final boolean TEMPLATE_IDENTIFIER_VALUE = true;
    public static final String X_TEMPLATE_IDENTIFIER = "highlight.x_template_id";
    public static final boolean X_TEMPLATE_IDENTIFIER_VALUE = false;
    public static final String DEFAULT = "highlight.default";
    public static final String OPENCLOSE = "highlight.openclose";
    public static final String COMMENT = "highlight.comment";
    public static final String COMMENT_TASK = "highlight.comment_task";
    public static final String JAVADOC_TAGS = "highlight.javadoc_tags";
    public static final String COMMENT_PRAGMA = "highlight.comment_pragma";
    public static final String KEYWORD = "highlight.keyword";
    public static final String KEYPHRASE = "highlight.keyphrase";
    public static final String PREPROC = "highlight.preproc";
    public static final String GROUP = "highlight.group";
    public static final String CONSTANT = "highlight.semantic_constant";
    public static final String UNIT = "highlight.unit";
    public static final String NUMBER = "highlight.number";
    public static final String STRING = "highlight.string";
    public static final String HDL_PATH = "highlight.hdl_path";
    public static final String METHOD = "highlight.method";
    public static final String TEMPLATE_ID = "highlight.template_id";
    public static final String PORT = "highlight.port";
    public static final String EVENT = "highlight.event";
    public static final String REPLACE = "highlight.replace";
    public static final String COMMENT_HYPERLINK = "highlight.comment_hyperlink";
    public static final String SEMANTIC_ARGUMENT = "highlight.semantic_argument";
    public static final String SEMANTIC_FIELD = "highlight.semantic_field";
    public static final String SEMANTIC_TYPE = "highlight.semantic_types";
    public static final String SEMANTIC_VARIABLE = "highlight.semantic_variable";
    public static final String SEMANTIC_OUT_PORT = "highlight.semantic_out_port";
    public static final String SEMANTIC_LABEL = "highlight.label";
    public static final String EXP_LITERAL = "highlight.exp_literal";
    public static final String EXP_REPLACE = "highlight.exp_replace";
    public static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    public static final RGB OPENCLOSE_COLOR = new RGB(0, 180, 20);
    public static final RGB COMMENT_COLOR = new RGB(128, 128, 128);
    public static final RGB COMMENT_TASK_COLOR = new RGB(100, 100, 156);
    public static final RGB COMMENT_PRAGMA_COLOR = new RGB(100, 100, 156);
    public static final RGB JAVADOCS_TAGS_COLOR = new RGB(100, 100, 156);
    public static final RGB KEYWORD_COLOR = new RGB(139, 0, 0);
    public static final RGB KEYPHRASE_COLOR = new RGB(139, 0, 0);
    public static final RGB PREPROC_COLOR = new RGB(0, 0, 0);
    public static final RGB GROUP_COLOR = new RGB(155, 100, 50);
    public static final RGB SCALAR_TYPE_COLOR = new RGB(53, 155, 203);
    public static final RGB CONSTANT_COLOR = new RGB(0, 0, 0);
    public static final RGB UNIT_COLOR = new RGB(53, 155, 203);
    public static final RGB NUMBER_COLOR = new RGB(0, 0, 255);
    public static final RGB STRING_COLOR = new RGB(204, 0, 204);
    public static final RGB HDL_PATH_COLOR = new RGB(0, 153, 0);
    public static final RGB METHOD_COLOR = new RGB(255, 102, 0);
    public static final RGB PORT_COLOR = new RGB(82, 102, 22);
    public static final RGB EVENT_COLOR = new RGB(0, 153, 153);
    public static final RGB REPLACE_COLOR = new RGB(204, 0, 0);
    public static final RGB PREFIX_COLOR = new RGB(255, 0, 0);
    public static final RGB SEMANTIC_ARGUMENT_COLOR = new RGB(106, 62, 62);
    public static final RGB SEMANTIC_FIELD_COLOR = new RGB(0, 0, 0);
    public static final RGB SEMANTIC_TYPE_COLOR = new RGB(0, 100, 179);
    public static final RGB SEMANTIC_VARIABLE_COLOR = new RGB(106, 62, 51);
    public static final RGB SEMANTIC_OUT_PORT_COLOR = new RGB(82, 102, 22);
    public static final RGB SEMANTIC_LABEL_COLOR = new RGB(77, 77, 77);
    public static final RGB EXP_LITERAL_COLOR = new RGB(204, 0, 204);
    public static final RGB EXP_REPLACE_COLOR = new RGB(80, 0, 80);
    public static final RGB COMMENT_HYPERLINK_COLOR = new RGB(50, 50, 156);
    public static final boolean DEFAULT_BOLD = false;
    public static final boolean OPENCLOSE_BOLD = true;
    public static final boolean COMMENT_BOLD = false;
    public static final boolean COMMENT_TASK_BOLD = true;
    public static final boolean COMMENT_PRAGMA_BOLD = true;
    public static final boolean JAVADOC_TAGS_BOLD = true;
    public static final boolean KEYWORD_BOLD = true;
    public static final boolean KEYPHRASE_BOLD = true;
    public static final boolean PREPROC_BOLD = true;
    public static final boolean GROUP_BOLD = true;
    public static final boolean SCALAR_TYPE_BOLD = true;
    public static final boolean CONSTANT_BOLD = true;
    public static final boolean UNIT_BOLD = true;
    public static final boolean NUMBER_BOLD = false;
    public static final boolean STRING_BOLD = false;
    public static final boolean HDL_PATH_BOLD = false;
    public static final boolean METHOD_BOLD = false;
    public static final boolean PORT_BOLD = false;
    public static final boolean EVENT_BOLD = false;
    public static final boolean REPLACE_BOLD = false;
    public static final boolean PREFIX_BOLD = false;
    public static final boolean SEMANTIC_ARGUMENT_BOLD = false;
    public static final boolean SEMANTIC_FIELD_BOLD = false;
    public static final boolean SEMANTIC_TYPE_BOLD = true;
    public static final boolean SEMANTIC_VARIABLE_BOLD = false;
    public static final boolean SEMANTIC_OUT_PORT_BOLD = false;
    public static final boolean SEMANTIC_LABEL_BOLD = true;
    public static final boolean EXP_LITERAL_BOLD = false;
    public static final boolean EXP_REPLACE_BOLD = true;
    public static final boolean COMMENT_HYPERLINK_BOLD = false;
    public static final boolean DEFAULT_ITALIC = false;
    public static final boolean OPENCLOSE_ITALIC = false;
    public static final boolean COMMENT_ITALIC = true;
    public static final boolean COMMENT_TASK_ITALIC = false;
    public static final boolean COMMENT_PRAGMA_ITALIC = false;
    public static final boolean JAVADOC_TAGS_ITALIC = false;
    public static final boolean KEYWORD_ITALIC = false;
    public static final boolean KEYPHRASE_ITALIC = false;
    public static final boolean PREPROC_ITALIC = false;
    public static final boolean GROUP_ITALIC = false;
    public static final boolean SCALAR_TYPE_ITALIC = false;
    public static final boolean CONSTANT_ITALIC = false;
    public static final boolean UNIT_ITALIC = false;
    public static final boolean NUMBER_ITALIC = false;
    public static final boolean STRING_ITALIC = false;
    public static final boolean HDL_PATH_ITALIC = false;
    public static final boolean METHOD_ITALIC = false;
    public static final boolean PORT_ITALIC = true;
    public static final boolean EVENT_ITALIC = false;
    public static final boolean REPLACE_ITALIC = false;
    public static final boolean PREFIX_ITALIC = true;
    public static final boolean SEMANTIC_ARGUMENT_ITALIC = false;
    public static final boolean SEMANTIC_FIELD_ITALIC = false;
    public static final boolean SEMANTIC_TYPE_ITALIC = false;
    public static final boolean SEMANTIC_VARIABLE_ITALIC = false;
    public static final boolean SEMANTIC_OUT_PORT_ITALIC = false;
    public static final boolean SEMANTIC_LABEL_ITALIC = false;
    public static final boolean EXP_LITERAL_ITALIC = false;
    public static final boolean EXP_REPLACE_ITALIC = false;
    public static final boolean COMMENT_HYPERLINK_ITALIC = true;
    public static final String E_KEYWORDS_STATEMENTS = "e.language.keywords.statements";
    public static final String E_KEYWORDS_STRUCT_MEMBERS = "e.language.keywords.struct_member";
    public static final String E_KEYWORDS_ACTIONS = "e.language.keywords.actions";
    public static final String E_KEYWORDS_EXPRESSIONS = "e.language.keywords.expressions";
    public static final String E_KEYWORDS_TEMPORAL_EXPRESSIONS = "e.language.keywords.temporal_expressions";
    public static final String E_KEYWORDS_ACCESS_MODIFIERS = "e.language.keywords.access_modifiers";
    public static final String E_KEYWORDS_SIMULTATOR_MEMBERS = "e.language.keywords.simulator_members";
    public static final String E_KEYWORDS_TYPES = "e.language.keywords.types";
    public static final String SLN_KEYWORDS_SCD = "sln.language.keywords.scenario_construction_directives";
    public static final String SDL_KEYWORDS_SCD = "sdl.language.keywords.scenario_construction_directives";
    public static final String DEFAULT_E_KEYWORDS_STATEMENTS = "annotation;table;uvm_ml_type_match;template;package;import;method_type;define;as;type;struct;unit;interface;like;extend;implementing;routine;sequence;repeatable;export;conditions;";
    public static final String DEFAULT_E_KEYWORDS_STRUCT_MEMBERS = "table;statements;soft_const;when;is;keep;prev;soft;select;before;cover;using;item;transition;cross;ranges;range;attribute;event;on;expect;assume;";
    public static final String DEFAULT_E_KEYWORDS_ACTIONS = "table;external;empty;undefined;statements;try_ie;first;report;compute;return;var;try;gen;keeping;print;check;that;assert;exclusive_start;start;stop;abort;if;then;else;case;default;while;repeat;until;for;from;to;step;do;do_and_grab;in;in_set;matching;break;continue;force;release;emit;wait;sync;";
    public static final String DEFAULT_E_KEYWORDS_EXPRESSIONS = "in_table;new;with;now;not;or;and;others;pass;edges;";
    public static final String DEFAULT_E_KEYWORDS_TEMPORAL_EXPRESSIONS = "cycle;consume;exec;eventually;detach;delay;fail;change;rise;fall;true;";
    public static final String DEFAULT_E_KEYWORDS_ACCESS_MODIFIERS = "private;protected;final;static;const;";
    public static final String DEFAULT_E_KEYWORDS_SIMULATOR_MEMBERS = ";";
    public static final String DEFAULT_E_KEYWORDS_TYPES = ";";
    public static final String DEFAULT_SLN_KEYWORDS_STATEMENTS = "token;component;action;function;";
    public static final String DEFAULT_SLN_KEYWORDS_STRUCT_MEMBERS = "compound;exec;bind;method;conditional;constraint;child;disable;initial;write_once;action;";
    public static final String DEFAULT_SLN_KEYWORDS_ACTIONS = "sln_emit;sln;code;";
    public static final String DEFAULT_SLN_KEYWORDS_EXPRESSIONS = ";";
    public static final String DEFAULT_SLN_KEYWORDS_TEMPORAL_EXPRESSIONS = ";";
    public static final String DEFAULT_SLN_KEYWORDS_ACCESS_MODIFIERS = "input;output;inout;lock;share;resource;";
    public static final String DEFAULT_SLN_KEYWORDS_SIMULATOR_MEMBERS = ";";
    public static final String DEFAULT_SLN_KEYWORDS_TYPES = ";";
    public static final String DEFAULT_SLN_KEYWORDS_SCD = "before;same_time;in;constraint;table";
    public static final String DEFAULT_SDL_KEYWORDS_STATEMENTS = "agent;scenario;operator;role;tool;";
    public static final String DEFAULT_SDL_KEYWORDS_STRUCT_MEMBERS = "scenario;param;SAME;inline;where;";
    public static final String DEFAULT_SDL_KEYWORDS_ACTIONS = ";";
    public static final String DEFAULT_SDL_KEYWORDS_EXPRESSIONS = ";";
    public static final String DEFAULT_SDL_KEYWORDS_TEMPORAL_EXPRESSIONS = ";";
    public static final String DEFAULT_SDL_KEYWORDS_ACCESS_MODIFIERS = ";";
    public static final String DEFAULT_SDL_KEYWORDS_SIMULATOR_MEMBERS = ";";
    public static final String DEFAULT_SDL_KEYWORDS_TYPES = ";";
    public static final String DEFAULT_SDL_KEYWORDS_SCD = ";";
    public static final String DEFAULT_E_KEYWORDS = "annotation;table;uvm_ml_type_match;template;package;import;method_type;define;as;type;struct;unit;interface;like;extend;implementing;routine;sequence;repeatable;export;conditions;table;statements;soft_const;when;is;keep;prev;soft;select;before;cover;using;item;transition;cross;ranges;range;attribute;event;on;expect;assume;table;external;empty;undefined;statements;try_ie;first;report;compute;return;var;try;gen;keeping;print;check;that;assert;exclusive_start;start;stop;abort;if;then;else;case;default;while;repeat;until;for;from;to;step;do;do_and_grab;in;in_set;matching;break;continue;force;release;emit;wait;sync;in_table;new;with;now;not;or;and;others;pass;edges;cycle;consume;exec;eventually;detach;delay;fail;change;rise;fall;true;private;protected;final;static;const;;;";
    public static final String DEFAULT_SLN_KEYWORDS = "annotation;table;uvm_ml_type_match;template;package;import;method_type;define;as;type;struct;unit;interface;like;extend;implementing;routine;sequence;repeatable;export;conditions;table;statements;soft_const;when;is;keep;prev;soft;select;before;cover;using;item;transition;cross;ranges;range;attribute;event;on;expect;assume;table;external;empty;undefined;statements;try_ie;first;report;compute;return;var;try;gen;keeping;print;check;that;assert;exclusive_start;start;stop;abort;if;then;else;case;default;while;repeat;until;for;from;to;step;do;do_and_grab;in;in_set;matching;break;continue;force;release;emit;wait;sync;in_table;new;with;now;not;or;and;others;pass;edges;cycle;consume;exec;eventually;detach;delay;fail;change;rise;fall;true;private;protected;final;static;const;;;token;component;action;function;compound;exec;bind;method;conditional;constraint;child;disable;initial;write_once;action;sln_emit;sln;code;;;input;output;inout;lock;share;resource;;;before;same_time;in;constraint;table";
    public static final String DEFAULT_SDL_KEYWORDS = "annotation;table;uvm_ml_type_match;template;package;import;method_type;define;as;type;struct;unit;interface;like;extend;implementing;routine;sequence;repeatable;export;conditions;table;statements;soft_const;when;is;keep;prev;soft;select;before;cover;using;item;transition;cross;ranges;range;attribute;event;on;expect;assume;table;external;empty;undefined;statements;try_ie;first;report;compute;return;var;try;gen;keeping;print;check;that;assert;exclusive_start;start;stop;abort;if;then;else;case;default;while;repeat;until;for;from;to;step;do;do_and_grab;in;in_set;matching;break;continue;force;release;emit;wait;sync;in_table;new;with;now;not;or;and;others;pass;edges;cycle;consume;exec;eventually;detach;delay;fail;change;rise;fall;true;private;protected;final;static;const;;;agent;scenario;operator;role;tool;scenario;param;SAME;inline;where;;;;;;;;";
    public static final String E_PHRASES_STATEMENTS = "e.language.keyphrases.statements";
    public static final String E_PHRASES_STRUCT_MEMBERS = "e.language.keyphrases.struct_member";
    public static final String E_PHRASES_ACTIONS = "e.language.keyphrases.actions";
    public static final String E_PHRASES_EXPRESSIONS = "e.language.keyphrases.expressions";
    public static final String E_PHRASES_TYPES = "e.language.keyphrases.types";
    public static final String E_PHRASES_SIMULTATOR_MEMBERS = "e.language.keyphrases.simulator_members";
    public static final String E_PHRASES_TEMPORAL_EXPRESSIONS = "e.language.keyphrases.temporal_expressions";
    public static final String E_PHRASES_ACCESS_MODIFIERS = "e.language.keyphrases.access_modifiers";
    public static final String SLN_PHRASES_SCD = "sln.language.keyphrases.scenario_construction_directives";
    public static final String SDL_PHRASES_SCD = "sdl.language.keyphrases.scenario_construction_directives";
    public static final String DEFAULT_E_PHRASES_STATEMENTS = "table count;table from;table count from;vhdl object;as computed;verilog import;cvl method;cvl callback;cvl call;is C routine;C export;export C;is import C;is import foreign C;verilog time;vhdl time;add port attribute;";
    public static final String DEFAULT_E_PHRASES_STRUCT_MEMBERS = "table count;table from;table count from;is empty;is undefined;is inline;is inline only;is also;is first;is only;using also;keep soft;keep gen;keep for each;is dynamic C routine;is foreign C routine;is foreign dynamic C routine;with any;is imported;starting from;";
    public static final String DEFAULT_E_PHRASES_ACTIONS = "table count;table from;table count from;check that;assert that;down to;for each;in reverse;using index;for each line;in file;for each file;all of;first of;state machine;";
    public static final String DEFAULT_E_PHRASES_EXPRESSIONS = "is a;is not a;is an;is not an;is not empty;not in;";
    public static final String DEFAULT_E_PHRASES_TYPES = "is instance;list of;in interface_port of;out interface_port of;export interface_port of;interface_port of;interface_imp of;interface_export of;simple_port of;in simple_port of;out simple_port of;inout simple_port of;event_port;in event_port;out event_port;inout event_port;in method_port of;out method_port of;in buffer_port of;out buffer_port of;";
    public static final String DEFAULT_E_PHRASES_SIMULATOR_MEMBERS = "verilog simulator;verilog code;verilog function;verilog task;verilog variable;vhdl simulator;vhdl code;vhdl function;vhdl procedure;vhdl driver;";
    public static final String DEFAULT_E_PHRASES_TEMPORAL_EXPRESSIONS = ";";
    public static final String DEFAULT_E_PHRASES_ACCESS_MODIFIERS = ";";
    public static final String DEFAULT_SLN_PHRASES_STATEMENTS = "abstract action;abstract component;macro action;non_macro action;";
    public static final String DEFAULT_SLN_PHRASES_STRUCT_MEMBERS = "constraint any;constraint soft;constraint default;token default value;abstract action;macro action;non_macro action;";
    public static final String DEFAULT_SLN_PHRASES_ACTIONS = ";";
    public static final String DEFAULT_SLN_PHRASES_EXPRESSIONS = ";";
    public static final String DEFAULT_SLN_PHRASES_TYPES = ";";
    public static final String DEFAULT_SLN_PHRASES_SIMULATOR_MEMBERS = ";";
    public static final String DEFAULT_SLN_PHRASES_TEMPORAL_EXPRESSIONS = ";";
    public static final String DEFAULT_SLN_PHRASES_ACCESS_MODIFIERS = ";";
    public static final String DEFAULT_SLN_PHRASES_SCD = "constraint soft;table count;table from;table count from;";
    public static final String DEFAULT_SDL_PHRASES_STATEMENTS = "abstract action;abstract component;macro action;non_macro action;";
    public static final String DEFAULT_SDL_PHRASES_STRUCT_MEMBERS = "constraint any;constraint soft;constraint default;token default value;abstract action;macro action;non_macro action;";
    public static final String DEFAULT_SDL_PHRASES_ACTIONS = ";";
    public static final String DEFAULT_SDL_PHRASES_EXPRESSIONS = ";";
    public static final String DEFAULT_SDL_PHRASES_TYPES = ";";
    public static final String DEFAULT_SDL_PHRASES_SIMULATOR_MEMBERS = ";";
    public static final String DEFAULT_SDL_PHRASES_TEMPORAL_EXPRESSIONS = ";";
    public static final String DEFAULT_SDL_PHRASES_ACCESS_MODIFIERS = ";";
    public static final String DEFAULT_SDL_PHRASES_SCD = "constraint soft;table count;table from;table count from;";
    public static final String DEFAULT_E_PHRASES = "table count;table from;table count from;vhdl object;as computed;verilog import;cvl method;cvl callback;cvl call;is C routine;C export;export C;is import C;is import foreign C;verilog time;vhdl time;add port attribute;table count;table from;table count from;is empty;is undefined;is inline;is inline only;is also;is first;is only;using also;keep soft;keep gen;keep for each;is dynamic C routine;is foreign C routine;is foreign dynamic C routine;with any;is imported;starting from;table count;table from;table count from;check that;assert that;down to;for each;in reverse;using index;for each line;in file;for each file;all of;first of;state machine;is a;is not a;is an;is not an;is not empty;not in;;;is instance;list of;in interface_port of;out interface_port of;export interface_port of;interface_port of;interface_imp of;interface_export of;simple_port of;in simple_port of;out simple_port of;inout simple_port of;event_port;in event_port;out event_port;inout event_port;in method_port of;out method_port of;in buffer_port of;out buffer_port of;verilog simulator;verilog code;verilog function;verilog task;verilog variable;vhdl simulator;vhdl code;vhdl function;vhdl procedure;vhdl driver;";
    public static final String DEFAULT_SLN_PHRASES = "table count;table from;table count from;vhdl object;as computed;verilog import;cvl method;cvl callback;cvl call;is C routine;C export;export C;is import C;is import foreign C;verilog time;vhdl time;add port attribute;table count;table from;table count from;is empty;is undefined;is inline;is inline only;is also;is first;is only;using also;keep soft;keep gen;keep for each;is dynamic C routine;is foreign C routine;is foreign dynamic C routine;with any;is imported;starting from;table count;table from;table count from;check that;assert that;down to;for each;in reverse;using index;for each line;in file;for each file;all of;first of;state machine;is a;is not a;is an;is not an;is not empty;not in;;;is instance;list of;in interface_port of;out interface_port of;export interface_port of;interface_port of;interface_imp of;interface_export of;simple_port of;in simple_port of;out simple_port of;inout simple_port of;event_port;in event_port;out event_port;inout event_port;in method_port of;out method_port of;in buffer_port of;out buffer_port of;verilog simulator;verilog code;verilog function;verilog task;verilog variable;vhdl simulator;vhdl code;vhdl function;vhdl procedure;vhdl driver;abstract action;abstract component;macro action;non_macro action;constraint any;constraint soft;constraint default;token default value;abstract action;macro action;non_macro action;;;;;;;";
    public static final String DEFAULT_SDL_PHRASES = "table count;table from;table count from;vhdl object;as computed;verilog import;cvl method;cvl callback;cvl call;is C routine;C export;export C;is import C;is import foreign C;verilog time;vhdl time;add port attribute;table count;table from;table count from;is empty;is undefined;is inline;is inline only;is also;is first;is only;using also;keep soft;keep gen;keep for each;is dynamic C routine;is foreign C routine;is foreign dynamic C routine;with any;is imported;starting from;table count;table from;table count from;check that;assert that;down to;for each;in reverse;using index;for each line;in file;for each file;all of;first of;state machine;is a;is not a;is an;is not an;is not empty;not in;;;is instance;list of;in interface_port of;out interface_port of;export interface_port of;interface_port of;interface_imp of;interface_export of;simple_port of;in simple_port of;out simple_port of;inout simple_port of;event_port;in event_port;out event_port;inout event_port;in method_port of;out method_port of;in buffer_port of;out buffer_port of;verilog simulator;verilog code;verilog function;verilog task;verilog variable;vhdl simulator;vhdl code;vhdl function;vhdl procedure;vhdl driver;abstract action;abstract component;macro action;non_macro action;constraint any;constraint soft;constraint default;token default value;abstract action;macro action;non_macro action;;;;;;;";
    public static final String E_SCALAR_TYPES = "e.language.scalar_types";
    public static final String DEFAULT_E_SCALAR_TYPES = "bool;bit;byte;nibble;int;uint;time;string;file;mvl;real;set;";
    public static final String DEFAULT_SLN_SCALAR_TYPES = ";";
    public static final String DEFAULT_SDL_SCALAR_TYPES = ";";
    public static final String E_CONSTANTS = "e.language.constants";
    public static final String DEFAULT_E_CONSTANTS = "TRUE;FALSE;NULL;UNDEF;MAX_INT;MIN_INT;MAX_UINT;MIN_LONGINT;MAX_LONGINT;MAX_LONGUINT;Strength_NONE;Strength_HiZ;Strength_SmallCharge;Strength_MediumCharge;Strength_LargeCharge;Strength_WeakDrive;Strength_PullDrive;Strength_StrongDrive;Strength_SupplyDrive";
    public static final String DEFAULT_SLN_CONSTANTS = ";";
    public static final String DEFAULT_SDL_CONSTANTS = ";";
    public static final String E_UNITS = "e.language.units";
    public static final String DEFAULT_E_UNITS = "hr;min;sec;ms;us;ns;ps;fs";
    public static final String DEFAULT_SLN_UNITS = "";
    public static final String DEFAULT_SDL_UNITS = "";
    public static final String E_PREPROC = "e.language.preproc";
    public static final String DEFAULT_E_PREPROC = "#define;#ifdef;#ifndef;#undef;#else;";
    public static final String DEFAULT_SLN_PREPROC = ";";
    public static final String DEFAULT_SDL_PREPROC = ";";
    public static final String CONTENTASSIST_PREF_IGNORE_CASE = "ca.ignore_case";
    public static final boolean CONTENTASSIST_PREF_IGNORE_CASE_VAL = true;
    public static final String CONTENTASSIST_PREF_INSERT_OPTIONAL_ARGUMENTS = "ca.insert_optional_arguments";
    public static final boolean CONTENTASSIST_PREF_INSERT_OPTIONAL_ARGUMENTS_VAL = true;
    public static final String CONTENTASSIST_PREF_CHARS_TRIGGER = "ca.chars_trigger";
    public static final String CONTENTASSIST_PREF_CHARS_TRIGGER_VAL = ".,@,%,= ,: ,on ,emit ,keep ,cover ,extend ,like ,when, import ";
    public static final String CONTENTASSIST_PREF_CAMEL_CASE = "ca.camel_case";
    public static final boolean CONTENTASSIST_PREF_CAMEL_CASE_VAL = true;
    public static final String CONTENTASSIST_PREF_PREFIX_MATCH = "ca.prefix_match";
    public static final boolean CONTENTASSIST_PREF_PREFIX_MATCH_VAL = true;
    public static final String TYPING_PREF_QUOTE_CASE = "typing.quote_case";
    public static final boolean TYPING_PREF_QUOTE_CASE_VAL = true;
    public static final String TYPING_PREF_PARAN_CASE = "typing.paran_case";
    public static final boolean TYPING_PREF_PARAN_CASE_VAL = true;
    public static final String TYPING_PREF_BRACK_CASE = "typing.brack_case";
    public static final boolean TYPING_PREF_BRACK_CASE_VAL = true;
    public static final String TYPING_PREF_CURLY_CASE = "typing.curly_case";
    public static final boolean TYPING_PREF_CURLY_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_QUOTE_CASE = "typing.enclose.quote_case";
    public static final boolean TYPING_ENCLOSE_PREF_QUOTE_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_PARAN_CASE = "typing.enclose.paran_case";
    public static final boolean TYPING_ENCLOSE_PREF_PARAN_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_BRACK_CASE = "typing.enclose.brack_case";
    public static final boolean TYPING_ENCLOSE_PREF_BRACK_CASE_VAL = true;
    public static final String TYPING_ENCLOSE_PREF_CURLY_CASE = "typing.enclose.curly_case";
    public static final boolean TYPING_ENCLOSE_PREF_CURLY_CASE_VAL = true;
    public static final String TYPING_TRANSFORM_SEMICOLON_TO_ASSIGN = "typing.transform_semicolon_to_assign";
    public static final boolean TYPING_TRANSFORM_SEMICOLON_TO_ASSIGN_VAL = true;
    public static final String TYPING_TRANSFORM_WHITESPACE = "typing.transform_whitespace";
    public static final boolean TYPING_TRANSFORM_WHITESPACE_VAL = false;
    public static final String DISABLE_AUTO_INDENT = "autoindent.disabled";
    public static final boolean DISABLE_AUTO_INDENT_VAL = false;
    public static final String OUTLINE_LEXICAL_SORT = "outline.lexical_sort";
    public static final String OUTLINE_CATEGORY_SORT = "outline.category_sort";
    public static final String OUTLINE_LIMIT_TEXT_LENGTH = "outline.short_text";
    public static final String EDITOR_STICKY_OCCURRENCES = "stickyOccurrences";
    public static final String COMMENT_STYLE_VHDL = "toggleCommnetStyle";
    public static final String JUMP_TO_DEFINED_METHOD_LAYER = "editor.jump_to_defined_method_layer";
    public static final boolean JUMP_TO_DEFINED_METHOD_LAYER_VALUE = true;
    public static final String DISABLE_TOOL_TIPS = "editor.disable_tool_tips";
    public static final boolean DISABLE_TOOL_TIPS_VALUE = false;
    public static final String E_TYPE_ACTIONS = "Actions";
    public static final String E_TYPE_STATEMENTS = "Statements";
    public static final String E_TYPE_STRUCT_MEMBERS = "Struct Members";
    public static final String E_TYPE_EXPRESSIONS = "Expressions";
    public static final String E_TYPE_TEMPORAL_EXPRESSIONS = "Temporal Expressions";
    public static final String E_TYPE_ACCESS_MODIFIERS = "Access Modifiers";
    public static final String E_TYPE_SIMULATOR_MEMBERS = "Simulator Members";
    public static final String E_TYPE_TYPES = "Types";
    public static final String SLN_TYPE_SCD = "Scenario Construction Directives";
    public static final String OVM_COMPLIANCE_CHECK_OVM_CLASSES = "OVMCompliance.check_ovm_classes";
    public static final boolean OVM_COMPLIANCE_CHECK_OVM_CLASSES_VAL = false;
    public static final String OVM_COMPLIANCE_CHECK_OVM_FILES = "OVMCompliance.check_ovm_files";
    public static final boolean OVM_COMPLIANCE_CHECK_OVM_FILES_VAL = false;
    public static final String VERISSIMO_BACKGROUND_COLOR = "verissimo.background_color";
    public static final RGB VERISSIMO_BACKGROUND_COLOR_VAL = new RGB(255, 255, 255);
    public static final String INACTIVE_CODE_HIGHLIGHT_ENABLE = "inactiveCodeHighlightEnable";
    public static final boolean INACTIVE_CODE_HIGHLIGHT_ENABLE_VAL = true;
    public static final String INACTIVE_CODE_HIGHLIGHT_COLOR = "inactiveCodeHighlightColor";
    public static final RGB INACTIVE_CODE_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String MATCHING_BRACKETS_HIGHLIGHT_ENABLE = "matchingBracketsEEnable";
    public static final boolean MATCHING_BRACKETS_HIGHLIGHT_ENABLE_VAL = true;
    public static final String MATCHING_BRACKETS_HIGHLIGHT_COLOR = "matchingBracketsEColor";
    public static final RGB MATCHING_BRACKETS_HIGHLIGHT_COLOR_VAL = new RGB(210, 210, 210);
    public static final String COMPARE_VIEWER_MAX_LINES = "disable.compareviewer";
    public static final int COMPARE_VIEWER_MAX_LINES_VALUE = 100000;
    public static final String EDITOR_CODE_FOLDING = "editor.codeFolding";
    public static final boolean EDITOR_CODE_FOLDING_VAL = true;
    public static final String EDITOR_CODE_FOLDING_NOF_LINES = "editor.numberOfLines";
    public static final int EDITOR_CODE_FOLDING_NOF_LINES_VAL = 10000;
    public static final String EDITOR_MANUAL_CODE_FOLDING = "editor.manualCodeFolding";
    public static final boolean EDITOR_MANUAL_CODE_FOLDING_VAL = true;
    public static final String OVERRIDE_ONLY_EMPY_OR_UNDEFINED = "override.methods.onlyEmptyOrUndefined";
    public static final boolean OVERRIDE_ONLY_EMPY_OR_UNDEFINED_VAL = false;

    public static String[] getEHighlightKeywords(AbstractUIPlugin plugin) {
        StringBuilder _mda = new StringBuilder();
        PrefConst.collectHighlightKeywords(_mda, plugin);
        return _mda.toString().split(";");
    }

    private static void collectHighlightKeywords(StringBuilder sb, AbstractUIPlugin plugin) {
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACTIONS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STRUCT_MEMBERS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STATEMENTS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_EXPRESSIONS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TEMPORAL_EXPRESSIONS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACCESS_MODIFIERS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_SIMULTATOR_MEMBERS));
        sb.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TYPES));
        sb.append("out;inout;of;");
    }

    public static String[] getSLNHighlightKeywords(AbstractUIPlugin plugin) {
        StringBuilder sb = new StringBuilder();
        PrefConst.collectHighlightKeywords(sb, plugin);
        sb.append((CharSequence)sb.append(plugin.getPreferenceStore().getString(SLN_KEYWORDS_SCD)));
        return sb.toString().split(";");
    }

    public static String[] getKeywords(AbstractUIPlugin plugin, boolean isSLN) {
        StringBuilder _mda = new StringBuilder();
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACTIONS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STRUCT_MEMBERS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STATEMENTS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_EXPRESSIONS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TEMPORAL_EXPRESSIONS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACCESS_MODIFIERS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_SIMULTATOR_MEMBERS));
        _mda.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TYPES));
        if (isSLN) {
            _mda.append(plugin.getPreferenceStore().getString(SLN_KEYWORDS_SCD));
        }
        return _mda.toString().split(";");
    }

    public static String[] getKeywords(AbstractUIPlugin plugin, String kind) {
        if (kind.equals(E_TYPE_ACTIONS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_ACTIONS).split(";");
        }
        if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_STRUCT_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_STATEMENTS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_STATEMENTS).split(";");
        }
        if (kind.equals(E_TYPE_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_TEMPORAL_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_ACCESS_MODIFIERS).split(";");
        }
        if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_SIMULTATOR_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_TYPES)) {
            return plugin.getPreferenceStore().getString(E_KEYWORDS_TYPES).split(";");
        }
        if (kind.equals(SLN_TYPE_SCD)) {
            return plugin.getPreferenceStore().getString(SLN_KEYWORDS_SCD).split(";");
        }
        return null;
    }

    public static String[] getDefaultKeywords(AbstractUIPlugin plugin, String kind) {
        if (kind.equals(E_TYPE_ACTIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_ACTIONS).split(";");
        }
        if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_STRUCT_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_STATEMENTS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_STATEMENTS).split(";");
        }
        if (kind.equals(E_TYPE_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_TEMPORAL_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_ACCESS_MODIFIERS).split(";");
        }
        if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_SIMULTATOR_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_TYPES)) {
            return plugin.getPreferenceStore().getDefaultString(E_KEYWORDS_TYPES).split(";");
        }
        if (kind.equals(SLN_TYPE_SCD)) {
            return plugin.getPreferenceStore().getDefaultString(SLN_KEYWORDS_SCD).split(";");
        }
        return null;
    }

    public static String[] getPhrases(AbstractUIPlugin plugin, String kind) {
        if (kind.equals(E_TYPE_ACTIONS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_ACTIONS).split(";");
        }
        if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_STRUCT_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_STATEMENTS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_STATEMENTS).split(";");
        }
        if (kind.equals(E_TYPE_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_TEMPORAL_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_ACCESS_MODIFIERS).split(";");
        }
        if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_SIMULTATOR_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_TYPES)) {
            return plugin.getPreferenceStore().getString(E_PHRASES_TYPES).split(";");
        }
        if (kind.equals(SLN_TYPE_SCD)) {
            return plugin.getPreferenceStore().getString(SLN_PHRASES_SCD).split(";");
        }
        return null;
    }

    public static String[] getDefaultPhrases(AbstractUIPlugin plugin, String kind) {
        if (kind.equals(E_TYPE_ACTIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_ACTIONS).split(";");
        }
        if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_STRUCT_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_STATEMENTS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_STATEMENTS).split(";");
        }
        if (kind.equals(E_TYPE_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_TEMPORAL_EXPRESSIONS).split(";");
        }
        if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_ACCESS_MODIFIERS).split(";");
        }
        if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_SIMULTATOR_MEMBERS).split(";");
        }
        if (kind.equals(E_TYPE_TYPES)) {
            return plugin.getPreferenceStore().getDefaultString(E_PHRASES_TYPES).split(";");
        }
        if (kind.equals(SLN_TYPE_SCD)) {
            return plugin.getPreferenceStore().getDefaultString(SLN_PHRASES_SCD).split(";");
        }
        return null;
    }

    public static String[][] getKeyphrasesForHighlight(AbstractUIPlugin plugin, boolean isSLN) {
        String[] phrases = PrefConst.getKeyphrasesPreference(plugin, isSLN);
        String[][] result = new String[phrases.length][2];
        int i = 0;
        while (i < phrases.length) {
            result[i] = phrases[i].split(" ");
            ++i;
        }
        return result;
    }

    public static String[] getDefaultETypes(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getDefaultString(E_SCALAR_TYPES).split(";");
    }

    public static String[] getETypes(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getString(E_SCALAR_TYPES).split(";");
    }

    public static void setETypes(AbstractUIPlugin plugin, String[] _items) {
        plugin.getPreferenceStore().setValue(E_SCALAR_TYPES, PrefConst.getStringPreference(_items));
    }

    public static String[] getDefaultEConstants(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getDefaultString(E_CONSTANTS).split(";");
    }

    public static String[] getEConstants(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getString(E_CONSTANTS).split(";");
    }

    public static void setEUnits(AbstractUIPlugin plugin, String[] _items) {
        plugin.getPreferenceStore().setValue(E_UNITS, PrefConst.getStringPreference(_items));
    }

    public static String[] getDefaultEUnits(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getDefaultString(E_UNITS).split(";");
    }

    public static String[] getEUnits(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getString(E_UNITS).split(";");
    }

    public static void setEConstants(AbstractUIPlugin plugin, String[] items) {
        plugin.getPreferenceStore().setValue(E_CONSTANTS, PrefConst.getStringPreference(items));
    }

    public static String[] getDefaultEPreproc(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getDefaultString(E_PREPROC).split(";");
    }

    public static String[] getEPreproc(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getString(E_PREPROC).split(";");
    }

    public static void setEPreproc(AbstractUIPlugin plugin, String[] items) {
        plugin.getPreferenceStore().setValue(E_PREPROC, PrefConst.getStringPreference(items));
    }

    private static String getStringPreference(String[] elements) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < elements.length) {
            buffer.append(elements[i]);
            buffer.append(";");
            ++i;
        }
        return buffer.toString();
    }

    public static int getMaxPhraseLength(AbstractUIPlugin plugin, boolean isSLN) {
        int max_size = 0;
        String[] phrases = PrefConst.getKeyphrasesPreference(plugin, isSLN);
        int i = 0;
        while (i < phrases.length) {
            max_size = Math.max(max_size, phrases[i].length());
            ++i;
        }
        return max_size;
    }

    public static String[] getKeywordsPreference(AbstractUIPlugin plugin, boolean isSLN) {
        StringBuilder result = new StringBuilder();
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACTIONS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STRUCT_MEMBERS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_STATEMENTS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_EXPRESSIONS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TEMPORAL_EXPRESSIONS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_ACCESS_MODIFIERS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_SIMULTATOR_MEMBERS));
        result.append(plugin.getPreferenceStore().getString(E_KEYWORDS_TYPES));
        result.append(plugin.getPreferenceStore().getString(E_SCALAR_TYPES));
        result.append(plugin.getPreferenceStore().getString(E_CONSTANTS));
        result.append(plugin.getPreferenceStore().getString(E_UNITS));
        result.append(plugin.getPreferenceStore().getString(E_PREPROC));
        if (isSLN) {
            result.append(plugin.getPreferenceStore().getString(SLN_KEYWORDS_SCD));
        }
        return result.toString().split(";");
    }

    private static String[] getKeyphrasesPreference(AbstractUIPlugin plugin, boolean isSLN) {
        StringBuilder sb = new StringBuilder();
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_ACTIONS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_EXPRESSIONS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_SIMULTATOR_MEMBERS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_STATEMENTS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_STRUCT_MEMBERS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_TYPES));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_TEMPORAL_EXPRESSIONS));
        sb.append(plugin.getPreferenceStore().getString(E_PHRASES_ACCESS_MODIFIERS));
        if (isSLN) {
            sb.append(plugin.getPreferenceStore().getString(SLN_PHRASES_SCD));
        }
        return sb.toString().split(";");
    }

    public static String[] getNamecheckKeywords(AbstractUIPlugin plugin, boolean isSLN) {
        return PrefConst.getKeywordsPreference(plugin, isSLN);
    }

    public static String[] getNamecheckKeyphrases(AbstractUIPlugin plugin, boolean isSLN) {
        return PrefConst.getKeyphrasesPreference(plugin, isSLN);
    }

    public static String[] getEContentTypes() {
        return new String[]{E_TYPE_ACTIONS, E_TYPE_STATEMENTS, E_TYPE_STRUCT_MEMBERS, E_TYPE_EXPRESSIONS, E_TYPE_TEMPORAL_EXPRESSIONS, E_TYPE_ACCESS_MODIFIERS, E_TYPE_SIMULATOR_MEMBERS, E_TYPE_TYPES};
    }

    public static String[] getSLNContentTypes() {
        return new String[]{E_TYPE_ACTIONS, E_TYPE_STATEMENTS, E_TYPE_STRUCT_MEMBERS, E_TYPE_EXPRESSIONS, E_TYPE_TEMPORAL_EXPRESSIONS, E_TYPE_ACCESS_MODIFIERS, E_TYPE_SIMULATOR_MEMBERS, E_TYPE_TYPES, SLN_TYPE_SCD};
    }

    public static TreeSymbol getTreeViewKeywords(AbstractUIPlugin plugin, boolean isSLN) {
        TreeSymbol tsp = new TreeSymbol("root");
        String[] types = !isSLN ? PrefConst.getEContentTypes() : PrefConst.getSLNContentTypes();
        int i = 0;
        while (i < types.length) {
            TreeSymbol ts = new TreeSymbol(types[i]);
            tsp.add(ts);
            String[] words = PrefConst.getKeywords(plugin, types[i]);
            if (words != null) {
                int j = 0;
                while (j < words.length) {
                    if (!words[j].isEmpty()) {
                        ts.add(new TreeSymbol(words[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tsp;
    }

    public static TreeSymbol getTreeViewDefaultKeywords(AbstractUIPlugin plugin, boolean isSLN) {
        TreeSymbol tsp = new TreeSymbol("root");
        String[] types = !isSLN ? PrefConst.getEContentTypes() : PrefConst.getSLNContentTypes();
        int i = 0;
        while (i < types.length) {
            TreeSymbol ts = new TreeSymbol(types[i]);
            tsp.add(ts);
            String[] words = PrefConst.getDefaultKeywords(plugin, types[i]);
            if (words != null) {
                int j = 0;
                while (j < words.length) {
                    if (!words[j].isEmpty()) {
                        ts.add(new TreeSymbol(words[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tsp;
    }

    public static void setTreeViewKeywords(AbstractUIPlugin plugin, TreeSymbol[] content) {
        if (content != null) {
            int i = 0;
            while (i < content.length) {
                String kind = content[i].getText();
                StringBuilder buffer = new StringBuilder();
                if (content[i].hasChildren()) {
                    TreeSymbol[] elements = content[i].getChildren();
                    int j = 0;
                    while (j < elements.length) {
                        buffer.append(elements[j].getText());
                        buffer.append(";");
                        ++j;
                    }
                } else {
                    buffer.append(";");
                }
                if (kind.equals(E_TYPE_ACTIONS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_ACTIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_STRUCT_MEMBERS, buffer.toString());
                } else if (kind.equals(E_TYPE_STATEMENTS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_STATEMENTS, buffer.toString());
                } else if (kind.equals(E_TYPE_EXPRESSIONS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_EXPRESSIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_TEMPORAL_EXPRESSIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_ACCESS_MODIFIERS, buffer.toString());
                } else if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_SIMULTATOR_MEMBERS, buffer.toString());
                } else if (kind.equals(E_TYPE_TYPES)) {
                    plugin.getPreferenceStore().setValue(E_KEYWORDS_TYPES, buffer.toString());
                } else if (kind.equals(SLN_TYPE_SCD)) {
                    plugin.getPreferenceStore().setValue(SLN_KEYWORDS_SCD, buffer.toString());
                }
                ++i;
            }
        }
    }

    public static TreeSymbol getTreeViewPhrases(AbstractUIPlugin plugin, boolean isSLN) {
        TreeSymbol tsp = new TreeSymbol("root");
        String[] types = !isSLN ? PrefConst.getEContentTypes() : PrefConst.getSLNContentTypes();
        int i = 0;
        while (i < types.length) {
            TreeSymbol ts = new TreeSymbol(types[i]);
            tsp.add(ts);
            String[] words = PrefConst.getPhrases(plugin, types[i]);
            if (words != null) {
                int j = 0;
                while (j < words.length) {
                    if (!words[j].isEmpty()) {
                        ts.add(new TreeSymbol(words[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tsp;
    }

    public static TreeSymbol getTreeViewDefaultPhrases(AbstractUIPlugin plugin, boolean isSLN) {
        TreeSymbol tsp = new TreeSymbol("root");
        String[] types = !isSLN ? PrefConst.getEContentTypes() : PrefConst.getSLNContentTypes();
        int i = 0;
        while (i < types.length) {
            TreeSymbol ts = new TreeSymbol(types[i]);
            tsp.add(ts);
            String[] words = PrefConst.getDefaultPhrases(plugin, types[i]);
            if (words != null) {
                int j = 0;
                while (j < words.length) {
                    if (!words[j].isEmpty()) {
                        ts.add(new TreeSymbol(words[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return tsp;
    }

    public static void setTreeViewPhrases(AbstractUIPlugin plugin, TreeSymbol[] content) {
        if (content != null) {
            int i = 0;
            while (i < content.length) {
                String kind = content[i].getText();
                StringBuilder buffer = new StringBuilder();
                if (content[i].hasChildren()) {
                    TreeSymbol[] elements = content[i].getChildren();
                    int j = 0;
                    while (j < elements.length) {
                        buffer.append(elements[j].getText());
                        buffer.append(";");
                        ++j;
                    }
                } else {
                    buffer.append(";");
                }
                if (kind.equals(E_TYPE_ACTIONS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_ACTIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_STRUCT_MEMBERS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_STRUCT_MEMBERS, buffer.toString());
                } else if (kind.equals(E_TYPE_STATEMENTS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_STATEMENTS, buffer.toString());
                } else if (kind.equals(E_TYPE_EXPRESSIONS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_EXPRESSIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_TEMPORAL_EXPRESSIONS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_TEMPORAL_EXPRESSIONS, buffer.toString());
                } else if (kind.equals(E_TYPE_ACCESS_MODIFIERS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_ACCESS_MODIFIERS, buffer.toString());
                } else if (kind.equals(E_TYPE_SIMULATOR_MEMBERS)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_SIMULTATOR_MEMBERS, buffer.toString());
                } else if (kind.equals(E_TYPE_TYPES)) {
                    plugin.getPreferenceStore().setValue(E_PHRASES_TYPES, buffer.toString());
                } else if (kind.equals(SLN_TYPE_SCD)) {
                    plugin.getPreferenceStore().setValue(SLN_PHRASES_SCD, buffer.toString());
                }
                ++i;
            }
        }
    }

    public static boolean getOVMComplianceCheckOVMClasses(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getBoolean(OVM_COMPLIANCE_CHECK_OVM_CLASSES);
    }

    public static boolean getOVMComplianceCheckOVMFiles(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getBoolean(OVM_COMPLIANCE_CHECK_OVM_FILES);
    }

    public static void setOVMComplianceCheckOVMClasses(AbstractUIPlugin plugin, boolean value) {
        plugin.getPreferenceStore().setValue(OVM_COMPLIANCE_CHECK_OVM_CLASSES, value);
    }

    public static void setOVMComplianceCheckOVMFiles(AbstractUIPlugin plugin, boolean value) {
        plugin.getPreferenceStore().setValue(OVM_COMPLIANCE_CHECK_OVM_FILES, value);
    }

    public static final RGB getVerissimoBackgroundColor(AbstractUIPlugin plugin) {
        return PreferenceConverter.getColor((IPreferenceStore)plugin.getPreferenceStore(), (String)VERISSIMO_BACKGROUND_COLOR);
    }

    public static int getCompareViewerMaxLines(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getInt(COMPARE_VIEWER_MAX_LINES);
    }

    public static boolean isCodeFoldingEnabled(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getBoolean(EDITOR_CODE_FOLDING);
    }

    public static int getCodeFoldingNofLines(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getInt(EDITOR_CODE_FOLDING_NOF_LINES);
    }

    public static boolean isManualCodeFoldingEnabled(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getBoolean(EDITOR_MANUAL_CODE_FOLDING);
    }

    public static boolean getOverrideOnlyEmptyOrUndefined(AbstractUIPlugin plugin) {
        return plugin.getPreferenceStore().getBoolean(OVERRIDE_ONLY_EMPY_OR_UNDEFINED);
    }

    public static void setOverrideOnlyEmptyOrUndefined(AbstractUIPlugin plugin, boolean value) {
        plugin.getPreferenceStore().setValue(OVERRIDE_ONLY_EMPY_OR_UNDEFINED, value);
    }
}

