/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.refactor.rename;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.search.BaseFileMatch;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEnum;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfScalarTypeLayer;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.edt.base.ui.refactor.ETextFileChange;
import ro.amiq.edt.base.ui.refactor.rename.ERenameRefactorInfo;
import ro.amiq.edt.base.ui.search.ReferenceSearchPageInput;
import ro.amiq.edt.base.ui.search.SearchQueryProvider;
import ro.amiq.edt.base.ui.search.text.FileMatch;
import ro.amiq.edt.base.ui.search.text.FileSearchResult;

public class ERenameDelegate
extends DVTRenameDelegate {
    private IEPluginConfig fPluginConfig;

    public ERenameDelegate(IEPluginConfig pluginConfig, DVTRenameRefactorInfo info, boolean useScopeInfo) {
        super(info, useScopeInfo);
        this.fPluginConfig = pluginConfig;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) {
        Object[] resultElements;
        RefactoringStatus result = new RefactoringStatus();
        IProject project = this.getRefactorInfo().getProject();
        RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
        String[] fileExtensions = null;
        try {
            fileExtensions = BaseReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
        }
        catch (CoreException coreException) {
            result.addFatalError("Could not search for references to " + this.getRefactorInfo().getOldSignature());
            return result;
        }
        IResource[] resources = new IResource[]{project};
        FileTextSearchScope searchScope = FileTextSearchScope.newSearchScope((IResource[])resources, (String[])fileExtensions, (boolean)false);
        RfNamedElement element = ((ERenameRefactorInfo)this.getRefactorInfo()).getNamedElement();
        int searchTypeConstant = ReferencesInWorkspaceAction.getSearchTypeConstant(element);
        ISearchQuery query = null;
        if (element instanceof RfMethod && !((RfMethod)element).isTCM() && element.getName().startsWith("on_")) {
            RfMethod method = (RfMethod)element;
            String name = method.getName().substring(3);
            boolean exists = ((ERenameRefactorInfo)this.getRefactorInfo()).eventExists(name, method.getPackageName(), method.getParentStruct());
            if (exists) {
                result.addFatalError("Could not perform refactoring operation on event auto-generated method.\nRename should be performed on event name.");
                return result;
            }
        }
        if (element instanceof RfMacro && !((RfMacro)element).isPreprocessing()) {
            input = new TextSearchPageInput(((RfMacro)element).getStringLiteral(), true, false, true, searchScope);
            query = new SearchQueryProvider(this.fPluginConfig, 1, searchTypeConstant, true, true, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        } else {
            input = new ReferenceSearchPageInput(element, true, false, true, searchScope);
            query = new SearchQueryProvider(this.fPluginConfig, 1, searchTypeConstant, true, true, RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
        }
        if (query == null) {
            result.addFatalError("Could not search for references to " + this.getRefactorInfo().getOldSignature());
            return result;
        }
        query.run(monitor);
        HashMap<IResource, Match[]> matches = new HashMap<IResource, Match[]>();
        FileSearchResult searchResult = (FileSearchResult)query.getSearchResult();
        Object[] objectArray = resultElements = searchResult.getElements();
        int n = resultElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object resultElement = objectArray[n2];
            if (resultElement instanceof IResource) {
                matches.put((IResource)resultElement, searchResult.getMatches(resultElement));
            }
            ++n2;
        }
        this.getRefactorInfo().setMatches(matches);
        return result;
    }

    protected DVTTextFileChange getTextFileChange(IFile file) {
        return new ETextFileChange(file.getName(), file);
    }

    public void createChangesFor(IFile file, Match[] matches, CompositeChange rootChange, DVTTextFileChange textFileChange, boolean inComments) {
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            if (match instanceof FileMatch) {
                FileMatch fileMatch = (FileMatch)match;
                String matchString = RfReferencesUtils.getFileMatchString((BaseFileMatch)fileMatch);
                ReplaceEdit replaceEdit = null;
                replaceEdit = fileMatch.isImplicit() && (fileMatch.getRfElementKind() == 2 || fileMatch.getRfElementKind() == 10 || fileMatch.getRfElementKind() == 11) ? new ReplaceEdit(fileMatch.getOffset(), 0, String.valueOf(this.getRefactorInfo().getNewName()) + ": ") : (fileMatch.isImplicit() ? new ReplaceEdit(fileMatch.getOffset() + fileMatch.getLength(), 0, ": " + this.getRefactorInfo().getNewName()) : new ReplaceEdit(fileMatch.getOffset(), fileMatch.getLength(), this.getRefactorInfo().getNewName()));
                textFileChange.addEdit((TextEdit)replaceEdit);
                this.addToChangeGroup(textFileChange, fileMatch, matchString, inComments, (TextEdit)replaceEdit, SEMANTIC_CHANGES);
            }
            ++n2;
        }
    }

    public IStatus checkNewNameInternal(DVTRenameRefactorInfo refactorInfo) {
        try {
            RfDefElement layer;
            String newName = refactorInfo.getNewName();
            IRfScope scope = (IRfScope)refactorInfo.getScope();
            RfNamedElement namedElement = (RfNamedElement)refactorInfo.getElement();
            if (namedElement instanceof RfType) {
                RfProject rfProject = namedElement.getRfProject();
                if (rfProject == null) {
                    return Status.OK_STATUS;
                }
                List<RfNamedElement> types = rfProject.getAllTypes(true, false);
                if (types == null || types.isEmpty()) {
                    return Status.OK_STATUS;
                }
                for (RfNamedElement type : types) {
                    if (!type.getName().equals(newName)) continue;
                    if (((RfType)type).getPackageName().equals(((RfType)namedElement).getPackageName())) {
                        return new Status(4, this.fPluginConfig.getPluginID(), "There is already a type with this name in this package.");
                    }
                    List<RfDefElement> layers = type.getLayers();
                    if (layers == null) continue;
                    for (RfDefElement layer2 : layers) {
                        if (layer2.getPackageName().equals(((RfType)type).getPackageName()) || layer2.hasQualifiedName()) continue;
                        return new Status(4, this.fPluginConfig.getPluginID(), "There is already a type with this name in a different package, extended in other packages.");
                    }
                }
                return Status.OK_STATUS;
            }
            if (namedElement instanceof RfMethod) {
                RfMethod candidate = scope.getMethodWithPrefix(null, null, 1, newName, 31);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "a method"));
                }
                return Status.OK_STATUS;
            }
            if (namedElement instanceof RfEvent) {
                RfEvent candidate = scope.getEventWithPrefix(null, null, 1, newName, 31);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "an event"));
                }
                return Status.OK_STATUS;
            }
            if (namedElement instanceof RfField) {
                RfField candidate = scope.getFieldWithPrefix(null, null, 1, newName, 31);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "a field"));
                }
                return Status.OK_STATUS;
            }
            if (namedElement instanceof RfVar) {
                RfVar candidate = scope.getVariableWithPrefix(0, 1, newName);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "a variable"));
                }
                candidate = scope.getArgumentWithPrefix(1, newName);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "an argument"));
                }
                return Status.OK_STATUS;
            }
            if (namedElement instanceof RfEnum && (layer = namedElement.getFirstLayer()) instanceof RfScalarTypeLayer) {
                RfEnum candidate = ((RfScalarTypeLayer)layer).getEnum(newName);
                if (candidate != null) {
                    return new Status(4, this.fPluginConfig.getPluginID(), MessageFormat.format("There is already {0} with this name.", "an enum item"));
                }
                return Status.OK_STATUS;
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new Status(4, this.fPluginConfig.getPluginID(), "Unexpected error while checking new name: " + e.getMessage());
        }
    }
}

