/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.refactor.rename;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.search.text.FileMatch;

public class ERenameRefactorInfo
extends DVTRenameRefactorInfo {
    private RfWNamedElementAndScope fNamedElementAndScope;

    public ERenameRefactorInfo(IProject project, RfWNamedElementAndScope namedElementAndScope) {
        super(project);
        this.fNamedElementAndScope = namedElementAndScope;
    }

    public RfNamedElement getNamedElement() {
        return this.fNamedElementAndScope.getNamedElement();
    }

    public String getOldName() {
        RfNamedElement element = this.getNamedElement();
        if (element == null) {
            return null;
        }
        return element.getName();
    }

    public String getOldSignature() {
        RfNamedElement element = this.getNamedElement();
        if (element == null) {
            return null;
        }
        return DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)element.getSignature(), (String)" ");
    }

    public boolean hasPotentialMatches() {
        if (this.getMatches() == null) {
            return false;
        }
        Iterator iterator = this.getMatches().values().iterator();
        while (iterator.hasNext()) {
            Match[] fileMatches;
            Match[] matchArray = fileMatches = (Match[])iterator.next();
            int n = fileMatches.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof FileMatch && ((FileMatch)match).isPossibleMatch()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean eventExists(String name, String packageName, RfStruct enclosingStruct) {
        if (enclosingStruct == null) {
            return false;
        }
        int accessModifier = 30;
        RfEvent event = enclosingStruct.getEventWithPrefix(packageName, enclosingStruct, 1, name, accessModifier);
        return event != null;
    }

    public IRfScopeElement getScope() {
        return this.fNamedElementAndScope.getScope();
    }

    public IRfNamedElement getElement() {
        return this.fNamedElementAndScope.getNamedElement();
    }
}

