/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.core.EDTBasePlugin;
import ro.amiq.edt.base.ui.search.AbstractSearchVisitorCommon;

public abstract class AbstractSearchVisitor
extends AbstractSearchVisitorCommon {
    @Override
    protected void evalNonFileBufferDocuments() {
        try {
            this.fDocumentsInEditors = new HashMap();
            IWorkbench workbench = EDTBasePlugin.getDefault().getWorkbench();
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchPage[] pages = windows[i].getPages();
                int x = 0;
                while (x < pages.length) {
                    IEditorReference[] editorRefs = pages[x].getEditorReferences();
                    int z = 0;
                    while (z < editorRefs.length) {
                        IEditorPart ep = editorRefs[z].getEditor(false);
                        if (ep instanceof ITextEditor && ep.isDirty()) {
                            this.evaluateTextEditor(this.fDocumentsInEditors, ep);
                        }
                        ++z;
                    }
                    ++x;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    @Override
    protected String getCharSetName(IResource resource) {
        try {
            if (resource instanceof IProject) {
                return ((IProject)resource).getDefaultCharset();
            }
            if (resource instanceof IFile) {
                return ((IFile)resource).getCharset();
            }
            return "unknown";
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    @Override
    protected IDocument getDocumentInEditorFromFile(IFile file) {
        return (IDocument)this.fDocumentsInEditors.get(file);
    }
}

