/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.ReplaceAction;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfActionBlockLayer;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStructLayer;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.search.ISearchConstants;
import ro.amiq.edt.base.ui.search.ReferenceSearchPageInput;
import ro.amiq.edt.base.ui.search.RfSearchQueryElement;
import ro.amiq.edt.base.ui.search.SearchQueryProvider;
import ro.amiq.edt.base.ui.search.text.FileSearchPage;

public abstract class AbstractTextSearchPage
extends DialogPage
implements ISearchPage,
IReplacePage,
ISearchConstants {
    private static final int HISTORY_SIZE = 12;
    private static final String STORE_CASE_SENSITIVE = "CASE_SENSITIVE";
    private static final String STORE_IS_WHOLE_WORD_SEARCH = "WHOLE_WORD_SEARCH";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_SEARCH_FOR = "SEARCH_FOR";
    private static final String STORE_LIMIT_TO = "LIMIT_TO";
    private static final String STORE_INCLUDE_LAYERS = "INCLUDE_LAYERS";
    private static final String STORE_INCLUDE_DECLARATIONS = "INCLUDE_DECLARATIONS";
    private static final String STORE_ONLY_COMPILED = "ONLY_COMPILED";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private List<SearchPatternData> fPreviousSearchPatterns = new ArrayList<SearchPatternData>(20);
    private boolean fFirstTime = true;
    private boolean fSearchDerived = false;
    private boolean fIsRegExSearch;
    private boolean fIsWholeWordSearch;
    private boolean fIsCaseSensitive;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Button fIsRegExCheckbox;
    private Button fIsWholeWordCheckbox;
    private CLabel fStatusLabel;
    private Button fOnlyCompiled;
    private ISearchPageContainer fContainer;
    private Button[] fSearchFor;
    private String[] fSearchForText = new String[]{SearchMessages.SearchPage_searchFor_type, SearchMessages.SearchPage_searchFor_method, SearchMessages.SearchPage_searchFor_field, SearchMessages.SearchPage_searchFor_events, SearchMessages.SearchPage_searchFor_coverage, SearchMessages.SearchPage_searchFor_macro, SearchMessages.SearchPage_searchFor_message, SearchMessages.SearchPage_searchFor_dut_error, SearchMessages.SearchPage_searchFor_error, SearchMessages.SearchPage_searchFor_word};
    private Button[] fLimitTo;
    private String[] fLimitToText = new String[]{SearchMessages.SearchPage_limitTo_declarations, SearchMessages.SearchPage_limitTo_references, SearchMessages.SearchPage_limitTo_notInComment, SearchMessages.SearchPage_limitTo_allOccurrences};
    private Button fIncludeLayers;
    private Button fIncludeDeclarations;
    private ContentAssistCommandAdapter fPatterFieldContentAssist;

    public abstract IEPluginConfig getPluginConfig();

    private ISearchQuery newQuery() throws CoreException {
        TextSearchPageInput input = null;
        SearchPatternData data = this.getPatternData();
        if (this.fLimitTo[1].getSelection() && this.getSearchFor() != 5) {
            RfSearchQueryElement element = new RfSearchQueryElement(this.getSearchFor(), data.textPattern);
            input = new ReferenceSearchPageInput(element, data.isCaseSensitive, data.isRegExSearch, data.isWholeWordSearch, this.createTextSearchScope());
        } else {
            input = new TextSearchPageInput(data.textPattern, data.isCaseSensitive, data.isRegExSearch, data.isWholeWordSearch, this.createTextSearchScope());
        }
        return new SearchQueryProvider(this.getPluginConfig(), this.getLimitTo(), this.getSearchFor(), this.getLimitTo() == 0 ? this.getIncludeLayers() : this.getIncludeDeclarations(), this.fOnlyCompiled.getSelection(), RWSearchTypeEnum.USAGES).createQuery((TextSearchQueryProvider.TextSearchInput)input);
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        this.writeConfiguration();
        this.saveToPrefStore();
        return true;
    }

    public boolean performReplace() {
        IStatus status;
        block5: {
            status = NewSearchUI.runQueryInForeground((IRunnableContext)this.getContainer().getRunnableContext(), (ISearchQuery)this.newQuery());
            if (!status.matches(8)) break block5;
            return false;
        }
        try {
            if (!status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_runproblem_message, (IStatus)status);
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISearchResultPage page;
                    ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                    if (view != null && (page = view.getActivePage()) instanceof FileSearchPage) {
                        final FileSearchPage filePage = (FileSearchPage)page;
                        Object[] elements = filePage.getInput().getElements();
                        final IFile[] files = new IFile[elements.length];
                        System.arraycopy(elements, 0, files, 0, files.length);
                        DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])files, (Callable)new Callable<IStatus>(){

                            @Override
                            public IStatus call() {
                                new ReplaceAction((BaseFileSearchPage)filePage, files).run();
                                return Status.OK_STATUS;
                            }
                        }, false, null);
                    }
                }
            });
            return true;
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_querycreationproblem_message, (IStatus)e.getStatus());
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope((String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope((IWorkingSet[])workingSets, (String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
            }
        }
        return FileTextSearchScope.newWorkspaceScope((String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
    }

    private static String[] getExtensions(IEPluginConfig pluginConfig) {
        final IFile[] fileResult = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IEditorPart editor = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (editor instanceof AbstractEEditor) {
                    IFile file = (IFile)editor.getAdapter(IResource.class);
                    if (file == null) {
                        return;
                    }
                    fileResult[0] = file;
                }
            }
        });
        if (fileResult[0] != null) {
            Set extensions = BaseReferencesInWorkspaceAction.getCompiledFileExtensionPatterns((IProject)fileResult[0].getProject());
            return extensions.toArray(new String[extensions.size()]);
        }
        return DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.edt.ESource", true);
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope((String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource2 != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope((IResource[])arr, (String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope((String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope((IResource[])res, (String[])AbstractTextSearchPage.getExtensions(this.getPluginConfig()), (boolean)this.fSearchDerived);
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.fPattern.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.getCaseSensitive(), this.getRegEx(), this.getWholeWord(), this.getSearchFor(), this.getLimitTo(), this.getIncludeLayers(), this.getIncludeDeclarations(), this.getOnlyCompiled(), AbstractTextSearchPage.getExtensions(this.getPluginConfig()), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = this.fPreviousSearchPatterns.get((int)i).textPattern;
            ++i;
        }
        return patterns;
    }

    private boolean getCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    private boolean getWholeWord() {
        return this.fIsWholeWordCheckbox.getSelection();
    }

    private boolean getRegEx() {
        return this.fIsRegExCheckbox.getSelection();
    }

    private boolean getIncludeLayers() {
        return this.fIncludeLayers.getSelection();
    }

    private void setIncludeLayers(boolean includeLayers) {
        this.fIncludeLayers.setSelection(includeLayers);
    }

    private boolean getIncludeDeclarations() {
        return this.fIncludeDeclarations.getSelection();
    }

    private boolean getOnlyCompiled() {
        return this.fOnlyCompiled.getSelection();
    }

    private void setIncludeDeclarations(boolean includeDeclarations) {
        this.fIncludeDeclarations.setSelection(includeDeclarations);
    }

    private void setOnlyCompiled(boolean onlyCompiled) {
        this.fOnlyCompiled.setSelection(onlyCompiled);
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.initializePatternControl();
            }
            this.updateFromPrefStore();
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        boolean hasFilePattern = this.fPattern.getText() != null && this.fPattern.getText().length() > 0;
        this.getContainer().setPerformActionEnabled(regexStatus && hasFilePattern);
    }

    public void createControl(Composite parent) {
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.E_FAMILY_REPARSE);
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control expressionComposite = this.addTextPatternControls(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        separator.setLayoutData((Object)data);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control limitTo = this.createLimitTo(result);
        limitTo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        SelectionAdapter elementInitializer = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractTextSearchPage.this.setLimitTo(AbstractTextSearchPage.this.getSearchFor(), AbstractTextSearchPage.this.getLimitTo());
            }
        };
        this.fSearchFor[0].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[1].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[2].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[3].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[4].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[5].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[6].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[7].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[8].addSelectionListener((SelectionListener)elementInitializer);
        this.fSearchFor[9].addSelectionListener((SelectionListener)elementInitializer);
        this.fLimitTo[0].addSelectionListener((SelectionListener)elementInitializer);
        this.fLimitTo[1].addSelectionListener((SelectionListener)elementInitializer);
        this.readConfiguration();
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, this.getTextSearhPageHelp());
    }

    public abstract String getTextSearhPageHelp();

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.getRegEx()) {
            block5: {
                try {
                    Pattern.compile(this.fPattern.getText());
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, SearchMessages.SearchPage_regularExpression_tip);
        } else {
            this.statusMessage(false, SearchMessages.SearchPage_containingText_hint);
        }
        return true;
    }

    private Control addTextPatternControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.SearchPage_containingText_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        label.setFont(group.getFont());
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText(SearchMessages.SearchPage_caseSensitive);
        this.fIsCaseSensitiveCheckbox.setSelection(!this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTextSearchPage.this.fIsCaseSensitive = AbstractTextSearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTextSearchPage.this.handleWidgetSelected();
                AbstractTextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractTextSearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fPatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.fPattern, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'\\', '[', '('}, true);
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText(SearchMessages.SearchPage_regularExpression);
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText(SearchMessages.SearchPage_containingText_hint);
        this.fIsWholeWordCheckbox = new Button(group, 32);
        this.fIsWholeWordCheckbox.setText(SearchMessages.SearchPage_wholeWordExpression);
        this.fIsWholeWordCheckbox.setSelection(this.fIsWholeWordSearch);
        this.fIsWholeWordCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTextSearchPage.this.fIsWholeWordSearch = AbstractTextSearchPage.this.getWholeWord();
                AbstractTextSearchPage.this.updateOKStatus();
                AbstractTextSearchPage.this.writeConfiguration();
            }
        });
        this.fIsWholeWordCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsWholeWordCheckbox.setFont(group.getFont());
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTextSearchPage.this.fIsRegExSearch = AbstractTextSearchPage.this.getRegEx();
                AbstractTextSearchPage.this.updateOKStatus();
                AbstractTextSearchPage.this.updateWholeWordStatus();
                AbstractTextSearchPage.this.writeConfiguration();
                AbstractTextSearchPage.this.fPatterFieldContentAssist.setEnabled(AbstractTextSearchPage.this.fIsRegExSearch);
            }
        });
        this.updateWholeWordStatus();
        return group;
    }

    private void updateWholeWordStatus() {
        this.fIsRegExSearch = this.getRegEx();
        this.fIsWholeWordSearch = this.getWholeWord();
        this.fIsWholeWordCheckbox.setEnabled(!this.fIsRegExSearch);
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_searchFor_label);
        result.setLayout((Layout)new GridLayout(2, true));
        this.fSearchFor = new Button[this.fSearchForText.length];
        int i = 0;
        while (i < this.fSearchForText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fSearchForText[i]);
            button.setSelection(i == 9);
            button.setLayoutData((Object)new GridData());
            this.fSearchFor[i] = button;
            ++i;
        }
        return result;
    }

    private Control createLimitTo(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText(SearchMessages.SearchPage_limitTo_label);
        result.setLayout((Layout)new GridLayout(1, true));
        this.fLimitTo = new Button[this.fLimitToText.length];
        int i = 0;
        while (i < this.fLimitToText.length) {
            Button button = new Button((Composite)result, 16);
            button.setText(this.fLimitToText[i]);
            button.setSelection(i == 2);
            button.setLayoutData((Object)new GridData());
            this.fLimitTo[i] = button;
            if (i == 0) {
                this.fIncludeLayers = new Button((Composite)result, 32);
                this.fIncludeLayers.setText(SearchMessages.SearchPage_limitTo_declarations_includeLayers);
                this.fIncludeLayers.setSelection(false);
                includeButtonData = new GridData();
                includeButtonData.horizontalIndent = 20;
                this.fIncludeLayers.setLayoutData((Object)includeButtonData);
            } else if (i == 1) {
                this.fIncludeDeclarations = new Button((Composite)result, 32);
                this.fIncludeDeclarations.setText(SearchMessages.SearchPage_limitTo_references_includeDeclarations);
                this.fIncludeDeclarations.setSelection(false);
                includeButtonData = new GridData();
                includeButtonData.horizontalIndent = 20;
                this.fIncludeDeclarations.setLayoutData((Object)includeButtonData);
            }
            ++i;
        }
        this.fOnlyCompiled = new Button((Composite)result, 32);
        this.fOnlyCompiled.setText(SearchMessages.SearchPage_limitTo_onlyCompiled);
        this.fOnlyCompiled.setSelection(true);
        GridData includeButtonData = new GridData();
        this.fOnlyCompiled.setLayoutData((Object)includeButtonData);
        return result;
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fPattern.setText(patternData.textPattern);
        this.fIsRegExCheckbox.setSelection(patternData.isRegExSearch);
        this.fIsWholeWordCheckbox.setSelection(patternData.isWholeWordSearch);
        this.fIncludeLayers.setSelection(patternData.isIncludeLayers);
        this.fIncludeDeclarations.setSelection(patternData.isIncludeDeclarations);
        this.fOnlyCompiled.setSelection(patternData.isOnlyCompiled);
        this.setSearchFor(patternData.searchFor);
        this.setLimitTo(patternData.searchFor, patternData.limitTo);
        this.updateWholeWordStatus();
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean initializePatternControl() {
        try {
            String text = null;
            ISelection selection = this.getSelection();
            if (selection == null || !(selection instanceof ITextSelection) || selection.isEmpty() || (text = ((ITextSelection)selection).getText()).length() > 0) {
                int searchType = 9;
                this.setSearchFor(searchType);
                this.setLimitTo(searchType, this.getLimitTo());
            } else {
                int searchType = 9;
                DVTEditor activeEditor = this.getActiveEditor();
                if (activeEditor == null) {
                    return false;
                }
                IEditorInput editorInput = activeEditor.getEditorInput();
                if (editorInput == null) {
                    return false;
                }
                IFile file = (IFile)editorInput.getAdapter(IFile.class);
                if (file == null) {
                    return false;
                }
                IProject project = file.getProject();
                if (project == null) {
                    return false;
                }
                IDocument document = activeEditor.getDocument();
                if (document == null) {
                    return false;
                }
                int offset = activeEditor.getCursor();
                RfProject rfProject = this.getPluginConfig().getRfManager().getRfProject(file.getProject());
                if (rfProject == null) {
                    return false;
                }
                RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElementForSearch(rfProject, file, document, offset, null);
                if (namedElementAndScope != null) {
                    RfNamedElement namedElement = namedElementAndScope.getNamedElement();
                    IRfScope scope = namedElementAndScope.getScope();
                    if (namedElement == null) {
                        return false;
                    }
                    if (namedElement instanceof RfStructMember) {
                        while (scope != null && scope instanceof RfActionBlockLayer) {
                            scope = ((RfActionBlockLayer)scope).getEnclosingScope();
                        }
                        if (scope != null && scope instanceof RfStructLayer) {
                            text = ((RfStructLayer)scope).getStruct() != null ? String.valueOf(((RfStructLayer)scope).getStruct().getPackageName()) + "::" + ((RfStructLayer)scope).getName() + "." + namedElement.getName() : namedElement.getName();
                            if (namedElement instanceof RfField) {
                                searchType = 2;
                            } else if (namedElement instanceof RfMethod) {
                                searchType = 1;
                            } else if (namedElement instanceof RfEvent) {
                                searchType = 3;
                            }
                        }
                    } else if (namedElement instanceof RfType) {
                        text = String.valueOf(((RfType)namedElement).getPackageName()) + "::" + namedElement.getName();
                        searchType = 0;
                    }
                }
                if (text == null || text.length() == 0) {
                    return false;
                }
                this.setSearchFor(searchType);
                this.setLimitTo(searchType, this.getLimitTo());
            }
            if (text == null || text.length() == 0) {
                return false;
            }
            this.fPattern.setText(this.insertEscapeChars(text));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private String insertEscapeChars(String text) {
        String readLine;
        int lengthOfFirstLine;
        StringBuilder sbIn;
        block6: {
            if (text == null || text.equals("")) {
                return "";
            }
            sbIn = new StringBuilder(text);
            BufferedReader reader = new BufferedReader(new StringReader(text));
            lengthOfFirstLine = 0;
            try {
                readLine = reader.readLine();
                if (readLine != null) break block6;
                return "";
            }
            catch (IOException iOException) {
                return "";
            }
        }
        lengthOfFirstLine = readLine.length();
        StringBuilder sbOut = new StringBuilder(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    private DVTEditor getActiveEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = workbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == activePage.getActivePart() && activeEditor instanceof DVTEditor) {
            return (DVTEditor)activeEditor;
        }
        return null;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    public abstract IDialogSettings getDialogSettings();

    private void readConfiguration() {
        try {
            IDialogSettings s = this.getDialogSettings();
            this.setCaseSensitive(s.getBoolean(STORE_CASE_SENSITIVE));
            this.setRegExSearch(s.getBoolean(STORE_IS_REG_EX_SEARCH));
            this.setWholeWordSearch(s.getBoolean(STORE_IS_WHOLE_WORD_SEARCH));
            this.setSearchFor(s.getInt(STORE_SEARCH_FOR));
            this.setLimitTo(s.getInt(STORE_SEARCH_FOR), s.getInt(STORE_LIMIT_TO));
            this.setIncludeLayers(s.getBoolean(STORE_INCLUDE_LAYERS));
            this.setIncludeDeclarations(s.getBoolean(STORE_INCLUDE_DECLARATIONS));
            this.setOnlyCompiled(s.getBoolean(STORE_ONLY_COMPILED));
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(this.getPluginConfig(), histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void setCaseSensitive(boolean selected) {
        this.fIsCaseSensitiveCheckbox.setSelection(selected);
    }

    private void setRegExSearch(boolean selected) {
        this.fIsRegExCheckbox.setSelection(selected);
        this.fPatterFieldContentAssist.setEnabled(this.fIsRegExSearch);
        this.updateWholeWordStatus();
    }

    private void setWholeWordSearch(boolean selected) {
        this.fIsWholeWordCheckbox.setSelection(selected);
        this.updateWholeWordStatus();
    }

    private void writeConfiguration() {
        try {
            IDialogSettings s = this.getDialogSettings();
            s.put(STORE_IS_WHOLE_WORD_SEARCH, this.fIsWholeWordSearch);
            s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
            s.put(STORE_CASE_SENSITIVE, this.getCaseSensitive());
            s.put(STORE_SEARCH_FOR, this.getSearchFor());
            s.put(STORE_LIMIT_TO, this.getLimitTo());
            s.put(STORE_INCLUDE_LAYERS, this.getIncludeLayers());
            s.put(STORE_INCLUDE_DECLARATIONS, this.getIncludeDeclarations());
            int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
            s.put(STORE_HISTORY_SIZE, historySize);
            int i = 0;
            while (i < historySize) {
                IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
                SearchPatternData data = this.fPreviousSearchPatterns.get(i);
                data.store(histSettings);
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int getSearchFor() {
        int i = 0;
        while (i < this.fSearchFor.length) {
            if (this.fSearchFor[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setSearchFor(int searchFor) {
        int i = 0;
        while (i < this.fSearchFor.length) {
            this.fSearchFor[i].setSelection(searchFor == i);
            ++i;
        }
    }

    private int getLimitTo() {
        int i = 0;
        while (i < this.fLimitTo.length) {
            if (this.fLimitTo[i].getSelection()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setLimitTo(int searchFor, int limitTo) {
        this.fOnlyCompiled.setEnabled(false);
        if (searchFor == 9) {
            this.fLimitTo[3].setEnabled(true);
            this.fLimitTo[2].setEnabled(true);
            this.fLimitTo[1].setEnabled(false);
            this.fLimitTo[0].setEnabled(false);
            this.fOnlyCompiled.setEnabled(true);
        } else if (searchFor == 4 || searchFor == 6 || searchFor == 7 || searchFor == 8) {
            this.fLimitTo[3].setEnabled(false);
            this.fLimitTo[2].setEnabled(false);
            this.fLimitTo[1].setEnabled(false);
            this.fLimitTo[0].setEnabled(false);
        } else {
            this.fLimitTo[3].setEnabled(false);
            this.fLimitTo[2].setEnabled(false);
            this.fLimitTo[1].setEnabled(true);
            this.fLimitTo[0].setEnabled(true);
        }
        if (searchFor == 0 && limitTo != 1 && limitTo != 0) {
            limitTo = 0;
        } else if (searchFor == 1 && limitTo != 1 && limitTo != 0) {
            limitTo = 0;
        } else if (searchFor == 2 && limitTo != 1 && limitTo != 0) {
            limitTo = 0;
        } else if (searchFor == 3 && limitTo != 1 && limitTo != 0) {
            limitTo = 0;
        } else if (searchFor == 4 && limitTo != 3) {
            limitTo = 3;
        } else if (searchFor == 5 && limitTo != 1 && limitTo != 0) {
            limitTo = 0;
        } else if (searchFor == 6 && limitTo != 3) {
            limitTo = 3;
        } else if (searchFor == 7 && limitTo != 3) {
            limitTo = 3;
        } else if (searchFor == 8 && limitTo != 3) {
            limitTo = 3;
        } else if (searchFor == 9 && limitTo != 2 && limitTo != 3) {
            limitTo = 2;
        }
        if (searchFor == 5) {
            this.fIncludeLayers.setEnabled(false);
        } else {
            this.fIncludeLayers.setEnabled(limitTo == 0);
        }
        this.fIncludeDeclarations.setEnabled(limitTo == 1);
        int i = 0;
        while (i < this.fLimitTo.length) {
            this.fLimitTo[i].setSelection(limitTo == i);
            ++i;
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fStatusLabel, JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusLabel, DVTColorUtil.INSTANCE.getBackground((Control)this.fStatusLabel.getParent()));
        } else {
            DVTColorUtil.INSTANCE.setForeground((Control)this.fStatusLabel, DVTColorUtil.INSTANCE.getDefaultForeground((Control)this.fStatusLabel));
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusLabel, DVTColorUtil.INSTANCE.getBackground((Control)this.fStatusLabel.getParent()));
        }
    }

    private void saveToPrefStore() {
        IPreferenceStore prefStore = this.getPluginConfig().getPlugin().getPreferenceStore();
        prefStore.setValue(STORE_IS_WHOLE_WORD_SEARCH, this.fIsWholeWordSearch);
        prefStore.setValue(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        prefStore.setValue(STORE_CASE_SENSITIVE, this.getCaseSensitive());
        prefStore.setValue(STORE_SEARCH_FOR, this.getSearchFor());
        prefStore.setValue(STORE_LIMIT_TO, this.getLimitTo());
        prefStore.setValue(STORE_INCLUDE_LAYERS, this.getIncludeLayers());
        prefStore.setValue(STORE_INCLUDE_DECLARATIONS, this.getIncludeDeclarations());
        prefStore.setValue(STORE_ONLY_COMPILED, this.getOnlyCompiled());
    }

    private void updateFromPrefStore() {
        IPreferenceStore prefStore = this.getPluginConfig().getPlugin().getPreferenceStore();
        this.setCaseSensitive(prefStore.getBoolean(STORE_CASE_SENSITIVE));
        this.setRegExSearch(prefStore.getBoolean(STORE_IS_REG_EX_SEARCH));
        this.setWholeWordSearch(prefStore.getBoolean(STORE_IS_WHOLE_WORD_SEARCH));
        this.setSearchFor(prefStore.getInt(STORE_SEARCH_FOR));
        this.setLimitTo(prefStore.getInt(STORE_SEARCH_FOR), prefStore.getInt(STORE_LIMIT_TO));
        this.setIncludeLayers(prefStore.getBoolean(STORE_INCLUDE_LAYERS));
        this.setIncludeDeclarations(prefStore.getBoolean(STORE_INCLUDE_DECLARATIONS));
        this.setOnlyCompiled(prefStore.getBoolean(STORE_ONLY_COMPILED));
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final boolean isWholeWordSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;
        private int searchFor;
        private int limitTo;
        private boolean isIncludeLayers;
        private boolean isIncludeDeclarations;
        private boolean isOnlyCompiled;

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, boolean isWholeWordSearch, int searchFor, int limitTo, boolean isIncludeLayers, boolean isIncludeDeclarations, boolean isOnlyCompiled, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isCaseSensitive = isCaseSensitive;
            this.isWholeWordSearch = isWholeWordSearch;
            this.searchFor = searchFor;
            this.limitTo = limitTo;
            this.isIncludeLayers = isIncludeLayers;
            this.isIncludeDeclarations = isIncludeDeclarations;
            this.isOnlyCompiled = isOnlyCompiled;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("isWholeWordSearch", this.isWholeWordSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            settings.put("searchFor", this.searchFor);
            settings.put("limitTo", this.limitTo);
            settings.put("isIncludeLayers", this.isIncludeLayers);
            settings.put("isIncludeDeclarations", this.isIncludeDeclarations);
            settings.put("isOnlyCompiled", this.isOnlyCompiled);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IEPluginConfig pluginConfig, IDialogSettings settings) {
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            try {
                int scope = settings.getInt("scope");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean isWholeWordSearch = settings.getBoolean("isWholeWordSearch");
                int searchFor = settings.getInt("searchFor");
                int limitTo = settings.getInt("limitTo");
                boolean isIncludeLayers = settings.getBoolean("isIncludeLayers");
                boolean isIncludeDeclarations = settings.getBoolean("isIncludeDeclarations");
                boolean isOnlyCompiled = settings.getBoolean("isOnlyCompiled");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, isWholeWordSearch, searchFor, limitTo, isIncludeLayers, isIncludeDeclarations, isOnlyCompiled, AbstractTextSearchPage.getExtensions(pluginConfig), scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

