/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import antlr.collections.AST;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.ui.editor.actions.ShowEmitersWalker;
import ro.amiq.edt.base.ui.search.text.EmittersSearchResult;
import ro.amiq.edt.base.ui.search.text.FileMatch;

public class EmittersSearchQuery
extends BaseSearchQuery
implements IBuildDoneListener {
    private RfNamedElement fRfElement;
    private IProject fProject;
    private RfElementPath fRfElementPath;
    private boolean fProjectRebuilt;
    private RfProject fRfProject;
    private AbstractTextSearchResult fSearchResult;
    private IEPluginConfig fPluginConfig;

    public EmittersSearchQuery(IEPluginConfig pluginConfig, RfNamedElement event) {
        this.fRfElement = event;
        this.fRfElementPath = RfElementPath.path((IRfNamedElement)event);
        this.fRfProject = event.getRfProject();
        this.fProject = this.fRfProject.getProject();
        this.fSearchResult = new EmittersSearchResult((ISearchQuery)this);
        this.fPluginConfig = pluginConfig;
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    public IStatus run(IProgressMonitor monitor) {
        HashSet fCachedMatches;
        block12: {
            final ParserPath[] fCurrentParserPath = new ParserPath[1];
            final HashSet allMatches = new HashSet();
            fCachedMatches = new HashSet();
            IReportHitsListener<SearchHit> listener = new IReportHitsListener<SearchHit>(){

                public void addMatch(SearchHit match) {
                    IFile file;
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    ParserPath parserPath = match.getParserPath();
                    if (!parserPath.equals((Object)fCurrentParserPath[0])) {
                        fCurrentParserPath[0] = parserPath;
                        RfReferencesUtils.flushMatches((Set)fCachedMatches, (AbstractTextSearchResult)EmittersSearchQuery.this.fSearchResult);
                    }
                    if ((file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path)) == null) {
                        return;
                    }
                    LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setWriteAccess(match.getAccess());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setElaborationHit(match.isElaborationHit());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, false, element);
                    fCachedMatches.add(fileMatch);
                }

                public Set<SearchHit> getMatches() {
                    return null;
                }
            };
            DocumentManager documentManager = new DocumentManager();
            try {
                try {
                    Set<ParserPath> files = this.fRfProject.getCompiledFilesSet();
                    documentManager.activate();
                    for (ParserPath parserPath : files) {
                        AST moduleAST;
                        EModuleInfo moduleInfo;
                        boolean hasHits;
                        RfModule module = this.fRfProject.getModule(parserPath);
                        if (module == null || !(hasHits = IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), (IFile)module.getFileAdapter(), new String[]{this.fRfElement.getName()}, null, false)) || (moduleInfo = this.fRfProject.getModuleInfo(module.getModuleReference())) == null || (moduleAST = moduleInfo.getModuleAST()) == null) continue;
                        ShowEmitersWalker emittersWalker = new ShowEmitersWalker(this.fRfElement);
                        emittersWalker.program(moduleAST);
                        Set<AST> emitActions = emittersWalker.getEmitActions();
                        IDocument document = documentManager.getDocument(parserPath, this.fProject);
                        for (AST emitActionAST : emitActions) {
                            int offset = emitActionAST.getOffset();
                            int line = emitActionAST.getLine();
                            int length = emitActionAST.getText().length();
                            try {
                                IRegion lineOffsetRegion = document.getLineInformationOfOffset(offset);
                                String lineContents = document.get(lineOffsetRegion.getOffset(), lineOffsetRegion.getLength());
                                SearchHit searchHit = new SearchHit(parserPath, line, offset, lineContents, length, this.fProject);
                                searchHit.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)line, (int)offset, (boolean)false));
                                int counter = RfReferencesUtils.countStartWS((String)lineContents);
                                if (counter >= 0) {
                                    RfNamedElement result = SemanticUtils.getTransientResult(RfNamedElement.class, emitActionAST);
                                    if (result instanceof RfMacro) {
                                        String macroText = document.get(offset, length);
                                        searchHit.setSearchedElement(macroText, offset - lineOffsetRegion.getOffset() - counter, false);
                                    } else {
                                        searchHit.setSearchedElement(this.fRfElement.getName(), offset - lineOffsetRegion.getOffset() - counter, false);
                                    }
                                }
                                listener.addMatch((Object)searchHit);
                            }
                            catch (BadLocationException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    documentManager.deactivate();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                documentManager.deactivate();
                throw throwable;
            }
            documentManager.deactivate();
        }
        RfReferencesUtils.flushMatches(fCachedMatches, (AbstractTextSearchResult)this.fSearchResult);
        return Status.OK_STATUS;
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt) {
            return this.fRfElement;
        }
        IRfNamedElement element = this.fRfElementPath.toNamedElement(this.fProject);
        this.fRfElement = element instanceof RfPredefinedEvent ? (RfPredefinedEvent)element : (RfEvent)element;
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    public String getLabel() {
        String fieldNameForLabel = this.fRfElement.getFullNameLabel();
        if (fieldNameForLabel == null && this.fRfElementPath != null) {
            fieldNameForLabel = this.fRfElementPath.getElementName();
        }
        if (fieldNameForLabel == null) {
            fieldNameForLabel = "";
        }
        return "[".concat(this.fProject.getName()).concat("]").concat(" Emitters of event '").concat(fieldNameForLabel).concat("'");
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fSearchResult;
    }
}

