/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.search.NewTextSearchEngine;
import ro.amiq.edt.base.ui.search.RfSearchQueryElement;
import ro.amiq.edt.base.ui.search.text.FileSearchQuery;
import ro.amiq.edt.base.ui.search.text.TextSearchResultCollector;

public class ReferenceSearchQuery
extends FileSearchQuery
implements IBuildDoneListener {
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private RfElementPath fRfElementPath;
    private boolean fProjectRebuilt;

    public ReferenceSearchQuery(IEPluginConfig pluginConfig, IProject project, String searchType, IRfNamedElement element, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, int searchFor) {
        super(pluginConfig, searchType, element.getName(), searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, includeDeclarations, true, searchFor);
        this.fRfElement = this.getElement(element);
        this.fRfElementPath = RfElementPath.path((IRfNamedElement)element);
        this.fProject = project;
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        try {
            if (this.getRfElement() == null) {
                return Status.OK_STATUS;
            }
            AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
            textResult.removeAll();
            Pattern searchPattern = this.getSearchPattern();
            boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
            boolean searchInBinaries = !this.isScopeAllFileTypes();
            TextSearchResultCollector collector = new TextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
            return new NewTextSearchEngine(this.fPluginConfig, this.fLimitTo, this.fSearchFor, this.fIncludeDeclarations, this.fOnlyCompiled, this).search(this.fPluginConfig, this.getRfElement(), (TextSearchScope)this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Status.CANCEL_STATUS;
        }
    }

    public String getResultLabel(int nMatches) {
        if (this.fProject == null) {
            return super.getResultLabel(nMatches);
        }
        String searchString = this.getSearchLabel();
        String searchType = this.getSearchType();
        String projectName = this.fProject.getName();
        if (searchString.isEmpty()) {
            return super.getResultLabel(nMatches);
        }
        String description = DVTStringUtil.removeTicks((String)this.fScope.getDescription());
        if (nMatches == 1) {
            Object[] args = new Object[]{searchType, searchString, description, projectName};
            return MessageFormat.format(SearchMessages.ReferenceSearchQuery_singularLabel, args);
        }
        Object[] args = new Object[]{searchType, searchString, nMatches, description, projectName};
        return MessageFormat.format(SearchMessages.ReferenceSearchQuery_pluralPattern, args);
    }

    private IRfNamedElement getElement(IRfNamedElement element) {
        RfField field;
        if (!(element instanceof RfMethod)) {
            return element;
        }
        RfMethod method = (RfMethod)element;
        RfStruct struct = method.getParentStruct();
        if (struct != null && RfUtils.isMethodPortField(field = struct.getField(method.getName()))) {
            return field;
        }
        return element;
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt || this.fRfElement instanceof RfSearchQueryElement || this.fRfElement != null && this.fRfElement.isPredefined()) {
            return this.fRfElement;
        }
        IRfNamedElement element = this.fRfElementPath.toNamedElement(this.fProject);
        this.fRfElement = this.getElement(element);
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }
}

