/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfArg;
import ro.amiq.edt.base.model.reflection.RfCoverItem;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfListType;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMacroLayer;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPseudoListField;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.predefined.RfPseudoMethod;
import ro.amiq.edt.base.model.reflection.semantic.RfSubtypeElement;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.edt.base.ui.search.RfSearchQueryElement;

public class ReferenceSearchVisitor {
    public static final Pattern WHILDCARD_PATTERN = Pattern.compile("(?<!\\\\)[*?]");
    public static final int BUFFER_SIZE = 524288;
    private final TextSearchRequestor fCollector;
    private Matcher fMatcher;
    private Map<IFile, IDocument> fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private final MultiStatus fStatus;
    private final ReusableMatchAccess fMatchAccess;
    private boolean fRemoveComments;
    private IRfNamedElement fRfElement;
    private boolean fIncludeDeclarations;
    private int fPossibleMatchesCount = 0;
    private int fPatternFormatIndex;
    private String fSearchPackage;
    private String fSearchStruct;
    private String fSearchElement;
    private boolean fRegexp;
    private String fSearchString;
    private String fSearchType;
    private boolean fIsWildcardSearch;
    private IEPluginConfig fPluginConfig;

    public ReferenceSearchVisitor(IEPluginConfig pluginConfig, IRfNamedElement element, TextSearchRequestor collector, Pattern searchPattern, String searchType, boolean removeComments, boolean includeDeclarations, boolean regexp, String searchString) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher("");
        this.fRemoveComments = removeComments;
        this.fRegexp = regexp;
        this.fSearchString = searchString;
        this.fSearchType = searchType;
        this.fMatchAccess = new ReusableMatchAccess();
        this.fRfElement = element;
        this.fIncludeDeclarations = includeDeclarations;
        this.fPluginConfig = pluginConfig;
        this.fIsWildcardSearch = WHILDCARD_PATTERN.matcher(searchString).find();
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = ReferenceSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, ReferenceSearchVisitor.this.fNumberOfScannedFiles, ReferenceSearchVisitor.this.fNumberOfFilesToScan};
                        ReferenceSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = ReferenceSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        ReferenceSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        String[] matchPatterns = new String[]{"(.+)::(.+)\\\\\\.(.+)", "(.+)::(.+)", "(.+)\\\\\\.(.+)"};
        Matcher patternMatcher = null;
        this.fPatternFormatIndex = 0;
        while (this.fPatternFormatIndex < matchPatterns.length) {
            patternMatcher = Pattern.compile(matchPatterns[this.fPatternFormatIndex]).matcher(this.fMatcher.pattern().pattern());
            if (patternMatcher.matches()) break;
            ++this.fPatternFormatIndex;
        }
        this.fSearchPackage = null;
        this.fSearchStruct = null;
        this.fSearchElement = null;
        if (this.fPatternFormatIndex != 3) {
            if (patternMatcher != null && this.fPatternFormatIndex == 2) {
                this.fSearchStruct = patternMatcher.group(1);
                this.fSearchElement = patternMatcher.group(2);
                this.fMatcher = Pattern.compile(this.fSearchElement).matcher("");
            } else if (patternMatcher != null && this.fPatternFormatIndex == 1) {
                this.fSearchPackage = patternMatcher.group(1);
                this.fSearchStruct = patternMatcher.group(2);
                this.fMatcher = Pattern.compile(this.fSearchStruct).matcher("");
            } else if (patternMatcher != null && this.fPatternFormatIndex == 0) {
                this.fSearchPackage = patternMatcher.group(1);
                this.fSearchStruct = patternMatcher.group(2);
                this.fSearchElement = patternMatcher.group(3);
                this.fMatcher = Pattern.compile(this.fSearchElement).matcher("");
            }
        }
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, this.fSearchType.toLowerCase(), this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            if (!DVTStartupConstants.isLSRunning.get()) {
                monitorUpdateJob.schedule();
            }
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferDocuments();
        String[] searchStrings = new String[]{this.fSearchString};
        if (this.fRfElement instanceof RfEvent) {
            searchStrings = new String[]{this.fSearchString, "on_" + this.fSearchString};
            this.fMatcher = Pattern.compile("\\b(on_)?" + this.fSearchString + "\\b").matcher("");
        }
        if (this.fRfElement instanceof RfMethod && ((RfMethod)this.fRfElement).isByEvent()) {
            String eventName = this.fSearchString.substring("on_".length());
            searchStrings = new String[]{this.fSearchString, eventName};
            this.fMatcher = Pattern.compile("\\b(on_)?" + eventName + "\\b").matcher("");
        }
        int i = 0;
        while (i < files.length) {
            block6: {
                boolean res;
                block7: {
                    RfModule module;
                    RfProject rfProject;
                    IProject project;
                    this.fCurrentFile = files[i];
                    if (this.fCurrentFile == null || this.fCurrentFile.getLocation() == null || (project = this.fCurrentFile.getProject()) == null || (rfProject = this.fPluginConfig.getRfManager().getRfProject(project)) == null || (module = rfProject.getModule((IResource)this.fCurrentFile)) == null) break block6;
                    if (this.fIsWildcardSearch) break block7;
                    boolean hasHist = false;
                    hasHist = this.fSearchElement != null ? IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), this.fCurrentFile, new String[]{this.fSearchElement}, this.fMatcher, this.fRegexp) : (this.fSearchStruct != null ? IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), this.fCurrentFile, new String[]{this.fSearchStruct}, this.fMatcher, this.fRegexp) : (this.fSearchPackage != null ? IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), this.fCurrentFile, new String[]{this.fSearchPackage}, this.fMatcher, this.fRegexp) : IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), this.fCurrentFile, searchStrings, this.fMatcher, this.fRegexp)));
                    if (!hasHist) break block6;
                }
                if (!(res = this.processFile(this.fCurrentFile))) break;
            }
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    /*
     * Exception decompiling
     */
    private boolean processFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = 524288;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private void locateMatches(IFile file, DocumentCharSequence searchInput) throws CoreException {
        try {
            int k = 0;
            this.fMatcher.reset((CharSequence)searchInput);
            while (this.fMatcher.find()) {
                boolean potentialMatch;
                int start = this.fMatcher.start();
                int end = this.fMatcher.end();
                IDocument openDocument = this.getOpenDocument(file);
                if (openDocument == null) continue;
                int line = openDocument.getLineOfOffset(start);
                IRegion startLineInfo = openDocument.getLineInformation(line);
                int lineOffset = openDocument.getLineOffset(line);
                if (this.fRfElement instanceof RfEvent && this.fMatcher.group().equals("on_" + this.fRfElement.getName())) {
                    start += 3;
                }
                this.fMatchAccess.initialize(file, start, end - start, (CharSequence)searchInput, false);
                IProject project = this.fCurrentFile.getProject();
                RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(project);
                RfMixedLangManager.getInstance().installPartitionerForFile(file, searchInput.getDocument());
                boolean validContentType = RfMixedLangManager.getInstance().validContentType(file.getProject(), searchInput.getDocument(), end - 1);
                if (!validContentType) continue;
                RfWNamedElementAndScope elementAndScope = RfUtils.getRfElementForSearch(rfProject, file, searchInput.getDocument(), end, this.fRfElement);
                RfNamedElement element = elementAndScope == null ? null : elementAndScope.getNamedElement();
                RfNamedElement origElement = elementAndScope == null ? null : elementAndScope.getOriginalElement();
                boolean bl = potentialMatch = element == null;
                if (potentialMatch) {
                    this.fMatchAccess.setPossibleMatch(true);
                    ++this.fPossibleMatchesCount;
                    int counter = this.countStartWS(openDocument, startLineInfo);
                    if (counter >= 0) {
                        this.fMatchAccess.setSearchedElement(this.fRfElement.getName(), start - lineOffset - counter);
                    }
                    if (this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) continue;
                    return;
                }
                if (elementAndScope == null || element == null) continue;
                IRfScope scope = elementAndScope.getScope();
                if (this.fRfElement instanceof RfSearchQueryElement && (element instanceof RfMethod && ((RfSearchQueryElement)this.fRfElement).isMethod() || element instanceof RfField && ((RfSearchQueryElement)this.fRfElement).isField() || (element instanceof RfEvent || element instanceof RfMethod && ((RfMethod)element).isByEvent()) && (((RfSearchQueryElement)this.fRfElement).isEvent() || ((RfSearchQueryElement)this.fRfElement).isMethod() && this.fRfElement.getName().startsWith("on_")) || element instanceof RfType && ((RfSearchQueryElement)this.fRfElement).isType() || element instanceof RfMacro && ((RfSearchQueryElement)this.fRfElement).isMacro())) {
                    int counter;
                    if (this.fPatternFormatIndex != 3) {
                        if (element instanceof RfStructMember) {
                            if (this.fSearchStruct != null) {
                                if (scope == null) continue;
                                IRfScope structScope = scope;
                                while (structScope != null && !(structScope instanceof RfStruct)) {
                                    structScope = structScope.getEnclosingScope();
                                }
                                RfStruct memberParent = (RfStruct)structScope;
                                if (memberParent == null) continue;
                                RfStruct firstParent = (RfStruct)rfProject.getType("main", false, 1, this.fSearchStruct, -1);
                                if (firstParent == null) {
                                    firstParent = ((RfStructMember)element).getParentStruct();
                                }
                                ArrayList<RfStruct> parentFamily = new ArrayList<RfStruct>();
                                parentFamily.add(firstParent);
                                this.getRecursiveStructChildren(parentFamily, firstParent);
                                boolean hasMatch = false;
                                for (RfStruct child : parentFamily) {
                                    if (!memberParent.getName().equals(child.getName())) continue;
                                    hasMatch = true;
                                    break;
                                }
                                if (!hasMatch) continue;
                            }
                            if (this.fSearchPackage != null && !Pattern.matches(this.fSearchPackage, ((RfStructMember)element).getPackageName())) {
                                continue;
                            }
                        } else if (element instanceof RfType && this.fSearchPackage != null && !Pattern.matches(this.fSearchPackage, ((RfType)element).getPackageName())) continue;
                    }
                    if (!this.fIncludeDeclarations) {
                        currentMatchFileParserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                        if (currentMatchFileParserPath == null) continue;
                        int currentMatchStartLine = line + 1;
                        boolean isDeclaration = this.isDeclarationLayer(element.getLayers(), currentMatchFileParserPath, currentMatchStartLine);
                        if (element instanceof RfMethod && ((RfMethod)element).isByEvent() && ((RfSearchQueryElement)this.fRfElement).isEvent()) {
                            isDeclaration = false;
                        }
                        if (isDeclaration) continue;
                    }
                    if ((counter = this.countStartWS(openDocument, startLineInfo)) >= 0) {
                        this.fMatchAccess.setSearchedElement(this.fRfElement.getName(), start - lineOffset - counter);
                    }
                    if (!this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) {
                        return;
                    }
                } else if (element.checkEquals(this.fRfElement) && origElement != null) {
                    currentMatchFileParserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
                    if (currentMatchFileParserPath == null) continue;
                    int currentMatchStartLine = line + 1;
                    boolean isFoundElemDecl = this.isDeclarationLayer(origElement.getLayers(), currentMatchFileParserPath, currentMatchStartLine);
                    if ((element instanceof RfVar || element instanceof RfField) && this.fRfElement instanceof RfType && !isFoundElemDecl) continue;
                    if (!this.fIncludeDeclarations) {
                        boolean isDeclaration = false;
                        if (element instanceof RfSubtypeElement) {
                            element = ((RfSubtypeElement)element).getNamedElement();
                        }
                        if (element instanceof RfPseudoListField) {
                            element = ((RfPseudoListField)element).getParentField();
                        }
                        if (!(element instanceof RfFieldTypeConstraint) && this.fRfElement.getClass().equals(element.getClass()) || element instanceof RfField && !(element instanceof RfFieldTypeConstraint) && this.fRfElement instanceof RfFieldTypeConstraint || element instanceof RfField && !(element instanceof RfPseudoListField) && this.fRfElement instanceof RfPseudoListField || this.fRfElement instanceof RfPseudoMethod && ((RfMethod)this.fRfElement).getParentStruct() instanceof RfListType && element instanceof RfField) {
                            isDeclaration = isFoundElemDecl;
                        }
                        if (this.fRfElement instanceof RfMethod && element instanceof RfEvent && isFoundElemDecl) {
                            isDeclaration = true;
                        } else if (this.fRfElement instanceof RfMethod && element instanceof RfMethod && ((RfMethod)this.fRfElement).isByEvent()) {
                            isDeclaration = false;
                        }
                        if (isDeclaration) continue;
                    }
                    if (element instanceof RfCoverItem) {
                        this.fMatchAccess.setImplicit(false);
                    } else if (element instanceof RfVar && ((RfVar)element).hasTypeFromName()) {
                        this.fMatchAccess.setImplicit(isFoundElemDecl);
                    } else if (element instanceof RfField && ((RfField)element).hasTypeFromName()) {
                        this.fMatchAccess.setImplicit(isFoundElemDecl);
                    }
                    if (this.fRfElement instanceof RfArg) {
                        this.fMatchAccess.setRfElementKind(11);
                    } else if (this.fRfElement instanceof RfVar) {
                        this.fMatchAccess.setRfElementKind(10);
                    } else if (this.fRfElement instanceof RfField) {
                        this.fMatchAccess.setRfElementKind(2);
                    }
                    int counter = this.countStartWS(openDocument, startLineInfo);
                    String matchString = this.fRfElement.getName();
                    if (this.fRfElement instanceof RfMethod && ((RfMethod)this.fRfElement).isByEvent() && (this.fMatcher.group().equals(this.fRfElement.getName().substring("on_".length())) || element instanceof RfEvent)) {
                        matchString = this.fRfElement.getName().substring("on_".length());
                    }
                    if (counter >= 0) {
                        this.fMatchAccess.setSearchedElement(matchString, start - lineOffset - counter);
                    }
                    if (!this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) {
                        return;
                    }
                }
                try {
                    if (k++ != 20) continue;
                    if (this.fProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                    }
                    k = 0;
                }
                catch (CoreException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, "", false);
        }
    }

    private int countStartWS(IDocument openDocument, IRegion startLineInfo) throws BadLocationException {
        try {
            String lineText = openDocument.get(startLineInfo.getOffset(), startLineInfo.getLength());
            int counter = 0;
            while (Character.isWhitespace(lineText.charAt(counter))) {
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    private boolean isDeclarationLayer(List<RfDefElement> layers, ParserPath parserPath, int currentMatchStartLine) {
        if (layers == null) {
            return false;
        }
        for (RfDefElement layer : layers) {
            if (layer instanceof RfMacroLayer && ((RfMacroLayer)layer).isConditional() || layer instanceof RfOnEventLayer || layer instanceof RfCoverLayer || !layer.getLayerModule().getParserPath().equals((Object)parserPath) || layer.getStartLine() != currentMatchStartLine) continue;
            return true;
        }
        return false;
    }

    private void getRecursiveStructChildren(List<RfStruct> result, RfStruct struct) {
        List<RfStruct> children = struct.getChildStructs();
        if (children == null) {
            return;
        }
        result.addAll(children);
        for (RfStruct childStruct : children) {
            if (childStruct instanceof RfListType) continue;
            this.getRecursiveStructChildren(result, childStruct);
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    public int getPossibleMachesCount() {
        return this.fPossibleMatchesCount;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    public static interface IImplicitDecl {
        public boolean isImplicit();

        public void setImplicit(boolean var1);

        public int getRfElementKind();

        public void setRfElementKind(int var1);
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess
    implements IImplicitDecl {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;
        private boolean fPossibleMatch;
        private boolean fImplicitDecl;
        private int fRfElementKind = -1;
        private String fSearchedElement;
        private int fSearchedElementOffset;

        public void initialize(IFile file, int offset, int length, CharSequence content, boolean value) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
            this.fPossibleMatch = value;
            this.fImplicitDecl = false;
            this.fSearchedElement = null;
            this.fSearchedElementOffset = -1;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public boolean isPossibleMatch() {
            return this.fPossibleMatch;
        }

        public void setPossibleMatch(boolean possibleMatch) {
            this.fPossibleMatch = possibleMatch;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }

        @Override
        public boolean isImplicit() {
            return this.fImplicitDecl;
        }

        @Override
        public void setImplicit(boolean implicitDecl) {
            this.fImplicitDecl = implicitDecl;
        }

        @Override
        public int getRfElementKind() {
            return this.fRfElementKind;
        }

        @Override
        public void setRfElementKind(int elementKind) {
            this.fRfElementKind = elementKind;
        }

        public void setSearchedElement(String searchedElement, int offset) {
            this.fSearchedElement = searchedElement;
            this.fSearchedElementOffset = offset;
        }

        public String getSearchedElement() {
            return this.fSearchedElement;
        }

        public int getSearchedElementOffset() {
            return this.fSearchedElementOffset;
        }
    }
}

