/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import ro.amiq.dvt.ui.search.BaseSearchQueryProvider;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.search.SearchManager;
import ro.amiq.dvt.ui.search.TextSearchPageInput;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.ui.search.DeclarationsSearchQuery;
import ro.amiq.edt.base.ui.search.ReadersSearchQuery;
import ro.amiq.edt.base.ui.search.ReferenceSearchPageInput;
import ro.amiq.edt.base.ui.search.ReferenceSearchQuery;
import ro.amiq.edt.base.ui.search.WritersSearchQuery;
import ro.amiq.edt.base.ui.search.text.FileSearchQuery;

public class SearchQueryProvider
extends BaseSearchQueryProvider {
    private int fLimitTo;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private boolean fOnlyCompiled;
    private IEPluginConfig fPluginConfig;
    private RWSearchTypeEnum fSearchRWType;

    public SearchQueryProvider(IEPluginConfig pluginConfig, int limitTo, int searchFor, boolean includeDeclarations, boolean isOnlyCompiled, RWSearchTypeEnum searchRWType) {
        this.fLimitTo = limitTo;
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fOnlyCompiled = isOnlyCompiled;
        this.fPluginConfig = pluginConfig;
        this.fSearchRWType = searchRWType;
        SearchManager.getInstance().getPositionTracker();
    }

    public ISearchQuery createQuery(TextSearchQueryProvider.TextSearchInput input) {
        String text;
        String searchLabel;
        boolean wholeWord;
        FileTextSearchScope scope = input.getScope();
        boolean regEx = input.isRegExSearch();
        boolean caseSensitive = input.isCaseSensitiveSearch();
        boolean bl = wholeWord = regEx ? false : ((TextSearchPageInput)input).isWholeWordSearch();
        if (input instanceof ReferenceSearchPageInput) {
            RfNamedElement element = ((ReferenceSearchPageInput)input).getRfElement();
            searchLabel = element.getFullNameLabel();
            if (this.fSearchRWType == RWSearchTypeEnum.USAGES) {
                return new ReferenceSearchQuery(this.fPluginConfig, this.getProject(element, input), this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fSearchFor);
            }
            if (this.fSearchRWType == RWSearchTypeEnum.READERS) {
                return new ReadersSearchQuery(this.fPluginConfig, this.getProject(element, input), this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fSearchFor);
            }
            if (this.fSearchRWType == RWSearchTypeEnum.WRITERS) {
                return new WritersSearchQuery(this.fPluginConfig, this.getProject(element, input), this.getSearchType(element), element, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fSearchFor);
            }
        }
        searchLabel = text = input.getSearchText();
        if (this.fSearchFor == 1) {
            searchLabel = String.valueOf(searchLabel) + "()";
        }
        if (this.fLimitTo == 0 || this.fLimitTo == 3 && this.fSearchFor == 4) {
            return new DeclarationsSearchQuery(this.fPluginConfig, this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
        }
        return new FileSearchQuery(this.fPluginConfig, this.getSearchType(), text, searchLabel, regEx, caseSensitive, wholeWord, scope, this.fLimitTo, this.fIncludeDeclarations, this.fOnlyCompiled, this.fSearchFor);
    }

    protected String getSearchType() {
        switch (this.fSearchFor) {
            case 0: {
                return "Type";
            }
            case 13: {
                return "Package";
            }
            case 12: {
                return "Enum";
            }
            case 3: {
                return "Event";
            }
            case 4: {
                return "Coverage";
            }
            case 5: {
                return "Macro";
            }
            case 2: {
                return "Field";
            }
            case 11: {
                return "Argument";
            }
            case 10: {
                return "Variable";
            }
            case 1: {
                return "Method";
            }
            case 6: {
                return "Message";
            }
            case 7: {
                return "Dut error message";
            }
            case 8: {
                return "Error message";
            }
        }
        return "Text";
    }
}

