/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class SearchResultUpdater
implements IResourceChangeListener,
IQueryListener {
    private AbstractTextSearchResult fResult;

    public SearchResultUpdater(AbstractTextSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.handleDelta(delta);
        }
    }

    private void handleDelta(IResourceDelta d) {
        try {
            d.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    switch (delta.getKind()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            IResource res = delta.getResource();
                            if (!(res instanceof IFile)) break;
                            Match[] matches = SearchResultUpdater.this.fResult.getMatches((Object)res);
                            SearchResultUpdater.this.fResult.removeMatches(matches);
                            break;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DVTExceptionHandler.log((Throwable)e);
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (this.fResult.equals(query.getSearchResult())) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

