/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.search.AbstractSearchVisitor;

public class TextSearchVisitor
extends AbstractSearchVisitor {
    public static final int BUFFER_SIZE = 524288;
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private int fSearchFor = -1;
    private final MultiStatus fStatus;
    private final ReusableMatchAccess fMatchAccess;
    private boolean fRemoveComments;
    private boolean fOnlyCompiled;
    private IEPluginConfig fPluginConfig;

    public TextSearchVisitor(IEPluginConfig pluginConfig, TextSearchRequestor collector, Pattern searchPattern, int searchFor, boolean removeComments, boolean onlyCompiled) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher("");
        this.fRemoveComments = removeComments;
        this.fSearchFor = searchFor;
        this.fMatchAccess = new ReusableMatchAccess();
        this.fPluginConfig = pluginConfig;
        this.fOnlyCompiled = onlyCompiled;
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = TextSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, TextSearchVisitor.this.fNumberOfScannedFiles, TextSearchVisitor.this.fNumberOfFilesToScan};
                        TextSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = TextSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_textsearch_task_label, this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processFiles(IFile[] files) {
        this.evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            boolean res;
            RfModule module;
            RfProject rfProject;
            IProject project;
            this.fCurrentFile = files[i];
            if (this.fCurrentFile != null && this.fCurrentFile.getLocation() != null && (project = this.fCurrentFile.getProject()) != null && (!this.fOnlyCompiled || (rfProject = this.fPluginConfig.getRfManager().getRfProject(project)) != null && (module = rfProject.getModule((IResource)this.fCurrentFile)) != null) && !(res = this.processFile(this.fCurrentFile))) break;
            ++i;
        }
        this.resetNonFileBufferDocuments();
    }

    /*
     * Exception decompiling
     */
    private boolean processFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        if (!DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)file, this.fProgressMonitor)) {
            return true;
        }
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = 524288;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    private void locateMatches(IFile file, DocumentCharSequence searchInput) throws CoreException {
        try {
            if (!DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)file, this.fProgressMonitor)) {
                return;
            }
            if (this.fSearchFor == 6 || this.fSearchFor == 7 || this.fSearchFor == 8) {
                String pattern = null;
                switch (this.fSearchFor) {
                    case 6: {
                        pattern = "message";
                        break;
                    }
                    case 7: {
                        pattern = "dut_error";
                        break;
                    }
                    case 8: {
                        pattern = "error";
                    }
                }
                if (pattern == null) {
                    return;
                }
                String content = searchInput.getDocument().get();
                MessageFinder messageMatcher = new MessageFinder(content, pattern);
                while (messageMatcher.find()) {
                    this.fMatcher.reset(searchInput.subSequence(messageMatcher.start(), messageMatcher.end()));
                    int k = 0;
                    while (this.fMatcher.find()) {
                        int start = this.fMatcher.start() + messageMatcher.start();
                        int end = this.fMatcher.end() + messageMatcher.start();
                        RfMixedLangManager.getInstance().installPartitionerForFile(file, searchInput.getDocument());
                        if (end != start && searchInput.notInComment(start) && searchInput.isInString(start)) {
                            this.fMatchAccess.initialize(file, start, end - start, (CharSequence)searchInput);
                            boolean res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                            if (!res) {
                                return;
                            }
                        }
                        if (k++ != 20) continue;
                        if (this.fProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                        }
                        k = 0;
                    }
                }
            } else {
                this.fMatcher.reset((CharSequence)searchInput);
                int k = 0;
                while (this.fMatcher.find()) {
                    int start = this.fMatcher.start();
                    int end = this.fMatcher.end();
                    if (end != start && searchInput.notInComment(start)) {
                        this.fMatchAccess.initialize(file, start, end - start, (CharSequence)searchInput);
                        boolean res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                        if (!res) {
                            return;
                        }
                    }
                    if (k++ != 20) continue;
                    if (this.fProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                    }
                    k = 0;
                }
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, "");
        }
    }

    public static class MessageFinder {
        private String input;
        private int end;
        private int start;
        private String pattern;
        private static final int INIT = 0;
        private static final int STRING = 1;
        private static final int FINISH = 2;

        public MessageFinder(String input, String pattern) {
            this.input = input;
            this.end = 0;
            this.start = 0;
            this.pattern = pattern;
        }

        public boolean find() {
            if (this.input == null) {
                return false;
            }
            int length = this.input.length();
            while ((this.start = this.input.indexOf(this.pattern, this.end)) >= 0) {
                this.end = this.start + this.pattern.length();
                if (this.start != 0 && Character.isJavaIdentifierPart(this.input.charAt(this.start - 1)) || this.end >= length || Character.isJavaIdentifierPart(this.input.charAt(this.end))) continue;
                char ch = ' ';
                while (this.end < length) {
                    ch = this.input.charAt(this.end);
                    if (!Character.isWhitespace(ch)) break;
                    ++this.end;
                }
                if (ch != 40) continue;
                this.end = this.endOfMessage(length, this.end);
                return true;
            }
            return false;
        }

        private int endOfMessage(int length, int offset) {
            int nested = 0;
            int state = 0;
            int pch = 32;
            int i = offset;
            while (i < length) {
                char ch = this.input.charAt(i);
                switch (state) {
                    case 0: {
                        if (pch != 92 && ch == '\"') {
                            state = 1;
                        } else if (ch == '(' || ch == '{' || ch == '[') {
                            ++nested;
                        } else if (ch == ')' || ch == '}' || ch == ']') {
                            --nested;
                        }
                        if (nested != 0) break;
                        return i + 1;
                    }
                    case 1: {
                        if (pch == 92 || ch != '\"') break;
                        state = 2;
                        break;
                    }
                    default: {
                        if (pch != 92 && ch == '\"') {
                            state = 1;
                        } else if (ch == '(' || ch == '{' || ch == '[') {
                            ++nested;
                        } else if (ch == ')' || ch == '}' || ch == ']') {
                            --nested;
                        }
                        if (nested != 0) break;
                        return i + 1;
                    }
                }
                pch = ch;
                ++i;
            }
            return offset;
        }

        public int end() {
            return this.end;
        }

        public int start() {
            return this.start;
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

