/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.search.DocumentCharSequence;
import ro.amiq.dvt.ui.search.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.RfCoverLayer;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfOnEventLayer;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.ui.search.AbstractSearchVisitor;
import ro.amiq.edt.base.ui.search.TextSearchVisitor;

public class TypeSearchVisitor
extends AbstractSearchVisitor {
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedProjects;
    private int fNumberOfProjectsToScan;
    private IProject fCurrentProject;
    private int fCheckForQueryInterruptionCounter = 0;
    private final MultiStatus fStatus;
    private int fSearchFor;
    private boolean fIncludeDeclarations;
    private TextSearchVisitor.ReusableMatchAccess fMatchAccess;
    private boolean fSearchReferences;
    private IEPluginConfig fPluginConfig;
    private String fSearchType;

    public TypeSearchVisitor(IEPluginConfig pluginConfig, TextSearchRequestor collector, Pattern searchPattern, String searchType, int searchFor, boolean includeDeclarations, boolean searchReferences) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher("");
        this.fSearchFor = searchFor;
        this.fIncludeDeclarations = includeDeclarations;
        this.fMatchAccess = new TextSearchVisitor.ReusableMatchAccess();
        this.fPluginConfig = pluginConfig;
        this.fSearchType = searchType;
        this.fSearchReferences = searchReferences;
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedProjects = 0;
        HashMap<String, IProject> projectsList = new HashMap<String, IProject>();
        int i = 0;
        while (i < files.length) {
            IProject project = files[i].getProject();
            if (!projectsList.containsKey(project.getName())) {
                projectsList.put(project.getName(), project);
            }
            ++i;
        }
        this.fNumberOfProjectsToScan = projectsList.size();
        this.fCurrentProject = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedProjects;
            {
                this.fLastNumberOfScannedProjects = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IProject project = TypeSearchVisitor.this.fCurrentProject;
                    if (project != null) {
                        String projectName = project.getName();
                        Object[] args = new Object[]{projectName, TypeSearchVisitor.this.fNumberOfScannedProjects, TypeSearchVisitor.this.fNumberOfProjectsToScan};
                        TypeSearchVisitor.this.fProgressMonitor.subTask(MessageFormat.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = TypeSearchVisitor.this.fNumberOfScannedProjects - this.fLastNumberOfScannedProjects;
                        TypeSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedProjects += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            MultiStatus multiStatus;
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : MessageFormat.format(SearchMessages.TextSearchVisitor_hidssearch_task_label, this.fSearchType.toLowerCase(), this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfProjectsToScan);
            monitorUpdateJob.setSystem(true);
            if (!DVTStartupConstants.isLSRunning.get()) {
                monitorUpdateJob.schedule();
            }
            try {
                this.fCollector.beginReporting();
                this.processProjects(projectsList);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processProjects(HashMap<String, IProject> projectsList) {
        this.evalNonFileBufferDocuments();
        Collection<IProject> projects = projectsList.values();
        for (IProject this.fCurrentProject : projects) {
            boolean res = this.processProject(this.fCurrentProject);
            if (!res) break;
        }
        this.resetNonFileBufferDocuments();
    }

    private boolean processProject(IProject currentProject) {
        Object[] args;
        try {
            RfProject rfProject = this.fPluginConfig.getRfManager().getRfProject(currentProject);
            if (rfProject == null) {
                return true;
            }
            ArrayList<RfDefElement> defElements = new ArrayList<RfDefElement>();
            boolean includeLayers = this.fIncludeDeclarations && (this.fSearchFor == 0 || this.fSearchFor == 1 || this.fSearchFor == 2 || this.fSearchFor == 3 || this.fSearchFor == 5) || this.fSearchFor == 4;
            String[] matchPatterns = new String[]{"(.+)::(.+)\\\\\\.(.+)", "(.+)::(.+)", "(.+)\\\\\\.(.+)"};
            Matcher patternMatcher = null;
            int patternFormatIndex = 0;
            patternFormatIndex = 0;
            while (patternFormatIndex < matchPatterns.length) {
                patternMatcher = Pattern.compile(matchPatterns[patternFormatIndex]).matcher(this.fMatcher.pattern().pattern());
                if (patternMatcher.matches()) break;
                ++patternFormatIndex;
            }
            if (this.fSearchFor == 0) {
                String searchPackage = null;
                String searchType = null;
                if (patternMatcher != null && patternFormatIndex == 1) {
                    searchPackage = patternMatcher.group(1);
                    searchType = patternMatcher.group(2);
                } else {
                    searchType = this.fMatcher.pattern().pattern();
                }
                int flags = this.fMatcher.pattern().flags();
                Pattern packagePattern = searchPackage != null ? Pattern.compile(searchPackage, flags) : null;
                Pattern typePattern = searchType != null ? Pattern.compile(searchType, flags) : null;
                defElements.addAll(rfProject.getTypes(7, includeLayers, packagePattern, typePattern));
            } else if (this.fSearchFor == 5) {
                Pattern memberPattern = this.fMatcher.pattern();
                defElements.addAll(rfProject.getMacros(false, this.fSearchReferences, this.fIncludeDeclarations, memberPattern));
            } else {
                Pattern memberPattern;
                String searchPackage = null;
                String searchStruct = null;
                String searchMember = null;
                if (patternFormatIndex == 3) {
                    searchMember = this.fMatcher.pattern().pattern();
                } else if (patternMatcher != null && patternFormatIndex == 2) {
                    searchStruct = patternMatcher.group(1);
                    searchMember = patternMatcher.group(2);
                } else if (patternFormatIndex == 1) {
                    searchMember = this.fMatcher.pattern().pattern();
                } else if (patternMatcher != null && patternFormatIndex == 0) {
                    searchPackage = patternMatcher.group(1);
                    searchStruct = patternMatcher.group(2);
                    searchMember = patternMatcher.group(3);
                }
                int flags = this.fMatcher.pattern().flags();
                Pattern packagePattern = searchPackage != null ? Pattern.compile(searchPackage, flags) : null;
                Pattern structPattern = searchStruct != null ? Pattern.compile(searchStruct, flags) : null;
                Pattern pattern = memberPattern = searchMember != null ? Pattern.compile(searchMember, flags) : null;
                if (this.fSearchFor == 1) {
                    defElements.addAll(rfProject.getStructMembers(1, includeLayers, packagePattern, structPattern, memberPattern));
                } else if (this.fSearchFor == 2) {
                    defElements.addAll(rfProject.getStructMembers(4, includeLayers, packagePattern, structPattern, memberPattern));
                } else if (this.fSearchFor == 3 || this.fSearchFor == 4) {
                    defElements.addAll(rfProject.getStructMembers(2, includeLayers, packagePattern, structPattern, memberPattern));
                }
            }
            if (defElements.isEmpty()) {
                return true;
            }
            boolean bl = this.locateMatches(defElements);
            return bl;
        }
        catch (UnsupportedCharsetException e) {
            args = new Object[]{this.getCharSetName((IResource)currentProject), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_unsupportedcharset, args);
            this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
        }
        catch (IllegalCharsetNameException e) {
            args = new Object[]{this.getCharSetName((IResource)currentProject), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_illegalcharset, args);
            this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
        }
        catch (CoreException e) {
            args = new Object[]{this.getExceptionMessage((Exception)((Object)e)), currentProject.getFullPath().makeRelative().toOSString()};
            String message = MessageFormat.format(SearchMessages.TextSearchVisitor_error, args);
            this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
        }
        catch (StackOverflowError e) {
            String message = SearchMessages.TextSearchVisitor_patterntoocomplex0;
            this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            ++this.fNumberOfScannedProjects;
        }
        if (this.fProgressMonitor.isCanceled()) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
        return true;
    }

    private boolean locateMatches(ArrayList<RfDefElement> defElements) throws CoreException {
        try {
            for (RfDefElement elementLayer : defElements) {
                IFile layerFile;
                if (this.fCheckForQueryInterruptionCounter++ == 20) {
                    if (this.fProgressMonitor.isCanceled()) {
                        throw new OperationCanceledException("Operation Canceled");
                    }
                    this.fCheckForQueryInterruptionCounter = 0;
                }
                if (this.fSearchFor == 4 && !(elementLayer instanceof RfCoverLayer) || this.fSearchFor == 3 && (elementLayer instanceof RfOnEventLayer || elementLayer instanceof RfCoverLayer) || elementLayer == null || (layerFile = (IFile)elementLayer.getInternalAdapter(IResource.class)) == null || !DVTFileUtils.getInstance().ensureFileInSyncWithUserAccept((IResource)layerFile, this.fProgressMonitor) || layerFile.getFullPath() == null || !this.fCollector.acceptFile(layerFile)) continue;
                TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(layerFile);
                IPath path = textFileBufferInfo.getPath();
                LocationKind locationKind = textFileBufferInfo.getLocationKind();
                IDocument document = this.getOpenDocument(layerFile);
                if (document == null) {
                    ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                    ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                    boolean shouldDisconnect = false;
                    if (textFileBuffer == null) {
                        shouldDisconnect = true;
                        bufferManager.connect(path, locationKind, null);
                    }
                    textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                    document = textFileBuffer.getDocument();
                    if (shouldDisconnect) {
                        bufferManager.disconnect(path, locationKind, null);
                    }
                }
                if (document == null) continue;
                DocumentCharSequence documentCharSequence = new DocumentCharSequence(document, true);
                int offset = document.getLineOffset(elementLayer.getStartLine() - 1);
                int length = document.getLineLength(elementLayer.getStartLine() - 1);
                String lineContent = document.get(offset, length);
                int start = 0;
                int end = 0;
                if (this.fSearchFor == 5) {
                    start = 0;
                    end = lineContent.length();
                } else {
                    Matcher wordMatch = Pattern.compile("\\b" + elementLayer.getName() + "\\b").matcher(lineContent);
                    start = wordMatch.find() ? wordMatch.start() : lineContent.indexOf(elementLayer.getName());
                    end = start + elementLayer.getName().length();
                }
                if (start < 0) continue;
                this.fMatchAccess.initialize(layerFile, offset + start, end - start, (CharSequence)documentCharSequence);
                if (this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess)) continue;
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }
}

