/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search;

import antlr.collections.AST;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.reflection.IReportHitsListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.actions.ShowWritersWalker;
import ro.amiq.edt.base.ui.search.RfSearchQueryElement;
import ro.amiq.edt.base.ui.search.text.FileMatch;
import ro.amiq.edt.base.ui.search.text.FileSearchQuery;
import ro.amiq.edt.base.ui.search.text.WritersFileSearchResult;

public class WritersSearchQuery
extends FileSearchQuery
implements IBuildDoneListener {
    private IRfNamedElement fRfElement;
    private IProject fProject;
    private RfElementPath fRfElementPath;
    private boolean fProjectRebuilt;
    private WritersFileSearchResult fSearchResult;
    private RfProject rfProject;

    public WritersSearchQuery(IEPluginConfig pluginConfig, IProject project, String searchType, IRfNamedElement element, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, int searchFor) {
        super(pluginConfig, searchType, element.getName(), searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, includeDeclarations, true, searchFor);
        this.fRfElement = this.getElement(element);
        this.fRfElementPath = RfElementPath.path((IRfNamedElement)element);
        this.rfProject = (RfProject)this.fRfElement.getRfProject();
        this.fProject = project;
        this.fSearchResult = new WritersFileSearchResult((BaseTextSearchQuery)this);
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        HashSet fCachedMatches;
        block10: {
            final ParserPath[] fCurrentParserPath = new ParserPath[1];
            final HashSet allMatches = new HashSet();
            fCachedMatches = new HashSet();
            IReportHitsListener<SearchHit> listener = new IReportHitsListener<SearchHit>(){

                public void addMatch(SearchHit match) {
                    IFile file;
                    if (allMatches.contains(match)) {
                        return;
                    }
                    allMatches.add(match);
                    ParserPath parserPath = match.getParserPath();
                    if (!parserPath.equals((Object)fCurrentParserPath[0])) {
                        fCurrentParserPath[0] = parserPath;
                        RfReferencesUtils.flushMatches((Set)fCachedMatches, (AbstractTextSearchResult)WritersSearchQuery.this.fSearchResult);
                    }
                    if ((file = DVTFileUtils.getInstance().findProjectFile(match.getProject(), parserPath.path)) == null) {
                        return;
                    }
                    LineElement element = new LineElement((IResource)file, match.getLine(), match.getOffset(), match.getContents());
                    element.setExtraInfo(match.getExtraInfo());
                    element.setWriteAccess(match.getAccess());
                    element.setSearchedElement(match.getSearchedElement(), match.getSearchedElementOffset(), match.isPossibleMatch());
                    element.setElaborationHit(match.isElaborationHit());
                    int matchLength = match.getMatchLength();
                    FileMatch fileMatch = new FileMatch(file, match.getOffset(), matchLength, false, element);
                    fCachedMatches.add(fileMatch);
                }

                public Set<SearchHit> getMatches() {
                    return null;
                }
            };
            DocumentManager documentManager = new DocumentManager();
            try {
                try {
                    Set<ParserPath> files = this.rfProject.getCompiledFilesSet();
                    String[] searchStrings = new String[]{this.fRfElement.getName()};
                    documentManager.activate();
                    for (ParserPath parserPath : files) {
                        AST moduleAST;
                        EModuleInfo moduleInfo;
                        boolean hasHits;
                        RfModule module = this.rfProject.getModule(parserPath);
                        if (module == null || !(hasHits = IdentifierIndexerManager.getInstance().hasHits(this.fPluginConfig.getIndexerClass(), (IFile)module.getFileAdapter(), searchStrings, null, false)) || (moduleInfo = this.rfProject.getModuleInfo(module.getModuleReference())) == null || (moduleAST = moduleInfo.getModuleAST()) == null) continue;
                        ShowWritersWalker writersWalker = new ShowWritersWalker((RfNamedElement)this.fRfElement);
                        writersWalker.program(moduleAST);
                        Set<AST> writers = writersWalker.getResult();
                        if (writers == null) continue;
                        IDocument document = documentManager.getDocument(parserPath, this.fProject);
                        for (AST writerAST : writers) {
                            int offset = writerAST.getOffset();
                            int line = writerAST.getLine();
                            int length = writerAST.getText().length();
                            try {
                                RfNamedElement result;
                                IRegion lineOffsetRegion = document.getLineInformationOfOffset(offset);
                                String lineContents = document.get(lineOffsetRegion.getOffset(), lineOffsetRegion.getLength());
                                SearchHit searchHit = new SearchHit(parserPath, line, offset, lineContents, length, this.fProject);
                                searchHit.setExtraInfo(RfSearchUtils.getScopeInfo((IProject)this.fProject, (ParserPath)parserPath, (int)line, (int)offset, (boolean)false));
                                int counter = RfReferencesUtils.countStartWS((String)lineContents);
                                if (counter >= 0 && !((result = SemanticUtils.getTransientResult(RfNamedElement.class, writerAST)) instanceof RfMacro)) {
                                    searchHit.setSearchedElement(this.fRfElement.getName(), offset - lineOffsetRegion.getOffset() - counter, false);
                                }
                                listener.addMatch((Object)searchHit);
                            }
                            catch (BadLocationException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    documentManager.deactivate();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                documentManager.deactivate();
                throw throwable;
            }
            documentManager.deactivate();
        }
        RfReferencesUtils.flushMatches(fCachedMatches, (AbstractTextSearchResult)this.fSearchResult);
        return Status.OK_STATUS;
    }

    public String getResultLabel(int nMatches) {
        if (this.fProject == null) {
            return super.getResultLabel(nMatches);
        }
        String searchString = this.getSearchLabel();
        String projectName = this.fProject.getName();
        if (searchString.isEmpty()) {
            return super.getResultLabel(nMatches);
        }
        String searchTypeField = this.getSearchedElementKind().toLowerCase();
        if (nMatches == 1) {
            Object[] args = new Object[]{"Writers", searchTypeField, searchString, projectName};
            return MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_singularLabel, args);
        }
        Object[] args = new Object[]{"Writers", searchTypeField, searchString, nMatches, projectName};
        return MessageFormat.format(SearchMessages.ReferenceSearchQuery_readersWriters_pluralPattern, args);
    }

    private IRfNamedElement getElement(IRfNamedElement element) {
        RfField field;
        if (!(element instanceof RfMethod)) {
            return element;
        }
        RfMethod method = (RfMethod)element;
        RfStruct struct = method.getParentStruct();
        if (struct != null && RfUtils.isMethodPortField(field = struct.getField(method.getName()))) {
            return field;
        }
        return element;
    }

    public IRfNamedElement getRfElement() {
        if (!this.fProjectRebuilt || this.fRfElement instanceof RfSearchQueryElement || this.fRfElement != null && this.fRfElement.isPredefined()) {
            return this.fRfElement;
        }
        IRfNamedElement element = this.fRfElementPath.toNamedElement(this.fProject);
        this.fRfElement = this.getElement(element);
        this.fProjectRebuilt = false;
        return this.fRfElement;
    }

    public void buildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason)) {
            return;
        }
        if (this.fProject == null) {
            return;
        }
        if (projectName != null && projectName.equals(this.fProject.getName())) {
            this.fProjectRebuilt = true;
        }
    }

    @Override
    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery baseSearchQuery) {
        return new WritersFileSearchResult((BaseTextSearchQuery)this);
    }

    public ISearchResult getSearchResult() {
        return this.fSearchResult;
    }
}

