/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search.constraints;

import antlr.collections.AST;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.BaseConstraintsSearchQuery;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.edt.base.model.EModuleInfo;
import ro.amiq.edt.base.model.reflection.IRfScope;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfFieldPropConstraint;
import ro.amiq.edt.base.model.reflection.RfFieldTypeConstraint;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfPseudoListField;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.RfVarLayer;
import ro.amiq.edt.base.model.reflection.semantic.SemanticUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.model.reflection.util.RfUtilsCommon;
import ro.amiq.edt.base.model.reflection.views.ConstraintsWalker;
import ro.amiq.edt.base.model.reflection.views.IConstraintsWalkerListener;
import ro.amiq.edt.base.model.reflection.views.RfConstraintKind;
import ro.amiq.edt.base.ui.search.constraints.CUtils;
import ro.amiq.edt.base.ui.search.constraints.ConstraintsSearchResult;
import ro.amiq.edt.base.ui.search.constraints.ConstraintsSearchUtils;
import ro.amiq.etools.eparser.EAST;

public abstract class BaseEConstraintsSearchQuery
extends BaseConstraintsSearchQuery
implements IConstraintsWalkerListener {
    private static final String IT = "it";

    protected BaseEConstraintsSearchQuery(RfNamedElement element) {
        super(BaseEConstraintsSearchQuery.getFieldFromTypePropConstraintOrPseudoList(element));
    }

    protected abstract void addMatch(ConstraintsWalker var1, EAST var2, RfConstraintKind var3);

    private static IRfNamedElement getFieldFromTypePropConstraintOrPseudoList(RfNamedElement field) {
        if (field instanceof RfFieldTypeConstraint) {
            return ((RfFieldTypeConstraint)field).getFieldOrVariable();
        }
        if (field instanceof RfFieldPropConstraint) {
            return ((RfFieldPropConstraint)field).getField();
        }
        if (field instanceof RfPseudoListField) {
            return ((RfPseudoListField)field).getParentField();
        }
        return field;
    }

    public String getFieldNameForLabel() {
        RfNamedElement field = (RfNamedElement)this.getField();
        if (field == null || field.getFullName() == null) {
            return null;
        }
        if (field instanceof RfField) {
            return field.getFullName().toString();
        }
        if (field instanceof RfVar) {
            return this.makeLabelFor((RfVar)field);
        }
        return field.getSignature();
    }

    private String makeLabelFor(RfVar variable) {
        String varFullName = variable.getName();
        if (varFullName == null) {
            return null;
        }
        RfDefElement layer = variable.getDeclaration();
        if (layer == null) {
            return varFullName;
        }
        IRfScope layerEnclosingScope = ((RfVarLayer)layer).getEnclosingScope();
        while (layerEnclosingScope != null && !(layerEnclosingScope instanceof RfMethodLayer)) {
            layerEnclosingScope = layerEnclosingScope.getEnclosingScope();
        }
        if (!(layerEnclosingScope instanceof RfMethodLayer)) {
            return varFullName;
        }
        RfMethod method = ((RfMethodLayer)layerEnclosingScope).getMethod();
        if (method == null || method.getFullName() == null) {
            return varFullName;
        }
        return String.valueOf(method.getFullName().toString()) + "." + varFullName;
    }

    protected int computeMonitorTicks() {
        int result = 0;
        RfProject rfProject = (RfProject)this.getRfProject();
        IRfNamedElement field = this.getField();
        if (field == null) {
            return result;
        }
        Collection<RfModule> allModules = rfProject.getAllModules();
        for (RfModule module : allModules) {
            if (!this.moduleReferencesField(module, field)) continue;
            ++result;
        }
        return result;
    }

    protected void computeMatches() {
        RfProject rfProject = (RfProject)this.getRfProject();
        IRfNamedElement field = this.getField();
        if (field == null) {
            return;
        }
        Collection<RfModule> allModules = rfProject.getAllModules();
        for (RfModule module : allModules) {
            if (this.getMonitor().isCanceled()) {
                return;
            }
            if (!this.moduleReferencesField(module, field)) continue;
            this.getMonitor().worked(1);
            EModuleInfo eModuleInfo = rfProject.getModuleInfo(module.getModuleReference());
            if (eModuleInfo == null) continue;
            ConstraintsWalker constraintsWalker = new ConstraintsWalker(rfProject, module.getParserPath(), eModuleInfo);
            constraintsWalker.walkFile(eModuleInfo.getModuleAST(), this);
        }
    }

    private boolean moduleReferencesField(RfModule module, IRfNamedElement field) {
        if (field == null) {
            return false;
        }
        List<RfModule.IdentifierPosition> identifiers = module.getIdentifiers(field.getName());
        if (identifiers == null) {
            return false;
        }
        for (RfModule.IdentifierPosition idPosition : identifiers) {
            if (!this.transientResultIs(idPosition.getNamedElement(), field)) continue;
            return true;
        }
        return false;
    }

    private boolean transientResultIs(IRfNamedElement candidate, IRfNamedElement field) {
        if (field == null) {
            return false;
        }
        return field.checkEquals((Object)candidate);
    }

    @Override
    public void idInConstraint(ConstraintsWalker walker, AST ast, RfConstraintKind kind) {
        if (walker == null || ast == null || walker.getParserPath() == null) {
            return;
        }
        EAST east = (EAST)ast;
        if (!CUtils.isLastInHid(east)) {
            return;
        }
        RfNamedElement transientResult = SemanticUtils.getTransientResult(RfNamedElement.class, (AST)east);
        if (kind == RfConstraintKind.KEEP_TYPE && transientResult instanceof RfFieldTypeConstraint && IT.equals(ast.getText())) {
            return;
        }
        RfNamedElement field = (RfNamedElement)this.getField();
        if (this.transientResultIs(transientResult, field)) {
            this.addMatch(walker, east, kind);
        }
    }

    protected int countStartWS(String lineContents) {
        int counter = 0;
        int i = 0;
        while (i < lineContents.length()) {
            counter = i;
            if (!Character.isWhitespace(lineContents.charAt(i))) break;
            ++i;
        }
        return counter;
    }

    protected String getMacroCall(ParserPath parserPath, LineInfo lineInfo) {
        RfProject rfProject = (RfProject)this.getRfProject();
        IFile file = DVTFileUtils.getInstance().findProjectFile(this.getProject(), parserPath.path);
        IDocument document = ConstraintsSearchUtils.INSTANCE.getDocument(file);
        if (document == null) {
            return "";
        }
        RfUtilsCommon.MacroRegion macroRegion = RfUtils.getMacro(rfProject, file, document, lineInfo.realOffset);
        if (macroRegion == null) {
            return "";
        }
        IRegion region = macroRegion.getRegion();
        try {
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    protected AbstractTextSearchResult makeSearchResult() {
        return new ConstraintsSearchResult((ISearchQuery)this);
    }

    protected boolean useScaledMonitor() {
        return false;
    }
}

