/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import ro.amiq.dvt.ui.search.BaseFileLabelProvider;
import ro.amiq.dvt.ui.search.LineElement;
import ro.amiq.dvt.ui.search.text.BaseConstraintsSearchPage;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.search.text.CategoryFilterConfig;
import ro.amiq.edt.base.model.reflection.views.RfConstraintKind;
import ro.amiq.edt.base.ui.search.constraints.ConstraintLineElement;
import ro.amiq.edt.base.ui.search.text.FileLabelProvider;
import ro.amiq.edt.base.ui.search.text.FileTreeContentProvider;

public class ConstraintsSearchPage
extends BaseConstraintsSearchPage {
    private static CategoryFilterConfig HIDE_NEW_WITH_CATEGORY_FILTER = new CategoryFilterConfig("Hide new with {...}", "searchViewEdtHideNewWith"){

        public boolean filter(LineElement lineElement) {
            return ((ConstraintLineElement)lineElement).getConstraintKind() == RfConstraintKind.NEW_WITH;
        }
    };
    private static CategoryFilterConfig HIDE_NEW_ACTIONS_CATEGORY_FILTER = new CategoryFilterConfig("Hide new actions", "searchViewEdtHideNew"){

        public boolean filter(LineElement lineElement) {
            return ((ConstraintLineElement)lineElement).getConstraintKind() == RfConstraintKind.NEW;
        }
    };
    private static CategoryFilterConfig HIDE_GEN_ACTIONS_CATEGORY_FILTER = new CategoryFilterConfig("Hide gen actions", "searchViewEdtHideGen"){

        public boolean filter(LineElement lineElement) {
            return ((ConstraintLineElement)lineElement).getConstraintKind() == RfConstraintKind.GEN;
        }
    };
    private static CategoryFilterConfig HIDE_DO_ACTIONS_CATEGORY_FILTER = new CategoryFilterConfig("Hide do actions", "searchViewEdtHideDo"){

        public boolean filter(LineElement lineElement) {
            return ((ConstraintLineElement)lineElement).getConstraintKind() == RfConstraintKind.DO;
        }
    };
    private static final List<CategoryFilterConfig> CONFIGS = Arrays.asList(HIDE_NEW_WITH_CATEGORY_FILTER, HIDE_NEW_ACTIONS_CATEGORY_FILTER, HIDE_GEN_ACTIONS_CATEGORY_FILTER, HIDE_DO_ACTIONS_CATEGORY_FILTER);

    protected BaseFileLabelProvider makeLabelProvider(BaseFileSearchPage page, int orderFlag, ILabelDecorator decorator) {
        return new FileLabelProvider((AbstractTextSearchViewPage)page, orderFlag, decorator);
    }

    protected IContentProvider makeFileTreeContentProvider(BaseFileSearchPage page, TreeViewer viewer, BaseFileLabelProvider innerLabelProvider) {
        return new FileTreeContentProvider(page, (AbstractTreeViewer)viewer, innerLabelProvider);
    }

    protected List<CategoryFilterConfig> getFilterConfigs() {
        ArrayList<CategoryFilterConfig> result = new ArrayList<CategoryFilterConfig>();
        result.add(HIDE_DO_ACTIONS_CATEGORY_FILTER);
        result.add(HIDE_GEN_ACTIONS_CATEGORY_FILTER);
        result.add(HIDE_NEW_ACTIONS_CATEGORY_FILTER);
        result.add(HIDE_NEW_WITH_CATEGORY_FILTER);
        return result;
    }
}

