/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.ui.search.text;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import ro.amiq.dvt.ui.search.BaseFileSearchQuery;
import ro.amiq.dvt.ui.search.BaseFileSearchResult;
import ro.amiq.dvt.ui.search.BaseTextSearchQuery;
import ro.amiq.dvt.ui.search.ui.SearchMessages;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.search.NewTextSearchEngine;
import ro.amiq.edt.base.ui.search.text.FileSearchResult;
import ro.amiq.edt.base.ui.search.text.TextSearchResultCollector;

public class FileSearchQuery
extends BaseFileSearchQuery {
    protected IEPluginConfig fPluginConfig;

    public FileSearchQuery(IEPluginConfig pluginConfig, String searchType, String searchText, String searchLabel, boolean isRegEx, boolean isCaseSensitive, boolean isWholeWord, FileTextSearchScope scope, int limitTo, boolean includeDeclarations, boolean isOnlyCompiled, int searchFor) {
        super(searchType, searchText, searchLabel, isRegEx, isCaseSensitive, isWholeWord, scope, limitTo, includeDeclarations, isOnlyCompiled, searchFor);
        this.fPluginConfig = pluginConfig;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        boolean searchInBinaries = !this.isScopeAllFileTypes();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, isFileSearchOnly, searchInBinaries);
        return new NewTextSearchEngine(this.fPluginConfig, this.fLimitTo, this.fSearchFor, this.fIncludeDeclarations, this.fOnlyCompiled, this).search((TextSearchScope)this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{file}, (String[])new String[]{"*"}, (boolean)true);
        Pattern searchPattern = this.getSearchPattern();
        boolean isFileSearchOnly = searchPattern.pattern().length() == 0;
        TextSearchResultCollector collector = new TextSearchResultCollector(result, isFileSearchOnly, true);
        return new NewTextSearchEngine(this.fPluginConfig, this.fLimitTo, this.fSearchFor, this.fIncludeDeclarations, this.fOnlyCompiled, this).search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected BaseFileSearchResult makeFileSearchResult(BaseTextSearchQuery baseSearchQuery) {
        return new FileSearchResult(baseSearchQuery);
    }

    public String getLabel() {
        return SearchMessages.FileSearchQuery_e_label;
    }
}

