/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.CommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.reflection.AbstractRfManager;
import ro.amiq.edt.base.model.reflection.IRfAssociatedType;
import ro.amiq.edt.base.model.reflection.IRfTemplateParam;
import ro.amiq.edt.base.model.reflection.RfDefElement;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfExpect;
import ro.amiq.edt.base.model.reflection.RfField;
import ro.amiq.edt.base.model.reflection.RfMacro;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfMethodLayer;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.RfStructMember;
import ro.amiq.edt.base.model.reflection.RfTemplateStruct;
import ro.amiq.edt.base.model.reflection.RfTemplateStructInstance;
import ro.amiq.edt.base.model.reflection.RfType;
import ro.amiq.edt.base.model.reflection.RfVar;
import ro.amiq.edt.base.model.reflection.util.RfUtils;

public abstract class EDTBaseLinkResolver
extends CommentLinkResolver {
    protected abstract AbstractRfManager getRfManager();

    public Collection<IRfNamedElement> getInitialCandidates(IRfNamedElement element, ITextEditor textEditor) {
        IRfScopeElement scope = element instanceof RfMacro ? RfUtils.getRfScope(this.getRfManager(), textEditor, textEditor == null ? null : textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()), ((RfMacro)element).getOffset(), ((RfMacro)element).getLine()) : element.getEnclosingScope();
        return EDTBaseLinkResolver.getInitialCandidatesInScope(scope);
    }

    public IRfNamedElement solveHyperlinkForAllCandidates(IRfNamedElement element, Collection<IRfNamedElement> candidates, String[] parsedLink, long timeoutTime) {
        try {
            RfNamedElement potentialMacro;
            IRfNamedElement foundElement = null;
            for (IRfNamedElement candidate : candidates) {
                foundElement = this.recursiveFindElement(candidate, parsedLink, 0, timeoutTime);
                if (foundElement == null) continue;
                return foundElement;
            }
            if (parsedLink.length != 1) {
                return foundElement;
            }
            if (!candidates.isEmpty()) {
                IRfNamedElement firstCandidate = candidates.iterator().next();
                if (candidates.size() == 1 && RfStruct.isPackageElement(firstCandidate, false)) {
                    return foundElement;
                }
            }
            if ((potentialMacro = EDTBaseLinkResolver.searchForMacro(element, parsedLink[0])) != null) {
                return potentialMacro;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static Collection<IRfNamedElement> getInitialCandidatesInScope(IRfScopeElement scope) {
        if (scope == null) {
            return null;
        }
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        while (scope != null) {
            if (scope instanceof RfNamedElement) {
                result.add((RfNamedElement)scope);
            }
            scope = scope.getEnclosingScope();
        }
        return result;
    }

    public IRfNamedElement recursiveFindElement(IRfNamedElement scope, String[] parsedElementPath, int pathIndex, long timeoutTime) throws Exception {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new Exception("Tooltip timeout in resolving link " + String.join((CharSequence)".", parsedElementPath));
        }
        if (!(scope instanceof RfNamedElement) || parsedElementPath == null) {
            return null;
        }
        if (scope.getRfProject() == null) {
            return null;
        }
        RfNamedElement currentScope = (RfNamedElement)scope;
        if (pathIndex >= parsedElementPath.length) {
            return scope;
        }
        List<RfNamedElement> members = EDTBaseLinkResolver.getCandidatesInScope(currentScope);
        if (members == null) {
            return null;
        }
        String name = EDTBaseLinkResolver.extractName(parsedElementPath[pathIndex]);
        String[] args = EDTBaseLinkResolver.extractArgs(parsedElementPath[pathIndex]);
        IRfNamedElement result = null;
        for (RfNamedElement member : members) {
            if (!parsedElementPath[pathIndex].equals(member.getName()) && !EDTBaseLinkResolver.isElementWithGenericParams(member, args, name) || (result = this.recursiveFindElement(member, parsedElementPath, pathIndex + 1, timeoutTime)) == null) continue;
            return result;
        }
        return null;
    }

    public static boolean isElementWithGenericParams(RfNamedElement member, String[] args, String name) {
        if (name == null || !name.equals(member.getName())) {
            return false;
        }
        if (member instanceof RfTemplateStruct) {
            List<IRfTemplateParam> allArgsByName = ((RfTemplateStruct)member).getParameters();
            if (allArgsByName == null || args == null || allArgsByName.size() != args.length) {
                return false;
            }
            int argsIndex = 0;
            for (IRfTemplateParam argument : allArgsByName) {
                if (!args[argsIndex].equals(argument.toString()) && !args[argsIndex].equals(EDTBaseLinkResolver.cleanArgument(argument.toString()))) {
                    return false;
                }
                ++argsIndex;
            }
            return true;
        }
        if (member instanceof RfStruct && ((RfStruct)member).getParentStruct() instanceof RfTemplateStructInstance) {
            RfTemplateStructInstance parentStruct = (RfTemplateStructInstance)((RfStruct)member).getParentStruct();
            if (parentStruct == null) {
                return false;
            }
            List<IRfAssociatedType> templateInstanceParameters = parentStruct.getTemplateInstanceParameters();
            if (templateInstanceParameters == null || args == null || templateInstanceParameters.size() != args.length) {
                return false;
            }
            int argsIndex = 0;
            for (IRfAssociatedType instanceParam : templateInstanceParameters) {
                if (!(args[argsIndex].equals(instanceParam.getAssociatedTypeName()) || parentStruct.parameterExists(args[argsIndex]) || parentStruct.parameterExists(EDTBaseLinkResolver.addArgumentSyntax(args[argsIndex])))) {
                    return false;
                }
                ++argsIndex;
            }
            return true;
        }
        return false;
    }

    private static String addArgumentSyntax(String arg) {
        if (!arg.startsWith("<") && !arg.endsWith(">")) {
            return "<" + arg + ">";
        }
        return arg;
    }

    private static String cleanArgument(String arg) {
        if (arg.startsWith("<") && arg.endsWith(">")) {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    public static String extractName(String nameWithParams) {
        if (nameWithParams == null || nameWithParams.isEmpty() || !nameWithParams.contains("(")) {
            return null;
        }
        int indexEnd = nameWithParams.indexOf("(");
        String name = nameWithParams.substring(0, indexEnd);
        if (name == null) {
            return null;
        }
        return name.trim();
    }

    public static String[] extractArgs(String name) {
        if (name == null || name.isEmpty() || !name.contains("(")) {
            return null;
        }
        int indexStart = name.indexOf("(") + "(".length();
        if (indexStart < 0 || indexStart > name.length()) {
            return null;
        }
        int indexEnd = name.indexOf(")");
        if (indexEnd < 0 || indexEnd > name.length() || indexStart > indexEnd) {
            return null;
        }
        String declaredTypes = name.substring(indexStart, indexEnd);
        String[] types = DVTStringUtil.split((Pattern)CommentConstants.ARGS_PATTERN, (String)declaredTypes);
        return types;
    }

    public static List<RfNamedElement> getCandidatesInScope(RfNamedElement element) {
        List<RfNamedElement> members;
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (element instanceof RfModule && (members = EDTBaseLinkResolver.getModuleCandidates((RfModule)element)) != null) {
            result.addAll(members);
        }
        if (element instanceof RfStruct) {
            List<RfStruct> localSDLScenarios;
            List<RfStruct> localSLNActions;
            List<RfStructMember> expects;
            Object events;
            List<RfStructMember> fields;
            Collection<RfType> types;
            Object childStruct;
            RfStruct struct = (RfStruct)element;
            List<RfStructMember> methods = struct.getMethods();
            if (methods != null) {
                result.addAll(methods);
            }
            if ((childStruct = struct.getChildStructs()) != null) {
                result.addAll((Collection<RfNamedElement>)childStruct);
            }
            if ((types = struct.getTypes()) != null) {
                result.addAll(types);
            }
            if ((fields = struct.getFields()) != null) {
                result.addAll(fields);
            }
            if ((events = struct.getEvents()) != null) {
                result.addAll((Collection<RfNamedElement>)events);
            }
            if ((expects = struct.getExpects()) != null) {
                result.addAll(expects);
            }
            if ((localSLNActions = struct.getLocalSLNActions()) != null) {
                result.addAll(localSLNActions);
            }
            if ((localSDLScenarios = struct.getLocalSDLScenarios()) != null) {
                result.addAll(localSDLScenarios);
            }
        }
        if (element instanceof RfMethod) {
            List<RfExpect> expectsWithPrefix;
            List<RfEvent> eventsWithPrefix;
            List<RfMethod> methodsWithPrefix;
            IRfScopeElement enclosingStruct;
            List<RfDefElement> layers = ((RfMethod)element).getLayers();
            for (RfDefElement layerDefElement : layers) {
                Collection actionBlockChildren;
                if (!(layerDefElement instanceof RfMethodLayer) || (actionBlockChildren = ((RfMethodLayer)layerDefElement).getChildren()) == null) continue;
                for (RfDefElement actionChild : actionBlockChildren) {
                    Collection children = actionChild.getChildren();
                    for (RfDefElement child : children) {
                        RfNamedElement namedElement = child.getNamedElement();
                        if (namedElement == null) continue;
                        result.add(namedElement);
                    }
                }
            }
            List<RfVar> variablesWithPrefix = ((RfMethod)element).getVariablesWithPrefix(Integer.MAX_VALUE, 2, "");
            if (variablesWithPrefix != null) {
                result.addAll(variablesWithPrefix);
            }
            if ((enclosingStruct = element.getEnclosingScope()) == null || !(enclosingStruct instanceof RfStruct)) {
                return result;
            }
            String packageName = ((RfMethod)element).getPackageName();
            List<RfField> fieldsWithPrefix = ((RfMethod)element).getFieldsWithPrefix(packageName, (RfStruct)enclosingStruct, 2, "", 31);
            if (fieldsWithPrefix != null) {
                result.addAll(fieldsWithPrefix);
            }
            if ((methodsWithPrefix = ((RfMethod)element).getMethodsWithPrefix(packageName, (RfStruct)enclosingStruct, 2, "", 31)) != null) {
                result.addAll(methodsWithPrefix);
            }
            if ((eventsWithPrefix = ((RfMethod)element).getEventsWithPrefix(packageName, (RfStruct)enclosingStruct, 2, "", 31)) != null) {
                result.addAll(eventsWithPrefix);
            }
            if ((expectsWithPrefix = ((RfMethod)element).getExpectsWithPrefix(packageName, (RfStruct)enclosingStruct, 2, "", 31)) != null) {
                result.addAll(expectsWithPrefix);
            }
        }
        return result;
    }

    public static List<RfNamedElement> getModuleCandidates(RfModule module) {
        IRfSingleLangProject rfProject = module.getRfProject();
        if (rfProject == null) {
            return null;
        }
        List<RfNamedElement> types = rfProject.getAllTypes(false, false);
        if (types == null) {
            return null;
        }
        Collection<RfStruct> allPackages = rfProject.getAllPackages();
        if (allPackages != null) {
            types.addAll(allPackages);
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement type : types) {
            if (!(type instanceof RfType)) continue;
            result.add(type);
        }
        result.addAll(rfProject.getAllPackages());
        return result;
    }

    public IFile getIFileFromElement(IRfNamedElement element) {
        if (element == null || !(element instanceof RfNamedElement)) {
            return null;
        }
        RfDefElement defElem = ((RfNamedElement)element).getDeclaration();
        if (defElem == null) {
            return null;
        }
        IRfFileDef defFile = defElem.getDefFile();
        if (defFile == null) {
            return null;
        }
        Object fileObj = defFile.getAdapter(IResource.class);
        if (!(fileObj instanceof IFile)) {
            return null;
        }
        return (IFile)fileObj;
    }

    public IRfNamedElement getNamedElementFromPath(String path, IProject project) {
        RfElementPath elementPath = RfElementPath.fromString((String)path, EDTBaseLinkResolver.class);
        if (elementPath == null) {
            return null;
        }
        return elementPath.toNamedElement(project);
    }

    public List<IRfNamedElement> getPackageCandidates(String packageName, IProject project) {
        RfProject rfProject = this.getRfManager().getRfProject(project);
        return EDTBaseLinkResolver.getPackageCandidatesFromProject(packageName, rfProject);
    }

    public static List<IRfNamedElement> getPackageCandidatesFromProject(String packageName, RfProject rfProject) {
        if (rfProject == null) {
            return null;
        }
        Collection<RfStruct> packages = rfProject.getAllPackages();
        ArrayList<IRfNamedElement> packageCandidates = new ArrayList<IRfNamedElement>();
        for (RfStruct currentPack : packages) {
            if (!packageName.equals(currentPack.getName())) continue;
            packageCandidates.add(currentPack);
        }
        return packageCandidates;
    }

    public static RfNamedElement searchForMacro(IRfNamedElement scope, String macroName) {
        if (scope == null || macroName == null) {
            return null;
        }
        IRfSingleLangProject rfProject = scope.getRfProject();
        if (!(rfProject instanceof RfProject)) {
            return null;
        }
        RfMacro macro = ((RfProject)rfProject).getMacro(macroName);
        if (macro != null) {
            return macro;
        }
        macro = ((RfProject)rfProject).getPreproc(macroName);
        if (macro != null) {
            return macro;
        }
        List<RfMacro> allMacros = ((RfProject)rfProject).getAllMacros(true, true);
        for (RfMacro loopMacro : allMacros) {
            if (!macroName.equals(loopMacro.getName())) continue;
            return loopMacro;
        }
        return null;
    }

    public IFile getFile(IRfNamedElement element, IProject project) {
        if (element instanceof RfMacro) {
            RfDefElement firstLayer = ((RfMacro)element).getFirstLayer();
            if (firstLayer == null) {
                return null;
            }
            ParserPath parserPath = firstLayer.getParserPath();
            if (parserPath == null) {
                return null;
            }
            return DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, parserPath.getCanonicalPath());
        }
        return this.getIFileFromElement(element);
    }
}

