/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;
import ro.amiq.edt.base.ui.EFileLabelProvider;
import ro.amiq.edt.base.utils.EDTFileUtilsCommon;
import ro.amiq.etools.eparser.EParser;

public class EDTFileUtils
extends EDTFileUtilsCommon {
    private static volatile EDTFileUtils fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private EDTFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EDTFileUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new EDTFileUtils();
            }
        }
        return fInstance;
    }

    public IFile selectFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final IFile[] result = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new EFileLabelProvider2());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("The selected file is referenced by multiple linked resources in the workspace.\nSelect a workspace resource to open the file.");
                if (dialog.open() == 0) {
                    result[0] = (IFile)dialog.getFirstResult();
                }
            }
        });
        return result[0];
    }

    public IProject selectProject(IProject[] projects, String message, IProject defaultSelection) {
        return ro.amiq.dvt.ui.Utils.selectProject((IProject[])projects, (String)message, (ILabelProvider)new EFileLabelProvider2(), (IProject)defaultSelection);
    }

    private void internalOpenEditor(IProject project, File classicFile, int line, String selectIdentifier) {
        IFile candidate = this.getProjectFile(project, classicFile.getAbsolutePath());
        if (candidate == null) {
            this.openEditor(classicFile, line);
            return;
        }
        this.openEditor(candidate, line, selectIdentifier);
    }

    public void openFile(AbstractEModelManager modelManager, IProject project, String knownPath, int line, String selectIdentifier) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = this.findProjectFile(project, knownPath);
        if (candidate != null) {
            this.openEditor(candidate, line, selectIdentifier);
            return;
        }
        Path path = new Path(Utils.canonicPath((String)knownPath));
        File classicFile = path.toFile();
        if (path.isAbsolute()) {
            this.internalOpenEditor(project, classicFile, line, selectIdentifier);
            return;
        }
        IEProject eProject = modelManager.getEModel().getEProject(project);
        if (eProject == null) {
            return;
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(true);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return;
        }
        String rawSpecmanPath = compilationUnitProperties.getDvtSpecmanPath();
        if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
            String[] specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
            String fullFileName = knownPath;
            classicFile = null;
            String fileSeparator = System.getProperty("file.separator");
            int i = 0;
            while (i < specmanPath.length) {
                fullFileName = String.valueOf(specmanPath[i]) + fileSeparator + knownPath;
                classicFile = new File(fullFileName);
                if (classicFile.exists()) break;
                classicFile = null;
                ++i;
            }
            if (classicFile != null) {
                this.internalOpenEditor(project, classicFile, line, selectIdentifier);
                return;
            }
        }
        classicFile = new File(customPath);
        this.internalOpenEditor(project, classicFile, line, selectIdentifier);
    }

    public void openFile(AbstractEModelManager modelManager, IProject project, String fromPath, String knownPath, int line, String selectIdentifier) {
        if (fromPath == null) {
            return;
        }
        String fullPath = this.getPathFromSpecmanPath(modelManager, project, fromPath, knownPath, line, selectIdentifier);
        if (fullPath != null) {
            this.openFile(modelManager, project, fullPath, line, selectIdentifier);
            return;
        }
        this.openFile(modelManager, project, knownPath, line, selectIdentifier);
    }

    public String getCoreEsvFile(boolean isSLN, boolean isSDL) {
        try {
            String coreESV = "esv/eparser.esv";
            if (isSLN) {
                coreESV = "esv/eparser_sln.esv";
            }
            if (isSDL) {
                coreESV = "esv/eparser_sdl.esv";
            }
            URL esvURL = EParser.class.getResource(coreESV);
            URL esvURL_local = FileLocator.toFileURL((URL)esvURL);
            return Path.fromOSString((String)esvURL_local.getFile()).toOSString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    static class EFileLabelProvider2
    extends EFileLabelProvider {
        EFileLabelProvider2() {
        }

        @Override
        protected String decorateText(String input, Object element) {
            if (element instanceof IFile) {
                return ((IFile)element).getFullPath().toOSString();
            }
            if (element instanceof IFolder) {
                return ((IFolder)element).getProjectRelativePath().toOSString();
            }
            return input;
        }
    }
}

