/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.io.File;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.edt.base.model.AbstractEModelManager;
import ro.amiq.edt.base.model.CompilationUnitProperties;
import ro.amiq.edt.base.model.IEProject;

public abstract class EDTFileUtilsCommon
extends DVTFileUtils {
    public void dumpAsComputedDebug(IProject project, String className, String classContent) {
        String debugPath = BuildConfigManager.getAsComputedDumpPath((IProject)project);
        if (debugPath != null) {
            IPath directoryPath = Path.fromOSString((String)debugPath).append("ro.amiq.edt.base.debug.ascomputed".replace('.', '/'));
            if (!directoryPath.toFile().exists()) {
                directoryPath.toFile().mkdirs();
            }
            DVTFileUtils.getInstance().writeStringToFile(directoryPath.append(String.valueOf(className) + ".java").toFile(), this.formatText(0, classContent), false);
        }
    }

    public String getPathFromSpecmanPath(AbstractEModelManager modelManager, IProject project, String fromPath, String knownPath, int line, String selectIdentifier) {
        IEProject eProject = modelManager.getEModel().getEProject(project);
        if (eProject == null) {
            return null;
        }
        CompilationUnitProperties compilationUnitProperties = eProject.getCompilationUnitProperties(true);
        if (!compilationUnitProperties.hasFilesToCompile()) {
            return null;
        }
        String rawSpecmanPath = compilationUnitProperties.getDvtSpecmanPath();
        if (rawSpecmanPath != null && rawSpecmanPath.length() != 0) {
            String[] specmanPath = DVTStringUtil.split((String)IDVTProject.DEFAULT_PATH_SPLIT_SEPARATOR, (String)rawSpecmanPath);
            String fullPath = null;
            File file = null;
            int i = 0;
            while (i < specmanPath.length + 1) {
                fullPath = i == specmanPath.length ? String.valueOf(fromPath) + DVTFileUtils.FILE_SEPARATOR + knownPath : String.valueOf(specmanPath[i]) + DVTFileUtils.FILE_SEPARATOR + knownPath;
                file = new File(fullPath);
                if (file.exists()) {
                    return fullPath;
                }
                ++i;
            }
        }
        return null;
    }

    public String formatText(int initialIndent, String unformatted) {
        if (unformatted == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] lines = DVTStringUtil.split((Pattern)DVTStringUtil.NEW_LINE, (String)unformatted);
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < initialIndent) {
            indent.append(" ");
            ++i;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() == 0) {
                sb.append('\n');
            } else {
                if (line.charAt(0) == '}') {
                    if (indent.length() >= 4) {
                        indent.delete(indent.length() - 4, indent.length());
                    }
                    sb.append((CharSequence)indent).append(line);
                    if (line.charAt(line.length() - 1) == '{') {
                        indent.append("    ");
                    }
                } else if (line.charAt(line.length() - 1) == '{') {
                    sb.append((CharSequence)indent).append(line);
                    indent.append("    ");
                } else {
                    sb.append((CharSequence)indent).append(line);
                }
                sb.append('\n');
            }
            ++n2;
        }
        return sb.toString();
    }
}

