/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.edt.base.utils.GoToImportUtilsCommon;

public class GoToImportUtils
extends GoToImportUtilsCommon {
    public static void goToImport(IEPluginConfig pluginConfig, IProject project, IResource fileAdapter) {
        try {
            IPath searchedPath = fileAdapter.getLocation();
            if (searchedPath == null) {
                return;
            }
            List<IActionHyperlink> hyperLinks = GoToImportUtils.getImportedLocations(pluginConfig, project, searchedPath);
            if (hyperLinks.isEmpty()) {
                GoToImportUtils.informationDialog(searchedPath.lastSegment());
                return;
            }
            if (hyperLinks.size() == 1) {
                hyperLinks.get(0).open();
            } else {
                GoToImportUtils.getHyperlinksForImportDirectives(hyperLinks, searchedPath.lastSegment()).open();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static IHyperlink getHyperlinksForImportDirectives(final List<IActionHyperlink> hyperLinks, final String moduleName) {
        return new IHyperlink(){

            public void open() {
                LabelProvider labelProvider = new LabelProvider(){

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public String getText(Object element) {
                        IPath fullPath = Path.fromOSString((String)((RfNamedElementActionHyperlink)element).getFullPath());
                        int lineNumber = ((RfNamedElementActionHyperlink)element).getLine();
                        return String.valueOf(fullPath.lastSegment()) + " @ line " + lineNumber + " - " + fullPath.toOSString();
                    }

                    public Image getImage(Object element) {
                        return DVTImages.imageCache.getImage(DVTImages.DESC_E_MODULE);
                    }
                };
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider, (ILabelProvider)labelProvider){
                    private final /* synthetic */ ILabelProvider val$labelProvider;
                    {
                        this.val$labelProvider = iLabelProvider;
                        super($anonymous0, $anonymous1);
                    }

                    protected FilteredList createFilteredList(Composite parent) {
                        FilteredList list = super.createFilteredList(parent);
                        list.setLabelProvider(this.val$labelProvider);
                        list.setFilterMatcher(new FilteredList.FilterMatcher(){
                            private StringMatcher fMatcher;

                            public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                                this.fMatcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)pattern, (boolean)ignoreCase, (boolean)ignoreWildCards);
                            }

                            public boolean match(Object element) {
                                return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)this.fMatcher, (String)fFilteredList.getLabelProvider().getText(element));
                            }
                        });
                        return list;
                    }
                };
                dialog.setTitle("Go To Import");
                dialog.setMessage("Select the locations you want to open ('" + moduleName + "' is imported multiple times):");
                dialog.setElements(hyperLinks.toArray());
                dialog.setMultipleSelection(true);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    if (result == null) {
                        return;
                    }
                    Object[] objectArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (object != null) {
                            RfNamedElementActionHyperlink selection = (RfNamedElementActionHyperlink)object;
                            selection.open();
                        }
                        ++n2;
                    }
                }
            }

            public String getTypeLabel() {
                return null;
            }

            public String getHyperlinkText() {
                return null;
            }

            public IRegion getHyperlinkRegion() {
                return ((IActionHyperlink)hyperLinks.get(0)).getHyperlinkRegion();
            }
        };
    }

    private static void informationDialog(final String moduleName) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, GoToImportUtilsCommon.moduleIsTopFileMessage(moduleName), 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }
}

