/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.ImportFilePath;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.util.RfUtils;
import ro.amiq.edt.base.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class GoToImportUtilsCommon {
    public static List<IActionHyperlink> getImportedLocations(IEPluginConfig pluginConfig, IProject project, IPath searchedPath) {
        ArrayList<IActionHyperlink> hyperLinks = new ArrayList<IActionHyperlink>();
        RfProject rfProject = pluginConfig.getRfManager().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        Collection<RfModule> allModules = rfProject.getAllModules();
        if (allModules == null || allModules.isEmpty()) {
            return null;
        }
        for (RfModule module : allModules) {
            List<ImportFilePath> importedFilePaths = module.getImportedFilePaths();
            if (importedFilePaths == null || importedFilePaths.isEmpty()) continue;
            for (ImportFilePath importFilePath : importedFilePaths) {
                RfNamedElementActionHyperlink actionHyperlink;
                int count;
                IPath trimmedSearchedPath;
                boolean shouldKeepDevice = importFilePath.getFilePath().getDevice() != null;
                String filePath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)importFilePath.getFilePath().toOSString(), DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, envVarName -> BuildConfigManager.getUserDefinedEnvVar((IProject)project, (String)envVarName, (BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy)BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION));
                IPath candidatePath = Path.fromOSString((String)filePath);
                while (candidatePath.segmentCount() > 0) {
                    if (!candidatePath.segment(0).equals("..") && !candidatePath.segment(0).equals(".")) break;
                    candidatePath = candidatePath.removeFirstSegments(1);
                }
                IPath iPath = trimmedSearchedPath = (count = searchedPath.segmentCount() - candidatePath.segmentCount()) > 0 ? searchedPath.removeFirstSegments(count) : searchedPath;
                if (!shouldKeepDevice) {
                    trimmedSearchedPath = trimmedSearchedPath.setDevice(null);
                }
                if (!trimmedSearchedPath.equals((Object)candidatePath) && !trimmedSearchedPath.equals((Object)candidatePath.addFileExtension("e")) || (actionHyperlink = RfUtils.createOpenActionToImportDirective(pluginConfig, module, project, (IRegion)new Region(0, 1), importFilePath)) == null) continue;
                hyperLinks.add(actionHyperlink);
            }
        }
        return hyperLinks;
    }

    public static String moduleIsTopFileMessage(String moduleName) {
        return "The operation is not available for the current module.\nModule '" + moduleName + "' is a top file.";
    }
}

