/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.IEModel;
import ro.amiq.edt.base.model.IEModule;
import ro.amiq.edt.base.model.reflection.RfModule;
import ro.amiq.edt.base.model.reflection.RfProject;
import ro.amiq.edt.base.model.reflection.semantic.RfSemanticError;
import ro.amiq.edt.base.model.reflection.views.EQuickViewersUtil;
import ro.amiq.edt.base.ui.editor.AbstractEEditor;
import ro.amiq.edt.base.ui.editor.highlight.ESemanticHighlighter;
import ro.amiq.edt.base.utils.UtilsCommon;

public class Utils
extends UtilsCommon {
    public static void triggerSemanticMarkers(IEPluginConfig pluginConfig, IProject project, Map<String, Collection<RfSemanticError>> semanticErrors, boolean toConsole) {
        pluginConfig.getSemanticErrorManager().reparsed(project, semanticErrors, toConsole);
    }

    public static void runOnDisplayThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    public static int convertPositionToLine(IDocument document, int offset) {
        try {
            if (document != null && document.getLength() > offset) {
                return document.getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static void connectActiveOpenEditor(final String editorID, final RfProject rfProject) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    if (rfProject.getFileEditors() == null) {
                        return;
                    }
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null) {
                        return;
                    }
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow == null) {
                        return;
                    }
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    if (activePage == null) {
                        return;
                    }
                    IEditorPart editor = activePage.getActiveEditor();
                    if (editor == null) {
                        return;
                    }
                    if (editor instanceof AbstractEEditor) {
                        IFile file = (IFile)editor.getAdapter(IResource.class);
                        if (file == null) {
                            return;
                        }
                        ParserPath parserPath = rfProject.resource2parser((IResource)file);
                        if (parserPath == null) {
                            return;
                        }
                        if (!rfProject.isCompiled(parserPath)) {
                            EQuickViewersUtil.getInstance().scheduleReparseIfNonTop(rfProject.getPluginConfig(), (ITextEditor)((DVTEditor)editor), false);
                            return;
                        }
                        rfProject.connectModuleToDocument(editorID, parserPath, (DVTEditor)editor, false);
                        rfProject.notifyParsingEndUsingParserPath(parserPath);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public static void connectPragmaCodePositions(IDocument document, RfModule module, Set<DVTSemanticFoldingPosition> foldingPositions) {
        try {
            if (module == null || document == null || foldingPositions == null) {
                return;
            }
            if (document.containsPositionCategory("CUSTOM_PRAGMA")) {
                try {
                    document.removePositionCategory("CUSTOM_PRAGMA");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            document.addPositionCategory("CUSTOM_PRAGMA");
            IRfSingleLangProject rfProject = module.getRfProject();
            if (rfProject == null) {
                return;
            }
            if (BuildConfigManager.getCustomPragmas((IProject)rfProject.getProject()).isEmpty()) {
                return;
            }
            IEModel eModel = rfProject.getPluginConfig().getModelManager().getEModel();
            if (eModel == null) {
                return;
            }
            IResource fileAdapter = module.getFileAdapter();
            if (!(fileAdapter instanceof IFile)) {
                return;
            }
            IEModule eModule = eModel.getOrCreateEModule((IFile)fileAdapter);
            if (eModule == null) {
                return;
            }
            List<CustomPragmaUsage> customPragmas = module.getCustomPragmas();
            if (customPragmas == null) {
                ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
                return;
            }
            ro.amiq.dvt.ui.Utils.addCustomPragmasPositions(customPragmas, foldingPositions, (IDocument)document);
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"CUSTOM_PRAGMA");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void startHighlight(AbstractUIPlugin plugin, IRfFileDef fileDef, DVTEditor dvtEditor) {
        if (fileDef == null || dvtEditor == null) {
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)fileDef, (DVTEditor)dvtEditor, (DVTSemanticHighlighter)new ESemanticHighlighter(dvtEditor.getDocument()), (AbstractUIPlugin)plugin, (String)"highlight.semantic");
        ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
    }

    public static int documentNumberOfLines(IDocument document) {
        return document.getNumberOfLines();
    }

    public static int documentLength(IDocument document) {
        return document.getLength();
    }

    public static int documentLineOffset(IDocument document, int line) throws Exception {
        return document.getLineOffset(line);
    }

    public static void addDocumentPosition(IDocument document, String string, Position position) throws Exception {
        position.length = Math.min(position.length, Math.max(0, document.getLength() - position.offset));
        document.addPosition(string, position);
    }

    public static void startUpdateBreadcrumbs(DVTEditor dvtEditor) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
                if (activeWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                Utils.internalSetReadOnlyBreadcrumbs(dvtEditor, false);
                if (!activePage.isPartVisible((IWorkbenchPart)dvtEditor)) {
                    return;
                }
                ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(dvtEditor.getCursorScopeForBreadcrumb(true), (IFile)dvtEditor.getAdapter(IResource.class), true);
                dvtEditor.updateBreadcrumb(ScopeBreadcrumbViewer.class, (AbstractBreadcrumbConfiguration)configuration);
                dvtEditor.updateBreadcrumb(VHBreadcrumbViewer.class, null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void setReadOnlyBreadcrumbs() {
        Job updateBCJob = new Job("Setting read-only Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : ro.amiq.dvt.ui.Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    Utils.internalSetReadOnlyBreadcrumbs((DVTEditor)editor, true);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    private static void internalSetReadOnlyBreadcrumbs(DVTEditor editor, boolean isReadOnly) {
        IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        boolean forceReadOnly = false;
        if (activePage.isPartVisible((IWorkbenchPart)editor)) {
            forceReadOnly = true;
        }
        List breadcrumbViewers = editor.getBreadcrumbViewers();
        for (AbstractBreadcrumbViewer breadcrumb : breadcrumbViewers) {
            if (!(breadcrumb instanceof ThickBreadcrumbViewer)) continue;
            ((ThickBreadcrumbViewer)breadcrumb).setModelReady(!isReadOnly);
            if (!forceReadOnly) continue;
            ((ThickBreadcrumbViewer)breadcrumb).changeReadOnlyState();
        }
    }

    public static void notifyAddInactiveCodeInfo(ParserPath parserPath, IDocument document) {
    }
}

