/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.edt.base.utils;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.edt.base.core.IEPluginConfig;
import ro.amiq.edt.base.model.reflection.FullName;
import ro.amiq.edt.base.model.reflection.RfEvent;
import ro.amiq.edt.base.model.reflection.RfKind;
import ro.amiq.edt.base.model.reflection.RfMethod;
import ro.amiq.edt.base.model.reflection.RfNamedElement;
import ro.amiq.edt.base.model.reflection.RfStruct;
import ro.amiq.edt.base.model.reflection.predefined.RfPredefinedEvent;

public class UtilsCommon {
    public static int convertPositionToLine(IDocument document, int offset) {
        try {
            if (document != null && document.getLength() > offset) {
                return document.getLineOfOffset(offset) + 1;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static int documentNumberOfLines(IDocument document) {
        return document.getNumberOfLines();
    }

    public static int documentLength(IDocument document) {
        return document.getLength();
    }

    public static int documentLineOffset(IDocument document, int line) throws Exception {
        return document.getLineOffset(line);
    }

    public static void addDocumentPosition(IDocument document, String string, Position position) throws Exception {
        position.length = Math.min(position.length, Math.max(0, document.getLength() - position.offset));
        document.addPosition(string, position);
    }

    public static boolean canShowEmitters(IRfNamedElement namedElement) {
        if (namedElement instanceof RfMethod && ((RfMethod)namedElement).isByEvent()) {
            return true;
        }
        return namedElement instanceof RfEvent || namedElement instanceof RfPredefinedEvent;
    }

    public static RfNamedElement getEvent(RfNamedElement namedElement) {
        if (namedElement instanceof RfEvent || namedElement instanceof RfPredefinedEvent) {
            return namedElement;
        }
        if (!(namedElement instanceof RfMethod) || !((RfMethod)namedElement).isByEvent()) {
            return null;
        }
        String methodName = namedElement.getName();
        if (methodName == null) {
            return null;
        }
        FullName methodFullName = ((RfMethod)namedElement).getFullName();
        if (methodFullName == null) {
            return null;
        }
        FullName candidateName = new FullName(methodName.substring(3), methodFullName.getDeterminant());
        RfStruct parentStruct = ((RfMethod)namedElement).getParentStruct();
        if (parentStruct == null) {
            return null;
        }
        return parentStruct.getEvent(candidateName);
    }

    public static boolean shouldShowReadersWriters(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        String kindName = namedElement.getKindName();
        if (kindName == null) {
            return false;
        }
        return kindName.equals(RfKind.VARIABLE.getName()) || kindName.equals(RfKind.FIELD.getName()) || kindName.equals(RfKind.ARGUMENT.getName()) || kindName.equals(RfKind.UNIT_INSTANCE.getName()) || kindName.equals(RfKind.PORT_BUFFER_IN.getName()) || kindName.equals(RfKind.PORT_BUFFER_OUT.getName()) || kindName.equals(RfKind.PORT_EVENT_IN.getName()) || kindName.equals(RfKind.PORT_EVENT_INOUT.getName()) || kindName.equals(RfKind.PORT_EVENT_OUT.getName()) || kindName.equals(RfKind.PORT_INTERFACE_IN.getName()) || kindName.equals(RfKind.PORT_INTERFACE_OUT.getName()) || kindName.equals(RfKind.PORT_METHOD_IN.getName()) || kindName.equals(RfKind.PORT_METHOD_OUT.getName()) || kindName.equals(RfKind.PORT_SIMPLE_IN.getName()) || kindName.equals(RfKind.PORT_SIMPLE_INOUT.getName()) || kindName.equals(RfKind.PORT_SIMPLE_OUT.getName());
    }

    public static int getCodeFoldingNofLines(IEPluginConfig pluginConfig) {
        return pluginConfig.getPlugin().getPreferenceStore().getInt("editor.numberOfLines");
    }
}

