/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public enum AICommandPicker {
    INSTANCE;

    private static final String DIALOG_MESSAGE = "Select an AI Assistant command to execute:";
    private static final String DIALOG_TITLE = "AI Assistant Commands";
    private static final String COMMAND_CATEGORY_ID = "ro.amiq.dvt.ai.category";
    private static final String AI_COMMAND_PREFIX = "DVT AI";

    public void selectCommand() {
        Shell shell = DVTUiUtils.getActiveWorkbenchShell();
        if (shell == null) {
            return;
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService == null) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        if (handlerService == null) {
            return;
        }
        Command[] allCommands = commandService.getDefinedCommands();
        ArrayList<NamedHandler> namedHandlersList = new ArrayList<NamedHandler>();
        Command[] commandArray = allCommands;
        int n = allCommands.length;
        int n2 = 0;
        while (n2 < n) {
            Command command = commandArray[n2];
            try {
                IHandler handler;
                Category category;
                if (command.isDefined() && command.isHandled() && command.isEnabled() && (category = command.getCategory()) != null && COMMAND_CATEGORY_ID.equals(category.getId()) && (handler = command.getHandler()) != null) {
                    IEvaluationContext context = handlerService.createContextSnapshot(true);
                    ExecutionEvent executionEvent = new ExecutionEvent(command, Collections.emptyMap(), null, (Object)context);
                    if (!"ro.amiq.dvt.ai.SelectCommand".equals(command.getId())) {
                        String name = command.getName();
                        if (name.startsWith(AI_COMMAND_PREFIX)) {
                            name = name.substring(AI_COMMAND_PREFIX.length() + 1);
                        }
                        if (name.startsWith(" ")) {
                            name = name.substring(1);
                        }
                        namedHandlersList.add(new NamedHandler(name, handler, executionEvent));
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof NamedHandler)) {
                    return super.getText(element);
                }
                return ((NamedHandler)element).name;
            }
        });
        dialog.setElements(namedHandlersList.toArray());
        dialog.setMultipleSelection(false);
        dialog.setTitle(DIALOG_TITLE);
        dialog.setMessage(DIALOG_MESSAGE);
        dialog.setHelpAvailable(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return;
        }
        if (result[0] == null || !(result[0] instanceof NamedHandler)) {
            return;
        }
        NamedHandler selectedCommand = (NamedHandler)result[0];
        try {
            selectedCommand.handler.execute(selectedCommand.executionEvent);
        }
        catch (ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public class NamedHandler {
        private final String name;
        private final IHandler handler;
        private final ExecutionEvent executionEvent;

        private NamedHandler(String name, IHandler handler, ExecutionEvent executionEvent) {
            this.name = name;
            this.handler = handler;
            this.executionEvent = executionEvent;
        }

        public String toString() {
            return this.name;
        }
    }
}

