/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import ro.amiq.dvt.externaltools.ExternalToolsColorManager;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum AIConsole {
    MAIN("DVT AI Console"),
    MESSAGES("DVT AI Messages Console"),
    AI_TOOLS("DVT AI Tools");

    public static final String DATE_AND_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateTimeFormatter DATE_TIME_FORMATTER;
    private MessageConsole console;
    private String consoleName;

    static {
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DATE_AND_TIME_FORMAT);
    }

    private AIConsole(String consoleTitle) {
        this.consoleName = consoleTitle;
    }

    private void createConsole() {
        IConsole[] existingConsoles;
        if (this.console != null) {
            return;
        }
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager consoleManager = plugin.getConsoleManager();
        IConsole[] iConsoleArray = existingConsoles = consoleManager.getConsoles();
        int n = existingConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (this.consoleName.equals(console.getName()) && console instanceof MessageConsole) {
                this.console = (MessageConsole)console;
                return;
            }
            ++n2;
        }
        this.console = new MessageConsole(this.consoleName, null);
        consoleManager.addConsoles(new IConsole[]{this.console});
    }

    public void logTrace(String message) {
        this.printMessage("Trace", message);
    }

    public void logDebug(String message) {
        this.printMessage("Debug", message);
    }

    public void logInfo(String message) {
        this.printMessage("Info", message);
    }

    public void logWarning(String message) {
        this.printMessage("Warning", message, ExternalToolsColorManager.PREDEFINED_WARNING_COLOR);
    }

    public void logError(String message) {
        this.printMessage("Error", message, ExternalToolsColorManager.PREDEFINED_ERROR_COLOR);
    }

    public String getContent() {
        if (this.console == null) {
            return null;
        }
        IDocument document = this.console.getDocument();
        if (document == null) {
            return null;
        }
        return document.get();
    }

    private void printMessage(String prefix, String message) {
        this.printMessage(prefix, message, null);
    }

    public MessageConsole getConsole() {
        return this.console;
    }

    private void printMessage(String prefix, String message, Color textColor) {
        LocalDateTime currentDateTime = LocalDateTime.now();
        String formattedMessage = String.valueOf(currentDateTime.format(DATE_TIME_FORMATTER)) + " [" + prefix + "] " + message;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.syncExec(() -> {
            if (this.console == null) {
                this.createConsole();
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (MessageConsoleStream out = this.console.newMessageStream();){
                    if (textColor != null) {
                        out.setColor(textColor);
                    }
                    out.println(formattedMessage);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }
}

