/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

public enum AIConstants {
    INSTANCE;


    public static enum CodeActions {
        INSTANCE;

        public static final String INSERT_AT_CURSOR = "insert-at-cursor";
        public static final String INSERT_AT_CUROSR_AND_COMPARE = "insert-at-cursor-and-compare";
        public static final String COPY_TO_CLIPBOARD = "copy-to-clipboard";
        public static final String INSERT_IN_NEW_FILE = "insert-in-new-file";
    }

    public static enum Commands {
        OPEN_PROTECT_FILE("DVT AI: Open Protect File", "ro.amiq.dvt.ai.OpenProtectFile"),
        RUN_LAST_SESSION_IN_CHAT("DVT AI: Run Last Session in Chat", "ro.amiq.dvt.ai.RunLastSessionInChat"),
        SAVE_CHAT_SESSION_AS_BLUEPRINT("DVT AI: Save Chat Session as Blueprint", "ro.amiq.dvt.ai.SaveChatSessionAsBlueprint"),
        SHOW_ALL_COMMANDS("DVT AI: Show All Commands", "ro.amiq.dvt.ai.SelectCommand"),
        SHOW_CHAT_HISTORY("DVT AI: Show Chat History", "ro.amiq.dvt.ai.ShowHistory"),
        SHOW_LAST_CHAT_SESSION("DVT AI: Show Last Chat Session", "ro.amiq.dvt.ai.ShowConversation"),
        START_A_NEW_CHAT_SESSION("DVT AI: Start a New Chat Session", "ro.amiq.dvt.ai.OpenNewSession"),
        START_NEW_SESSION_FROM_BLUEPRINT("DVT AI: Start a New Session from Blueprint", "ro.amiq.dvt.ai.StartNewSessionFromBlueprint"),
        SEND_FILE_TO_PROMPT("DVT AI: Send File to Prompt", "ro.amiq.dvt.ai.SendFileToPrompt"),
        SEND_SELECTED_LINES_TO_PROMPT_AS_ANCHOR("DVT AI: Send Selected Lines to Prompt as Anchor", "ro.amiq.dvt.ai.sendSelectedLinesToPromptAsAnchor"),
        SEND_SELECTED_LINES_TO_PROMPT_AS_CODE_BLOCK("DVT AI: Send Selected Lines to Prompt as Code Block", "ro.amiq.dvt.ai.sendSelectedLinesToPromptAsCodeBlock"),
        STOP_GENERATION("DVT AI: Stop Generation", "ro.amiq.dvt.ai.StopEditorGeneration"),
        EDIT_PREDEFINED_BLUEPRINT("DVT AI: Edit Predefined Blueprint", "ro.amiq.dvt.ai.editPredefinedBlueprint"),
        EDIT_PREDEFINED_SNIPPET("DVT AI: Edit Predefined Snippet", "ro.amiq.dvt.ai.editPredefinedSnippet"),
        EDIT_CODE_COMPLETION_BLUEPRINT("DVT AI: Edit Code Completion Blueprint", "ro.amiq.dvt.ai.editCodeCompletionBlueprint"),
        CREATE_NEW_BLUEPRINT("DVT AI: Create New Blueprint", "ro.amiq.dvt.ai.createNewBlueprint"),
        CREATE_NEW_PROBLEM_AUTOCORRECT_BLUEPRINT("DVT AI: Create New Problem Auto-correct Blueprint", "ro.amiq.dvt.ai.CreateNewProblemAutocorrectBlueprint"),
        CREATE_NEW_VERISSIMO_AUTOCORRECT_BLUEPRINT("DVT AI: Create New Verissimo Auto-correct Blueprint", "ro.amiq.dvt.ai.CreateNewVerissimoAutocorrectBlueprint"),
        CREATE_NEW_SNIPPET("DVT AI: Create New Snippet", "ro.amiq.dvt.ai.createNewSnippet");

        private final String commandName;
        private final String commandID;

        private Commands(String commandName, String commandID) {
            this.commandName = commandName;
            this.commandID = commandID;
        }

        public String getCommandID() {
            return this.commandID;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public static String getCommandIDFromCommandName(String commandName) {
            Commands[] commandsArray = Commands.values();
            int n = commandsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Commands command = commandsArray[n2];
                if (commandName.equals(command.commandName)) {
                    return command.commandID;
                }
                ++n2;
            }
            return null;
        }
    }

    public static enum ProblemAutocorrect {
        INSTANCE;

        public static final String PROBLEM_AUTOCORRECT_DEFAULT_BLUEPRINT_NAME = "Problem Auto-correct";
        public static final String PROBLEM_AUTOCORRECT_DIALOG_TITLE = "Problem Auto-correct";
        public static final String PROBLEM_AUTOCORRECT_ERROR = "Problem Auto-correct Error";
        public static final String BLUEPRINT_NOT_FOUND_ERROR_MSG = "Problem Auto-correct Error: No blueprint was found!";
        public static final String MODEL_NOT_FOUND_ERROR_MSG = "Problem Auto-correct Error: No model was found!";
        public static final int NUMBER_OF_SURROUNDING_LINES_FOR_PROBLEMS = 3;
        public static final int MODEL_AVAILABILITY_TIMEOUT_SECONDS = 10;
        public static final int GET_BLUEPRINTS_FOR_PROBLEM_REQUEST_TIMEOUT_SECONDS = 10;
    }

    public static enum PropertyTester {
        INSTANCE;

        public static final String DVT_IS_AI_ENABLED = "isAIEnabled";
    }

    public static enum SessionTarget {
        INSTANCE;

        public static final String CHAT = "chat";
        public static final String EDITOR = "editor";
        public static final String CODE_COMPLETION = "code-completion";
        public static final String PROBLEM_AUTOCORRECT = "problem-autocorrect";
        public static final String VERISSIMO_AUTOCORRECT = "verissimo-autocorrect";
        public static final String PROBLEM_EXPLAIN = "problem-explain";
        public static final String VERISSIMO_HIT_EXPLAIN = "verissimo-hit-explain";
        public static final String SPECADOR_LIVE_PREVIEW = "specador-live-preview";
        public static final String COMMIT_MESSAGE = "git-source-control";
    }

    public static enum Settings {
        INSTANCE;

        public static final String LANGUAGE_MODELS = "DVT.AI.languageModels";
        public static final String EDITOR_INSERT_UNMODIFIED_REPLY = "DVT.AI.editor.insertUnmodifiedReply.enabled";
        public static final String ADD_GENERATED_CODE_WATERMARK = "DVT.AI.addGeneratedCodeWatermark.enabled";
        public static final String CLIPBOARD_SNIPPET = "DVT.AI.clipboardSnippet.enabled";
        public static final String CODE_COMPLETION = "DVT.AI.codeCompletion.enabled";
        public static final String TOOLTIP_MARKUP_LANGUAGE = "DVT.tooltips.markupLanguage";
        public static final String SEND_KEY_PREFERENCE = "DVT.AI.chat.prompt.sendKey";
    }

    public static enum SnippetNames {
        INSTANCE;

        public static final String LANGUAGE = "language";
        public static final String SELECTED = "selected";
        public static final String EXAMPLES_OF = "examples of";
        public static final String USAGES_OF = "usages of";
        public static final String RECENT_CODE_SECTIONS = "recent code sections";
        public static final String RECENT_CODE_SECTIONS_FROM_OPEN_EDITORS = "recent code sections from open editors";
        public static final String OUTLINE_OF = "outline of";
        public static final String FILENAME_OF = "filename of";
        public static final String SYMBOL = "symbol";
        public static final String DESIGN_HIERARCHY = "design hierarchy";
        public static final String VERIFICATION_HIERARCHY = "verification hierarchy";
        public static final String PROBLEMS_FROM_SELECTED = "problems from selected";
        public static final String DEPENDENCIES_OF = "dependencies of";
        public static final String CODE_BEFORE_SELECTION = "code before selection";
        public static final String CODE_AFTER_SELECTION = "code after selection";
        public static final String CLIPBOARD = "clipboard";
        public static final String KIND_OF_SELECTED_CONTAINER = "kind of selected container";
        public static final String NAME_OF_SELECTED_CONTAINER = "name of selected container";
    }

    public static enum SymbolRequests {
        INSTANCE;

        public static final String AUTOCOMPLETE = "Symbol autocomplete";
        public static final String SOLVING = "Symbol solving";
    }

    public static enum VerissimoAutocorrect {
        INSTANCE;

        public static final int VERISSIMO_AUTOCORRECT_FUTURE_TIMEOUT_MILISECONDS = 100;
    }
}

