/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.List;
import java.util.StringJoiner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public enum AIExpansionUtils {
    INSTANCE;

    private static final String TYPEDEF = "typedef";
    public static final String TICK_DEFINE = "`define";
    public static final String LIST_ITEMS_SEPARATOR = "\n\n";

    public CodeSnippet expandDefElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode, boolean includeAdditionalExpansions) {
        List<CodeSnippet> additionalExpansions;
        IRegion foldingRegion;
        int endLine;
        int startLine;
        String filePath;
        String code;
        IDocument document;
        IProject iProject;
        ParserPath parserPath;
        block17: {
            if (defElement == null) {
                return null;
            }
            parserPath = defElement.getParserPath();
            if (parserPath == null || parserPath.path == null) {
                return null;
            }
            IRfSingleLangProject rfProject = defElement.getRfProject();
            if (rfProject == null) {
                return null;
            }
            iProject = rfProject.getProject();
            document = AIUtils.getInstance().getDocumentFromPath(iProject, parserPath.path);
            if (document == null) {
                return null;
            }
            code = null;
            filePath = AIPathUtils.INSTANCE.makePathRelativeToProject(parserPath.path, iProject);
            startLine = -1;
            endLine = -1;
            foldingRegion = null;
            try {
                foldingRegion = DVTUtilsCommon.INSTANCE.getFoldingRegion(defElement, document, true);
                if (foldingRegion != null) break block17;
                return null;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        code = document.get(foldingRegion.getOffset(), foldingRegion.getLength());
        if (code == null || code.isEmpty()) {
            return null;
        }
        if (formatCode) {
            String indentedCode;
            String string = indentedCode = editor != null ? this.indentCodeSnippet(code, editor) : this.indentCodeSnippet(code, parserPath.path, iProject);
            if (indentedCode != null) {
                code = indentedCode;
            }
        }
        try {
            startLine = document.getLineOfOffset(foldingRegion.getOffset()) + 1;
            endLine = document.getLineOfOffset(foldingRegion.getOffset() + foldingRegion.getLength()) + 1;
            if (code.endsWith("\n")) {
                --endLine;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            startLine = -1;
            endLine = -1;
        }
        StringBuilder finalCode = new StringBuilder(code);
        if (includeAdditionalExpansions && (additionalExpansions = this.getAdditionalExpansionsForDefElement(defElement, editor, formatCode)) != null && !additionalExpansions.isEmpty()) {
            for (CodeSnippet additional : additionalExpansions) {
                finalCode.append(LIST_ITEMS_SEPARATOR).append(additional.getCode());
                if (filePath != null && !filePath.equals(additional.getFilePath())) {
                    filePath = null;
                    startLine = -1;
                    endLine = -1;
                }
                if (startLine > 0 && additional.getStartLine() > 0 && additional.getStartLine() < startLine) {
                    startLine = additional.getStartLine();
                }
                if (endLine <= 0 || additional.getEndLine() <= endLine) continue;
                endLine = additional.getEndLine();
            }
        }
        return new CodeSnippet(finalCode.toString(), filePath, startLine, endLine);
    }

    public CodeSnippet getNamedElementExpansionForSelectionType(IRfNamedElementAndScope namedElementAndScope, SnippetSelectionType selectionType, DVTEditor editor) {
        IRfNamedElement namedElement;
        LanguageKind languageKind = namedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        if (SnippetSelectionType.PORT_LIST.equals(selectionType)) {
            return this.getElementPortList(namedElementAndScope);
        }
        IRfDefElement defElement = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAcceptedContainers(selectionType), selectionType == SnippetSelectionType.ELEMENT);
        if (defElement == null) {
            return null;
        }
        String containerPath = AIUtils.getInstance().getFilePathFromDefElement(defElement, false);
        ParserPath parserPath = editor.getParserPath();
        IRfSingleLangProject containerRfProject = defElement.getRfProject();
        if (containerRfProject == null) {
            return null;
        }
        if (containerPath != null && parserPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, containerRfProject.getProject(), parserPath.path, editor.getProject())) {
            if (selectionType != SnippetSelectionType.CONTAINER) {
                return null;
            }
            namedElement = namedElementAndScope.getIRfNamedElement();
            if (!(namedElement instanceof IRfTypeAliasElement)) {
                return null;
            }
            if ((namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType()) == null || namedElement.getDeclaration() == null) {
                return null;
            }
            defElement = namedElement.getDeclaration();
        }
        if ((namedElement = defElement.getNamedElement()) instanceof IRfTypeAliasElement && (namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType()) != null) {
            defElement = namedElement.getDeclaration();
        }
        return this.getImplementationOrDeclarationExpandedForElement(defElement, editor, true, true);
    }

    public CodeSnippet expandArrayTypedef(IRfAssociatedTypeElement element) {
        String pathRelativeToProject;
        int endLine;
        int startLine;
        CodeSnippet result;
        block8: {
            if (element == null) {
                return null;
            }
            IRfNamedElement associatedType = element.getAssociatedType();
            if (associatedType == null) {
                return null;
            }
            StringBuilder code = new StringBuilder(TYPEDEF);
            code.append(" ").append(associatedType.getName()).append(" ");
            code.append(element.getName()).append(";");
            result = new CodeSnippet(code.toString(), null, -1, -1);
            String filePath = AIUtils.getInstance().getFilePathFromNamedElement((IRfNamedElement)element, false);
            if (filePath == null) {
                return result;
            }
            IRfSingleLangProject rfProject = element.getRfProject();
            if (rfProject == null) {
                return null;
            }
            IProject iProject = rfProject.getProject();
            IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
            if (document == null) {
                return result;
            }
            startLine = document.getLineOfOffset(element.getOffset()) + 1;
            endLine = document.getLineOfOffset(element.getEndOffset()) + 1;
            pathRelativeToProject = AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject);
            if (pathRelativeToProject != null) break block8;
            return null;
        }
        try {
            result.setFilePath(pathRelativeToProject);
            result.setStartLine(startLine);
            result.setEndLine(endLine);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public CodeSnippet getImplementationOrDeclarationExpandedForElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode, boolean includeAdditionalExpansions) {
        Object implementation;
        if (defElement == null) {
            return null;
        }
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (namedElement instanceof IRfPortElement) {
            return this.expandPortElement((IRfPortElement)namedElement);
        }
        if (namedElement != null && (implementation = namedElement.getImplementation()) instanceof IRfDefElement) {
            return this.expandDefElement((IRfDefElement)implementation, editor, formatCode, includeAdditionalExpansions);
        }
        return this.expandDefElement(defElement, editor, formatCode, includeAdditionalExpansions);
    }

    public CodeSnippet increaseEditorRange(EditorRange editorRange, int surroundingLines, boolean formatCode) {
        if (editorRange == null) {
            return null;
        }
        IFile file = editorRange.getFile();
        if (file == null) {
            return null;
        }
        IProject iProject = file.getProject();
        if (iProject == null) {
            return null;
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, editorRange.getFullPath());
        if (document == null) {
            return null;
        }
        int startLine = DVTFileUtils.getInstance().getLineFromOffset(file, editorRange.getStartOffset()) - surroundingLines - 1;
        int endLine = DVTFileUtils.getInstance().getLineFromOffset(file, editorRange.getEndOffset()) + surroundingLines - 1;
        try {
            int startOffset = startLine > 0 ? document.getLineOffset(startLine) : 0;
            int endOffset = endLine < document.getNumberOfLines() ? document.getLineOffset(endLine) + document.getLineLength(endLine) - 1 : document.getLength();
            String code = document.get(startOffset, endOffset - startOffset);
            if (formatCode) {
                code = this.indentCodeSnippet(code, editorRange.getFullPath(), iProject);
            }
            return new CodeSnippet(code, AIPathUtils.INSTANCE.makePathRelativeToProject(editorRange.getFullPath(), iProject), startLine + 1, endLine + 1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public CodeSnippet getFileContentAsCodeSnippet(String filePath, IProject iProject) {
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return null;
        }
        return new CodeSnippet(document.get(), AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject), -1, -1);
    }

    public String getDefElementTextBasedOnOffsets(IRfDefElement defElement) {
        if (defElement == null) {
            return "";
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return "";
        }
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return "";
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(rfProject.getProject(), parserPath.path);
        if (document == null) {
            return "";
        }
        try {
            return document.get(defElement.getStartOffset(), defElement.getEndOffset() - defElement.getStartOffset());
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public String indentCodeSnippet(String codeSnippet, DVTEditor editor) {
        if (codeSnippet == null || editor == null) {
            return codeSnippet;
        }
        DVTSourceViewerConfiguration config = editor.makeSourceViewerConfiguration();
        if (config == null) {
            return codeSnippet;
        }
        IDocument detectIndentationDocument = TestHelper.isTestMode() ? null : editor.getDocument();
        return this.indentWithTabSize(codeSnippet, config, editor.getTabWidth(), detectIndentationDocument);
    }

    public String indentCodeSnippet(String codeSnippet, String filePath, IProject iProject) {
        if (codeSnippet == null || filePath == null) {
            return codeSnippet;
        }
        if (iProject == null) {
            return codeSnippet;
        }
        String nature = AIUtils.getInstance().getNatureForFilePath(filePath, iProject);
        if (nature == null) {
            return codeSnippet;
        }
        DVTSourceViewerConfiguration config = RfMixedLangManager.getInstance().getSourceViewerConfigurationForFile(nature, iProject);
        if (config == null) {
            return codeSnippet;
        }
        IDocument detectIndentationDocument = TestHelper.isTestMode() ? null : CFUtils.getInstance().getDetectIndentationDocument(filePath);
        return this.indentWithTabSize(codeSnippet, config, AIUtils.getInstance().getTabSizeForFilePath(filePath), detectIndentationDocument);
    }

    private String indentWithTabSize(String codeSnippet, DVTSourceViewerConfiguration config, int tabSize, IDocument detectIndentationDoc) {
        if (TestHelper.isTestMode()) {
            tabSize = AIUtils.getInstance().getTabSizeFromPreferences();
        }
        config.setTabWidth(tabSize);
        codeSnippet = codeSnippet.replace("\r", "");
        String indented = Utils.indentString(() -> config, (String)DVTStringUtil.trimLeadingWhitespaces((String)codeSnippet, (int)Integer.MAX_VALUE), (IDocument)detectIndentationDoc, (String)"", (boolean)false);
        String finalResult = indented != null ? indented : codeSnippet;
        return TextUtils.replaceTabsWithSpaces((String)finalResult, (int)tabSize);
    }

    private List<CodeSnippet> getAdditionalExpansionsForDefElement(IRfDefElement defElement, DVTEditor editor, boolean formatCode) {
        IRfNamedElement namedElement = defElement.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        LanguageKind languageKind = namedElement.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        return aiContributor.getAdditionalExpansionsForDefElement(defElement, editor, formatCode);
    }

    private CodeSnippet getElementPortList(IRfNamedElementAndScope namedElementAndScope) {
        IRfScopeElement scope = namedElementAndScope.getScope();
        IRfDesignElement designElement = null;
        while (scope != null) {
            IRfNamedElement namedElement;
            if (scope instanceof IRfDesignElement) {
                designElement = (IRfDesignElement)scope;
                break;
            }
            if (scope instanceof IRfDefElement && (namedElement = ((IRfDefElement)scope).getNamedElement()) instanceof IRfDesignElement) {
                designElement = (IRfDesignElement)namedElement;
                break;
            }
            scope = scope.getEnclosingScope();
        }
        if (designElement == null) {
            return null;
        }
        List portList = designElement.getLocalPorts();
        if (portList == null || portList.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (IRfPortElement portElem : portList) {
            sb.append(portElem.getContextInformationSignature()).append(";\n");
        }
        return new CodeSnippet(sb.toString(), null, 0, 0);
    }

    private CodeSnippet expandPortElement(IRfPortElement portElement) {
        String signature = portElement.getSignature();
        if (signature == null) {
            return null;
        }
        String filePath = AIUtils.getInstance().getFilePathFromNamedElement((IRfNamedElement)portElement, false);
        if (filePath == null) {
            return new CodeSnippet(signature, null, -1, -1);
        }
        IRfSingleLangProject rfProject = portElement.getRfProject();
        if (rfProject == null) {
            return new CodeSnippet(signature, null, -1, -1);
        }
        IProject iProject = rfProject.getProject();
        if (iProject == null) {
            return new CodeSnippet(signature, null, -1, -1);
        }
        IDocument document = AIUtils.getInstance().getDocumentFromPath(iProject, filePath);
        if (document == null) {
            return new CodeSnippet(signature, null, -1, -1);
        }
        try {
            int startLine = document.getLineOfOffset(portElement.getOffset()) + 1;
            int endLine = document.getLineOfOffset(portElement.getEndOffset()) + 1;
            return new CodeSnippet(signature, AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject), startLine, endLine);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new CodeSnippet(signature, null, -1, -1);
        }
    }

    public String getLocationsFromCodeSnippets(List<CodeSnippet> codeSnippets) {
        StringJoiner joiner = new StringJoiner(LIST_ITEMS_SEPARATOR);
        for (CodeSnippet codeSnippet : codeSnippets) {
            String locationString = codeSnippet.getLocationString();
            if (locationString == null) continue;
            joiner.add(locationString);
        }
        return joiner.toString();
    }
}

