/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ltk.core.refactoring.PerformRefactoringOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProgressIndicatorManager;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AISnippetSolver;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.BooleanContextClauses;
import ro.amiq.dvt.ai.ChatManager;
import ro.amiq.dvt.ai.ChatSendKeyPref;
import ro.amiq.dvt.ai.CodeActionExecutor;
import ro.amiq.dvt.ai.EditorManager;
import ro.amiq.dvt.ai.EditorSession;
import ro.amiq.dvt.ai.GitManager;
import ro.amiq.dvt.ai.HotspotManager;
import ro.amiq.dvt.ai.ModelsManager;
import ro.amiq.dvt.ai.incremental.AIIncrementalBuildManager;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.CodeSnippetList;
import ro.amiq.dvt.ai.model.Dependency;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.FileDetails;
import ro.amiq.dvt.ai.model.FileEdit;
import ro.amiq.dvt.ai.model.FileStats;
import ro.amiq.dvt.ai.model.MultiRootTree;
import ro.amiq.dvt.ai.model.OutlineResult;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AIInternalErrorException;
import ro.amiq.dvt.ai.model.exceptions.AINoEditorException;
import ro.amiq.dvt.ai.model.exceptions.AINoSelectionException;
import ro.amiq.dvt.ai.model.exceptions.AIProtectException;
import ro.amiq.dvt.ai.model.exceptions.AISnippetExpansionFailureException;
import ro.amiq.dvt.ai.model.exceptions.AISymbolExpansionFailureException;
import ro.amiq.dvt.ai.model.params.ApplyFileEditsParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStartParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStopParams;
import ro.amiq.dvt.ai.model.params.AssistantMessageStreamParams;
import ro.amiq.dvt.ai.model.params.CreateDirectoryParams;
import ro.amiq.dvt.ai.model.params.ExecuteCodeActionHostParams;
import ro.amiq.dvt.ai.model.params.FindFilesParams;
import ro.amiq.dvt.ai.model.params.FrontPageChangedParams;
import ro.amiq.dvt.ai.model.params.GetActiveEditorInfoParams;
import ro.amiq.dvt.ai.model.params.GetEnvVarParams;
import ro.amiq.dvt.ai.model.params.GetFullPathParams;
import ro.amiq.dvt.ai.model.params.GetLanguageInfoParams;
import ro.amiq.dvt.ai.model.params.GetSettingValueParams;
import ro.amiq.dvt.ai.model.params.GetSymbolsForAutocompleteParams;
import ro.amiq.dvt.ai.model.params.GetValidSymbolsParams;
import ro.amiq.dvt.ai.model.params.InsertCommitMessageParams;
import ro.amiq.dvt.ai.model.params.InvokeToolParams;
import ro.amiq.dvt.ai.model.params.IsFileProtectedParams;
import ro.amiq.dvt.ai.model.params.LogParams;
import ro.amiq.dvt.ai.model.params.LogWithActionsParams;
import ro.amiq.dvt.ai.model.params.ModifySettingValueParams;
import ro.amiq.dvt.ai.model.params.OpenFileEditDiffParams;
import ro.amiq.dvt.ai.model.params.OpenFileParams;
import ro.amiq.dvt.ai.model.params.PrepareInvokeToolParams;
import ro.amiq.dvt.ai.model.params.PrepareInvokeToolResponse;
import ro.amiq.dvt.ai.model.params.ReadFileParams;
import ro.amiq.dvt.ai.model.params.SSCodeBeforeAfterSelectionParams;
import ro.amiq.dvt.ai.model.params.SSDHVHContextParams;
import ro.amiq.dvt.ai.model.params.SSDependenciesOfSelectedParams;
import ro.amiq.dvt.ai.model.params.SSDependenciesOfSymbolParams;
import ro.amiq.dvt.ai.model.params.SSEditorsHotspotsParams;
import ro.amiq.dvt.ai.model.params.SSExamplesOfParams;
import ro.amiq.dvt.ai.model.params.SSOutlineOfSelectedParams;
import ro.amiq.dvt.ai.model.params.SSProblemsFromSelectedParams;
import ro.amiq.dvt.ai.model.params.SSSelectedParams;
import ro.amiq.dvt.ai.model.params.SSSymbolFilenameParams;
import ro.amiq.dvt.ai.model.params.SSSymbolOutlineParams;
import ro.amiq.dvt.ai.model.params.SSSymbolOutlineResponse;
import ro.amiq.dvt.ai.model.params.SSSymbolParams;
import ro.amiq.dvt.ai.model.params.SSUsagesOfParams;
import ro.amiq.dvt.ai.model.params.ShowCurrentModelInfoParams;
import ro.amiq.dvt.ai.model.params.ShowDropdownPickerParams;
import ro.amiq.dvt.ai.model.params.ShowHostSessionParams;
import ro.amiq.dvt.ai.model.params.ShowInputBoxParams;
import ro.amiq.dvt.ai.model.params.ShowProtectedFileAccessParams;
import ro.amiq.dvt.ai.model.params.SolveSymbolParams;
import ro.amiq.dvt.ai.model.params.StartProgressIndicatorParams;
import ro.amiq.dvt.ai.model.params.UpdateAcknowledgmentStateParams;
import ro.amiq.dvt.ai.model.params.WaitForIncrementalParams;
import ro.amiq.dvt.ai.model.params.WriteFileParams;
import ro.amiq.dvt.ai.model.responses.ApplyFileEditsResponse;
import ro.amiq.dvt.ai.model.responses.CopilotModelsResponse;
import ro.amiq.dvt.ai.model.responses.CreateDirectoryResponse;
import ro.amiq.dvt.ai.model.responses.FindFilesResponse;
import ro.amiq.dvt.ai.model.responses.GetActiveEditorInfoResponse;
import ro.amiq.dvt.ai.model.responses.GetEnvVarResponse;
import ro.amiq.dvt.ai.model.responses.GetFullPathResponse;
import ro.amiq.dvt.ai.model.responses.GetLanguageInfoResponse;
import ro.amiq.dvt.ai.model.responses.GetMCPToolsResponse;
import ro.amiq.dvt.ai.model.responses.GetOpenFilesResponse;
import ro.amiq.dvt.ai.model.responses.GetProjectEnvResponse;
import ro.amiq.dvt.ai.model.responses.GetProjectPathResponse;
import ro.amiq.dvt.ai.model.responses.GetSettingValueResponse;
import ro.amiq.dvt.ai.model.responses.GetSymbolsForAutocompleteResponse;
import ro.amiq.dvt.ai.model.responses.GetValidSymbolsResponse;
import ro.amiq.dvt.ai.model.responses.InsertCommitMessageResponse;
import ro.amiq.dvt.ai.model.responses.InvokeToolResponse;
import ro.amiq.dvt.ai.model.responses.IsFileProtectedResponse;
import ro.amiq.dvt.ai.model.responses.LogWithActionsResponse;
import ro.amiq.dvt.ai.model.responses.OpenFileResponse;
import ro.amiq.dvt.ai.model.responses.ReadFileResponse;
import ro.amiq.dvt.ai.model.responses.SSClipboardResponse;
import ro.amiq.dvt.ai.model.responses.SSCodeBeforeAfterSelectionResponse;
import ro.amiq.dvt.ai.model.responses.SSDependenciesOfResponse;
import ro.amiq.dvt.ai.model.responses.SSFilenameOfSelectedFileResonse;
import ro.amiq.dvt.ai.model.responses.SSKindOfSelectedContainerResponse;
import ro.amiq.dvt.ai.model.responses.SSLanguageResponse;
import ro.amiq.dvt.ai.model.responses.SSNameOfSelectedContainerResponse;
import ro.amiq.dvt.ai.model.responses.SSProblemsFromSelectedResponse;
import ro.amiq.dvt.ai.model.responses.SSSymbolFilenameResponse;
import ro.amiq.dvt.ai.model.responses.ShowDropdownPickerResponse;
import ro.amiq.dvt.ai.model.responses.ShowHostSessionResponse;
import ro.amiq.dvt.ai.model.responses.ShowInputBoxResponse;
import ro.amiq.dvt.ai.model.responses.WaitForIncrementalResponse;
import ro.amiq.dvt.ai.model.responses.WriteFileResponse;
import ro.amiq.dvt.ai.tools.AITool;
import ro.amiq.dvt.ai.tools.AIToolsRegistry;
import ro.amiq.dvt.ai.tools.AIToolsRegistryCommon;
import ro.amiq.dvt.ai.ui.refactoring.DVTReplaceRefactoringFactory;
import ro.amiq.dvt.ai.ui.refactoring.ProblemAutocorrectRefactoringWizard;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.compare.CompareInput;
import ro.amiq.dvt.ui.compare.FileCompareInputPart;
import ro.amiq.dvt.ui.compare.ICompareInputPart;
import ro.amiq.dvt.ui.compare.TextCompareInputPart;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.refactor.replace.DVTReplaceRefactoring;
import ro.amiq.dvt.ui.utils.StringEditorUtils;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.wizards.specador.SpecadorPreviewListener;

public enum AIHostAPI {
    INSTANCE;


    public GetEnvVarResponse getEnvVar(BooleanSupplier isCanceled, GetEnvVarParams params) {
        try {
            return new GetEnvVarResponse(System.getenv(params.variable));
        }
        catch (Exception exception) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to get '" + params.variable + "' envvar!", 0));
        }
    }

    public void log(LogParams params) {
        AIUtils.getInstance().writeToAiConsole(params.target, params.message, params.severity, params.popup);
    }

    public LogWithActionsResponse logWithActions(BooleanSupplier isCanceled, LogWithActionsParams params) {
        String pressedButton = null;
        try {
            pressedButton = AIUtils.getInstance().writeToAiConsoleWithActions(params.target, params.message, params.severity, params.popup, params.actions);
        }
        catch (InterruptedException | ExecutionException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new LogWithActionsResponse(pressedButton);
    }

    public void executeCodeAction(ExecuteCodeActionHostParams params) {
        CodeActionExecutor.INSTANCE.executeCodeAction(params);
    }

    public ShowHostSessionResponse showSession(BooleanSupplier isCanceled, ShowHostSessionParams params) {
        ShowHostSessionResponse response = new ShowHostSessionResponse();
        boolean sessionStarted = "specador-live-preview".equals(params.hostTarget) || EditorManager.INSTANCE.startEditorSession(params);
        response.status = sessionStarted ? "OK" : "ERROR";
        return response;
    }

    public void frontPageChanged(FrontPageChangedParams params) {
        if (params.getToFrontPage().equals("Chat")) {
            BooleanContextClauses.IS_CONVERSATION_DISPLAYED.updateValue(true);
        } else if (params.getToFrontPage().equals("History")) {
            BooleanContextClauses.IS_CONVERSATION_DISPLAYED.updateValue(false);
        }
    }

    public void showProtectedFileAccessNotification(BooleanSupplier isCanceled, ShowProtectedFileAccessParams params) {
        AIUtils.getInstance().showProtectedFileAccessNotification(params.fileName, params.protectFileLine);
    }

    public void focusChat() {
        ChatManager.INSTANCE.focusChat();
    }

    public FindFilesResponse findFiles(BooleanSupplier isCanceled, final FindFilesParams params) {
        final FindFilesResponse findFilesResponse = new FindFilesResponse();
        try {
            java.nio.file.Path absolutePath = null;
            String patternWithSpecialCharactersReplaced = DVTFileUtils.getInstance().replaceSpecialCharactersInGlobPattern(params.glob);
            java.nio.file.Path globPath = Paths.get(patternWithSpecialCharactersReplaced, new String[0]);
            switch (params.cwd) {
                case "projectDir": {
                    java.nio.file.Path selectedProjectPath = Utils.getActiveProjectPath();
                    if (selectedProjectPath == null) {
                        return findFilesResponse;
                    }
                    absolutePath = selectedProjectPath.resolve(globPath);
                    break;
                }
                case "rootDir": {
                    absolutePath = globPath.toAbsolutePath();
                    break;
                }
                default: {
                    return findFilesResponse;
                }
            }
            int firstWildcardSegment = 0;
            int i = 0;
            while (i < absolutePath.getNameCount()) {
                if (absolutePath.getName(i).toString().contains("STAR_CHARACTER_REPLACEMENT") || absolutePath.getName(i).toString().contains("QUESTION_MARK_CHARACTER_REPLACEMENT")) {
                    firstWildcardSegment = i;
                    break;
                }
                ++i;
            }
            java.nio.file.Path baseDirPath = absolutePath;
            if (firstWildcardSegment != 0) {
                baseDirPath = absolutePath.subpath(0, firstWildcardSegment);
            }
            baseDirPath = absolutePath.getRoot().resolve(baseDirPath);
            FileSystem fileSystem = FileSystems.getDefault();
            String absolutePathString = absolutePath.toString();
            if (DVTFileUtils.getInstance().pathStartsWithADriveLetter(absolutePathString)) {
                absolutePathString = absolutePathString.replace("\\", "\\\\");
            }
            final PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:" + DVTFileUtils.getInstance().undoSpecialCharactersInGlobPatternReplacement(absolutePathString));
            Files.walkFileTree(baseDirPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes attrs) throws IOException {
                    if (pathMatcher.matches(path)) {
                        if ("file".equals(params.kind) && attrs.isDirectory()) {
                            return FileVisitResult.CONTINUE;
                        }
                        FileDetails fileDetails = new FileDetails(path.toString());
                        if (params.stats) {
                            FileStats stats = new FileStats();
                            stats.kind = attrs.isDirectory() ? "directory" : "file";
                            stats.mtime = attrs.lastModifiedTime().toMillis();
                            stats.size = attrs.size();
                            fileDetails.stats = stats;
                        }
                        findFilesResponse.files.add(fileDetails);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return findFilesResponse;
    }

    public GetProjectPathResponse getProjectPath(BooleanSupplier isCanceled) {
        java.nio.file.Path activeProjectPath = Utils.getActiveProjectPath();
        if (activeProjectPath == null) {
            return null;
        }
        return new GetProjectPathResponse(activeProjectPath.toString());
    }

    public GetFullPathResponse getFullPath(BooleanSupplier isCanceled, GetFullPathParams params) {
        List<String> fullPaths;
        java.nio.file.Path filePath = null;
        filePath = !params.fileNameOrPath.contains(File.separator) ? ((fullPaths = AISymbolSolver.INSTANCE.getFullPathsFromCompiledFileQuery(String.valueOf(SymbolQueryKey.FILE.toString()) + ":" + SymbolQueryUtils.makeExactPattern((String)params.fileNameOrPath), AIUtils.getInstance().getSelectedProject(), isCanceled)) != null && !fullPaths.isEmpty() ? AIUtils.getInstance().resolveFilePath(fullPaths.get(0)) : AIUtils.getInstance().resolveFilePath(params.fileNameOrPath)) : AIUtils.getInstance().resolveFilePath(params.fileNameOrPath);
        return filePath == null ? null : new GetFullPathResponse(filePath.toString());
    }

    public ReadFileResponse readFile(BooleanSupplier isCanceled, ReadFileParams params) {
        ReadFileResponse response = new ReadFileResponse();
        java.nio.file.Path filePath = null;
        try {
            List<String> fullPaths;
            filePath = !params.fileNameOrPath.contains(File.separator) ? ((fullPaths = AISymbolSolver.INSTANCE.getFullPathsFromCompiledFileQuery(String.valueOf(SymbolQueryKey.FILE.toString()) + ":" + SymbolQueryUtils.makeExactPattern((String)params.fileNameOrPath), AIUtils.getInstance().getSelectedProject(), isCanceled)) != null && !fullPaths.isEmpty() ? AIUtils.getInstance().resolveFilePath(fullPaths.get(0)) : AIUtils.getInstance().resolveFilePath(params.fileNameOrPath)) : AIUtils.getInstance().resolveFilePath(params.fileNameOrPath);
            if (filePath == null) {
                throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to read '" + params.fileNameOrPath + "' file!", 0));
            }
            byte[] bytes = Files.readAllBytes(filePath);
            response.content = new String(bytes);
            response.fullPath = filePath.toString();
            return response;
        }
        catch (Exception exception) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to read '" + params.fileNameOrPath + "' file!", 0));
        }
    }

    public WriteFileResponse writeFile(BooleanSupplier isCanceled, WriteFileParams params) {
        WriteFileResponse response = new WriteFileResponse();
        IProject selectedProject = AIUtils.getInstance().getSelectedProject();
        try {
            ApplyFileEditsParams fileEditsParams;
            java.nio.file.Path filePath;
            List<String> fullPaths;
            if (params.content == null) {
                throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to write '" + params.fileNameOrPath + "' file!", 0));
            }
            String filePathOrName = params.fileNameOrPath;
            if (!filePathOrName.contains(File.separator) && (fullPaths = AISymbolSolver.INSTANCE.getFullPathsFromCompiledFileQuery(String.valueOf(SymbolQueryKey.FILE.toString()) + ":" + SymbolQueryUtils.makeExactPattern((String)params.fileNameOrPath), selectedProject, isCanceled)) != null && !fullPaths.isEmpty()) {
                filePathOrName = fullPaths.get(0);
            }
            if ((filePath = Paths.get(filePathOrName, new String[0])).toFile().exists() && params.writeInDocument && (fileEditsParams = this.getFileEditsParamsFromWriteFileParams(filePath.toString(), params.content, selectedProject)) != null) {
                ApplyFileEditsResponse fileEditResponse = this.applyEditsNoPreview(fileEditsParams, isCanceled);
                if (fileEditResponse.result == ApplyFileEditsResponse.ApplyFileEditsResult.SUCCESS) {
                    response.fullPath = filePath.toString();
                    return response;
                }
            }
            if (!filePath.isAbsolute()) {
                IFile projectFile;
                block30: {
                    projectFile = selectedProject.getFile((IPath)new Path(params.fileNameOrPath));
                    if (!projectFile.exists()) {
                        IContainer parent = projectFile.getParent();
                        if (parent instanceof IFolder && !parent.exists()) {
                            ((IFolder)parent).create(true, true, null);
                        }
                        Throwable throwable = null;
                        Object var10_14 = null;
                        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(params.content.getBytes());){
                            projectFile.create((InputStream)inputStream, true, null);
                            break block30;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (ByteArrayInputStream inputStream = new ByteArrayInputStream(params.content.getBytes());){
                        projectFile.setContents((InputStream)inputStream, true, true, null);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                response.fullPath = projectFile.getLocation().toOSString();
            } else {
                filePath = AIUtils.getInstance().resolveFilePath(filePathOrName);
                if (filePath == null) {
                    throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to write '" + params.fileNameOrPath + "' file!", 0));
                }
                java.nio.file.Path parentDir = filePath.getParent();
                if (parentDir != null) {
                    Files.createDirectories(parentDir, new FileAttribute[0]);
                }
                Files.write(filePath, params.content.getBytes(), new OpenOption[0]);
                response.fullPath = filePath.toString();
            }
            return response;
        }
        catch (Exception exception) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to write '" + params.fileNameOrPath + "' file!", 0));
        }
    }

    public OpenFileResponse openFile(BooleanSupplier isCanceled, OpenFileParams params) {
        OpenFileResponse response;
        block9: {
            response = new OpenFileResponse();
            try {
                if (params.content != null && params.titlePrefix != null) {
                    String editorTitle = String.valueOf(params.titlePrefix) + " (" + AIUtils.getInstance().getMd5Hash(params.content) + ")";
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> StringEditorUtils.INSTANCE.openString(editorTitle, openFileParams.content));
                    response.success = true;
                }
                if (params.filePath == null) break block9;
                java.nio.file.Path filePath = AIUtils.getInstance().resolveFilePath(params.filePath);
                if (filePath == null) {
                    return response;
                }
                File file = filePath.toFile();
                if (file == null || !file.exists()) {
                    return response;
                }
                if (params.lineNumber <= 0) {
                    DVTFileUtils.getInstance().openEditor(file, 0);
                    response.success = true;
                    return response;
                }
                int offset = 0;
                IDocument document = AIUtils.getInstance().getDocumentFromPath(AIUtils.getInstance().getSelectedProject(), filePath.toString());
                if (document != null) {
                    try {
                        offset = document.getLineOffset(params.lineNumber - 1);
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                DVTFileUtils.getInstance().openEditorWithOffset(file, offset, 0, true, "org.eclipse.ui.DefaultTextEditor");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return response;
    }

    public GetOpenFilesResponse getOpenFiles(BooleanSupplier isCanceled) {
        String activeEditorPath = AIUtils.getInstance().getActiveEditorFullPath();
        Set<String> openEditorsPaths = HotspotManager.getInstance().getOpenEditorsNormalizedPaths();
        if (openEditorsPaths == null || openEditorsPaths.isEmpty()) {
            return null;
        }
        GetOpenFilesResponse response = new GetOpenFilesResponse();
        response.openFiles = new ArrayList<GetOpenFilesResponse.UIOpenFile>();
        openEditorsPaths.stream().sorted().forEach(openFilePath -> {
            boolean bl = getOpenFilesResponse.openFiles.add(new GetOpenFilesResponse.UIOpenFile((String)openFilePath, openFilePath.equals(activeEditorPath)));
        });
        return response;
    }

    public CreateDirectoryResponse createDirectory(BooleanSupplier isCanceled, CreateDirectoryParams params) {
        CreateDirectoryResponse response = new CreateDirectoryResponse();
        try {
            java.nio.file.Path dirPath = Paths.get(params.path, new String[0]);
            if (!dirPath.isAbsolute()) {
                IProject selectedProject = AIUtils.getInstance().getSelectedProject();
                IFolder folder = selectedProject.getFolder((IPath)new Path(params.path));
                if (!folder.exists()) {
                    AIUtils.getInstance().createFolderRecursively(folder);
                }
            } else {
                dirPath = AIUtils.getInstance().resolveFilePath(params.path);
                if (dirPath == null) {
                    throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to delete '" + params.path + "' directory!", 0));
                }
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            response.success = true;
            return response;
        }
        catch (Exception exception) {
            throw new AIInternalErrorException(new AIExceptionData(AIExceptionKind.INTERNAL_ERROR.KIND, "Failed to delete '" + params.path + "' directory!", 0));
        }
    }

    public Void startListeningForIncrementals(BooleanSupplier isCanceled) {
        AIIncrementalBuildManager.INSTANCE.startListening();
        return null;
    }

    public Void openFileEditDiff(BooleanSupplier isCanceled, OpenFileEditDiffParams params) {
        IFile iFile;
        ICompareInputPart[] inputParts = new ICompareInputPart[2];
        String fileName = Utils.getFileName((String)params.filePath);
        String contentType = BaseUtils.getFileExtension((String)fileName);
        if (!params.readOnly && (iFile = DVTFileUtils.getInstance().findProjectFile(AIUtils.getInstance().getSelectedProject(), params.filePath)) != null) {
            inputParts[0] = new FileCompareInputPart(iFile);
        }
        if (inputParts[0] == null) {
            inputParts[0] = new TextCompareInputPart(contentType, params.newContent, String.valueOf(fileName) + (params.fromToolEditDiffButton ? " (after edit)" : ""));
        }
        inputParts[1] = new TextCompareInputPart(contentType, params.oldContent, String.valueOf(fileName) + (params.fromToolEditDiffButton ? " (before edit)" : ""));
        Display.getDefault().syncExec(() -> {
            CompareInput compareInput = new CompareInput(inputParts[0], inputParts[1], openFileEditDiffParams.diffTitle);
            CompareUI.openCompareEditor((CompareEditorInput)compareInput);
        });
        return null;
    }

    public IsFileProtectedResponse isFileProtected(BooleanSupplier isCanceled, IsFileProtectedParams params) {
        String fullPath;
        IProject iProject;
        block3: {
            try {
                iProject = AIUtils.getInstance().getSelectedProject();
                fullPath = AIPathUtils.INSTANCE.getAbsolutePathFromFileNameOrPath(params.fileNameOrPath, iProject, isCanceled);
                if (fullPath != null) break block3;
                return null;
            }
            catch (AIProtectException aIProtectException) {
                return new IsFileProtectedResponse(true);
            }
        }
        return new IsFileProtectedResponse(AIProtectManager.INSTANCE.isFileProtected(fullPath, iProject));
    }

    public GetProjectEnvResponse getProjectEnv(BooleanSupplier isCanceled) {
        return new GetProjectEnvResponse(null);
    }

    public WaitForIncrementalResponse waitForIncremental(BooleanSupplier isCanceled, WaitForIncrementalParams params) {
        boolean success = AIIncrementalBuildManager.INSTANCE.waitForIncremental(params.filePath, params.timeoutMillis);
        return new WaitForIncrementalResponse(success);
    }

    public ApplyFileEditsResponse applyFileEdits(BooleanSupplier isCanceled, ApplyFileEditsParams params) {
        if (!params.showPreview) {
            return this.applyEditsNoPreview(params, isCanceled);
        }
        DVTReplaceRefactoringFactory factory = new DVTReplaceRefactoringFactory(params, "Problem Auto-correct", "Problem Auto-correct Changes");
        if (factory.refactoringPerformsSingleFileEdits()) {
            return this.applyEditsEditorSessionStrategy(factory, isCanceled);
        }
        return this.applyEditsRefactorPreviewStrategy((Refactoring)factory.createDVTReplaceRefactoring(), isCanceled);
    }

    public InsertCommitMessageResponse insertCommitMessage(BooleanSupplier isCanceled, InsertCommitMessageParams params) {
        return GitManager.INSTANCE.insertCommitMessage(isCanceled, params.commitMessage);
    }

    private ApplyFileEditsParams getFileEditsParamsFromWriteFileParams(String fullPath, String newContent, IProject project) {
        IDocument document = AIUtils.getInstance().getDocumentFromPath(project, fullPath);
        if (document == null) {
            return null;
        }
        FileEdit fileEdit = new FileEdit(fullPath, 1, document.getNumberOfLines(), newContent);
        return new ApplyFileEditsParams(Arrays.asList(fileEdit), false);
    }

    private ApplyFileEditsResponse applyEditsNoPreview(ApplyFileEditsParams params, BooleanSupplier isCanceled) {
        DVTReplaceRefactoringFactory factory = new DVTReplaceRefactoringFactory(params, "Edit File tool", "Edit File tool Changes");
        DVTReplaceRefactoring refactoring = factory.createDVTReplaceRefactoring();
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        if (isCanceled.getAsBoolean()) {
            return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.CANCEL);
        }
        try {
            op.run(null);
            RefactoringStatus status = op.getConditionStatus();
            if (status != null && status.hasFatalError()) {
                return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
            }
        }
        catch (CoreException coreException) {
            return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
        }
        return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.SUCCESS);
    }

    private ApplyFileEditsResponse applyEditsEditorSessionStrategy(DVTReplaceRefactoringFactory factory, BooleanSupplier isCanceled) {
        DVTReplaceRefactoring refactoring = factory.createDVTReplaceRefactoring();
        PerformRefactoringOperation op = new PerformRefactoringOperation((Refactoring)refactoring, 6);
        IFile file = refactoring.getFile(AIUtils.getInstance().getSelectedProject(), factory.getSingleFileChanges());
        IDocument document = AIUtils.getInstance().getDocumentFromFile(file);
        String initialContent = document.get();
        if (isCanceled.getAsBoolean()) {
            return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.CANCEL);
        }
        try {
            op.run(null);
            RefactoringStatus status = op.getConditionStatus();
            if (status != null && status.hasFatalError()) {
                return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
            }
        }
        catch (CoreException coreException) {
            return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
        }
        Display.getDefault().asyncExec(() -> {
            FileCompareInputPart left = new FileCompareInputPart(file);
            TextCompareInputPart right = new TextCompareInputPart(left.getType(), initialContent);
            CompareInput compareInput = new CompareInput((ICompareInputPart)left, (ICompareInputPart)right);
            CompareUI.openCompareEditor((CompareEditorInput)compareInput);
        });
        return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.SUCCESS);
    }

    private ApplyFileEditsResponse applyEditsRefactorPreviewStrategy(Refactoring refactoring, BooleanSupplier isCanceled) {
        ProblemAutocorrectRefactoringWizard wizard = new ProblemAutocorrectRefactoringWizard(refactoring);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        if (isCanceled.getAsBoolean()) {
            return new ApplyFileEditsResponse(ApplyFileEditsResponse.ApplyFileEditsResult.CANCEL);
        }
        AtomicReference<ApplyFileEditsResponse.ApplyFileEditsResult> result = new AtomicReference<ApplyFileEditsResponse.ApplyFileEditsResult>();
        result.set(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec(() -> {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            try {
                this.stopProgressIndicator();
                int status = op.run(window.getShell(), "Problem Auto-correct");
                switch (status) {
                    case 1025: {
                        result.set(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
                        break;
                    }
                    case 1: {
                        result.set(ApplyFileEditsResponse.ApplyFileEditsResult.CANCEL);
                        break;
                    }
                    case 0: {
                        result.set(ApplyFileEditsResponse.ApplyFileEditsResult.SUCCESS);
                        break;
                    }
                    default: {
                        result.set(ApplyFileEditsResponse.ApplyFileEditsResult.ERROR);
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                result.set(ApplyFileEditsResponse.ApplyFileEditsResult.CANCEL);
            }
        });
        return new ApplyFileEditsResponse((ApplyFileEditsResponse.ApplyFileEditsResult)result.get());
    }

    public GetMCPToolsResponse getMCPTools(BooleanSupplier isCanceled) {
        return new GetMCPToolsResponse(AIToolsRegistry.getTools(false).stream().map(t -> AIToolsRegistryCommon.convertTool(t)).toList());
    }

    public InvokeToolResponse invokeTool(BooleanSupplier isCanceled, InvokeToolParams params) {
        AITool tool = AIToolsRegistry.getTools(true).stream().filter(t -> t.getName().equals(params.getToolName())).findFirst().orElse(null);
        if (tool == null) {
            return null;
        }
        return new InvokeToolResponse(tool.validateInputAndInvoke(isCanceled, params.getInput()));
    }

    public PrepareInvokeToolResponse prepareInvokeTool(BooleanSupplier isCanceled, PrepareInvokeToolParams params) {
        AITool tool = AIToolsRegistry.getTools(true).stream().filter(t -> t.getName().equals(params.getToolName())).findFirst().orElse(null);
        if (tool == null) {
            return null;
        }
        return tool.prepareInvoke(isCanceled, params.getInput());
    }

    public CodeSnippet solveSnippetSelected(BooleanSupplier isCanceled, SSSelectedParams params) {
        ITextSelection textSelection;
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (AIUtils.getInstance().isPromptExpansionEditor(activeEditor)) {
            return AISnippetSolver.getInstance().solveSnippetSelectedInsidePromptExpansionEditor((ITextEditor)activeEditor, params.selectionType, params.indicateCursorPosition);
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        String filePath = iPath.toOSString();
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(filePath, editorFile.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(iPath.toOSString(), protectFileLine);
        }
        if ((textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor)) == null || textSelection.getOffset() < 0) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        switch (params.selectionType) {
            case FILE: {
                String fileContentWithCursorPositionMarked;
                String fileContent = DVTFileUtils.getInstance().readFileContent(editorFile);
                if (params.indicateCursorPosition && (fileContentWithCursorPositionMarked = AIUtils.getInstance().getEditorContentWithCursorPosition(activeEditor, textSelection)) != null) {
                    fileContent = fileContentWithCursorPositionMarked;
                }
                return new CodeSnippet(fileContent, AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, editorFile.getProject()), -1, -1);
            }
            case CODE: {
                String selectedCode = textSelection.getText();
                if (params.indicateCursorPosition) {
                    selectedCode = AIUtils.getInstance().addCursorIndicatorToSelection(selectedCode, activeEditor);
                }
                selectedCode = AIExpansionUtils.INSTANCE.indentCodeSnippet(selectedCode, activeEditor instanceof DVTEditor ? (DVTEditor)activeEditor : null);
                return new CodeSnippet(selectedCode, AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, editorFile.getProject()), textSelection.getStartLine() + 1, textSelection.getEndLine() + 1);
            }
            case CONTAINER: 
            case ELEMENT: 
            case ACTION_BLOCK: 
            case METHOD: 
            case PORT_LIST: 
            case CLASS: 
            case MODULE: 
            case INTERFACE: 
            case PACKAGE: 
            case ENTITY: 
            case ARCHITECTURE: 
            case CONFIGURATION: 
            case UNIT: 
            case STRUCT: {
                EditorPosition editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
                CodeSnippet result = AISnippetSolver.getInstance().solveSnippetSelected(editorPosition, params.selectionType, params.indicateCursorPosition, activeEditor instanceof DVTEditor ? (DVTEditor)activeEditor : null, isCanceled);
                if (result == null) {
                    throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "selected"), 1));
                }
                return result;
            }
        }
        return null;
    }

    public CodeSnippetList solveSnippetExamplesOf(BooleanSupplier isCanceled, SSExamplesOfParams params) {
        CodeSnippetList response = new CodeSnippetList();
        List<CodeSnippet> results = AISnippetSolver.getInstance().solveSnippetExamplesOf(params.getType(), params.getMaxNumberOfExamples(), AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "examples of"), 1));
        }
        response.setCodeSnippets(results);
        return response;
    }

    public CodeSnippetList solveSnippetUsagesOf(BooleanSupplier isCanceled, SSUsagesOfParams params) {
        List<CodeSnippet> results;
        CodeSnippetList response = new CodeSnippetList();
        EditorPosition editorPosition = null;
        if (params.symbolName == null || params.symbolName.isEmpty()) {
            IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
            if (!(activeEditor instanceof DVTEditor)) {
                throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
            }
            IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
            if (editorFile == null) {
                throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
            }
            ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
            if (textSelection == null) {
                throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
            }
            editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
        }
        if ((results = AISnippetSolver.getInstance().solveSnippetUsagesOf(params.symbolName, editorPosition, params.maxNumberOfUsages, params.surroundingLines, AIUtils.getInstance().getSelectedProject(), isCanceled)) == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "usages of"), 1));
        }
        response.setCodeSnippets(results);
        return response;
    }

    public OutlineResult solveSnippetOutlineOfSelected(BooleanSupplier isCanceled, SSOutlineOfSelectedParams params) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ParserPath parserPath = ((DVTEditor)activeEditor).getParserPath();
        if (parserPath == null || parserPath.path == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        EditorPosition editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
        OutlineResult result = AISnippetSolver.getInstance().solveSnippetOutlineOfSelected(params.selectedType, editorPosition, isCanceled);
        if (result == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "outline of"), 1));
        }
        return result;
    }

    public SSSymbolOutlineResponse solveSnippetSymbolOutline(BooleanSupplier isCanceled, SSSymbolOutlineParams params) {
        SSSymbolOutlineResponse response = new SSSymbolOutlineResponse();
        List<OutlineResult> results = AISnippetSolver.getInstance().solveSnippetSymbolOutline(params.symbolName, AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "outline of"), 1));
        }
        response.results = results;
        return response;
    }

    public SSSymbolFilenameResponse solveSnippetSymbolFilename(BooleanSupplier isCanceled, SSSymbolFilenameParams params) {
        SSSymbolFilenameResponse response = new SSSymbolFilenameResponse();
        List<String> results = AISnippetSolver.getInstance().solveSnippetSymbolFilename(params.symbolName, AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "filename of"), 1));
        }
        response.fileNames = results;
        return response;
    }

    public SSFilenameOfSelectedFileResonse solveSnippetFilenameOfSelectedFile(BooleanSupplier isCanceled) {
        SSFilenameOfSelectedFileResonse response = new SSFilenameOfSelectedFileResonse();
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        response.fileName = Paths.get(iPath.toOSString(), new String[0]).getFileName().toString();
        return response;
    }

    public SSLanguageResponse solveSnippetLanguage(BooleanSupplier isCanceled) {
        SSLanguageResponse response = new SSLanguageResponse();
        String editorLanguage = AISnippetSolver.getInstance().getLanguageFromActiveEditor();
        if (editorLanguage != null) {
            response.languages = new ArrayList<String>(Arrays.asList(editorLanguage));
            return response;
        }
        List<String> languages = AISnippetSolver.getInstance().solveSnippetLanguage(AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (languages == null || languages.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "language"), 1));
        }
        response.languages = languages;
        return response;
    }

    public MultiRootTree solveSnippetDHVHContext(BooleanSupplier isCanceled, SSDHVHContextParams params) {
        MultiRootTree response = new MultiRootTree();
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        List<TreeElement> result = AISnippetSolver.getInstance().solveSnippetDhVhContext((DVTEditor)activeEditor, params.dhContext, params.topExpandLevels, params.bottomExpandLevels, isCanceled);
        if (result == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, params.dhContext ? "design hierarchy" : "verification hierarchy"), 1));
        }
        response.setRoots(result);
        return response;
    }

    public CodeSnippetList solveSnippetEditorsHotspots(BooleanSupplier isCanceled, SSEditorsHotspotsParams params) {
        List<CodeSnippet> results;
        CodeSnippetList response = new CodeSnippetList();
        String excludedFilePath = null;
        if (params.excludeActiveEditor) {
            excludedFilePath = AIUtils.getInstance().getActiveEditorFullPath();
        }
        if ((results = AISnippetSolver.getInstance().solveSnippetEditorsHotspots(params.maxNumberOfHotspots, params.onlyOpenEditors, excludedFilePath, isCanceled)) == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, params.onlyOpenEditors ? "recent code sections from open editors" : "recent code sections"), 1));
        }
        response.setCodeSnippets(results);
        return response;
    }

    public SSProblemsFromSelectedResponse solveSnippetProblemsFromSelected(BooleanSupplier isCanceled, SSProblemsFromSelectedParams params) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        SSProblemsFromSelectedResponse result = AISnippetSolver.getInstance().solveSnippetProblemsFromSelected(params, (ITextEditor)activeEditor, textSelection, isCanceled);
        if (result == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "problems from selected"), 1));
        }
        return result;
    }

    public SSCodeBeforeAfterSelectionResponse solveSnippetCodeBeforeSelection(BooleanSupplier isCanceled, SSCodeBeforeAfterSelectionParams params) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        SSCodeBeforeAfterSelectionResponse result = AISnippetSolver.getInstance().solveSnippetCodeBeforeSelection(params, (ITextEditor)activeEditor, textSelection);
        if (result == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "code before selection"), 1));
        }
        return result;
    }

    public SSClipboardResponse solveSnippetClipboard(BooleanSupplier isCanceled) {
        if (!PrefConst.getAIAClipboardSnippet()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.CLIPBOARD_NOT_ENABLED.KIND, String.format(AIExceptionKind.CLIPBOARD_NOT_ENABLED.MESSAGE, "clipboard"), 1));
        }
        String clipboardContent = Utils.pasteFromClipboard();
        return new SSClipboardResponse(clipboardContent);
    }

    public SSCodeBeforeAfterSelectionResponse solveSnippetCodeAfterSelection(BooleanSupplier isCanceled, SSCodeBeforeAfterSelectionParams params) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof ITextEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        SSCodeBeforeAfterSelectionResponse result = AISnippetSolver.getInstance().solveSnippetCodeAfterSelection(params, (ITextEditor)activeEditor, textSelection);
        if (result == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "code after selection"), 1));
        }
        return result;
    }

    public CodeSnippetList solveSnippetSymbol(BooleanSupplier isCanceled, SSSymbolParams params) {
        CodeSnippetList response = new CodeSnippetList();
        List<CodeSnippet> results = AISnippetSolver.getInstance().solveSnippetSymbol(params.symbolQuery, params.maxNumberOfSymbols, AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "symbol"), 1));
        }
        response.setCodeSnippets(results);
        return response;
    }

    public SSNameOfSelectedContainerResponse solveSnippetNameOfSelectedContainer(BooleanSupplier isCanceled) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (AIUtils.getInstance().isPromptExpansionEditor(activeEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        EditorPosition editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
        String name = AISnippetSolver.getInstance().solveSnippetNameOfSelectedContainer(editorPosition, isCanceled);
        if (name == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "name of selected container"), 1));
        }
        return new SSNameOfSelectedContainerResponse(name);
    }

    public SSKindOfSelectedContainerResponse solveSnippetKindOfSelectedContainer(BooleanSupplier isCanceled) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (AIUtils.getInstance().isPromptExpansionEditor(activeEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        EditorPosition editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
        String type = AISnippetSolver.getInstance().solveSnippetKindOfSelectedContainer(editorPosition, isCanceled);
        if (type == null) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "kind of selected container"), 1));
        }
        return new SSKindOfSelectedContainerResponse(type);
    }

    public SSDependenciesOfResponse solveSnippetDependenciesOfSelected(BooleanSupplier isCanceled, SSDependenciesOfSelectedParams params) {
        SSDependenciesOfResponse response = new SSDependenciesOfResponse();
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor(activeEditor);
        if (textSelection == null) {
            throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        EditorPosition editorPosition = new EditorPosition(editorFile, textSelection.getOffset());
        List<Dependency> results = AISnippetSolver.getInstance().solveSnippetDependenciesOfSelected(editorPosition, params.selectedType, params.expansionStrategy, params.wrappingCharCount, params.separatorCharCount, params.charCountLimit, isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "dependencies of"), 1));
        }
        response.results = results;
        return response;
    }

    public SSDependenciesOfResponse solveSnippetDependenciesOfSymbol(BooleanSupplier isCanceled, SSDependenciesOfSymbolParams params) {
        SSDependenciesOfResponse response = new SSDependenciesOfResponse();
        List<Dependency> results = AISnippetSolver.getInstance().solveSnippetDependenciesOfSymbol(params.symbolName, params.expansionStrategy, params.wrappingCharCount, params.separatorCharCount, params.charCountLimit, AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (results == null || results.isEmpty()) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "dependencies of"), 1));
        }
        response.results = results;
        return response;
    }

    public CodeSnippetList solveSymbol(BooleanSupplier isCanceled, SolveSymbolParams params) {
        List<CodeSnippet> symbolExpansions = AISymbolSolver.INSTANCE.solveSymbol(params.symbolQuery, Integer.MAX_VALUE, AIUtils.getInstance().getSelectedProject(), isCanceled);
        if (symbolExpansions == null || symbolExpansions.isEmpty()) {
            throw new AISymbolExpansionFailureException(new AIExceptionData(AIExceptionKind.SYMBOL_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SYMBOL_EXPANSION_FAILURE.MESSAGE, params.symbolQuery), 1));
        }
        return new CodeSnippetList(symbolExpansions);
    }

    public GetValidSymbolsResponse getValidSymbols(BooleanSupplier isCanceled, GetValidSymbolsParams params) {
        List<String> validSymbols = AISymbolSolver.INSTANCE.getValidSymbols(params.getSymbols(), AIUtils.getInstance().getSelectedProject(), isCanceled);
        return new GetValidSymbolsResponse(validSymbols);
    }

    public GetSymbolsForAutocompleteResponse getSymbolsForAutocomplete(BooleanSupplier isCanceled, GetSymbolsForAutocompleteParams params) {
        GetSymbolsForAutocompleteResponse response = new GetSymbolsForAutocompleteResponse();
        response.symbolNames = AISymbolSolver.INSTANCE.getSymbolsForAutocomplete(params.symbolQuery, AIUtils.getInstance().getSelectedProject(), isCanceled);
        return response;
    }

    public Void modifySettingValue(BooleanSupplier isCanceled, ModifySettingValueParams params) {
        try {
            switch (params.settingId) {
                case "DVT.AI.editor.insertUnmodifiedReply.enabled": {
                    PrefConst.setAIAEditorInsertUnmodifiedReply((boolean)((Boolean)params.value));
                    break;
                }
                case "DVT.AI.addGeneratedCodeWatermark.enabled": {
                    PrefConst.setAIAAddGeneratedCodeWatermark((boolean)((Boolean)params.value));
                    break;
                }
                case "DVT.AI.clipboardSnippet.enabled": {
                    PrefConst.setAIAClipboardSnippet((boolean)((Boolean)params.value));
                    break;
                }
                case "DVT.AI.codeCompletion.enabled": {
                    PrefConst.setAIAAccessProposalsInDefaultPage((boolean)((Boolean)params.value));
                    break;
                }
                case "DVT.tooltips.markupLanguage": {
                    PrefConst.setTooltipMarkupLanguage((String)((String)params.value));
                    break;
                }
                case "DVT.AI.chat.prompt.sendKey": {
                    PrefConst.setAIASendKeyPreference((ChatSendKeyPref)ChatSendKeyPref.of((String)((String)params.value)));
                    break;
                }
                default: {
                    break;
                }
                case "DVT.AI.languageModels": {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.UNABLE_TO_CHANGE_SETTING_VALUE.KIND, String.format(AIExceptionKind.UNABLE_TO_CHANGE_SETTING_VALUE.MESSAGE, params.getSettingId()), 0));
        }
        return null;
    }

    public GetSettingValueResponse getSettingValue(BooleanSupplier isCanceled, GetSettingValueParams params) {
        GetSettingValueResponse response = new GetSettingValueResponse();
        switch (params.settingId) {
            case "DVT.AI.editor.insertUnmodifiedReply.enabled": {
                response.value = PrefConst.getAIAEditorInsertUnmodifiedReply();
                break;
            }
            case "DVT.AI.addGeneratedCodeWatermark.enabled": {
                response.value = PrefConst.getAIAAddGeneratedCodeWatermark();
                break;
            }
            case "DVT.AI.clipboardSnippet.enabled": {
                response.value = PrefConst.getAIAClipboardSnippet();
                break;
            }
            case "DVT.AI.codeCompletion.enabled": {
                response.value = PrefConst.getAIAAccessProposalsInDefaultPage();
                break;
            }
            case "DVT.tooltips.markupLanguage": {
                response.value = PrefConst.getTooltipMarkupLanguage();
                break;
            }
            case "DVT.AI.chat.prompt.sendKey": {
                response.value = PrefConst.getAIASendKeyPreference().getValue();
                break;
            }
            case "DVT.AI.languageModels": {
                response.value = null;
                break;
            }
            default: {
                response.value = PreferenceUtils.INSTANCE.getString(params.settingId);
            }
        }
        return response;
    }

    public Void assistantMessageStart(BooleanSupplier isCanceled, AssistantMessageStartParams params) {
        switch (params.sessionTarget) {
            case "specador-live-preview": {
                SpecadorPreviewListener.INSTANCE.startCommentDescription(params.sessionId, params.slot.id);
                break;
            }
            case "editor": {
                EditorManager.INSTANCE.assistantMessageStart(params);
                break;
            }
        }
        return null;
    }

    public Void assistantMessageStream(BooleanSupplier isCanceled, AssistantMessageStreamParams params) {
        switch (params.sessionTarget) {
            case "specador-live-preview": {
                SpecadorPreviewListener.INSTANCE.streamCommentDescription(params.content);
                break;
            }
            case "editor": {
                EditorManager.INSTANCE.assistantMessageStream(params);
                break;
            }
        }
        return null;
    }

    public Void assistantMessageStop(BooleanSupplier isCanceled, AssistantMessageStopParams params) {
        switch (params.sessionTarget) {
            case "specador-live-preview": {
                SpecadorPreviewListener.INSTANCE.stopCommentDescription();
                break;
            }
            case "editor": {
                EditorManager.INSTANCE.assistantMessageStop(params);
                break;
            }
        }
        return null;
    }

    public void showCurrentModelInformation(ShowCurrentModelInfoParams params) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> ModelsManager.INSTANCE.selectModel(showCurrentModelInfoParams.modelInfo));
    }

    public ShowInputBoxResponse showInputBox(BooleanSupplier isCanceled, ShowInputBoxParams params) {
        ShowInputBoxResponse response = new ShowInputBoxResponse();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().syncExec(() -> {
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            Shell shell = activeWorkbenchWindow.getShell();
            if (shell == null) {
                return;
            }
            InputDialog dialog = new InputDialog(shell, showInputBoxParams.title, "", showInputBoxParams.value, null);
            ObjectionManager.getInstance().clear(Objection.AI_INPUT_DIALOG);
            if (dialog.open() == 0) {
                showInputBoxResponse.value = dialog.getValue();
            }
        });
        return response;
    }

    public ShowDropdownPickerResponse showDropdownPicker(BooleanSupplier isCanceled, ShowDropdownPickerParams params) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(DVTUiUtils.getActiveWorkbenchShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return super.getText(element);
            }
        });
        dialog.setElements(params.getItems().toArray());
        dialog.setMultipleSelection(params.canPickMany);
        dialog.setTitle(params.title);
        dialog.setHelpAvailable(false);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            int n = dialog.open();
        });
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return new ShowDropdownPickerResponse(Collections.emptyList());
        }
        List<String> selectedItems = Arrays.stream(result).map(obj -> (String)obj).collect(Collectors.toList());
        return new ShowDropdownPickerResponse(selectedItems);
    }

    public CopilotModelsResponse copilotModels(BooleanSupplier isCanceled) {
        CopilotModelsResponse response = new CopilotModelsResponse();
        response.models = Collections.emptyList();
        return response;
    }

    public GetActiveEditorInfoResponse getActiveEditorInfo(BooleanSupplier isCanceled, GetActiveEditorInfoParams params) {
        EditorSession editorSession = EditorManager.INSTANCE.getEditorSession(params.sessionId);
        return editorSession.getActiveEditorInfo();
    }

    public GetLanguageInfoResponse getLanguageInfo(BooleanSupplier isCanceled, GetLanguageInfoParams params) {
        return new GetLanguageInfoResponse(AIUtils.getInstance().getSingleLineCommentForLanguageId(params.langId));
    }

    public Void startProgressIndicator(BooleanSupplier isCanceled, StartProgressIndicatorParams params) {
        return AIProgressIndicatorManager.INSTANCE.startProgressIndicator(params.message);
    }

    public void stopProgressIndicator() {
        AIProgressIndicatorManager.INSTANCE.stopProgressIndicator();
    }

    public Void updateAcknowledgmentState(BooleanSupplier isCanceled, UpdateAcknowledgmentStateParams params) {
        BooleanContextClauses.IS_AI_ENABLED.updateValue(params.ack.getValue().equals(UpdateAcknowledgmentStateParams.AcknowledgmentState.ACCEPTED.getValue()));
        if (params.ack.getValue().equals(UpdateAcknowledgmentStateParams.AcknowledgmentState.DECLINED.getValue()) || params.ack.getValue().equals(UpdateAcknowledgmentStateParams.AcknowledgmentState.UNKNOWN.getValue())) {
            ModelsManager.INSTANCE.showDisableMsg();
        }
        return null;
    }
}

