/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import ro.amiq.dvt.logging.UnloggableException;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum AIHostExecutor {
    INSTANCE;

    private final ExecutorService executor = Executors.newCachedThreadPool();

    public ExecutorService getExecutorService() {
        return this.executor;
    }

    public <P, R> CompletableFuture<R> run(BiFunction<BooleanSupplier, P, R> function, P params) {
        AIHostTask<P, R> task = new AIHostTask<P, R>(params, function);
        CompletableFuture.runAsync(task, this.executor);
        return task.getCompletableFeature();
    }

    public <R> CompletableFuture<R> run(Function<BooleanSupplier, R> function) {
        return this.run((BooleanSupplier c, P p) -> function.apply((BooleanSupplier)c), null);
    }

    public <P> void run(BiConsumer<BooleanSupplier, P> consumer, P params) {
        this.run((BooleanSupplier c, P p) -> {
            consumer.accept((BooleanSupplier)c, (Object)p);
            return null;
        }, params);
    }

    public <P> void run(Consumer<P> consumer, P params) {
        this.run((BooleanSupplier c, P p) -> {
            consumer.accept(p);
            return null;
        }, params);
    }

    public void run(Runnable runnable) {
        this.run((BooleanSupplier c, P p) -> {
            runnable.run();
            return null;
        }, null);
    }

    public static class AIHostTask<P, R>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        private final P params;
        private final CompletableFuture<R> completableFuture;
        private final BiFunction<BooleanSupplier, P, R> function;

        public AIHostTask(P params, BiFunction<BooleanSupplier, P, R> function) {
            this.params = params;
            this.function = function;
            this.completableFuture = new CompletableFuture();
        }

        @Override
        public void run() {
            try {
                if (!this.completableFuture.isCancelled()) {
                    this.completableFuture.complete(this.function.apply(this.completableFuture::isCancelled, this.params));
                }
            }
            catch (Throwable e) {
                if (!(e instanceof UnloggableException)) {
                    DVTLogger.INSTANCE.logError(e);
                }
                this.completableFuture.completeExceptionally(e);
            }
        }

        public CompletableFuture<R> getCompletableFeature() {
            return this.completableFuture;
        }

        public P getParams() {
            return this.params;
        }
    }
}

