/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.net.URISyntaxException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTSplashInfo;
import ro.amiq.dvt.ai.AIConnectionInfo;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIHostLS;
import ro.amiq.dvt.ai.AINodeJSConfiguration;
import ro.amiq.dvt.ai.ICore;
import ro.amiq.dvt.ai.incremental.AIIncrementalBuildListener;
import ro.amiq.dvt.ai.model.adapters.GsonManager;
import ro.amiq.dvt.ai.model.params.UpdateCoreLicenseStateParams;
import ro.amiq.dvt.ai.ui.browser.BrowserUtils;
import ro.amiq.dvt.ai.ui.browser.websocket.AIWebSocketClient;
import ro.amiq.dvt.ai.ui.browser.websocket.WSLauncherBuilder;
import ro.amiq.dvt.node.NodeJSConfiguration;
import ro.amiq.dvt.node.NodeJSManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;

public class AIManager {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final String CONNECTION_INFO_ERROR_MSG = "Core failed to return conncetion info!";
    private static final String CONNECTION_INFO_HOST_ERROR_MSG = "Core failed to return the host websocket url!";
    private static final String INVALID_HOST_URL_ERROR_MSG = "Core returned an invalid host websocket url!";
    private static final String NODE_FAILED_TO_START_ERROR_MSG = "Core failed to start!";
    private static final String NODE_START_CANCELATION_ERROR_MSG = "Core start canceled!";
    private static final String HOST_WS_CONNECTION_ERROR_MSG = "Host failed to connect to core websocket!";
    private final AIHostLS hostInstance = new AIHostLS();
    private static Browser browserInstance;
    private AIConnectionInfo connectionInfo;
    private static CompletableFuture<AIManager> aiManagerFuture;

    static {
        aiManagerFuture = CompletableFuture.supplyAsync(() -> new AIManager(), executor);
    }

    private AIManager() {
        try {
            AINodeJSConfiguration.getInstance().setCoreRestartCallback(() -> AIManager.onCoreRestart());
            NodeJSManager.INSTANCE.start((NodeJSConfiguration)AINodeJSConfiguration.getInstance());
            this.connectionInfo = AINodeJSConfiguration.getInstance().getConnectionInfo().get();
            if (this.connectionInfo == null) {
                DVTLogger.INSTANCE.logError(CONNECTION_INFO_ERROR_MSG);
                return;
            }
            if (this.connectionInfo.hostWsUrl == null) {
                DVTLogger.INSTANCE.logError(CONNECTION_INFO_HOST_ERROR_MSG);
                return;
            }
            this.connectHostToCore();
            if (browserInstance != null && !browserInstance.isDisposed()) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    browserInstance.setUrl(this.getServerUrl());
                    AIConsole.MAIN.logDebug("Browser URL changed to: " + this.getServerUrl());
                });
            }
            AIConsole.MAIN.logDebug("AI Assistant initialized succesfully");
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError(HOST_WS_CONNECTION_ERROR_MSG);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        catch (ExecutionException e) {
            DVTLogger.INSTANCE.logError(NODE_FAILED_TO_START_ERROR_MSG);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        catch (CancellationException e) {
            DVTLogger.INSTANCE.logInfo(NODE_START_CANCELATION_ERROR_MSG);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        catch (URISyntaxException e) {
            DVTLogger.INSTANCE.logError(INVALID_HOST_URL_ERROR_MSG);
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        DVTSplashInfo.INSTANCE.addCoreStateListener(state -> {
            try {
                this.hostInstance.getCore().updateCoreLicenseState(new UpdateCoreLicenseStateParams(state.name()));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        BuildEventManager.getInstance().registerListener((IBuildEventManagerListener)new AIIncrementalBuildListener());
    }

    private void connectHostToCore() throws URISyntaxException, InterruptedException {
        AIWebSocketClient coreHostWs = new AIWebSocketClient(this.connectionInfo.hostWsUrl);
        WSLauncherBuilder builder = new WSLauncherBuilder();
        Launcher.Builder launcherBuilder = builder.setWebSocket(coreHostWs).setLocalService(this.hostInstance).setRemoteInterface(ICore.class).configureGson(GsonManager.INSTANCE::configureGson);
        Launcher launcher = launcherBuilder.create();
        coreHostWs.connectBlocking();
        this.hostInstance.setCore((ICore)launcher.getRemoteProxy());
    }

    public static CompletableFuture<AIManager> getInstance() {
        return aiManagerFuture;
    }

    private static void onCoreRestart() {
        aiManagerFuture = CompletableFuture.supplyAsync(() -> new AIManager(), executor);
    }

    public AIHostLS getHost() {
        return this.hostInstance;
    }

    public String getServerUrl() {
        return this.connectionInfo.chatUrl;
    }

    public Browser getBrowser() {
        if (browserInstance == null || browserInstance.isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                browserInstance = BrowserUtils.INSTANCE.initializeBrowser();
                browserInstance.setUrl(this.getServerUrl());
                AIConsole.MAIN.logDebug("Browser URL changed to: " + this.getServerUrl());
            });
        }
        return browserInstance;
    }
}

