/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import ro.amiq.dvt.ai.AIConnectionInfo;
import ro.amiq.dvt.ai.AIConsole;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.LogSeverity;
import ro.amiq.dvt.ai.model.LogTarget;
import ro.amiq.dvt.node.NodeJSConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.JarUtils;

public class AINodeJSConfiguration
extends NodeJSConfiguration {
    public static final String NODE_RUNTIME_ID = "AINodeRuntime";
    private static final String NODE_STATUS_INDENTIFIER = "NODE_SERVER_STATUS:";
    private static final String NODE_EXITED_ERROR_MSG = "Core runtime exited unexpectedly! Attempting restart...";
    private static final String NODE_SOURCE_MAP_ARG = "--enable-source-maps";
    private static final String NODE_DEGUGGER_ARG = "--inspect=127.0.0.1:9229";
    private static final String LOG_FILE_PREFIX = "dvt.ai.node.";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final int MAX_NOF_RETRIES = 5;
    private static final String DVT_AI_NODE_OPTIONS_VAR = "DVT_AI_NODE_OPTIONS";
    private static final Pattern ADDITIONAL_ARGS_SPLIT_PATTERN = Pattern.compile(" +");
    private static AINodeJSConfiguration instance;
    private CompletableFuture<AIConnectionInfo> connectionInfo = new CompletableFuture();
    private Runnable coreRestartCallback;
    private final Gson gson = new Gson();

    private AINodeJSConfiguration() {
        super(NODE_RUNTIME_ID);
    }

    public static synchronized AINodeJSConfiguration getInstance() {
        if (instance == null) {
            instance = new AINodeJSConfiguration();
        }
        return instance;
    }

    public CompletableFuture<AIConnectionInfo> getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setCoreRestartCallback(Runnable coreRestartCallback) {
        this.coreRestartCallback = coreRestartCallback;
    }

    protected List<String> getArguments() {
        String additionalNodeArgs;
        ArrayList<String> arguments = new ArrayList<String>();
        if (DVTLogger.INSTANCE.isDebugMode()) {
            arguments.add(NODE_SOURCE_MAP_ARG);
            arguments.add(NODE_DEGUGGER_ARG);
        }
        if ((additionalNodeArgs = System.getenv(DVT_AI_NODE_OPTIONS_VAR)) != null && !additionalNodeArgs.isEmpty()) {
            arguments.addAll(Arrays.asList(ADDITIONAL_ARGS_SPLIT_PATTERN.split(additionalNodeArgs.trim())));
        }
        File resourcesDirectory = JarUtils.getDirectory((String)("resources" + File.separator + "ai"), ((Object)((Object)this)).getClass(), (boolean)false);
        arguments.add(resourcesDirectory.toPath().resolve("core").resolve("core.js").toString());
        arguments.add(resourcesDirectory.toPath().resolve("chat").toString());
        return arguments;
    }

    protected String getLogFilePath() {
        return String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + LOG_FILE_PREFIX + System.currentTimeMillis() + LOG_FILE_EXTENSION;
    }

    protected int getMaxNofRestartRetries() {
        return 5;
    }

    protected void afterStart() {
        AIConsole.MAIN.logDebug("Core runtime started");
    }

    protected void processOutputLine(String line) {
        if (line.startsWith(NODE_STATUS_INDENTIFIER)) {
            String connectionInfoJson = line.substring(NODE_STATUS_INDENTIFIER.length());
            AIConsole.MAIN.logDebug("Core connection info succesfully retrieved:");
            AIConsole.MAIN.logDebug(connectionInfoJson);
            this.connectionInfo.complete((AIConnectionInfo)this.gson.fromJson(connectionInfoJson, AIConnectionInfo.class));
        }
    }

    protected boolean shouldSkipLogLine(String line) {
        return line.startsWith(NODE_STATUS_INDENTIFIER);
    }

    protected boolean onKilled() {
        try {
            AIUtils.getInstance().writeToAiConsole(LogTarget.AI_CONSOLE, NODE_EXITED_ERROR_MSG, LogSeverity.ERROR, NODE_EXITED_ERROR_MSG);
            this.connectionInfo = new CompletableFuture();
            if (this.coreRestartCallback != null) {
                this.coreRestartCallback.run();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    protected void onException(Exception e) {
        this.connectionInfo.completeExceptionally(e);
    }
}

