/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum AIPathUtils {
    INSTANCE;

    public static final String STAR_STAR_GLOB_PATTERN = "**";
    public static final String PATH_MATCHER_GLOB_SYNTAX = "glob:";
    public static final String BACKSLASH_CHARACTER_STRING = "\\";
    public static final String BACKSLASH_CHARACTER_ESCAPED = "\\\\";
    private static final Character UNIX_PATH_SEPARATOR_CHARACTER;
    private static final Character WINDOWS_PATH_SEPARATOR_CHARACTER;
    private static final Pattern ENV_VAR_PATTERN;
    private static final Set<Character> GLOB_PATTERNS_SPECIAL_CHARACTERS;

    static {
        UNIX_PATH_SEPARATOR_CHARACTER = Character.valueOf('/');
        WINDOWS_PATH_SEPARATOR_CHARACTER = Character.valueOf('\\');
        ENV_VAR_PATTERN = Pattern.compile("\\$\\{?(?<varName>[A-Za-z_][A-Za-z0-9_]*)\\}?");
        GLOB_PATTERNS_SPECIAL_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}')));
    }

    public String normalizePath(String fullPath) {
        if (fullPath == null) {
            return "";
        }
        IPath path = Path.fromOSString((String)fullPath);
        String device = path.getDevice();
        if (device != null && !device.isEmpty()) {
            path = path.setDevice(device.toUpperCase());
        }
        return path.toOSString();
    }

    public String makePathRelativeToProject(String fullPath, IProject iProject) {
        if (fullPath == null) {
            return null;
        }
        if (iProject == null) {
            return null;
        }
        IPath projectLocation = iProject.getLocation();
        if (projectLocation == null) {
            return null;
        }
        String projectPathString = projectLocation.toOSString();
        if (projectPathString == null) {
            return null;
        }
        if (this.normalizePath(fullPath).startsWith(this.normalizePath(projectPathString))) {
            return fullPath.substring(projectPathString.length() + 1);
        }
        return fullPath;
    }

    public java.nio.file.Path getProtectFilePath(IProject iProject) {
        if (iProject == null) {
            return null;
        }
        IPath projectLocation = iProject.getLocation();
        if (projectLocation == null) {
            return null;
        }
        String osString = projectLocation.toOSString();
        if (osString == null) {
            return null;
        }
        java.nio.file.Path protectFilePath = Paths.get(osString, AIUtils.AI_PROTECT_FILE_PATH);
        if (protectFilePath == null || !protectFilePath.toFile().isFile()) {
            return null;
        }
        return protectFilePath;
    }

    public String replaceEnvVarsInPath(String path, List<String> invalidEnvVars, IProject iProject) {
        if (iProject == null) {
            return null;
        }
        Map env = BuildConfigManager.getenv((IProject)iProject);
        Matcher matcher = ENV_VAR_PATTERN.matcher(path);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String varName = matcher.group("varName");
            String value = (String)env.get(varName);
            if (value == null) {
                invalidEnvVars.add(varName);
                value = "";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public String normalizeAndMakePathAbsolute(String pathString, IProject iProject) {
        if (pathString == null) {
            return null;
        }
        pathString = DVTFileUtils.getInstance().replaceSpecialCharactersInGlobPattern(pathString);
        java.nio.file.Path path = Paths.get(pathString, new String[0]);
        if (path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            return DVTFileUtils.getInstance().undoSpecialCharactersInGlobPatternReplacement(this.normalizePath(path.normalize().toString()));
        }
        if (iProject == null) {
            return null;
        }
        IPath projectLocation = iProject.getLocation();
        if (projectLocation == null) {
            return null;
        }
        String osString = projectLocation.toOSString();
        if (osString == null) {
            return null;
        }
        java.nio.file.Path absolutePath = Paths.get(osString, pathString);
        if (absolutePath == null) {
            return null;
        }
        return DVTFileUtils.getInstance().undoSpecialCharactersInGlobPatternReplacement(this.normalizePath(absolutePath.normalize().toString()));
    }

    public String getAbsolutePathFromFileNameOrPath(String fileNameOrPath, IProject iProject, BooleanSupplier isCanceled) {
        List<String> fullPaths;
        String fullPath = fileNameOrPath;
        if (!fileNameOrPath.contains(File.separator) && (fullPaths = AISymbolSolver.INSTANCE.getFullPathsFromCompiledFileQuery(String.valueOf(SymbolQueryKey.FILE.toString()) + ":" + SymbolQueryUtils.makeExactPattern((String)fileNameOrPath), iProject, isCanceled)) != null && !fullPaths.isEmpty()) {
            fullPath = fullPaths.get(0);
        }
        return this.normalizeAndMakePathAbsolute(fullPath, iProject);
    }

    public boolean pathsAreEqual(String path1, IProject project1, String path2, IProject project2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        if (project1 == null && project2 == null) {
            return true;
        }
        if (project1 == null || project2 == null) {
            return false;
        }
        if (!project1.equals((Object)project2)) {
            return false;
        }
        String path1Normalized = this.normalizeAndMakePathAbsolute(path1, project1);
        String path2Normalized = this.normalizeAndMakePathAbsolute(path2, project2);
        return path1Normalized != null && path1Normalized.equals(path2Normalized);
    }

    public int getIndexOfFirstGlobPatternCharInPath(String path) {
        if (path == null || path.length() < 2) {
            return -1;
        }
        int result = -1;
        int i = 1;
        while (i < path.length()) {
            if (GLOB_PATTERNS_SPECIAL_CHARACTERS.contains(Character.valueOf(path.charAt(i))) && (path.charAt(i - 1) != WINDOWS_PATH_SEPARATOR_CHARACTER.charValue() || File.separatorChar != UNIX_PATH_SEPARATOR_CHARACTER.charValue())) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public int getLastPathSeparatorIndexInPath(String path) {
        if (path == null || path.isEmpty()) {
            return -1;
        }
        int result = -1;
        int i = path.length() - 1;
        while (i >= 0) {
            char chr = path.charAt(i);
            if (chr == UNIX_PATH_SEPARATOR_CHARACTER.charValue()) {
                result = i;
                break;
            }
            if (chr == WINDOWS_PATH_SEPARATOR_CHARACTER.charValue() && File.separatorChar == WINDOWS_PATH_SEPARATOR_CHARACTER.charValue()) {
                result = i;
                break;
            }
            --i;
        }
        return result;
    }

    public List<String> sortPathsAndEliminateDuplicates(List<String> fullPaths) {
        fullPaths.sort(String::compareTo);
        LinkedHashSet<String> uniqueFullPaths = new LinkedHashSet<String>(fullPaths);
        return new ArrayList<String>(uniqueFullPaths);
    }
}

