/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public enum AIProgressIndicatorManager {
    INSTANCE;

    private static final String DVT_PREFIX = "[dvt] ";
    private Job job;

    public Void startProgressIndicator(String message) {
        if (this.job != null || message == null) {
            return null;
        }
        this.job = new ProgressIndicatorJob(DVT_PREFIX + message);
        this.job.schedule();
        try {
            this.job.join();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return null;
    }

    public void stopProgressIndicator() {
        if (this.job == null) {
            return;
        }
        this.job.cancel();
        this.job = null;
    }

    private class ProgressIndicatorJob
    extends Job {
        public ProgressIndicatorJob(String message) {
            super(message);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            while (!monitor.isCanceled()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }
            return Status.CANCEL_STATUS;
        }
    }
}

