/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectRule;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public enum AIProtectManager {
    INSTANCE;

    private static final String COMMENT_START_CHARACTER = "#";
    private static final String NEGATE_PATTERN_CHARACTER = "!";
    private static final String PROTECT_FILE_PATH;
    private static final long CACHE_EXPIRATION_THRESHOLD = 5000L;
    Map<IProject, Long> cacheExpirationTime = new ConcurrentHashMap<IProject, Long>();
    Map<IProject, Long> protectFileLastModifyTime = new ConcurrentHashMap<IProject, Long>();
    Map<IProject, Long> protectFileLastSize = new ConcurrentHashMap<IProject, Long>();
    private Map<IProject, List<AIProtectRule>> fileProtectRules = new ConcurrentHashMap<IProject, List<AIProtectRule>>();

    static {
        PROTECT_FILE_PATH = ".dvt" + File.separator + "ai" + File.separator + "protect";
    }

    public void parseProtectFile(boolean triggeredBySaveInEditor, IProject iProject) {
        if (iProject == null) {
            return;
        }
        this.fileProtectRules.put(iProject, new ArrayList());
        Path protectFilePath = AIPathUtils.INSTANCE.getProtectFilePath(iProject);
        if (protectFilePath == null) {
            return;
        }
        if (triggeredBySaveInEditor) {
            this.protectFileLastModifyTime.put(iProject, protectFilePath.toFile().lastModified());
            this.protectFileLastSize.put(iProject, protectFilePath.toFile().length());
        }
        String protectFileContent = Utils.readFileContentBetweenLines((String)protectFilePath.toString(), (IProject)iProject, (int)0, (int)Integer.MAX_VALUE);
        String[] lines = protectFileContent.split(System.lineSeparator());
        ArrayList<String> invalidEnvVars = new ArrayList<String>();
        int firstInvalidEnvVarLine = -1;
        int currentLineNumber = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isNegated;
            String protectPattern;
            PathMatcher matcher;
            String line = stringArray[n2];
            String trimmedLine = line.trim();
            ++currentLineNumber;
            if (!trimmedLine.isEmpty() && !trimmedLine.startsWith(COMMENT_START_CHARACTER) && (matcher = this.convertProtectPatternToPathMatcher(protectPattern = (isNegated = trimmedLine.startsWith(NEGATE_PATTERN_CHARACTER)) ? trimmedLine.substring(NEGATE_PATTERN_CHARACTER.length()) : trimmedLine, invalidEnvVars, iProject)) != null) {
                if (!invalidEnvVars.isEmpty() && firstInvalidEnvVarLine < 0) {
                    firstInvalidEnvVarLine = currentLineNumber;
                }
                this.fileProtectRules.get(iProject).add(new AIProtectRule(isNegated, matcher, currentLineNumber));
            }
            ++n2;
        }
        if (triggeredBySaveInEditor && firstInvalidEnvVarLine > 0) {
            String warningMessage = AIUtils.getInstance().computeInvalidEnvVarsWarningMessage(invalidEnvVars, true);
            AIUtils.getInstance().showInvalidEnvironmentVariablesWarning(warningMessage, firstInvalidEnvVarLine);
        }
    }

    public int getProtectLineNumber(String fullPath, IProject iProject) {
        if (fullPath == null) {
            return 0;
        }
        if (iProject == null) {
            return 0;
        }
        if (fullPath.endsWith(PROTECT_FILE_PATH)) {
            return 1;
        }
        fullPath = AIPathUtils.INSTANCE.normalizePath(fullPath);
        this.refresh(iProject);
        boolean isProtected = false;
        int lineNumberOfLastMatch = 0;
        for (AIProtectRule rule : this.fileProtectRules.getOrDefault(iProject, List.of())) {
            if (!rule.matchesFilePath(fullPath)) continue;
            isProtected = !rule.isNegated();
            lineNumberOfLastMatch = rule.getLineNumber();
        }
        return isProtected ? lineNumberOfLastMatch : 0;
    }

    public boolean isFileProtected(String fullPath, IProject iProject) {
        return this.getProtectLineNumber(fullPath, iProject) > 0;
    }

    public boolean isDefElementProtected(IRfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        ParserPath parserPath = defElement.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return false;
        }
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        return this.isFileProtected(parserPath.path, rfProject.getProject());
    }

    private void refresh(IProject iProject) {
        if (iProject == null) {
            return;
        }
        if (System.currentTimeMillis() < this.cacheExpirationTime.getOrDefault(iProject, 0L)) {
            return;
        }
        this.cacheExpirationTime.put(iProject, System.currentTimeMillis() + 5000L);
        Path protectFilePath = AIPathUtils.INSTANCE.getProtectFilePath(iProject);
        if (protectFilePath == null) {
            this.fileProtectRules.clear();
            return;
        }
        long modifyTime = protectFilePath.toFile().lastModified();
        long size = protectFilePath.toFile().length();
        if (modifyTime == this.protectFileLastModifyTime.getOrDefault(iProject, 0L) && size == this.protectFileLastSize.getOrDefault(iProject, 0L)) {
            return;
        }
        this.protectFileLastModifyTime.put(iProject, modifyTime);
        this.protectFileLastSize.put(iProject, size);
        this.parseProtectFile(false, iProject);
    }

    private PathMatcher convertProtectPatternToPathMatcher(String protectPattern, List<String> invalidEnvVars, IProject iProject) {
        if (iProject == null) {
            return null;
        }
        if ((protectPattern = AIPathUtils.INSTANCE.replaceEnvVarsInPath(protectPattern, invalidEnvVars, iProject)) == null) {
            return null;
        }
        if ((protectPattern = AIPathUtils.INSTANCE.normalizeAndMakePathAbsolute(protectPattern, iProject)) == null) {
            return null;
        }
        protectPattern = protectPattern.replace("**" + File.separator, "**");
        if (DVTFileUtils.getInstance().pathStartsWithADriveLetter(protectPattern)) {
            protectPattern = protectPattern.replace("\\", "\\\\");
        }
        return FileSystems.getDefault().getPathMatcher("glob:" + protectPattern);
    }
}

