/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.ai.AIManager;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.model.params.OnDidSaveUserFileParams;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum AIResourceChangeListener implements IResourceChangeListener
{
    INSTANCE;

    private static final List<String> AI_FILE_EXTENSIONS;

    static {
        AI_FILE_EXTENSIONS = Arrays.asList(".jsonc", ".json", ".js", ".ts");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    boolean fileContentChanged;
                    if (!(delta.getResource() instanceof IFile)) {
                        return true;
                    }
                    IFile file = (IFile)delta.getResource();
                    int kind = delta.getKind();
                    int flags = delta.getFlags();
                    boolean fileWasDeleted = kind == 2;
                    boolean bl = fileContentChanged = kind == 4 && (flags & 0x100) != 0;
                    if ((fileWasDeleted || fileContentChanged) && file.getLocation() != null && file.getLocation().toOSString().endsWith(AIUtils.AI_PROTECT_FILE_PATH)) {
                        AIProtectManager.INSTANCE.parseProtectFile(fileContentChanged, file.getProject());
                        return false;
                    }
                    if (fileContentChanged) {
                        if (AI_FILE_EXTENSIONS.stream().anyMatch(file.getName()::endsWith)) {
                            AIManager.getInstance().thenAccept(aiManager -> aiManager.getHost().getCore().onDidSaveUserFile(new OnDidSaveUserFileParams(file.getLocation().toOSString())));
                            return false;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

