/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AISnippetSolverCommon;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.Problem;
import ro.amiq.dvt.ai.model.ProblemsFromSelectedType;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AINoEditorException;
import ro.amiq.dvt.ai.model.exceptions.AINoSelectionException;
import ro.amiq.dvt.ai.model.exceptions.AISnippetExpansionFailureException;
import ro.amiq.dvt.ai.model.params.SSCodeBeforeAfterSelectionParams;
import ro.amiq.dvt.ai.model.params.SSProblemsFromSelectedParams;
import ro.amiq.dvt.ai.model.responses.SSCodeBeforeAfterSelectionResponse;
import ro.amiq.dvt.ai.model.responses.SSProblemsFromSelectedResponse;
import ro.amiq.dvt.model.reflection.IRfDefContainer;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;

public class AISnippetSolver
extends AISnippetSolverCommon {
    private static final Object LOCK = new Object();
    private static AISnippetSolver INSTANCE;
    private static final int NUMBER_OF_SURROUNDING_LINES_FOR_PROBLEMS = 3;
    private static final Comparator<IMarker> MARKERS_COMPARATOR;

    static {
        MARKERS_COMPARATOR = (m1, m2) -> {
            int severity2;
            int severity1 = m1.getAttribute("severity", -1);
            if (severity1 != (severity2 = m2.getAttribute("severity", -1))) {
                return severity2 - severity1;
            }
            int line1 = m1.getAttribute("lineNumber", -1);
            int line2 = m2.getAttribute("lineNumber", -1);
            return line1 - line2;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AISnippetSolver getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new AISnippetSolver();
            }
        }
        return INSTANCE;
    }

    @Override
    protected IDVTElementWrapper getOutlineDataForFilePath(String filePath, IProject iProject) {
        RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(iProject, false);
        if (rfMixedLangProject == null) {
            return null;
        }
        IRfFileDef fileDef = null;
        ParserPath parserPath = new ParserPath(filePath);
        Collection singleLangProjects = rfMixedLangProject.getSingleLangProjects();
        for (IRfSingleLangProject singleLangProject : singleLangProjects) {
            fileDef = singleLangProject.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(fileDef.getLanguageKind());
            if (aiContributor == null) {
                return null;
            }
            return aiContributor.getOutlineWrapper((IRfDefContainer)fileDef);
        }
        return null;
    }

    @Override
    public IDVTElementWrapper getOutlineDataForDefElement(IRfDefElement defElement) {
        if (defElement == null) {
            return null;
        }
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(defElement.getLanguageKind());
        if (aiContributor == null) {
            return null;
        }
        return aiContributor.getOutlineWrapper((IRfDefContainer)defElement);
    }

    @Override
    protected String getActiveEditorNormalizedPath() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        IFile file = DVTFileUtils.getInstance().getEditorFile(activeEditor);
        if (file == null) {
            return null;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return null;
        }
        return AIPathUtils.INSTANCE.normalizePath(location.toOSString());
    }

    public CodeSnippet solveSnippetSelectedInsidePromptExpansionEditor(ITextEditor textEditor, SnippetSelectionType selectionType, boolean indicateCursorPosition) {
        if (selectionType == null) {
            return null;
        }
        switch (selectionType) {
            case FILE: {
                String fileContentWithCursorPositionMarked;
                IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
                if (document == null) {
                    throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
                }
                String fileContent = document.get();
                if (indicateCursorPosition && (fileContentWithCursorPositionMarked = AIUtils.getInstance().getEditorContentWithCursorPosition((IEditorPart)textEditor, AIUtils.getInstance().getTextSelectionFromActiveEditor((IEditorPart)textEditor))) != null) {
                    fileContent = fileContentWithCursorPositionMarked;
                }
                return new CodeSnippet(fileContent, null, 0, 0);
            }
            case CODE: {
                ITextSelection textSelection = AIUtils.getInstance().getTextSelectionFromActiveEditor((IEditorPart)textEditor);
                if (textSelection == null) {
                    throw new AINoSelectionException(new AIExceptionData(AIExceptionKind.NO_ELEMENT_SELECTED.KIND, AIExceptionKind.NO_ELEMENT_SELECTED.MESSAGE, 0));
                }
                String selectedCode = textSelection.getText();
                if (indicateCursorPosition) {
                    selectedCode = AIUtils.getInstance().addCursorIndicatorToSelection(selectedCode, (IEditorPart)textEditor);
                }
                return new CodeSnippet(selectedCode, null, 0, 0);
            }
        }
        throw new AISnippetExpansionFailureException(new AIExceptionData(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.KIND, String.format(AIExceptionKind.SNIPPET_EXPANSION_FAILURE.MESSAGE, "selected"), 1));
    }

    public SSProblemsFromSelectedResponse solveSnippetProblemsFromSelected(SSProblemsFromSelectedParams params, ITextEditor textEditor, ITextSelection textSelection, BooleanSupplier isCanceled) {
        if (params.selectionType == null) {
            return null;
        }
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile((IEditorPart)textEditor);
        if (editorFile == null) {
            return null;
        }
        IPath location = editorFile.getLocation();
        if (location == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
        if (document == null) {
            return null;
        }
        String filePath = location.toOSString();
        if (filePath == null) {
            return null;
        }
        IProject iProject = editorFile.getProject();
        if (iProject == null) {
            return null;
        }
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(filePath, iProject);
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(filePath, protectFileLine);
        }
        int startOffset = -1;
        int endOffset = -1;
        switch (params.selectionType) {
            case CODE: {
                startOffset = textSelection.getOffset();
                endOffset = textSelection.getOffset() + textSelection.getLength();
                break;
            }
            case FILE: {
                startOffset = 0;
                endOffset = document.getLength();
                break;
            }
            case CONTAINER: {
                IRfDefElement containerDefElement;
                startOffset = 0;
                endOffset = document.getLength();
                IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(new EditorPosition(editorFile, textSelection.getOffset()));
                if (namedElementAndScope == null) {
                    return null;
                }
                LanguageKind languageKind = namedElementAndScope.getLanguageKind();
                IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
                if (aiContributor == null || (containerDefElement = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAcceptedContainers(SnippetSelectionType.CONTAINER))) == null) break;
                ParserPath parserPath = containerDefElement.getParserPath();
                IRfSingleLangProject rfProject = containerDefElement.getRfProject();
                if (rfProject == null || parserPath == null || parserPath.path == null || !AIPathUtils.INSTANCE.pathsAreEqual(parserPath.path, rfProject.getProject(), filePath, iProject)) break;
                try {
                    startOffset = document.getLineOffset(containerDefElement.getStartLine() - 1);
                    endOffset = document.getLineOffset(containerDefElement.getEndLine() - 1) + document.getLineLength(containerDefElement.getEndLine() - 1);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    startOffset = 0;
                    endOffset = document.getLength();
                }
                break;
            }
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "problems from selected");
        List<Problem> problems = this.getProblemsForFileRange(editorFile, filePath, startOffset, endOffset, params.includeErrors, params.includeWarnings, params.maxNumberOfProblems, document, isCanceled);
        if (problems == null || problems.isEmpty()) {
            return null;
        }
        CodeSnippet codeSnippet = new CodeSnippet();
        if (params.includeProblematicCode) {
            try {
                String code = document.get(startOffset, endOffset - startOffset);
                if (params.selectionType != ProblemsFromSelectedType.FILE) {
                    code = AIExpansionUtils.INSTANCE.indentCodeSnippet(code, filePath, iProject);
                }
                codeSnippet.setCode(code);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return new SSProblemsFromSelectedResponse(problems, codeSnippet);
            }
            String pathRelativeToProject = AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject);
            int startLine = -1;
            int endLine = -1;
            if (params.selectionType != ProblemsFromSelectedType.FILE) {
                try {
                    startLine = document.getLineOfOffset(startOffset) + 1;
                    endLine = document.getLineOfOffset(endOffset - 1) + 1;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            codeSnippet.setFilePath(pathRelativeToProject);
            codeSnippet.setStartLine(startLine);
            codeSnippet.setEndLine(endLine);
        }
        return new SSProblemsFromSelectedResponse(problems, codeSnippet);
    }

    public String getLanguageFromActiveEditor() {
        String contentTypeId;
        IEditorInput editorInput;
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof DVTEditor) {
            LanguageKind languageKind;
            LanguageKind languageKind2 = languageKind = activeEditor instanceof BCEditor ? LanguageKind.BC : ((DVTEditor)activeEditor).getLanguageKind();
            if (languageKind != null && NATURE_TO_LANGUAGE.containsKey(languageKind.getLongName())) {
                return (String)NATURE_TO_LANGUAGE.get(languageKind.getLongName());
            }
        }
        if (!((editorInput = activeEditor.getEditorInput()) instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((IFileEditorInput)editorInput).getFile();
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
        if (contentType != null && AIUtils.CONTENT_TYPE_ID_TO_LANGUAGE.containsKey(contentTypeId = contentType.getId())) {
            return AIUtils.CONTENT_TYPE_ID_TO_LANGUAGE.get(contentTypeId);
        }
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        String fileExtension = fileName.substring(index);
        return AIUtils.EXTENSION_TO_LANGUAGE.get(fileExtension);
    }

    SSCodeBeforeAfterSelectionResponse solveSnippetCodeBeforeSelection(SSCodeBeforeAfterSelectionParams params, ITextEditor textEditor, ITextSelection textSelection) {
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile((IEditorPart)textEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(iPath.toOSString(), editorFile.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(iPath.toOSString(), protectFileLine);
        }
        try {
            IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
            int resultEndLine = textSelection.getStartLine();
            int resultEndOffset = textSelection.getOffset();
            int resultStartLine = resultEndLine - params.getMaxNumberOfLines() > 0 ? resultEndLine - params.getMaxNumberOfLines() : 0;
            int resultStartOffset = document.getLineOffset(resultStartLine);
            String codeBefore = document.get(resultStartOffset, resultEndOffset - resultStartOffset);
            return new SSCodeBeforeAfterSelectionResponse(new CodeSnippet(codeBefore, iPath.toOSString(), resultStartLine, resultEndLine));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    SSCodeBeforeAfterSelectionResponse solveSnippetCodeAfterSelection(SSCodeBeforeAfterSelectionParams params, ITextEditor textEditor, ITextSelection textSelection) {
        IFile editorFile = DVTFileUtils.getInstance().getEditorFile((IEditorPart)textEditor);
        if (editorFile == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        IPath iPath = editorFile.getLocation();
        if (iPath == null) {
            throw new AINoEditorException(new AIExceptionData(AIExceptionKind.NO_EDITOR_FOUND.KIND, AIExceptionKind.NO_EDITOR_FOUND.MESSAGE, 0));
        }
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(iPath.toOSString(), editorFile.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(iPath.toOSString(), protectFileLine);
        }
        try {
            IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
            int resultStartLine = textSelection.getEndLine();
            int resultStartOffset = textSelection.getOffset() + textSelection.getLength();
            int resultEndLine = resultStartLine + params.getMaxNumberOfLines() > document.getNumberOfLines() ? document.getNumberOfLines() - 1 : resultStartLine + params.getMaxNumberOfLines();
            int resultEndOffset = document.getLineOffset(resultEndLine) + document.getLineLength(resultEndLine);
            String codeBefore = document.get(resultStartOffset, resultEndOffset - resultStartOffset);
            return new SSCodeBeforeAfterSelectionResponse(new CodeSnippet(codeBefore, iPath.toOSString(), resultStartLine, resultEndLine));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public List<Problem> getProblemsForFileRange(IFile file, String filePath, int startOffset, int endOffset, boolean includeErrors, boolean includeWarnings, int maxNumberOfProblems, IDocument document, BooleanSupplier isCanceled) {
        IMarker[] markers;
        if (startOffset < 0 || endOffset < startOffset || maxNumberOfProblems <= 0) {
            return null;
        }
        try {
            markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 1);
            if (markers == null || markers.length == 0) {
                return null;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "problems from selected");
        List filteredMarkers = Arrays.stream(markers).filter(marker -> this.markerIsInsideRange((IMarker)marker, startOffset, endOffset, document)).filter(marker -> {
            try {
                return !LintingProblemsManager.LINTING_MARKERS.contains(marker.getType());
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }).filter(marker -> includeErrors && marker.getAttribute("severity", -1) == 2 || includeWarnings && marker.getAttribute("severity", -1) == 1).sorted(MARKERS_COMPARATOR).collect(Collectors.toList());
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (IMarker marker2 : filteredMarkers) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "problems from selected");
            int markerLine = marker2.getAttribute("lineNumber", -1);
            String message = marker2.getAttribute("message", null);
            int severity = marker2.getAttribute("severity", -1);
            if (markerLine <= 0 || message == null) continue;
            String severityString = severity == 2 ? "error" : "warning";
            String surroundingCode = DVTFileUtils.getInstance().getLinesFromFile(file, Math.max(markerLine - 3, 1), markerLine + 3, null);
            if (surroundingCode.endsWith("\n")) {
                surroundingCode = surroundingCode.substring(0, surroundingCode.length() - 1);
            }
            result.add(new Problem(filePath, markerLine, message, severityString, surroundingCode));
            if (result.size() >= maxNumberOfProblems) break;
        }
        return result;
    }

    private boolean markerIsInsideRange(IMarker marker, int startOffset, int endOffset, IDocument document) {
        int markerStart = marker.getAttribute("charStart", -1);
        int markerEnd = marker.getAttribute("charEnd", -1);
        if (markerStart < 0 || markerEnd < 0) {
            try {
                int startLine = document.getLineOfOffset(startOffset) + 1;
                int endLine = document.getLineOfOffset(endOffset) + 1;
                int markerLine = marker.getAttribute("lineNumber", -1);
                return startLine <= markerLine && markerLine <= endLine;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return markerEnd >= startOffset && markerStart <= endOffset;
    }
}

