/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ai;

import com.google.common.collect.ImmutableMap;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ai.AIExpansionUtils;
import ro.amiq.dvt.ai.AIPathUtils;
import ro.amiq.dvt.ai.AIProtectManager;
import ro.amiq.dvt.ai.AISymbolSolver;
import ro.amiq.dvt.ai.AIUtils;
import ro.amiq.dvt.ai.HotspotManager;
import ro.amiq.dvt.ai.contributor.AILangContributorManager;
import ro.amiq.dvt.ai.contributor.IAILangContributor;
import ro.amiq.dvt.ai.model.CodeMatchPriority;
import ro.amiq.dvt.ai.model.CodeSnippet;
import ro.amiq.dvt.ai.model.DependenciesExpansionStrategy;
import ro.amiq.dvt.ai.model.Dependency;
import ro.amiq.dvt.ai.model.DependencySource;
import ro.amiq.dvt.ai.model.EditorPosition;
import ro.amiq.dvt.ai.model.EditorRange;
import ro.amiq.dvt.ai.model.MultiRootTree;
import ro.amiq.dvt.ai.model.OutlineResult;
import ro.amiq.dvt.ai.model.SnippetDependenciesOfSelectedType;
import ro.amiq.dvt.ai.model.SnippetOutlineOfSelectedType;
import ro.amiq.dvt.ai.model.SnippetSelectionType;
import ro.amiq.dvt.ai.model.TreeElement;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionData;
import ro.amiq.dvt.ai.model.exceptions.AIExceptionKind;
import ro.amiq.dvt.ai.model.exceptions.AINoDHAvailableException;
import ro.amiq.dvt.ai.model.exceptions.AINoVHAvailableException;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.symbolcollector.SymbolQueryKey;
import ro.amiq.dvt.symbolcollector.SymbolQueryUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyElDesignHierarchyModel;

public abstract class AISnippetSolverCommon {
    protected static final Map<String, String> NATURE_TO_LANGUAGE = new ImmutableMap.Builder().put((Object)"Verilog/SystemVerilog Language", (Object)"SystemVerilog").put((Object)"VHDL Language", (Object)"VHDL").put((Object)"e Language", (Object)"e Language").put((Object)"PSS Language", (Object)"PSS").put((Object)"Build Config", (Object)"DVT Build Configuration File").build();

    public List<String> solveSnippetLanguage(IProject iProject, BooleanSupplier isCanceled) {
        if (iProject == null) {
            return null;
        }
        List natures = DVTNature.getProjectNatures((IProject)iProject);
        ArrayList<String> languages = new ArrayList<String>();
        for (String nature : natures) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "language");
            String language = NATURE_TO_LANGUAGE.get(nature);
            if (language == null) continue;
            languages.add(language);
        }
        return languages;
    }

    public CodeSnippet solveSnippetSelected(EditorPosition editorPosition, SnippetSelectionType selectionType, boolean indicateCursorPosition, DVTEditor editor, BooleanSupplier isCanceled) {
        IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition);
        if (namedElementAndScope == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "selected");
        CodeSnippet result = AIExpansionUtils.INSTANCE.getNamedElementExpansionForSelectionType(namedElementAndScope, selectionType, editor);
        if (result == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "selected");
        if (indicateCursorPosition) {
            AIUtils.getInstance().addCursorPositionIndicatorToCodeSnippet(result, editor, editorPosition);
        }
        return result;
    }

    public String solveSnippetNameOfSelectedContainer(EditorPosition editorPosition, BooleanSupplier isCanceled) {
        IRfNamedElementAndScope namedElementAndScope;
        if (editorPosition == null) {
            return null;
        }
        IFile file = editorPosition.getFile();
        if (file == null) {
            return null;
        }
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(editorPosition.getFullPath(), file.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(editorPosition.getFullPath(), protectFileLine);
        }
        if ((namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition)) == null) {
            return null;
        }
        LanguageKind languageKind = namedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "name of selected container");
        IRfDefElement namedElementContainer = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAllContainersExceptMethods());
        if (namedElementContainer == null) {
            return null;
        }
        IRfDefElement typeAliasContainer = this.resolveTypeAliasDefElement(namedElementAndScope);
        if (typeAliasContainer != null) {
            namedElementContainer = typeAliasContainer;
        }
        String containerPath = AIUtils.getInstance().getFilePathFromDefElement(namedElementContainer, false);
        IRfSingleLangProject rfProject = namedElementContainer.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, rfProject.getProject(), editorPosition.getFullPath(), file.getProject())) {
            return null;
        }
        return AIUtils.getInstance().getElementName(namedElementContainer);
    }

    public String solveSnippetKindOfSelectedContainer(EditorPosition editorPosition, BooleanSupplier isCanceled) {
        IRfNamedElementAndScope namedElementAndScope;
        if (editorPosition == null) {
            return null;
        }
        IFile file = editorPosition.getFile();
        if (file == null) {
            return null;
        }
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(editorPosition.getFullPath(), file.getProject());
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(editorPosition.getFullPath(), protectFileLine);
        }
        if ((namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition)) == null) {
            return null;
        }
        LanguageKind languageKind = namedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "kind of selected container");
        IRfDefElement namedElementContainer = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAllContainersExceptMethods());
        if (namedElementContainer == null) {
            return null;
        }
        IRfDefElement typeAliasContainer = this.resolveTypeAliasDefElement(namedElementAndScope);
        if (typeAliasContainer != null) {
            namedElementContainer = typeAliasContainer;
        }
        String containerPath = AIUtils.getInstance().getFilePathFromDefElement(namedElementContainer, false);
        IRfSingleLangProject rfProject = namedElementContainer.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, rfProject.getProject(), editorPosition.getFullPath(), file.getProject())) {
            return null;
        }
        IRfKind defElementKind = aiContributor.getDefElementKind(namedElementContainer);
        if (defElementKind == null) {
            return null;
        }
        return defElementKind.getName();
    }

    public OutlineResult solveSnippetOutlineOfSelected(SnippetOutlineOfSelectedType selectedType, EditorPosition editorPosition, BooleanSupplier isCanceled) {
        if (editorPosition == null) {
            return null;
        }
        IFile file = editorPosition.getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(editorPosition.getFullPath(), project);
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(editorPosition.getFullPath(), protectFileLine);
        }
        if (SnippetOutlineOfSelectedType.FILE.equals(selectedType)) {
            return this.getOutlineOfFile(editorPosition.getFullPath(), project);
        }
        IRfNamedElementAndScope namedElementAndScopeAtEditorPosition = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition);
        if (namedElementAndScopeAtEditorPosition == null) {
            return null;
        }
        LanguageKind languageKind = namedElementAndScopeAtEditorPosition.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "outline of");
        IRfDefElement defElement = AIUtils.getInstance().getNamedElementContainer(namedElementAndScopeAtEditorPosition, aiContributor.getAcceptedContainers(SnippetSelectionType.CONTAINER));
        if (defElement == null) {
            return null;
        }
        IRfDefElement typeAliasContainer = this.resolveTypeAliasDefElement(namedElementAndScopeAtEditorPosition);
        if (typeAliasContainer != null) {
            defElement = typeAliasContainer;
        }
        String defElementPath = AIUtils.getInstance().getFilePathFromDefElement(defElement, false);
        IRfSingleLangProject rfProject = defElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (defElementPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(defElementPath, rfProject.getProject(), editorPosition.getFullPath(), project)) {
            return null;
        }
        String elementKind = AIUtils.getInstance().getDefElementKind(defElement);
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "outline of");
        IDVTElementWrapper elementOutline = this.getOutlineDataForDefElement(defElement);
        if (elementOutline == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "outline of");
        ArrayList<TreeElement> roots = new ArrayList<TreeElement>();
        roots.add(this.convertToOutlineTreeElement(elementOutline));
        List<TreeElement> additionalOutlines = aiContributor.getAdditionalOutlinesForDefElement(defElement);
        if (additionalOutlines != null) {
            roots.addAll(additionalOutlines);
        }
        return new OutlineResult(AIUtils.getInstance().getElementName(defElement), elementKind, AIUtils.getInstance().getFilePathFromDefElement(defElement, true), -1, -1, new MultiRootTree(roots));
    }

    public List<OutlineResult> solveSnippetSymbolOutline(String symbolQuery, IProject iProject, BooleanSupplier isCanceled) {
        ArrayList<OutlineResult> results = new ArrayList<OutlineResult>();
        if (this.isFileQuery(symbolQuery)) {
            List<String> fullPaths = AISymbolSolver.INSTANCE.getAbsolutePathsFromFileQuery(symbolQuery, iProject, isCanceled);
            for (String fullPath : fullPaths) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "outline of");
                OutlineResult fileOutline = this.getOutlineOfFile(fullPath, iProject);
                if (fileOutline == null) continue;
                results.add(fileOutline);
            }
            return results;
        }
        List<IRfNamedElement> namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolQuery, iProject, isCanceled);
        for (IRfNamedElement namedElement : namedElements) {
            List<TreeElement> additionalOutlines;
            TreeElement root;
            IDVTElementWrapper symbolOutline;
            IRfDefElement defElement;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "outline of");
            if (namedElement instanceof IMacroInfo) continue;
            if (namedElement instanceof IRfTypeAliasElement) {
                namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
            }
            if ((defElement = namedElement.getDeclaration()) == null || (symbolOutline = this.getOutlineDataForDefElement(defElement)) == null || (root = this.convertToOutlineTreeElement(symbolOutline)) == null) continue;
            ArrayList<TreeElement> roots = new ArrayList<TreeElement>(Arrays.asList(root));
            IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(namedElement.getLanguageKind());
            if (aiContributor != null && (additionalOutlines = aiContributor.getAdditionalOutlinesForDefElement(defElement)) != null) {
                roots.addAll(additionalOutlines);
            }
            results.add(new OutlineResult(AIUtils.getInstance().getElementName(namedElement), AIUtils.getInstance().getDefElementKind(defElement), AIUtils.getInstance().getFilePathFromNamedElement(namedElement, true), -1, -1, new MultiRootTree(roots)));
        }
        return results;
    }

    public List<String> solveSnippetSymbolFilename(String symbolQuery, IProject iProject, BooleanSupplier isCanceled) {
        if (this.isFileQuery(symbolQuery)) {
            List<String> fullPaths = AISymbolSolver.INSTANCE.getAbsolutePathsFromFileQuery(symbolQuery, iProject, isCanceled);
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "filename of");
            return fullPaths.stream().map(fullPath -> Paths.get(fullPath, new String[0]).getFileName().toString()).collect(Collectors.toList());
        }
        List<IRfNamedElement> namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolQuery, iProject, isCanceled);
        HashSet<String> uniqueFileNames = new HashSet<String>();
        for (IRfNamedElement namedElement : namedElements) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "filename of");
            if (namedElement instanceof IMacroInfo) {
                ParserPath macroParserPath = namedElement.getMacroParserPath();
                if (macroParserPath == null || macroParserPath.path == null) continue;
                uniqueFileNames.add(Paths.get(macroParserPath.path, new String[0]).getFileName().toString());
                continue;
            }
            String path = AIUtils.getInstance().getFilePathFromNamedElement(namedElement, false);
            if (path == null) continue;
            uniqueFileNames.add(Paths.get(path, new String[0]).getFileName().toString());
        }
        return new ArrayList<String>(uniqueFileNames);
    }

    public List<CodeSnippet> solveSnippetExamplesOf(SymbolQueryKey queryKey, int maxNumberOfResults, IProject iProject, BooleanSupplier isCanceled) {
        ArrayList<CodeSnippet> result = new ArrayList<CodeSnippet>();
        Map<IRfNamedElement, EditorRange> elementsAndLocations = AISymbolSolver.INSTANCE.getNamedElementsMatchingType(queryKey, iProject, isCanceled);
        if (elementsAndLocations == null) {
            return result;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "examples of");
        ArrayList<MatchAndPriority> elementsAndPriorities = new ArrayList<MatchAndPriority>();
        for (Map.Entry<IRfNamedElement, EditorRange> entry : elementsAndLocations.entrySet()) {
            elementsAndPriorities.add(new MatchAndPriority(entry.getKey(), this.getEditorRangePriority(entry.getValue())));
        }
        elementsAndPriorities.sort((map1, map2) -> Integer.compare(map1.priority.getPriority(), map2.priority.getPriority()));
        int currentNumberOfResults = 0;
        int i = 0;
        while (i < elementsAndPriorities.size()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "examples of");
            Collection defElements = ((IRfNamedElement)((MatchAndPriority)elementsAndPriorities.get((int)i)).match).getDeclarations();
            boolean foundValidElement = false;
            for (IRfDefElement defElement : defElements) {
                CodeSnippet codeSnippet;
                if (defElement == null || (codeSnippet = AIExpansionUtils.INSTANCE.expandDefElement(defElement, null, false, true)) == null) continue;
                foundValidElement = true;
                result.add(codeSnippet);
            }
            if (foundValidElement && ++currentNumberOfResults >= maxNumberOfResults) break;
            ++i;
        }
        return result;
    }

    public List<CodeSnippet> solveSnippetUsagesOf(String symbolQuery, EditorPosition cursorPosition, int maxNumberOfResults, int surroundingLines, IProject iProject, BooleanSupplier isCanceled) {
        if (this.isFileQuery(symbolQuery)) {
            return this.getUsagesOfFile(symbolQuery, maxNumberOfResults, iProject, isCanceled);
        }
        List<EditorRange> usagesRanges = this.getUsagesForNamedElements(this.getSymbolsFromQueryOrCursorPosition(symbolQuery, cursorPosition, iProject, isCanceled), isCanceled);
        if (usagesRanges == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
        return surroundingLines < 0 ? this.getSurroundingContainersFromUsagesRanges(usagesRanges, maxNumberOfResults, isCanceled) : this.getUsagesWithSurroundingLinesFromRanges(usagesRanges, surroundingLines, maxNumberOfResults, isCanceled);
    }

    public List<CodeSnippet> solveSnippetEditorsHotspots(int maxNumberOfResults, boolean onlyOpenEditors, String excludedFilePath, BooleanSupplier isCanceled) {
        ArrayList<CodeSnippet> result = new ArrayList<CodeSnippet>();
        int currentNumberOfResults = 0;
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, onlyOpenEditors ? "recent code sections from open editors" : "recent code sections");
        List<IRfDefElement> hotspots = onlyOpenEditors ? HotspotManager.getInstance().getRecentHotspotsFromOpenEditors() : HotspotManager.getInstance().getRecentHotspots();
        for (IRfDefElement hotspot : hotspots) {
            CodeSnippet codeSnippet;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, onlyOpenEditors ? "recent code sections from open editors" : "recent code sections");
            if (excludedFilePath != null && AIPathUtils.INSTANCE.normalizePath(excludedFilePath).equals(AIUtils.getInstance().getFilePathFromDefElement(hotspot, false)) || (codeSnippet = AIExpansionUtils.INSTANCE.expandDefElement(hotspot, null, false, true)) == null) continue;
            result.add(codeSnippet);
            if (++currentNumberOfResults >= maxNumberOfResults) break;
        }
        return result;
    }

    public List<TreeElement> solveSnippetDhVhContext(DVTEditor editor, boolean dhContext, int topExpand, int bottomExpand, BooleanSupplier isCanceled) {
        if (dhContext && !AbstractBreadcrumbUtilsCommon.editorHasDesignContext((DVTEditor)editor)) {
            throw new AINoDHAvailableException(new AIExceptionData(AIExceptionKind.DH_NOT_AVAILABLE.KIND, AIExceptionKind.DH_NOT_AVAILABLE.MESSAGE, 1));
        }
        if (!dhContext && !AbstractBreadcrumbUtilsCommon.editorHasVerificationContext((DVTEditor)editor)) {
            throw new AINoVHAvailableException(new AIExceptionData(AIExceptionKind.VH_NOT_AVAILABLE.KIND, AIExceptionKind.VH_NOT_AVAILABLE.MESSAGE, 1));
        }
        List<TreeElement> result = dhContext ? this.getDhTree(editor, topExpand, bottomExpand, isCanceled) : this.getVhTree(editor, topExpand, bottomExpand, isCanceled);
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, dhContext ? "design hierarchy" : "verification hierarchy");
        if (result == null) {
            throw dhContext ? new AINoDHAvailableException(new AIExceptionData(AIExceptionKind.DH_NOT_AVAILABLE.KIND, AIExceptionKind.DH_NOT_AVAILABLE.MESSAGE, 1)) : new AINoVHAvailableException(new AIExceptionData(AIExceptionKind.VH_NOT_AVAILABLE.KIND, AIExceptionKind.VH_NOT_AVAILABLE.MESSAGE, 1));
        }
        return result;
    }

    public List<CodeSnippet> solveSnippetSymbol(String symbolQuery, int maxNumberOfSymbols, IProject project, BooleanSupplier isCanceled) {
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "symbol");
        return AISymbolSolver.INSTANCE.solveSymbol(symbolQuery, maxNumberOfSymbols > 0 ? maxNumberOfSymbols : Integer.MAX_VALUE, project, isCanceled);
    }

    public List<Dependency> solveSnippetDependenciesOfSelected(EditorPosition editorPosition, SnippetDependenciesOfSelectedType selectedType, DependenciesExpansionStrategy expansionStrategy, int wrappingCharCount, int separatorCharCount, int charCountLimit, BooleanSupplier isCanceled) {
        if (editorPosition == null || selectedType == null || expansionStrategy == null) {
            return null;
        }
        IFile file = editorPosition.getFile();
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        int protectFileLine = AIProtectManager.INSTANCE.getProtectLineNumber(editorPosition.getFullPath(), project);
        if (protectFileLine > 0) {
            AIUtils.getInstance().onDidAccessProtectedFile(editorPosition.getFullPath(), protectFileLine);
        }
        if (selectedType == SnippetDependenciesOfSelectedType.FILE) {
            List<DependencySource> dependencySources = this.getDependencySourcesForFile(editorPosition.getFullPath(), project, isCanceled);
            return this.getDependenciesFromSources(dependencySources, expansionStrategy, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
        }
        IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(editorPosition);
        if (namedElementAndScope == null) {
            return null;
        }
        LanguageKind languageKind = namedElementAndScope.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        IRfDefElement container = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAllContainersExceptMethods());
        if (container == null) {
            return null;
        }
        IRfDefElement typeAliasContainer = this.resolveTypeAliasDefElement(namedElementAndScope);
        if (typeAliasContainer != null) {
            container = typeAliasContainer;
        }
        String containerPath = AIUtils.getInstance().getFilePathFromDefElement(container, false);
        IRfSingleLangProject rfProject = container.getRfProject();
        if (rfProject == null) {
            return null;
        }
        if (containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, rfProject.getProject(), editorPosition.getFullPath(), project)) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
        List<DependencySource> dependencySources = this.getDependencySourcesForContainer(container, editorPosition, languageKind, isCanceled);
        if (dependencySources == null) {
            return null;
        }
        return this.getDependenciesFromSources(dependencySources, expansionStrategy, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
    }

    public List<Dependency> solveSnippetDependenciesOfSymbol(String symbolQuery, DependenciesExpansionStrategy expansionStrategy, int wrappingCharCount, int separatorCharCount, int charCountLimit, IProject iProject, BooleanSupplier isCanceled) {
        LinkedHashSet<DependencySource> dependencySources = new LinkedHashSet<DependencySource>();
        if (this.isFileQuery(symbolQuery)) {
            List<String> fullPaths = AISymbolSolver.INSTANCE.getAbsolutePathsFromFileQuery(symbolQuery, iProject, isCanceled);
            for (String fullPath : fullPaths) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
                dependencySources.addAll(this.getDependencySourcesForFile(fullPath, iProject, isCanceled));
            }
            return this.getDependenciesFromSources(new ArrayList<DependencySource>(dependencySources), expansionStrategy, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
        }
        List<IRfNamedElement> namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolQuery, iProject, isCanceled);
        for (IRfNamedElement namedElement : namedElements) {
            List<DependencySource> namedElementDependencySources;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            if (namedElement instanceof IMacroInfo) continue;
            if (namedElement instanceof IRfTypeAliasElement) {
                namedElement = ((IRfTypeAliasElement)namedElement).getTranslatedType();
            }
            if ((namedElementDependencySources = this.getDependencySourcesForContainer(namedElement.getDeclaration(), AIUtils.getInstance().getEditorPositionFromDefElement(namedElement.getDeclaration()), namedElement.getLanguageKind(), isCanceled)) == null) continue;
            dependencySources.addAll(namedElementDependencySources);
        }
        return this.getDependenciesFromSources(new ArrayList<DependencySource>(dependencySources), expansionStrategy, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
    }

    private List<DependencySource> getDependencySourcesForFile(String fullPath, IProject iProject, BooleanSupplier isCanceled) {
        List<IRfDefElement> containersInFile = AIUtils.getInstance().getContainersInFile(fullPath, iProject, false);
        if (containersInFile == null) {
            return new ArrayList<DependencySource>();
        }
        LinkedHashSet dependencySources = new LinkedHashSet();
        for (IRfDefElement container : containersInFile) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            List<DependencySource> containerDependencies = this.getDependencySourcesForContainer(container, AIUtils.getInstance().getEditorPositionFromDefElement(container), container.getLanguageKind(), isCanceled);
            if (containerDependencies == null) continue;
            ArrayList<DependencySource> dependenciesFiltered = new ArrayList<DependencySource>();
            for (DependencySource containerDependency : containerDependencies) {
                String dependencyFilePath;
                if (!containerDependency.isMacro() && (dependencyFilePath = AIUtils.getInstance().getFilePathFromDefElement(containerDependency.getDefElement(), false)) != null && AIPathUtils.INSTANCE.normalizePath(dependencyFilePath).equals(AIPathUtils.INSTANCE.normalizePath(fullPath))) continue;
                dependenciesFiltered.add(containerDependency);
            }
            dependencySources.addAll(dependenciesFiltered);
        }
        return new ArrayList<DependencySource>(dependencySources);
    }

    public List<DependencySource> getDependencySourcesForContainer(IRfDefElement container, EditorPosition cursorPosition, LanguageKind languageKind, BooleanSupplier isCanceled) {
        if (languageKind == null || container == null) {
            return null;
        }
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        return aiContributor.getContainerDependencySources(container, cursorPosition, isCanceled);
    }

    public List<CodeSnippet> getUsagesWithSurroundingLinesFromRanges(List<EditorRange> usagesRanges, int surroundingLines, int maxNumberOfResults, BooleanSupplier isCanceled) {
        List rangesAndPrioritiesSorted = usagesRanges.stream().map(range -> new MatchAndPriority(range, this.getEditorRangePriority((EditorRange)range))).sorted((map1, map2) -> Integer.compare(map1.priority.getPriority(), map2.priority.getPriority())).collect(Collectors.toList());
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
        int currentNumberOfResults = 0;
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        int i = 0;
        while (i < rangesAndPrioritiesSorted.size()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
            EditorRange usageRange = (EditorRange)((MatchAndPriority)rangesAndPrioritiesSorted.get((int)i)).match;
            IFile file = usageRange.getFile();
            if (file != null) {
                CodeSnippet usageExpanded;
                IProject iProject = file.getProject();
                if (!AIProtectManager.INSTANCE.isFileProtected(usageRange.getFullPath(), iProject) && (usageExpanded = AIExpansionUtils.INSTANCE.increaseEditorRange(usageRange, surroundingLines, true)) != null) {
                    results.add(usageExpanded);
                    if (++currentNumberOfResults >= maxNumberOfResults) break;
                }
            }
            ++i;
        }
        return results;
    }

    private List<CodeSnippet> getSurroundingContainersFromUsagesRanges(List<EditorRange> usagesRanges, int maxNumberOfResults, BooleanSupplier isCanceled) {
        List<IRfDefElement> containers = new ArrayList<IRfDefElement>();
        for (EditorRange usageRange : usagesRanges) {
            IRfDefElement container2;
            LanguageKind languageKind;
            IAILangContributor aiContributor;
            IRfNamedElementAndScope namedElementAndScope;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
            IFile file = usageRange.getFile();
            if (file == null || (namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(new EditorPosition(file, usageRange.getStartOffset()))) == null || (aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind = namedElementAndScope.getLanguageKind())) == null || (container2 = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAcceptedContainers(SnippetSelectionType.CONTAINER))) == null) continue;
            String containerPath = AIUtils.getInstance().getFilePathFromDefElement(container2, false);
            IRfSingleLangProject rfProject = container2.getRfProject();
            if (rfProject == null || containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, rfProject.getProject(), usageRange.getFullPath(), file.getProject()) || AIProtectManager.INSTANCE.isDefElementProtected(container2)) continue;
            containers.add(container2);
        }
        containers = AIUtils.getInstance().removeDuplicateDefElements(containers, false);
        if (containers == null || containers.isEmpty()) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
        List containersAndPrioritiesSorted = containers.stream().map(container -> new MatchAndPriority(container, this.getEditorRangePriority(AIUtils.getInstance().getEditorRangeFromDefElement((IRfDefElement)container)))).sorted((map1, map2) -> Integer.compare(map1.priority.getPriority(), map2.priority.getPriority())).collect(Collectors.toList());
        int currentNumberOfResults = 0;
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        int i = 0;
        while (i < containersAndPrioritiesSorted.size()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
            CodeSnippet containerExpanded = AIExpansionUtils.INSTANCE.expandDefElement((IRfDefElement)((MatchAndPriority)containersAndPrioritiesSorted.get((int)i)).match, null, false, true);
            if (containerExpanded != null) {
                results.add(containerExpanded);
                if (++currentNumberOfResults >= maxNumberOfResults) break;
            }
            ++i;
        }
        return results;
    }

    private List<TreeElement> getDhTree(DVTEditor editor, int topExpand, int bottomExpand, BooleanSupplier isCanceled) {
        if (editor == null) {
            return null;
        }
        IProject iProject = editor.getProject();
        if (iProject == null) {
            return null;
        }
        BreadcrumbInput bcInput = DHBreadcrumbUtils.getBreadcrumbInput(DHBreadcrumbViewer.class, (IDVTBreadcrumbHost)editor);
        if (bcInput == null) {
            return null;
        }
        List segments = bcInput.getInputSegments();
        if (segments == null || segments.size() < 2) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
        List segmentsFiltered = segments.subList(1, segments.size());
        List upwardsDesignElements = segmentsFiltered.stream().map(segment -> segment.getDesignElement(iProject)).collect(Collectors.toList());
        IRfBreadcrumbElement lastElement = ((BreadcrumbSegment)segmentsFiltered.get(segmentsFiltered.size() - 1)).getElement();
        if (!(lastElement instanceof ElementPath)) {
            return null;
        }
        ElementPath elementPath = ((ElementPath)lastElement).toElaborationForm();
        List<String> upwardsBcSegmentsNames = AIUtils.getInstance().getSegmentsFromElementPath(elementPath);
        if (upwardsBcSegmentsNames == null) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
        int currentLevel = upwardsBcSegmentsNames.size();
        int maxLevel = currentLevel + bottomExpand;
        LazyElDesignHierarchyModel model = new LazyElDesignHierarchyModel(iProject);
        TreeElement downwardsSubtree = this.getSubtreeForDHPath(new LinkedList<String>(upwardsBcSegmentsNames), currentLevel, maxLevel, model, null, isCanceled);
        if (currentLevel == 1) {
            return Arrays.asList(downwardsSubtree);
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
        ArrayList<TreeElement> upwardsTreeElements = new ArrayList<TreeElement>();
        int i = 0;
        while (i < currentLevel - 1) {
            upwardsTreeElements.add(new TreeElement());
            ++i;
        }
        i = 0;
        while (i < currentLevel - 1) {
            ((TreeElement)upwardsTreeElements.get(i)).addChild(i == currentLevel - 2 ? downwardsSubtree : (TreeElement)upwardsTreeElements.get(i + 1));
            ((TreeElement)upwardsTreeElements.get(i)).setElement(i > 0 ? this.computeDHTreeElementLabel(upwardsBcSegmentsNames.get(i), this.getAssociatedTypeName(upwardsDesignElements.get(i))) : upwardsBcSegmentsNames.get(i));
            ++i;
        }
        downwardsSubtree.setElement(this.computeDHTreeElementLabel(upwardsBcSegmentsNames.get(currentLevel - 1), this.getAssociatedTypeName(upwardsDesignElements.get(currentLevel - 1))));
        if (topExpand == 0) {
            return Arrays.asList((TreeElement)upwardsTreeElements.get(0));
        }
        i = Math.max(currentLevel - topExpand - 1, 0);
        while (i < currentLevel - 1) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
            TreeElement element = (TreeElement)upwardsTreeElements.get(i);
            String[] pathSegments = upwardsBcSegmentsNames.subList(0, i + 1).toArray(new String[0]);
            String nextSegment = upwardsBcSegmentsNames.get(i + 1);
            List children = model.getAllChildrenOfPath(TreePath.of(null, (String[])pathSegments, null));
            if (children != null && !children.isEmpty()) {
                for (TreePath child : children) {
                    if (nextSegment.equals(child.getLastSegment())) continue;
                    TreeElement childTreeElement = new TreeElement();
                    childTreeElement.setElement(this.computeDHTreeElementLabel(child.getLastSegment(), this.getAssociatedTypeName(child.getElement())));
                    element.addChild(childTreeElement);
                }
            }
            ++i;
        }
        return Arrays.asList((TreeElement)upwardsTreeElements.get(0));
    }

    private TreeElement getSubtreeForDHPath(LinkedList<String> pathSegments, int level, int maxLevel, LazyElDesignHierarchyModel model, String currentAssociatedTypeName, BooleanSupplier isCanceled) {
        TreeElement treeElement = new TreeElement(this.computeDHTreeElementLabel(pathSegments.getLast(), currentAssociatedTypeName), null);
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
        List children = model.getAllChildrenOfPath(TreePath.of(null, (String[])pathSegments.toArray(new String[0]), null));
        if (children != null && !children.isEmpty() && level < maxLevel) {
            for (TreePath child : children) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "design hierarchy");
                pathSegments.addLast(child.getLastSegment());
                String childAssociatedTypeName = this.getAssociatedTypeName(child.getElement());
                TreeElement childElement = this.getSubtreeForDHPath(pathSegments, level + 1, maxLevel, model, childAssociatedTypeName, isCanceled);
                treeElement.addChild(childElement);
                pathSegments.removeLast();
            }
        }
        return treeElement;
    }

    private List<TreeElement> getVhTree(DVTEditor editor, int topExpand, int bottomExpand, BooleanSupplier isCanceled) {
        BreadcrumbInput bcInput = VHBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, (IDVTBreadcrumbHost)editor);
        if (bcInput == null) {
            return null;
        }
        LanguageKind languageKind = editor.getLanguageKind();
        IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
        if (aiContributor == null) {
            return null;
        }
        ILabelProvider labelProvider = aiContributor.getVhElementLabelProvider(editor);
        if (labelProvider == null) {
            return null;
        }
        List vhSegments = bcInput.getInputSegments();
        if (vhSegments == null || vhSegments.isEmpty()) {
            return null;
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "verification hierarchy");
        ArrayList<IRfVHBreadcrumbElement> upwardsBcElements = new ArrayList<IRfVHBreadcrumbElement>();
        for (BreadcrumbSegment vhSegment : vhSegments) {
            IRfBreadcrumbElement element = vhSegment.getElement();
            if (!(element instanceof IRfVHBreadcrumbElement)) {
                return null;
            }
            upwardsBcElements.add((IRfVHBreadcrumbElement)element);
        }
        int currentLevel = upwardsBcElements.size();
        int maxLevel = currentLevel + bottomExpand;
        TreeElement downwardsSubtree = this.getSubtreeForVHElement((IRfVHBreadcrumbElement)upwardsBcElements.get(currentLevel - 1), labelProvider, currentLevel, maxLevel, isCanceled);
        if (currentLevel == 1) {
            return Arrays.asList(downwardsSubtree);
        }
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "verification hierarchy");
        ArrayList<TreeElement> upwardsTreeElements = new ArrayList<TreeElement>();
        int i = 0;
        while (i < currentLevel - 1) {
            upwardsTreeElements.add(new TreeElement());
            ++i;
        }
        i = 0;
        while (i < currentLevel - 1) {
            ((TreeElement)upwardsTreeElements.get(i)).addChild(i == currentLevel - 2 ? downwardsSubtree : (TreeElement)upwardsTreeElements.get(i + 1));
            ((TreeElement)upwardsTreeElements.get(i)).setElement(labelProvider.getText(upwardsBcElements.get(i)));
            ++i;
        }
        if (topExpand == 0) {
            return Arrays.asList((TreeElement)upwardsTreeElements.get(0));
        }
        i = Math.max(currentLevel - topExpand - 1, 0);
        while (i < currentLevel - 1) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "verification hierarchy");
            List children = ((IRfVHBreadcrumbElement)upwardsBcElements.get(i)).getAllVHChildren();
            if (children != null && !children.isEmpty()) {
                String nextSegmentName = labelProvider.getText(upwardsBcElements.get(i + 1));
                for (IRfVHBreadcrumbElement child : children) {
                    String childName = labelProvider.getText((Object)child);
                    if (childName.equals(nextSegmentName)) continue;
                    ((TreeElement)upwardsTreeElements.get(i)).addChild(new TreeElement(childName, null));
                }
            }
            ++i;
        }
        return Arrays.asList((TreeElement)upwardsTreeElements.get(0));
    }

    public TreeElement getSubtreeForVHElement(IRfVHBreadcrumbElement bcElement, ILabelProvider labelProvider, int level, int maxLevel, BooleanSupplier isCanceled) {
        TreeElement treeElement = new TreeElement(labelProvider.getText((Object)bcElement), null);
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "verification hierarchy");
        List children = bcElement.getAllVHChildren();
        if (children != null && !children.isEmpty() && level < maxLevel) {
            for (IRfVHBreadcrumbElement child : children) {
                AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "verification hierarchy");
                TreeElement childElement = this.getSubtreeForVHElement(child, labelProvider, level + 1, maxLevel, isCanceled);
                treeElement.addChild(childElement);
            }
        }
        return treeElement;
    }

    public List<IRfNamedElement> getSymbolsFromQueryOrCursorPosition(String symbolQuery, EditorPosition cursorPosition, IProject iProject, BooleanSupplier isCanceled) {
        if (symbolQuery != null && !symbolQuery.isEmpty() && cursorPosition != null || (symbolQuery == null || symbolQuery.isEmpty()) && cursorPosition == null) {
            return null;
        }
        ArrayList<IRfNamedElement> namedElements = new ArrayList();
        AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
        if (cursorPosition != null) {
            IRfNamedElementAndScope namedElementAndScope = AIUtils.getInstance().getNamedElementAndScopeAtEditorPosition(cursorPosition);
            if (namedElementAndScope == null) {
                return null;
            }
            IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
            if (namedElement != null) {
                namedElements.add(namedElement);
            } else {
                LanguageKind languageKind = namedElementAndScope.getLanguageKind();
                IAILangContributor aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind);
                if (aiContributor == null) {
                    return null;
                }
                IRfDefElement container = AIUtils.getInstance().getNamedElementContainer(namedElementAndScope, aiContributor.getAcceptedContainers(SnippetSelectionType.CONTAINER));
                if (container == null) {
                    return null;
                }
                String containerPath = AIUtils.getInstance().getFilePathFromDefElement(container, false);
                IRfSingleLangProject rfProject = container.getRfProject();
                if (rfProject == null) {
                    return null;
                }
                if (containerPath != null && !AIPathUtils.INSTANCE.pathsAreEqual(containerPath, rfProject.getProject(), cursorPosition.getFullPath(), iProject)) {
                    return null;
                }
                namedElement = container.getNamedElement();
                if (namedElement == null) {
                    return null;
                }
                namedElements.add(namedElement);
            }
        } else {
            namedElements = AISymbolSolver.INSTANCE.getNamedElementsByName(symbolQuery, iProject, isCanceled);
        }
        return namedElements;
    }

    public List<EditorRange> getUsagesForNamedElements(List<IRfNamedElement> namedElements, BooleanSupplier isCanceled) {
        if (namedElements == null || namedElements.isEmpty()) {
            return null;
        }
        LinkedHashSet<EditorRange> usages = new LinkedHashSet<EditorRange>();
        for (IRfNamedElement namedElement : namedElements) {
            LanguageKind languageKind;
            IAILangContributor aiContributor;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
            IRfSingleLangProject rfProject = namedElement.getRfProject();
            if (rfProject == null || (aiContributor = AILangContributorManager.INSTANCE.getContributor(languageKind = namedElement.getLanguageKind())) == null) continue;
            aiContributor.computeReferences(usages, namedElement, rfProject.getProject());
        }
        return new ArrayList<EditorRange>(usages);
    }

    private List<CodeSnippet> getUsagesOfFile(String fileQuery, int maxNumberOfResults, IProject iProject, BooleanSupplier isCanceled) {
        if (iProject == null) {
            return null;
        }
        IRfSingleLangProject vlogProject = RfMixedLangManager.getInstance().getRfSingleLangProject(iProject, "ro.amiq.vlogdt.VlogNature", false);
        if (vlogProject == null) {
            return null;
        }
        ArrayList<CodeSnippet> results = new ArrayList<CodeSnippet>();
        HashSet<String> uniqueFiles = new HashSet<String>();
        List<String> fullPaths = AISymbolSolver.INSTANCE.getAbsolutePathsFromFileQuery(fileQuery, iProject, isCanceled);
        for (String fullPath : fullPaths) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "usages of");
            Set includingFiles = vlogProject.getIncludingFilesForFilePath(fullPath);
            if (includingFiles == null || includingFiles.isEmpty()) continue;
            for (String includingFilePath : includingFiles) {
                CodeSnippet codeSnippet;
                if (AIProtectManager.INSTANCE.isFileProtected(includingFilePath, iProject) || uniqueFiles.contains(includingFilePath) || (codeSnippet = AIExpansionUtils.INSTANCE.getFileContentAsCodeSnippet(includingFilePath, iProject)) == null) continue;
                uniqueFiles.add(includingFilePath);
                results.add(codeSnippet);
                if (results.size() < maxNumberOfResults) continue;
                return results;
            }
        }
        return results;
    }

    private OutlineResult getOutlineOfFile(String filePath, IProject iProject) {
        IDVTElementWrapper outlineData = this.getOutlineDataForFilePath(filePath, iProject);
        if (outlineData == null || outlineData.getChildren() == null || outlineData.getChildren().isEmpty()) {
            return null;
        }
        List topElements = outlineData.getChildren();
        ArrayList<TreeElement> roots = new ArrayList<TreeElement>();
        for (IDVTElementWrapper topElement : topElements) {
            roots.add(this.convertToOutlineTreeElement(topElement));
        }
        return new OutlineResult(null, null, AIPathUtils.INSTANCE.makePathRelativeToProject(filePath, iProject), -1, -1, new MultiRootTree(roots));
    }

    public TreeElement convertToOutlineTreeElement(IDVTElementWrapper elementWrapper) {
        if (elementWrapper == null) {
            return null;
        }
        Object rfElement = elementWrapper.getRfElement();
        if (!(rfElement instanceof IRfDefElement)) {
            return null;
        }
        IRfDefElement defElement = (IRfDefElement)rfElement;
        TreeElement result = new TreeElement();
        String signature = AIUtils.getInstance().getDefElementSignature(defElement);
        if (signature == null) {
            return null;
        }
        result.setElement(signature);
        List children = elementWrapper.getChildren();
        if (children == null) {
            return result;
        }
        for (IDVTElementWrapper child : children) {
            result.addChild(this.convertToOutlineTreeElement(child));
        }
        return result;
    }

    private CodeMatchPriority getEditorRangePriority(EditorRange editorRange) {
        String normalizedFilePath = AIPathUtils.INSTANCE.normalizePath(editorRange.getFullPath());
        if (normalizedFilePath.equals(this.getActiveEditorNormalizedPath())) {
            return CodeMatchPriority.ACTIVE_EDITOR;
        }
        Set<String> openEditors = HotspotManager.getInstance().getOpenEditorsNormalizedPaths();
        if (openEditors != null && openEditors.contains(normalizedFilePath)) {
            return CodeMatchPriority.OPEN_FILES;
        }
        if (HotspotManager.getInstance().isFileRecent(normalizedFilePath)) {
            return CodeMatchPriority.RECENT_FILES;
        }
        return CodeMatchPriority.GENERIC_MATCH;
    }

    private String getAssociatedTypeName(Object object) {
        if (object instanceof IRfInstanceElement) {
            return ((IRfInstanceElement)object).getAssociatedTypeName();
        }
        if (object instanceof IRfNamedElement) {
            return ((IRfNamedElement)object).getName();
        }
        return null;
    }

    private String computeDHTreeElementLabel(String elementName, String elementAssociatedTypeName) {
        if (elementAssociatedTypeName == null) {
            return elementName;
        }
        return String.valueOf(elementName) + ": " + elementAssociatedTypeName;
    }

    public List<Dependency> getDependenciesFromSources(List<DependencySource> dependencySources, DependenciesExpansionStrategy expansionStrategy, int wrappingCharCount, int separatorCharCount, int charCountLimit, BooleanSupplier isCanceled) {
        IAILangContributor aiContributor;
        dependencySources = dependencySources.stream().filter(dependency -> !AIProtectManager.INSTANCE.isDefElementProtected(dependency.getDefElement())).collect(Collectors.toList());
        if (expansionStrategy == DependenciesExpansionStrategy.FORCE_CODE_SNIPPET) {
            return this.getCodeSnippetsFromSources(dependencySources, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
        }
        if (expansionStrategy == DependenciesExpansionStrategy.FORCE_OUTLINE) {
            return this.getOutlinesFromSources(dependencySources, wrappingCharCount, separatorCharCount, charCountLimit, isCanceled);
        }
        int currentCharCount = 0;
        ArrayList<Dependency> results = new ArrayList<Dependency>();
        for (DependencySource dependencySource : dependencySources) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            if (dependencySource.isMacro()) {
                CodeSnippet macroDefinition = dependencySource.getMacroDefinition();
                results.add(new Dependency(false, null, macroDefinition));
                currentCharCount += macroDefinition.getCode().length();
                continue;
            }
            if (dependencySource.isFiltered()) {
                List<TreeElement> additionalOutlines;
                IRfDefElement defElement = dependencySource.getDefElement();
                IDVTElementWrapper dependencyOutlineData = this.getOutlineDataForDefElement(defElement);
                TreeElement outlineTreeRoot = this.convertToOutlineTreeElement(dependencyOutlineData);
                ArrayList<TreeElement> roots = new ArrayList<TreeElement>(Arrays.asList(outlineTreeRoot));
                IRfNamedElement namedElement = defElement.getNamedElement();
                if (namedElement != null && (aiContributor = AILangContributorManager.INSTANCE.getContributor(namedElement.getLanguageKind())) != null && (additionalOutlines = aiContributor.getAdditionalOutlinesForDefElement(defElement)) != null) {
                    roots.addAll(additionalOutlines);
                }
                OutlineResult outlineResult = new OutlineResult(AIUtils.getInstance().getElementName(defElement), AIUtils.getInstance().getDefElementKind(defElement), AIUtils.getInstance().getFilePathFromDefElement(defElement, true), -1, -1, new MultiRootTree(roots));
                Dependency dependency2 = new Dependency(true, outlineResult, null);
                results.add(dependency2);
                currentCharCount += dependency2.getCharCount();
                continue;
            }
            CodeSnippet expansion = AIExpansionUtils.INSTANCE.expandDefElement(dependencySource.getDefElement(), null, false, true);
            if (expansion == null) continue;
            results.add(new Dependency(false, null, expansion));
            currentCharCount += expansion.getCode().length();
        }
        if ((currentCharCount += results.size() * wrappingCharCount + (results.size() - 1) * separatorCharCount) <= charCountLimit) {
            return results;
        }
        int i = results.size() - 1;
        while (i >= 0) {
            TreeElement outlineTreeRoot;
            IDVTElementWrapper dependencyOutlineData;
            IRfDefElement dependency3;
            IRfNamedElement namedElement;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            DependencySource dependencySource = dependencySources.get(i);
            if (!(dependencySource.isMacro() || ((Dependency)results.get(i)).isOutline() || (namedElement = (dependency3 = dependencySource.getDefElement()).getNamedElement()) instanceof IRfCompositeTypeElement || namedElement instanceof IRfEnumElement || (dependencyOutlineData = this.getOutlineDataForDefElement(dependency3)) == null || (outlineTreeRoot = this.convertToOutlineTreeElement(dependencyOutlineData)) == null)) {
                List<TreeElement> additionalOutlines;
                ArrayList<TreeElement> roots = new ArrayList<TreeElement>(Arrays.asList(outlineTreeRoot));
                aiContributor = AILangContributorManager.INSTANCE.getContributor(namedElement.getLanguageKind());
                if (aiContributor != null && (additionalOutlines = aiContributor.getAdditionalOutlinesForDefElement(dependency3)) != null) {
                    roots.addAll(additionalOutlines);
                }
                int outlineSize = roots.stream().map(AIUtils.getInstance()::getCharCountOfTree).reduce(0, Integer::sum);
                int expansionSize = ((Dependency)results.get(i)).getCodeSnippet().getCode().length();
                if (outlineSize <= expansionSize) {
                    OutlineResult outlineResult = new OutlineResult(AIUtils.getInstance().getElementName(namedElement), AIUtils.getInstance().getDefElementKind(dependency3), AIUtils.getInstance().getFilePathFromDefElement(dependency3, true), -1, -1, new MultiRootTree(roots));
                    results.set(i, new Dependency(true, outlineResult, null));
                    currentCharCount -= expansionSize;
                    if ((currentCharCount += outlineSize) <= charCountLimit) {
                        return results;
                    }
                }
            }
            --i;
        }
        ArrayList<Dependency> finalResults = new ArrayList<Dependency>();
        currentCharCount = 0;
        int i2 = 0;
        while (i2 < results.size()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            int addedCharacters = ((Dependency)results.get(i2)).getCharCount() + wrappingCharCount;
            if (i2 != 0) {
                addedCharacters += separatorCharCount;
            }
            if (currentCharCount + addedCharacters > charCountLimit) break;
            currentCharCount += addedCharacters;
            finalResults.add((Dependency)results.get(i2));
            ++i2;
        }
        return finalResults;
    }

    private List<Dependency> getCodeSnippetsFromSources(List<DependencySource> dependencySources, int wrappingCharCount, int separatorCharCount, int charCountLimit, BooleanSupplier isCanceled) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        int currentCharCount = 0;
        int i = 0;
        while (i < dependencySources.size()) {
            CodeSnippet expansion;
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            DependencySource dependencySource = dependencySources.get(i);
            CodeSnippet codeSnippet = expansion = dependencySource.isMacro() ? dependencySource.getMacroDefinition() : AIExpansionUtils.INSTANCE.expandDefElement(dependencySource.getDefElement(), null, false, true);
            if (expansion != null) {
                int addedCharacters = expansion.getCode().length() + wrappingCharCount;
                if (i != 0) {
                    addedCharacters += separatorCharCount;
                }
                if (currentCharCount + addedCharacters > charCountLimit) {
                    return result;
                }
                currentCharCount += addedCharacters;
                result.add(new Dependency(false, null, expansion));
            }
            ++i;
        }
        return result;
    }

    private List<Dependency> getOutlinesFromSources(List<DependencySource> dependencySources, int wrappingCharCount, int separatorCharCount, int charCountLimit, BooleanSupplier isCanceled) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        int currentCharCount = 0;
        int i = 0;
        while (i < dependencySources.size()) {
            AIUtils.getInstance().checkSnippetSolvingCancellation(isCanceled, "dependencies of");
            DependencySource dependencySource = dependencySources.get(i);
            if (dependencySource.isMacro()) {
                CodeSnippet macroDefinition = dependencySource.getMacroDefinition();
                if (macroDefinition != null) {
                    int addedCharacters = macroDefinition.getCode().length() + wrappingCharCount;
                    if (i != 0) {
                        addedCharacters += separatorCharCount;
                    }
                    if (currentCharCount + addedCharacters > charCountLimit) {
                        return result;
                    }
                    currentCharCount += addedCharacters;
                    result.add(new Dependency(false, null, macroDefinition));
                }
            } else {
                TreeElement outlineTreeRoot;
                IRfDefElement defElement = dependencySource.getDefElement();
                IDVTElementWrapper outlineData = this.getOutlineDataForDefElement(defElement);
                if (outlineData != null && (outlineTreeRoot = this.convertToOutlineTreeElement(outlineData)) != null) {
                    List<TreeElement> additionalOutlines;
                    IAILangContributor aiContributor;
                    ArrayList<TreeElement> roots = new ArrayList<TreeElement>(Arrays.asList(outlineTreeRoot));
                    IRfNamedElement namedElement = defElement.getNamedElement();
                    if (namedElement != null && (aiContributor = AILangContributorManager.INSTANCE.getContributor(namedElement.getLanguageKind())) != null && (additionalOutlines = aiContributor.getAdditionalOutlinesForDefElement(defElement)) != null) {
                        roots.addAll(additionalOutlines);
                    }
                    OutlineResult outlineResult = new OutlineResult(AIUtils.getInstance().getElementName(defElement), AIUtils.getInstance().getDefElementKind(defElement), AIUtils.getInstance().getFilePathFromDefElement(defElement, true), -1, -1, new MultiRootTree(roots));
                    Dependency dependency = new Dependency(true, outlineResult, null);
                    int addedCharacters = dependency.getCharCount() + wrappingCharCount;
                    if (i != 0) {
                        addedCharacters += separatorCharCount;
                    }
                    if (currentCharCount + addedCharacters > charCountLimit) {
                        return result;
                    }
                    currentCharCount += addedCharacters;
                    result.add(dependency);
                }
            }
            ++i;
        }
        return result;
    }

    private IRfDefElement resolveTypeAliasDefElement(IRfNamedElementAndScope namedElementAndScope) {
        IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
        if (!(namedElement instanceof IRfTypeAliasElement)) {
            return null;
        }
        IRfNamedElement translatedType = ((IRfTypeAliasElement)namedElement).getTranslatedType();
        if (translatedType == null) {
            return null;
        }
        return translatedType.getDeclaration();
    }

    private boolean isFileQuery(String query) {
        String queryKey = SymbolQueryUtils.getQueryKey((String)query);
        return SymbolQueryKey.FILE.isEqualTo(queryKey);
    }

    protected abstract String getActiveEditorNormalizedPath();

    protected abstract IDVTElementWrapper getOutlineDataForFilePath(String var1, IProject var2);

    public abstract IDVTElementWrapper getOutlineDataForDefElement(IRfDefElement var1);

    private static class MatchAndPriority {
        public Object match;
        public CodeMatchPriority priority;

        public MatchAndPriority(Object match, CodeMatchPriority priority) {
            this.match = match;
            this.priority = priority;
        }
    }
}

